/*
 * Decompiled with CFR 0.152.
 */
package org.drools.xml.rules;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import junit.framework.TestCase;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.lang.descr.AccessorDescr;
import org.drools.lang.descr.AccumulateDescr;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.CollectDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.FieldBindingDescr;
import org.drools.lang.descr.FieldConstraintDescr;
import org.drools.lang.descr.ForallDescr;
import org.drools.lang.descr.FromDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.FunctionImportDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.LiteralRestrictionDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.PatternSourceDescr;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.ReturnValueRestrictionDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.lang.descr.VariableRestrictionDescr;
import org.drools.xml.XmlPackageReader;

public class XmlPackageReaderTest
extends TestCase {
    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }

    protected RuleBase getRuleBase(RuleBaseConfiguration config) throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }

    public void testParseFrom() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParseFrom.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        XmlPackageReaderTest.assertNotNull((Object)packageDescr);
        RuleDescr obj = (RuleDescr)packageDescr.getRules().get(0);
        PatternDescr patterndescr = (PatternDescr)obj.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)patterndescr.getSource();
        AccessorDescr accessordescriptor = (AccessorDescr)from.getDataSource();
        XmlPackageReaderTest.assertEquals((String)accessordescriptor.getVariableName(), (String)"cheesery");
        XmlPackageReaderTest.assertEquals((String)patterndescr.getObjectType(), (String)"Cheese");
        XmlPackageReaderTest.assertEquals((String)patterndescr.getIdentifier(), (String)"cheese");
    }

    public void testAccumulate() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParseAccumulate.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        XmlPackageReaderTest.assertNotNull((Object)packageDescr);
        RuleDescr obj = (RuleDescr)packageDescr.getRules().get(0);
        Object patternobj = obj.getLhs().getDescrs().get(0);
        XmlPackageReaderTest.assertTrue((boolean)(patternobj instanceof PatternDescr));
        PatternDescr patterncheese = (PatternDescr)patternobj;
        XmlPackageReaderTest.assertEquals((String)patterncheese.getIdentifier(), (String)"cheese");
        XmlPackageReaderTest.assertEquals((String)patterncheese.getObjectType(), (String)"Cheese");
        AccumulateDescr accumulatedescr = (AccumulateDescr)patterncheese.getSource();
        XmlPackageReaderTest.assertEquals((String)"total += $cheese.getPrice();", (String)accumulatedescr.getActionCode());
        XmlPackageReaderTest.assertEquals((String)"int total = 0;", (String)accumulatedescr.getInitCode());
        XmlPackageReaderTest.assertEquals((String)"new Integer( total ) );", (String)accumulatedescr.getResultCode());
        patternobj = obj.getLhs().getDescrs().get(1);
        XmlPackageReaderTest.assertTrue((boolean)(patternobj instanceof PatternDescr));
        PatternDescr patternmax = (PatternDescr)patternobj;
        XmlPackageReaderTest.assertEquals((String)patternmax.getIdentifier(), (String)"max");
        XmlPackageReaderTest.assertEquals((String)patternmax.getObjectType(), (String)"Number");
        accumulatedescr = (AccumulateDescr)patternmax.getSource();
        XmlPackageReaderTest.assertTrue((boolean)accumulatedescr.isExternalFunction());
        XmlPackageReaderTest.assertEquals((String)"max", (String)accumulatedescr.getFunctionIdentifier());
        XmlPackageReaderTest.assertNull((Object)accumulatedescr.getInitCode());
        XmlPackageReaderTest.assertNull((Object)accumulatedescr.getActionCode());
        XmlPackageReaderTest.assertNull((Object)accumulatedescr.getResultCode());
        XmlPackageReaderTest.assertNull((Object)accumulatedescr.getReverseCode());
    }

    public void testAccumulateMultiPattern() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParseAccumulate.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        XmlPackageReaderTest.assertNotNull((Object)packageDescr);
        RuleDescr obj = (RuleDescr)packageDescr.getRules().get(1);
        Object patternobj = obj.getLhs().getDescrs().get(0);
        XmlPackageReaderTest.assertTrue((boolean)(patternobj instanceof PatternDescr));
        PatternDescr patterncheese = (PatternDescr)patternobj;
        XmlPackageReaderTest.assertEquals((String)patterncheese.getIdentifier(), (String)"cheese");
        XmlPackageReaderTest.assertEquals((String)patterncheese.getObjectType(), (String)"Cheese");
        AccumulateDescr accumulatedescr = (AccumulateDescr)patterncheese.getSource();
        XmlPackageReaderTest.assertEquals((String)"total += $cheese.getPrice();", (String)accumulatedescr.getActionCode());
        XmlPackageReaderTest.assertEquals((String)"int total = 0;", (String)accumulatedescr.getInitCode());
        XmlPackageReaderTest.assertEquals((String)"new Integer( total ) );", (String)accumulatedescr.getResultCode());
        AndDescr anddescr = (AndDescr)accumulatedescr.getInput();
        List descrlist = anddescr.getDescrs();
        PatternDescr[] listpattern = descrlist.toArray(new PatternDescr[descrlist.size()]);
        XmlPackageReaderTest.assertEquals((String)listpattern[0].getObjectType(), (String)"Milk");
        XmlPackageReaderTest.assertEquals((String)listpattern[1].getObjectType(), (String)"Cup");
    }

    public void testParseForall() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParseForall.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        XmlPackageReaderTest.assertNotNull((Object)packageDescr);
        RuleDescr obj = (RuleDescr)packageDescr.getRules().get(0);
        ForallDescr forall = (ForallDescr)obj.getLhs().getDescrs().get(0);
        List forallPaterns = forall.getDescrs();
        PatternDescr pattarnState = (PatternDescr)forallPaterns.get(0);
        PatternDescr personState = (PatternDescr)forallPaterns.get(1);
        PatternDescr cheeseState = (PatternDescr)forallPaterns.get(2);
        XmlPackageReaderTest.assertEquals((String)pattarnState.getObjectType(), (String)"State");
        XmlPackageReaderTest.assertEquals((String)personState.getObjectType(), (String)"Person");
        XmlPackageReaderTest.assertEquals((String)cheeseState.getObjectType(), (String)"Cheese");
    }

    public void testParseExists() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParseExists.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        XmlPackageReaderTest.assertNotNull((Object)packageDescr);
        RuleDescr obj = (RuleDescr)packageDescr.getRules().get(0);
        Object existdescr = obj.getLhs().getDescrs().get(0);
        XmlPackageReaderTest.assertTrue((boolean)(existdescr instanceof ExistsDescr));
        Object patternDescriptor = ((ExistsDescr)existdescr).getDescrs().get(0);
        XmlPackageReaderTest.assertTrue((boolean)(patternDescriptor instanceof PatternDescr));
        XmlPackageReaderTest.assertEquals((String)((PatternDescr)patternDescriptor).getObjectType(), (String)"Person");
        Object notDescr = obj.getLhs().getDescrs().get(1);
        XmlPackageReaderTest.assertEquals((String)notDescr.getClass().getName(), (String)NotDescr.class.getName());
        existdescr = ((NotDescr)notDescr).getDescrs().get(0);
        patternDescriptor = ((ExistsDescr)existdescr).getDescrs().get(0);
        XmlPackageReaderTest.assertTrue((boolean)(patternDescriptor instanceof PatternDescr));
        XmlPackageReaderTest.assertEquals((String)((PatternDescr)patternDescriptor).getObjectType(), (String)"Cheese");
    }

    public void testParseCollect() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParseCollect.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        XmlPackageReaderTest.assertNotNull((Object)packageDescr);
        RuleDescr obj = (RuleDescr)packageDescr.getRules().get(0);
        Object objectpattern = obj.getLhs().getDescrs().get(0);
        XmlPackageReaderTest.assertTrue((boolean)(objectpattern instanceof PatternDescr));
        PatternDescr patterndescr = (PatternDescr)objectpattern;
        XmlPackageReaderTest.assertEquals((String)patterndescr.getObjectType(), (String)"Cheese");
        PatternSourceDescr collectobj = patterndescr.getSource();
        XmlPackageReaderTest.assertTrue((boolean)(collectobj instanceof CollectDescr));
        CollectDescr collectDescr = (CollectDescr)collectobj;
        PatternDescr inputpattern = collectDescr.getInputPattern();
        XmlPackageReaderTest.assertEquals((String)inputpattern.getObjectType(), (String)"Person");
        Object fieldContraintObject = inputpattern.getConstraint().getDescrs().get(0);
        XmlPackageReaderTest.assertTrue((boolean)(fieldContraintObject instanceof FieldConstraintDescr));
        FieldConstraintDescr fieldconstraintdescr = (FieldConstraintDescr)fieldContraintObject;
        XmlPackageReaderTest.assertEquals((String)fieldconstraintdescr.getFieldName(), (String)"hair");
        Object literal1 = fieldconstraintdescr.getRestrictions().get(0);
        XmlPackageReaderTest.assertTrue((boolean)(literal1 instanceof LiteralRestrictionDescr));
        LiteralRestrictionDescr literalDesc = (LiteralRestrictionDescr)literal1;
        XmlPackageReaderTest.assertEquals((String)literalDesc.getEvaluator(), (String)"==");
        XmlPackageReaderTest.assertEquals((String)literalDesc.getText(), (String)"pink");
        fieldContraintObject = patterndescr.getConstraint().getDescrs().get(0);
        XmlPackageReaderTest.assertTrue((boolean)(fieldContraintObject instanceof FieldConstraintDescr));
        fieldconstraintdescr = (FieldConstraintDescr)fieldContraintObject;
        XmlPackageReaderTest.assertEquals((String)fieldconstraintdescr.getFieldName(), (String)"type");
        literal1 = fieldconstraintdescr.getRestrictions().get(0);
        XmlPackageReaderTest.assertTrue((boolean)(literal1 instanceof LiteralRestrictionDescr));
        literalDesc = (LiteralRestrictionDescr)literal1;
        XmlPackageReaderTest.assertEquals((String)literalDesc.getEvaluator(), (String)"==");
        XmlPackageReaderTest.assertEquals((String)literalDesc.getText(), (String)"1");
    }

    public void testParsePackageName() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParsePackageName.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        XmlPackageReaderTest.assertNotNull((Object)packageDescr);
        XmlPackageReaderTest.assertEquals((String)"com.sample", (String)packageDescr.getName());
    }

    public void testParseImport() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParseImport.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        XmlPackageReaderTest.assertNotNull((Object)packageDescr);
        XmlPackageReaderTest.assertEquals((String)"com.sample", (String)packageDescr.getName());
        List imports = packageDescr.getImports();
        XmlPackageReaderTest.assertEquals((int)2, (int)imports.size());
        XmlPackageReaderTest.assertEquals((String)"java.util.HashMap", (String)((ImportDescr)imports.get(0)).getTarget());
        XmlPackageReaderTest.assertEquals((String)"org.drools.*", (String)((ImportDescr)imports.get(1)).getTarget());
        List functionImport = packageDescr.getFunctionImports();
        XmlPackageReaderTest.assertEquals((String)"org.drools.function", (String)((FunctionImportDescr)functionImport.get(0)).getTarget());
    }

    public void testParseGlobal() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParseGlobal.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        XmlPackageReaderTest.assertNotNull((Object)packageDescr);
        XmlPackageReaderTest.assertEquals((String)"com.sample", (String)packageDescr.getName());
        List imports = packageDescr.getImports();
        XmlPackageReaderTest.assertEquals((int)2, (int)imports.size());
        XmlPackageReaderTest.assertEquals((String)"java.util.HashMap", (String)((ImportDescr)imports.get(0)).getTarget());
        XmlPackageReaderTest.assertEquals((String)"org.drools.*", (String)((ImportDescr)imports.get(1)).getTarget());
        List globals = packageDescr.getGlobals();
        XmlPackageReaderTest.assertEquals((int)2, (int)globals.size());
        GlobalDescr x = (GlobalDescr)globals.get(0);
        GlobalDescr yada = (GlobalDescr)globals.get(1);
        XmlPackageReaderTest.assertEquals((String)"com.sample.X", (String)x.getType());
        XmlPackageReaderTest.assertEquals((String)"x", (String)x.getIdentifier());
        XmlPackageReaderTest.assertEquals((String)"com.sample.Yada", (String)yada.getType());
        XmlPackageReaderTest.assertEquals((String)"yada", (String)yada.getIdentifier());
    }

    public void testParseFunction() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParseFunction.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        XmlPackageReaderTest.assertNotNull((Object)packageDescr);
        XmlPackageReaderTest.assertEquals((String)"com.sample", (String)packageDescr.getName());
        List imports = packageDescr.getImports();
        XmlPackageReaderTest.assertEquals((int)2, (int)imports.size());
        XmlPackageReaderTest.assertEquals((String)"java.util.HashMap", (String)((ImportDescr)imports.get(0)).getTarget());
        XmlPackageReaderTest.assertEquals((String)"org.drools.*", (String)((ImportDescr)imports.get(1)).getTarget());
        List globals = packageDescr.getGlobals();
        XmlPackageReaderTest.assertEquals((int)2, (int)globals.size());
        GlobalDescr x = (GlobalDescr)globals.get(0);
        GlobalDescr yada = (GlobalDescr)globals.get(1);
        XmlPackageReaderTest.assertEquals((String)"com.sample.X", (String)x.getType());
        XmlPackageReaderTest.assertEquals((String)"x", (String)x.getIdentifier());
        XmlPackageReaderTest.assertEquals((String)"com.sample.Yada", (String)yada.getType());
        XmlPackageReaderTest.assertEquals((String)"yada", (String)yada.getIdentifier());
        FunctionDescr functionDescr = (FunctionDescr)packageDescr.getFunctions().get(0);
        List names = functionDescr.getParameterNames();
        XmlPackageReaderTest.assertEquals((Object)"foo", names.get(0));
        XmlPackageReaderTest.assertEquals((Object)"bada", names.get(1));
        List types = functionDescr.getParameterTypes();
        XmlPackageReaderTest.assertEquals((Object)"Bar", types.get(0));
        XmlPackageReaderTest.assertEquals((Object)"Bing", types.get(1));
        XmlPackageReaderTest.assertEquals((String)"System.out.println(\"hello world\");", (String)functionDescr.getText().trim());
    }

    public void testParseRule() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParseRule.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        XmlPackageReaderTest.assertNotNull((Object)packageDescr);
        XmlPackageReaderTest.assertEquals((String)"com.sample", (String)packageDescr.getName());
        List imports = packageDescr.getImports();
        XmlPackageReaderTest.assertEquals((int)2, (int)imports.size());
        XmlPackageReaderTest.assertEquals((String)"java.util.HashMap", (String)((ImportDescr)imports.get(0)).getTarget());
        XmlPackageReaderTest.assertEquals((String)"org.drools.*", (String)((ImportDescr)imports.get(1)).getTarget());
        List globals = packageDescr.getGlobals();
        XmlPackageReaderTest.assertEquals((int)2, (int)globals.size());
        GlobalDescr x = (GlobalDescr)globals.get(0);
        GlobalDescr yada = (GlobalDescr)globals.get(1);
        XmlPackageReaderTest.assertEquals((String)"com.sample.X", (String)x.getType());
        XmlPackageReaderTest.assertEquals((String)"x", (String)x.getIdentifier());
        XmlPackageReaderTest.assertEquals((String)"com.sample.Yada", (String)yada.getType());
        XmlPackageReaderTest.assertEquals((String)"yada", (String)yada.getIdentifier());
        FunctionDescr functionDescr = (FunctionDescr)packageDescr.getFunctions().get(0);
        List names = functionDescr.getParameterNames();
        XmlPackageReaderTest.assertEquals((Object)"foo", names.get(0));
        XmlPackageReaderTest.assertEquals((Object)"bada", names.get(1));
        List types = functionDescr.getParameterTypes();
        XmlPackageReaderTest.assertEquals((Object)"Bar", types.get(0));
        XmlPackageReaderTest.assertEquals((Object)"Bing", types.get(1));
        XmlPackageReaderTest.assertEquals((String)"System.out.println(\"hello world\");", (String)functionDescr.getText().trim());
        RuleDescr ruleDescr = (RuleDescr)packageDescr.getRules().get(0);
        XmlPackageReaderTest.assertEquals((String)"simple_rule", (String)ruleDescr.getName());
        XmlPackageReaderTest.assertEquals((int)4, (int)ruleDescr.getAttributes().size());
        AttributeDescr attributeDescr = (AttributeDescr)ruleDescr.getAttributes().get(0);
        XmlPackageReaderTest.assertEquals((String)"salience", (String)attributeDescr.getName());
        XmlPackageReaderTest.assertEquals((String)"10", (String)attributeDescr.getValue());
        AndDescr lhs = ruleDescr.getLhs();
        XmlPackageReaderTest.assertEquals((int)7, (int)lhs.getDescrs().size());
        PatternDescr patternDescr = (PatternDescr)lhs.getDescrs().get(0);
        XmlPackageReaderTest.assertEquals((String)"Bar", (String)patternDescr.getObjectType());
        String consequence = (String)ruleDescr.getConsequence();
        XmlPackageReaderTest.assertNotNull((Object)consequence);
    }

    public void testParseLhs() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParseLhs.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        XmlPackageReaderTest.assertNotNull((Object)packageDescr);
        XmlPackageReaderTest.assertEquals((String)"com.sample", (String)packageDescr.getName());
        List imports = packageDescr.getImports();
        XmlPackageReaderTest.assertEquals((int)2, (int)imports.size());
        XmlPackageReaderTest.assertEquals((String)"java.util.HashMap", (String)((ImportDescr)imports.get(0)).getTarget());
        XmlPackageReaderTest.assertEquals((String)"org.drools.*", (String)((ImportDescr)imports.get(1)).getTarget());
        List globals = packageDescr.getGlobals();
        XmlPackageReaderTest.assertEquals((int)2, (int)globals.size());
        GlobalDescr x = (GlobalDescr)globals.get(0);
        GlobalDescr yada = (GlobalDescr)globals.get(1);
        XmlPackageReaderTest.assertEquals((String)"com.sample.X", (String)x.getType());
        XmlPackageReaderTest.assertEquals((String)"x", (String)x.getIdentifier());
        XmlPackageReaderTest.assertEquals((String)"com.sample.Yada", (String)yada.getType());
        XmlPackageReaderTest.assertEquals((String)"yada", (String)yada.getIdentifier());
        FunctionDescr functionDescr = (FunctionDescr)packageDescr.getFunctions().get(0);
        List names = functionDescr.getParameterNames();
        XmlPackageReaderTest.assertEquals((Object)"foo", names.get(0));
        XmlPackageReaderTest.assertEquals((Object)"bada", names.get(1));
        List types = functionDescr.getParameterTypes();
        XmlPackageReaderTest.assertEquals((Object)"Bar", types.get(0));
        XmlPackageReaderTest.assertEquals((Object)"Bing", types.get(1));
        XmlPackageReaderTest.assertEquals((String)"System.out.println(\"hello world\");", (String)functionDescr.getText().trim());
        RuleDescr ruleDescr = (RuleDescr)packageDescr.getRules().get(0);
        XmlPackageReaderTest.assertEquals((String)"my rule", (String)ruleDescr.getName());
        AndDescr lhsDescr = ruleDescr.getLhs();
        AndDescr andDescr = (AndDescr)lhsDescr.getDescrs().get(0);
        OrDescr orDescr = (OrDescr)lhsDescr.getDescrs().get(1);
        PatternDescr pattern1 = (PatternDescr)lhsDescr.getDescrs().get(2);
        XmlPackageReaderTest.assertNull((Object)pattern1.getIdentifier());
        XmlPackageReaderTest.assertEquals((String)"Foo", (String)pattern1.getObjectType());
        PatternDescr pattern2 = (PatternDescr)lhsDescr.getDescrs().get(3);
        XmlPackageReaderTest.assertEquals((String)"Bar", (String)pattern2.getObjectType());
        XmlPackageReaderTest.assertEquals((String)"bar", (String)pattern2.getIdentifier());
        PatternDescr pattern3 = (PatternDescr)lhsDescr.getDescrs().get(4);
        FieldConstraintDescr fieldConstraintDescr = (FieldConstraintDescr)pattern3.getDescrs().get(0);
        LiteralRestrictionDescr literalDescr = (LiteralRestrictionDescr)fieldConstraintDescr.getRestrictions().get(0);
        XmlPackageReaderTest.assertEquals((String)"field1", (String)fieldConstraintDescr.getFieldName());
        XmlPackageReaderTest.assertEquals((String)"==", (String)literalDescr.getEvaluator());
        XmlPackageReaderTest.assertEquals((String)"value1", (String)literalDescr.getText());
        ReturnValueRestrictionDescr returnValueDescr = (ReturnValueRestrictionDescr)fieldConstraintDescr.getRestrictions().get(1);
        XmlPackageReaderTest.assertEquals((String)"==", (String)returnValueDescr.getEvaluator());
        XmlPackageReaderTest.assertEquals((Object)"1==1", (Object)returnValueDescr.getContent());
        VariableRestrictionDescr variableDescr = (VariableRestrictionDescr)fieldConstraintDescr.getRestrictions().get(2);
        XmlPackageReaderTest.assertEquals((String)"==", (String)variableDescr.getEvaluator());
        XmlPackageReaderTest.assertEquals((String)"var1", (String)variableDescr.getIdentifier());
        PredicateDescr predicateDescr = (PredicateDescr)pattern3.getDescrs().get(1);
        XmlPackageReaderTest.assertEquals((Object)"1==1", (Object)predicateDescr.getContent());
        FieldBindingDescr fieldBindingDescr = (FieldBindingDescr)pattern3.getDescrs().get(2);
        XmlPackageReaderTest.assertEquals((String)"field1", (String)fieldBindingDescr.getFieldName());
        XmlPackageReaderTest.assertEquals((String)"var1", (String)fieldBindingDescr.getIdentifier());
        NotDescr notDescr = (NotDescr)lhsDescr.getDescrs().get(5);
        XmlPackageReaderTest.assertEquals((int)1, (int)notDescr.getDescrs().size());
        PatternDescr patternDescr = (PatternDescr)notDescr.getDescrs().get(0);
        XmlPackageReaderTest.assertEquals((String)"Bar", (String)patternDescr.getObjectType());
        ExistsDescr existsDescr = (ExistsDescr)lhsDescr.getDescrs().get(6);
        XmlPackageReaderTest.assertEquals((int)1, (int)existsDescr.getDescrs().size());
        patternDescr = (PatternDescr)existsDescr.getDescrs().get(0);
        XmlPackageReaderTest.assertEquals((String)"Bar", (String)patternDescr.getObjectType());
        andDescr = (AndDescr)lhsDescr.getDescrs().get(7);
        XmlPackageReaderTest.assertEquals((int)2, (int)andDescr.getDescrs().size());
        orDescr = (OrDescr)andDescr.getDescrs().get(1);
        patternDescr = (PatternDescr)orDescr.getDescrs().get(0);
        XmlPackageReaderTest.assertEquals((String)"Bar", (String)patternDescr.getObjectType());
        patternDescr = (PatternDescr)andDescr.getDescrs().get(0);
        XmlPackageReaderTest.assertEquals((String)"Yada", (String)patternDescr.getObjectType());
        orDescr = (OrDescr)lhsDescr.getDescrs().get(8);
        XmlPackageReaderTest.assertEquals((int)2, (int)orDescr.getDescrs().size());
        andDescr = (AndDescr)orDescr.getDescrs().get(1);
        patternDescr = (PatternDescr)andDescr.getDescrs().get(0);
        XmlPackageReaderTest.assertEquals((String)"Foo", (String)patternDescr.getObjectType());
        patternDescr = (PatternDescr)orDescr.getDescrs().get(0);
        XmlPackageReaderTest.assertEquals((String)"Zaa", (String)patternDescr.getObjectType());
        EvalDescr evalDescr = (EvalDescr)lhsDescr.getDescrs().get(9);
        XmlPackageReaderTest.assertEquals((Object)"1==1", (Object)evalDescr.getContent());
    }

    public void testParseRhs() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParseRhs.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        XmlPackageReaderTest.assertNotNull((Object)packageDescr);
        XmlPackageReaderTest.assertEquals((String)"com.sample", (String)packageDescr.getName());
        List imports = packageDescr.getImports();
        XmlPackageReaderTest.assertEquals((int)2, (int)imports.size());
        XmlPackageReaderTest.assertEquals((String)"java.util.HashMap", (String)((ImportDescr)imports.get(0)).getTarget());
        XmlPackageReaderTest.assertEquals((String)"org.drools.*", (String)((ImportDescr)imports.get(1)).getTarget());
        List globals = packageDescr.getGlobals();
        XmlPackageReaderTest.assertEquals((int)2, (int)globals.size());
        GlobalDescr x = (GlobalDescr)globals.get(0);
        GlobalDescr yada = (GlobalDescr)globals.get(1);
        XmlPackageReaderTest.assertEquals((String)"com.sample.X", (String)x.getType());
        XmlPackageReaderTest.assertEquals((String)"x", (String)x.getIdentifier());
        XmlPackageReaderTest.assertEquals((String)"com.sample.Yada", (String)yada.getType());
        XmlPackageReaderTest.assertEquals((String)"yada", (String)yada.getIdentifier());
        FunctionDescr functionDescr = (FunctionDescr)packageDescr.getFunctions().get(0);
        List names = functionDescr.getParameterNames();
        XmlPackageReaderTest.assertEquals((Object)"foo", names.get(0));
        XmlPackageReaderTest.assertEquals((Object)"bada", names.get(1));
        List types = functionDescr.getParameterTypes();
        XmlPackageReaderTest.assertEquals((Object)"Bar", types.get(0));
        XmlPackageReaderTest.assertEquals((Object)"Bing", types.get(1));
        XmlPackageReaderTest.assertEquals((String)"System.out.println(\"hello world\");", (String)functionDescr.getText().trim());
        RuleDescr ruleDescr = (RuleDescr)packageDescr.getRules().get(0);
        XmlPackageReaderTest.assertEquals((String)"my rule", (String)ruleDescr.getName());
        String consequence = (String)ruleDescr.getConsequence();
        XmlPackageReaderTest.assertNotNull((Object)consequence);
        XmlPackageReaderTest.assertEquals((String)"System.out.println( \"hello\" );", (String)consequence.trim());
    }

    public void testParseQuery() throws Exception {
        XmlPackageReader xmlPackageReader = this.getXmReader();
        xmlPackageReader.read((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ParseQuery.xml")));
        PackageDescr packageDescr = xmlPackageReader.getPackageDescr();
        XmlPackageReaderTest.assertNotNull((Object)packageDescr);
        XmlPackageReaderTest.assertEquals((String)"com.sample", (String)packageDescr.getName());
        List imports = packageDescr.getImports();
        XmlPackageReaderTest.assertEquals((int)2, (int)imports.size());
        XmlPackageReaderTest.assertEquals((String)"java.util.HashMap", (String)((ImportDescr)imports.get(0)).getTarget());
        XmlPackageReaderTest.assertEquals((String)"org.drools.*", (String)((ImportDescr)imports.get(1)).getTarget());
        List globals = packageDescr.getGlobals();
        XmlPackageReaderTest.assertEquals((int)2, (int)globals.size());
        GlobalDescr x = (GlobalDescr)globals.get(0);
        GlobalDescr yada = (GlobalDescr)globals.get(1);
        XmlPackageReaderTest.assertEquals((String)"com.sample.X", (String)x.getType());
        XmlPackageReaderTest.assertEquals((String)"x", (String)x.getIdentifier());
        XmlPackageReaderTest.assertEquals((String)"com.sample.Yada", (String)yada.getType());
        XmlPackageReaderTest.assertEquals((String)"yada", (String)yada.getIdentifier());
        FunctionDescr functionDescr = (FunctionDescr)packageDescr.getFunctions().get(0);
        List names = functionDescr.getParameterNames();
        XmlPackageReaderTest.assertEquals((Object)"foo", names.get(0));
        XmlPackageReaderTest.assertEquals((Object)"bada", names.get(1));
        List types = functionDescr.getParameterTypes();
        XmlPackageReaderTest.assertEquals((Object)"Bar", types.get(0));
        XmlPackageReaderTest.assertEquals((Object)"Bing", types.get(1));
        XmlPackageReaderTest.assertEquals((String)"System.out.println(\"hello world\");", (String)functionDescr.getText().trim());
        QueryDescr queryDescr = (QueryDescr)packageDescr.getRules().get(0);
        XmlPackageReaderTest.assertEquals((String)"my query", (String)queryDescr.getName());
        AndDescr lhs = queryDescr.getLhs();
        XmlPackageReaderTest.assertEquals((int)1, (int)lhs.getDescrs().size());
        PatternDescr patternDescr = (PatternDescr)lhs.getDescrs().get(0);
        XmlPackageReaderTest.assertEquals((String)"Foo", (String)patternDescr.getObjectType());
    }

    private XmlPackageReader getXmReader() {
        PackageBuilderConfiguration conf = new PackageBuilderConfiguration();
        return new XmlPackageReader(conf.getSemanticModules());
    }
}

