/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.RuleBase;
import org.drools.base.ClassFieldAccessor;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.base.ClassFieldReader;
import org.drools.builder.DecisionTableConfiguration;
import org.drools.builder.DecisionTableInputType;
import org.drools.builder.KnowledgeType;
import org.drools.builder.ResourceConfiguration;
import org.drools.common.InternalRuleBase;
import org.drools.commons.jci.problems.CompilationProblem;
import org.drools.compiler.DecisionTableFactory;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsError;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.FieldTemplateError;
import org.drools.compiler.FunctionError;
import org.drools.compiler.GlobalError;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.PackageBuilderErrors;
import org.drools.compiler.PackageRegistry;
import org.drools.compiler.ParserError;
import org.drools.compiler.ProcessBuildError;
import org.drools.compiler.ProcessBuilder;
import org.drools.compiler.RuleBuildError;
import org.drools.compiler.RuleFlowLoadError;
import org.drools.compiler.TypeDeclarationError;
import org.drools.definition.process.Process;
import org.drools.factmodel.ClassBuilder;
import org.drools.factmodel.ClassDefinition;
import org.drools.factmodel.FieldDefinition;
import org.drools.facttemplates.FactTemplate;
import org.drools.facttemplates.FactTemplateImpl;
import org.drools.facttemplates.FieldTemplate;
import org.drools.facttemplates.FieldTemplateImpl;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.FactTemplateDescr;
import org.drools.lang.descr.FieldTemplateDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.FunctionImportDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.lang.descr.TypeDeclarationDescr;
import org.drools.lang.descr.TypeFieldDescr;
import org.drools.lang.dsl.DSLTokenizedMappingFile;
import org.drools.lang.dsl.DefaultExpander;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.rule.CompositeClassLoader;
import org.drools.rule.JavaDialectRuntimeData;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.rule.TypeDeclaration;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleBuilder;
import org.drools.spi.AcceptsReadAccessor;
import org.drools.xml.XmlPackageReader;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageBuilder {
    private Map<String, PackageRegistry> pkgRegistryMap;
    private List<DroolsError> results;
    private PackageBuilderConfiguration configuration;
    public static final RuleBuilder ruleBuilder = new RuleBuilder();
    private ReteooRuleBase ruleBase;
    private String defaultNamespace;
    private final String defaultDialect;
    private CompositeClassLoader rootClassLoader;
    private Map<String, Class> globals;
    private String url;
    private List<DSLTokenizedMappingFile> dslFiles;

    public PackageBuilder() {
        this((RuleBase)null, null);
    }

    public PackageBuilder(Package pkg) {
        this(pkg, null);
    }

    public PackageBuilder(RuleBase ruleBase) {
        this(ruleBase, null);
    }

    public PackageBuilder(PackageBuilderConfiguration configuration) {
        this((RuleBase)null, configuration);
    }

    public PackageBuilder(Package pkg, PackageBuilderConfiguration configuration) {
        if (configuration == null) {
            configuration = new PackageBuilderConfiguration();
        }
        this.configuration = configuration;
        this.rootClassLoader = new CompositeClassLoader(this.configuration.getClassLoader());
        this.defaultNamespace = pkg.getName();
        this.defaultDialect = this.configuration.getDefaultDialect();
        this.pkgRegistryMap = new HashMap<String, PackageRegistry>();
        this.results = new ArrayList<DroolsError>();
        PackageRegistry pkgRegistry = new PackageRegistry(this, pkg);
        pkgRegistry.setDialect(this.defaultDialect);
        this.pkgRegistryMap.put(pkg.getName(), pkgRegistry);
        this.globals = new HashMap<String, Class>();
    }

    public PackageBuilder(RuleBase ruleBase, PackageBuilderConfiguration configuration) {
        if (configuration == null) {
            configuration = new PackageBuilderConfiguration();
        }
        this.configuration = configuration;
        this.rootClassLoader = ruleBase != null ? ((InternalRuleBase)ruleBase).getRootClassLoader() : new CompositeClassLoader(this.configuration.getClassLoader());
        this.defaultDialect = this.configuration.getDefaultDialect();
        this.pkgRegistryMap = new HashMap<String, PackageRegistry>();
        this.results = new ArrayList<DroolsError>();
        this.ruleBase = (ReteooRuleBase)ruleBase;
        this.globals = new HashMap<String, Class>();
    }

    public void addPackageFromDrl(Reader reader) throws DroolsParserException, IOException {
        DrlParser parser = new DrlParser();
        PackageDescr pkg = parser.parse(reader);
        this.results.addAll(parser.getErrors());
        if (!parser.hasErrors()) {
            this.addPackage(pkg);
        }
    }

    public void addPackageFromDrl(URL url) throws DroolsParserException, IOException {
        this.url = url.toExternalForm();
        this.addPackageFromDrl(new InputStreamReader(url.openStream()));
        this.url = null;
    }

    public void addPackageFromXml(Reader reader) throws DroolsParserException, IOException {
        XmlPackageReader xmlReader = new XmlPackageReader(this.configuration.getSemanticModules());
        try {
            xmlReader.read(reader);
        }
        catch (SAXException e) {
            throw new DroolsParserException(e.toString(), e.getCause());
        }
        this.addPackage(xmlReader.getPackageDescr());
    }

    public void addPackageFromXml(URL url) throws DroolsParserException, IOException {
        this.url = url.toExternalForm();
        this.addPackageFromXml(new InputStreamReader(url.openStream()));
        this.url = null;
    }

    public void addPackageFromDrl(Reader source, Reader dsl) throws DroolsParserException, IOException {
        DrlParser parser = new DrlParser();
        PackageDescr pkg = parser.parse(source, dsl);
        this.results.addAll(parser.getErrors());
        if (!parser.hasErrors()) {
            this.addPackage(pkg);
        }
    }

    public void addPackageFromDslr(Reader source) {
        DrlParser parser = new DrlParser();
        DefaultExpander expander = this.getDslExpander();
        try {
            String str = expander.expand(source);
            if (expander.hasErrors()) {
                this.results.addAll(expander.getErrors());
            }
            PackageDescr pkg = parser.parse(str);
            this.results.addAll(parser.getErrors());
            if (!parser.hasErrors()) {
                this.addPackage(pkg);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addPackageFromDslr(URL url) {
        this.url = url.toExternalForm();
        try {
            this.addPackageFromDslr(new InputStreamReader(url.openStream()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.url = null;
    }

    public void addDsl(Reader dsl) {
        try {
            DSLTokenizedMappingFile file = new DSLTokenizedMappingFile();
            file.parseAndLoad(dsl);
            if (this.dslFiles == null) {
                this.dslFiles = new ArrayList<DSLTokenizedMappingFile>();
            }
            this.dslFiles.add(file);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addDsl(URL url) {
        this.url = url.toExternalForm();
        try {
            this.addDsl(new InputStreamReader(url.openStream()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.url = null;
    }

    public void addRuleFlow(Reader processSource) {
        this.addProcessFromXml(processSource);
    }

    public void addProcessFromXml(URL processSource) {
        this.url = processSource.toExternalForm();
        try {
            this.addProcessFromXml(new InputStreamReader(processSource.openStream()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.url = null;
    }

    public void addProcessFromXml(Reader processSource) {
        ProcessBuilder processBuilder = new ProcessBuilder(this);
        try {
            processBuilder.addProcessFromFile(processSource, this.url);
            this.results.addAll(processBuilder.getErrors());
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            this.results.add(new RuleFlowLoadError("Unable to load the rule flow.", e));
        }
        this.results = this.getResults(this.results);
    }

    public void addResource(URL url, KnowledgeType type) {
        this.addResource(url, type, null);
    }

    public void addResource(URL url, KnowledgeType type, ResourceConfiguration configuration) {
        try {
            if (type == KnowledgeType.DTABLE) {
                DecisionTableConfiguration dtableConfiguration = (DecisionTableConfiguration)configuration;
                String string = DecisionTableFactory.loadFromInputStream(url.openStream(), dtableConfiguration);
                this.addPackageFromDrl(new StringReader(string));
            } else {
                this.addResource(new InputStreamReader(url.openStream()), type, configuration);
            }
        }
        catch (DroolsParserException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void addResource(Reader reader, KnowledgeType type) {
        this.addResource(reader, type, null);
    }

    public void addResource(Reader reader, KnowledgeType type, ResourceConfiguration configuration) {
        try {
            switch (type) {
                case DRL: {
                    this.addPackageFromDrl(reader);
                    break;
                }
                case DSLR: {
                    this.addPackageFromDslr(reader);
                    break;
                }
                case DSL: {
                    this.addDsl(reader);
                    break;
                }
                case XDRL: {
                    this.addPackageFromXml(reader);
                    break;
                }
                case DRF: {
                    this.addProcessFromXml(reader);
                    break;
                }
                case DTABLE: {
                    DecisionTableConfiguration dtableConfiguration = (DecisionTableConfiguration)configuration;
                    if (dtableConfiguration.getInputType() == DecisionTableInputType.XLS) {
                        throw new IllegalArgumentException("Use addResource(URL url, KnowledgeType type, ResourceConfiguration configuration) when adding XLS decision tables.");
                    }
                    String string = DecisionTableFactory.loadFromReader(reader, dtableConfiguration);
                    this.addPackageFromDrl(new StringReader(string));
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addPackage(PackageDescr packageDescr) {
        this.validateUniqueRuleNames(packageDescr);
        String dialectName = this.defaultDialect;
        for (AttributeDescr value : packageDescr.getAttributes()) {
            if (!"dialect".equals(value.getName())) continue;
            dialectName = value.getValue();
            break;
        }
        if (!this.isEmpty(packageDescr.getNamespace())) {
            if (this.checkNamespace(packageDescr.getNamespace())) {
                this.defaultNamespace = packageDescr.getNamespace();
            } else {
                packageDescr.setNamespace(this.defaultNamespace);
            }
        } else {
            packageDescr.setNamespace(this.defaultNamespace);
        }
        PackageRegistry pkgRegistry = this.pkgRegistryMap.get(packageDescr.getNamespace());
        if (pkgRegistry == null) {
            pkgRegistry = this.newPackage(packageDescr);
        } else {
            this.mergePackage(packageDescr);
        }
        pkgRegistry.setDialect(dialectName);
        if (!this.hasErrors()) {
            Iterator<Object> it = packageDescr.getFactTemplates().iterator();
            while (it.hasNext()) {
                this.addFactTemplate((FactTemplateDescr)it.next());
            }
            if (!packageDescr.getFunctions().isEmpty()) {
                for (FunctionDescr functionDescr : packageDescr.getFunctions()) {
                    if (this.isEmpty(functionDescr.getNamespace())) {
                        functionDescr.setNamespace(this.defaultNamespace);
                    }
                    if (this.isEmpty(functionDescr.getDialect())) {
                        functionDescr.setDialect(pkgRegistry.getDialect());
                    }
                    this.preCompileAddFunction(functionDescr);
                }
                for (FunctionDescr functionDescr : packageDescr.getFunctions()) {
                    this.addFunction(functionDescr);
                }
                this.compileAll();
                for (FunctionDescr functionDescr : packageDescr.getFunctions()) {
                    this.postCompileAddFunction(functionDescr);
                }
            }
            for (RuleDescr ruleDescr : packageDescr.getRules()) {
                if (this.isEmpty(ruleDescr.getNamespace())) {
                    ruleDescr.setNamespace(this.defaultNamespace);
                }
                if (this.isEmpty(ruleDescr.getDialect())) {
                    ruleDescr.setDialect(pkgRegistry.getDialect());
                }
                this.addRule(ruleDescr);
            }
        }
        this.compileAll();
        this.reloadAll();
        this.updateResults();
        if (this.ruleBase != null) {
            for (RuleDescr ruleDescr : packageDescr.getRules()) {
                pkgRegistry = this.pkgRegistryMap.get(ruleDescr.getNamespace());
                this.ruleBase.addRule(pkgRegistry.getPackage(), pkgRegistry.getPackage().getRule(ruleDescr.getName()));
            }
        }
    }

    private boolean checkNamespace(String newName) {
        if (this.configuration == null) {
            return true;
        }
        if (this.defaultNamespace == null) {
            return true;
        }
        if (this.defaultNamespace.equals(newName)) {
            return true;
        }
        return this.configuration.isAllowMultipleNamespaces();
    }

    public boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public void updateResults() {
        this.results = this.getResults(this.results);
    }

    public void compileAll() {
        for (PackageRegistry pkgRegistry : this.pkgRegistryMap.values()) {
            pkgRegistry.compileAll();
        }
    }

    public void reloadAll() {
        for (PackageRegistry pkgRegistry : this.pkgRegistryMap.values()) {
            pkgRegistry.getDialectRuntimeRegistry().onBeforeExecute();
        }
    }

    private List getResults(List results) {
        for (PackageRegistry pkgRegistry : this.pkgRegistryMap.values()) {
            results = pkgRegistry.getDialectCompiletimeRegistry().addResults(results);
        }
        return results;
    }

    private void validateUniqueRuleNames(PackageDescr packageDescr) {
        HashSet<String> names = new HashSet<String>();
        String namespace = packageDescr.getNamespace();
        for (RuleDescr rule : packageDescr.getRules()) {
            String name = rule.getName();
            if (names.contains(name)) {
                this.results.add(new ParserError("Duplicate rule name: " + name, rule.getLine(), rule.getColumn()));
            }
            names.add(name);
        }
    }

    private PackageRegistry newPackage(PackageDescr packageDescr) {
        Package pkg;
        if (this.ruleBase != null && this.ruleBase.getPackage(packageDescr.getName()) != null) {
            pkg = this.ruleBase.getPackage(packageDescr.getName());
        } else {
            pkg = new Package(packageDescr.getName());
            pkg.setClassFieldAccessorCache(new ClassFieldAccessorCache((ClassLoader)this.rootClassLoader));
            if (this.ruleBase != null) {
                this.ruleBase.addPackage(pkg);
                pkg = this.ruleBase.getPackage(packageDescr.getName());
            } else {
                pkg.getDialectRuntimeRegistry().onAdd(this.rootClassLoader);
            }
        }
        PackageRegistry pkgRegistry = new PackageRegistry(this, pkg);
        pkgRegistry.addImport(packageDescr.getNamespace() + ".*");
        this.pkgRegistryMap.put(packageDescr.getName(), pkgRegistry);
        this.mergePackage(packageDescr);
        return pkgRegistry;
    }

    private void mergePackage(PackageDescr packageDescr) {
        PackageRegistry pkgRegistry = this.isEmpty(packageDescr.getName()) ? this.pkgRegistryMap.get(this.defaultNamespace) : this.pkgRegistryMap.get(packageDescr.getNamespace());
        List imports = packageDescr.getImports();
        for (Object importEntry : imports) {
            pkgRegistry.addImport(((ImportDescr)importEntry).getTarget());
        }
        this.processTypeDeclarations(packageDescr);
        Iterator it = packageDescr.getFunctionImports().iterator();
        while (it.hasNext()) {
            Object importEntry;
            importEntry = ((FunctionImportDescr)it.next()).getTarget();
            pkgRegistry.addStaticImport((String)importEntry);
            pkgRegistry.getPackage().addStaticImport((String)importEntry);
        }
        List globals = packageDescr.getGlobals();
        for (GlobalDescr global : globals) {
            String identifier = global.getIdentifier();
            String className = global.getType();
            try {
                Class clazz = pkgRegistry.getTypeResolver().resolveType(className);
                pkgRegistry.getPackage().addGlobal(identifier, clazz);
                this.globals.put(identifier, clazz);
            }
            catch (ClassNotFoundException e) {
                this.results.add(new GlobalError(identifier, global.getLine()));
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processTypeDeclarations(PackageDescr packageDescr) {
        PackageRegistry defaultRegistry = this.isEmpty(packageDescr.getName()) ? this.pkgRegistryMap.get(this.defaultNamespace) : this.pkgRegistryMap.get(packageDescr.getNamespace());
        PackageRegistry pkgRegistry = null;
        Iterator<TypeDeclarationDescr> i$ = packageDescr.getTypeDeclarations().iterator();
        while (true) {
            String duration;
            TypeDeclaration type;
            TypeDeclarationDescr typeDescr;
            block16: {
                String templateName;
                if (!i$.hasNext()) {
                    return;
                }
                typeDescr = i$.next();
                if (this.isEmpty(typeDescr.getNamespace())) {
                    typeDescr.setNamespace(defaultRegistry.getPackage().getName());
                    pkgRegistry = defaultRegistry;
                } else {
                    pkgRegistry = this.pkgRegistryMap.get(typeDescr.getNamespace());
                }
                type = new TypeDeclaration(typeDescr.getTypeName());
                String role = typeDescr.getMetaAttribute("role");
                if (role != null) {
                    type.setRole(TypeDeclaration.Role.parseRole((String)role));
                }
                if ((templateName = typeDescr.getMetaAttribute("template")) != null) {
                    type.setFormat(TypeDeclaration.Format.TEMPLATE);
                    FactTemplate template = pkgRegistry.getPackage().getFactTemplate(templateName);
                    if (template != null) {
                        type.setTypeTemplate(template);
                        break block16;
                    } else {
                        this.results.add(new TypeDeclarationError("Template not found '" + template + "' for type '" + type.getTypeName() + "'", typeDescr.getLine()));
                        continue;
                    }
                }
                String className = typeDescr.getMetaAttribute("class");
                if (className == null) {
                    className = type.getTypeName();
                }
                type.setFormat(TypeDeclaration.Format.POJO);
                try {
                    if (typeDescr.getFields().size() > 0) {
                        this.generateDeclaredBean(typeDescr, type, pkgRegistry);
                    }
                    Class clazz = pkgRegistry.getTypeResolver().resolveType(className);
                    type.setTypeClass(clazz);
                    if (type.getTypeClassDef() == null) break block16;
                    try {
                        this.buildFieldAccessors(type, pkgRegistry);
                        break block16;
                    }
                    catch (Exception e) {
                        this.results.add(new TypeDeclarationError("Error creating field accessors for '" + className + "' for type '" + type.getTypeName() + "'", typeDescr.getLine()));
                    }
                }
                catch (ClassNotFoundException e) {
                    this.results.add(new TypeDeclarationError("Class not found '" + className + "' for type '" + type.getTypeName() + "'", typeDescr.getLine()));
                }
                continue;
            }
            String timestamp = typeDescr.getMetaAttribute("timestamp");
            if (timestamp != null) {
                type.setTimestampAttribute(timestamp);
                ClassDefinition cd = type.getTypeClassDef();
                ClassFieldAccessorStore store = pkgRegistry.getPackage().getClassFieldAccessorStore();
                ClassFieldReader extractor = store.getReader(type.getTypeClass().getName(), timestamp, (AcceptsReadAccessor)new TypeDeclaration.TimestampAccessorSetter(type));
            }
            if ((duration = typeDescr.getMetaAttribute("duration")) != null) {
                type.setDurationAttribute(duration);
                ClassDefinition cd = type.getTypeClassDef();
                ClassFieldAccessorStore store = pkgRegistry.getPackage().getClassFieldAccessorStore();
                ClassFieldReader extractor = store.getReader(type.getTypeClass().getName(), duration, (AcceptsReadAccessor)new TypeDeclaration.DurationAccessorSetter(type));
            }
            pkgRegistry.getPackage().addTypeDeclaration(type);
        }
    }

    private final void buildFieldAccessors(TypeDeclaration type, PackageRegistry pkgRegistry) throws SecurityException, IllegalArgumentException, InstantiationException, IllegalAccessException, IOException, IntrospectionException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, NoSuchFieldException {
        ClassDefinition cd = type.getTypeClassDef();
        ClassFieldAccessorStore store = pkgRegistry.getPackage().getClassFieldAccessorStore();
        for (FieldDefinition attrDef : cd.getFieldsDefinitions()) {
            ClassFieldAccessor accessor = store.getAccessor(cd.getDefinedClass().getName(), attrDef.getName());
            attrDef.setReadWriteAccessor(accessor);
        }
    }

    private void generateDeclaredBean(TypeDeclarationDescr typeDescr, TypeDeclaration type, PackageRegistry pkgRegistry) {
        ClassBuilder cb = new ClassBuilder();
        String fullName = typeDescr.getNamespace() + "." + typeDescr.getTypeName();
        ClassDefinition def = new ClassDefinition(fullName);
        Map<String, TypeFieldDescr> flds = typeDescr.getFields();
        try {
            for (TypeFieldDescr field : flds.values()) {
                String fullFieldType = pkgRegistry.getTypeResolver().resolveType(field.getPattern().getObjectType()).getName();
                FieldDefinition fieldDef = new FieldDefinition(field.getFieldName(), fullFieldType);
                boolean isKey = field.getMetaAttributes().containsKey("key");
                fieldDef.setKey(isKey);
                def.addField(fieldDef);
            }
            byte[] d = cb.buildClass(def);
            JavaDialectRuntimeData dialect = (JavaDialectRuntimeData)pkgRegistry.getDialectRuntimeRegistry().getDialectData("java");
            dialect.write(JavaDialectRuntimeData.convertClassToResourcePath((String)fullName), d);
            type.setTypeClassDef(def);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.results.add(new TypeDeclarationError("Unable to create a class for declared type " + fullName + ": " + e.getMessage() + ";", typeDescr.getLine()));
        }
    }

    private void addFunction(FunctionDescr functionDescr) {
        functionDescr.setUrl(this.url);
        PackageRegistry pkgRegistry = this.pkgRegistryMap.get(functionDescr.getNamespace());
        Dialect dialect = pkgRegistry.getDialectCompiletimeRegistry().getDialect(functionDescr.getDialect());
        dialect.addFunction(functionDescr, pkgRegistry.getTypeResolver());
    }

    private void preCompileAddFunction(FunctionDescr functionDescr) {
        PackageRegistry pkgRegistry = this.pkgRegistryMap.get(functionDescr.getNamespace());
        Dialect dialect = pkgRegistry.getDialectCompiletimeRegistry().getDialect(functionDescr.getDialect());
        dialect.preCompileAddFunction(functionDescr, pkgRegistry.getTypeResolver());
    }

    private void postCompileAddFunction(FunctionDescr functionDescr) {
        PackageRegistry pkgRegistry = this.pkgRegistryMap.get(functionDescr.getNamespace());
        Dialect dialect = pkgRegistry.getDialectCompiletimeRegistry().getDialect(functionDescr.getDialect());
        dialect.postCompileAddFunction(functionDescr, pkgRegistry.getTypeResolver());
    }

    private void addFactTemplate(FactTemplateDescr factTemplateDescr) {
        ArrayList<FieldTemplateImpl> fields = new ArrayList<FieldTemplateImpl>();
        int index = 0;
        PackageRegistry pkgRegistry = this.pkgRegistryMap.get(this.defaultNamespace);
        for (FieldTemplateDescr fieldTemplateDescr : factTemplateDescr.getFields()) {
            FieldTemplateImpl fieldTemplate = null;
            try {
                fieldTemplate = new FieldTemplateImpl(fieldTemplateDescr.getName(), index++, pkgRegistry.getTypeResolver().resolveType(fieldTemplateDescr.getClassType()));
            }
            catch (ClassNotFoundException e) {
                this.results.add(new FieldTemplateError(pkgRegistry.getPackage(), fieldTemplateDescr, null, "Unable to resolve Class '" + fieldTemplateDescr.getClassType() + "'"));
            }
            fields.add(fieldTemplate);
        }
        FactTemplateImpl factTemplate = new FactTemplateImpl(pkgRegistry.getPackage(), factTemplateDescr.getName(), fields.toArray(new FieldTemplate[fields.size()]));
    }

    private void addRule(RuleDescr ruleDescr) {
        ruleDescr.setUrl(this.url);
        if (ruleDescr instanceof QueryDescr) {
            // empty if block
        }
        PackageRegistry pkgRegistry = this.pkgRegistryMap.get(ruleDescr.getNamespace());
        DialectCompiletimeRegistry ctr = pkgRegistry.getDialectCompiletimeRegistry();
        RuleBuildContext context = new RuleBuildContext(this, ruleDescr, ctr, pkgRegistry.getPackage(), ctr.getDialect(pkgRegistry.getDialect()));
        ruleBuilder.build(context);
        this.results.addAll(context.getErrors());
        context.getRule().setUrl(this.url);
        context.getDialect().addRule(context);
        if (this.ruleBase != null && pkgRegistry.getPackage().getRule(ruleDescr.getName()) != null) {
            this.ruleBase.removeRule(pkgRegistry.getPackage(), pkgRegistry.getPackage().getRule(ruleDescr.getName()));
        }
        pkgRegistry.getPackage().addRule(context.getRule());
    }

    public Package getPackage() {
        PackageRegistry pkgRegistry = this.pkgRegistryMap.get(this.defaultNamespace);
        Package pkg = null;
        if (pkgRegistry != null) {
            pkg = pkgRegistry.getPackage();
        }
        if (this.hasErrors() && pkg != null) {
            pkg.setError(this.getErrors().toString());
        }
        return pkg;
    }

    public Package[] getPackages() {
        Package[] pkgs = new Package[this.pkgRegistryMap.size()];
        int i = 0;
        String errors = null;
        if (!this.getErrors().isEmpty()) {
            errors = this.getErrors().toString();
        }
        for (PackageRegistry pkgRegistry : this.pkgRegistryMap.values()) {
            Package pkg = pkgRegistry.getPackage();
            pkg.getDialectRuntimeRegistry().onBeforeExecute();
            if (errors != null) {
                pkg.setError(errors);
            }
            pkgs[i++] = pkg;
        }
        return pkgs;
    }

    public PackageBuilderConfiguration getPackageBuilderConfiguration() {
        return this.configuration;
    }

    public PackageRegistry getPackageRegistry(String name) {
        return this.pkgRegistryMap.get(name);
    }

    public Map<String, PackageRegistry> getPackageRegistry() {
        return this.pkgRegistryMap;
    }

    public DefaultExpander getDslExpander() {
        DefaultExpander expander = new DefaultExpander();
        if (this.dslFiles == null || this.dslFiles.isEmpty()) {
            return expander;
        }
        for (DSLTokenizedMappingFile file : this.dslFiles) {
            expander.addDSLMapping(file.getMapping());
        }
        return expander;
    }

    public Map<String, Class> getGlobals() {
        return this.globals;
    }

    public boolean hasErrors() {
        return this.results.size() > 0;
    }

    public PackageBuilderErrors getErrors() {
        return new PackageBuilderErrors(this.results.toArray(new DroolsError[this.results.size()]));
    }

    protected void resetErrors() {
        this.results.clear();
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public String getDefaultDialect() {
        return this.defaultDialect;
    }

    private String ucFirst(String name) {
        return name.toUpperCase().charAt(0) + name.substring(1);
    }

    public CompositeClassLoader getRootClassLoader() {
        return this.rootClassLoader;
    }

    public static class SrcError
    extends DroolsError {
        private Object object;
        private String message;
        private int[] errorLines = new int[0];

        public SrcError(Object object, String message) {
            this.object = object;
            this.message = message;
        }

        public Object getObject() {
            return this.object;
        }

        public int[] getErrorLines() {
            return this.errorLines;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.message);
            buf.append(" : ");
            buf.append("\n");
            if (this.object instanceof CompilationProblem[]) {
                CompilationProblem[] problem = (CompilationProblem[])this.object;
                for (int i = 0; i < problem.length; ++i) {
                    buf.append("\t");
                    buf.append(problem[i]);
                    buf.append("\n");
                }
            } else if (this.object != null) {
                buf.append(this.object);
            }
            return buf.toString();
        }
    }

    public static class SrcErrorHandler
    extends ErrorHandler {
        public SrcErrorHandler(String message) {
            this.message = message;
        }

        public DroolsError getError() {
            return new SrcError(this.collectCompilerProblems(), this.message);
        }
    }

    public static class FunctionErrorHandler
    extends ErrorHandler {
        private FunctionDescr descr;

        public FunctionErrorHandler(FunctionDescr functionDescr, String message) {
            this.descr = functionDescr;
            this.message = message;
        }

        public DroolsError getError() {
            return new FunctionError(this.descr, this.collectCompilerProblems(), this.message);
        }
    }

    public static class ProcessInvokerErrorHandler
    extends ProcessErrorHandler {
        public ProcessInvokerErrorHandler(BaseDescr processDescr, Process process, String message) {
            super(processDescr, process, message);
        }
    }

    public static class RuleInvokerErrorHandler
    extends RuleErrorHandler {
        public RuleInvokerErrorHandler(BaseDescr ruleDescr, Rule rule, String message) {
            super(ruleDescr, rule, message);
        }
    }

    public static class ProcessErrorHandler
    extends ErrorHandler {
        private BaseDescr descr;
        private Process process;

        public ProcessErrorHandler(BaseDescr ruleDescr, Process process, String message) {
            this.descr = ruleDescr;
            this.process = process;
            this.message = message;
        }

        public DroolsError getError() {
            return new ProcessBuildError(this.process, this.descr, (Object)this.collectCompilerProblems(), this.message);
        }
    }

    public static class RuleErrorHandler
    extends ErrorHandler {
        private BaseDescr descr;
        private Rule rule;

        public RuleErrorHandler(BaseDescr ruleDescr, Rule rule, String message) {
            this.descr = ruleDescr;
            this.rule = rule;
            this.message = message;
        }

        public DroolsError getError() {
            return new RuleBuildError(this.rule, this.descr, (Object)this.collectCompilerProblems(), this.message);
        }
    }

    public static abstract class ErrorHandler {
        private final List errors = new ArrayList();
        protected String message;
        private boolean inError = false;

        public boolean isInError() {
            return this.inError;
        }

        public void addError(CompilationProblem err) {
            this.errors.add(err);
            this.inError = true;
        }

        public abstract DroolsError getError();

        protected CompilationProblem[] collectCompilerProblems() {
            if (this.errors.size() == 0) {
                return null;
            }
            CompilationProblem[] list = new CompilationProblem[this.errors.size()];
            this.errors.toArray(list);
            return list;
        }
    }

    public static class PackageMergeException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 400L;

        public PackageMergeException(String message) {
            super(message);
        }
    }

    public static class MissingPackageNameException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 400L;

        public MissingPackageNameException(String message) {
            super(message);
        }
    }
}

