/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.agent.KnowledgeAgent;
import org.drools.agent.KnowledgeAgentConfiguration;
import org.drools.agent.KnowledgeAgentFactory;
import org.drools.io.ResourceChangeScannerConfiguration;
import org.drools.io.ResourceFactory;
import org.drools.io.impl.ResourceChangeScannerImpl;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.util.FileManager;

public class KnowledgeAgentTest
extends TestCase {
    FileManager fileManager;

    protected void setUp() throws Exception {
        this.fileManager = new FileManager();
        this.fileManager.setUp();
        ((ResourceChangeScannerImpl)ResourceFactory.getResourceChangeScannerService()).reset();
        ResourceFactory.getResourceChangeNotifierService().start();
        ResourceFactory.getResourceChangeScannerService().start();
    }

    protected void tearDown() throws Exception {
        this.fileManager.tearDown();
        ResourceFactory.getResourceChangeNotifierService().stop();
        ResourceFactory.getResourceChangeScannerService().stop();
        ((ResourceChangeScannerImpl)ResourceFactory.getResourceChangeScannerService()).reset();
    }

    public void testModifyFile() throws IOException, InterruptedException {
        String rule1 = "";
        rule1 = rule1 + "package org.drools.test\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule rule1\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "list.add( drools.getRule().getName() );\n";
        rule1 = rule1 + "end\n";
        File f1 = this.fileManager.newFile("rule1.drl");
        f1.deleteOnExit();
        BufferedWriter output = new BufferedWriter(new FileWriter(f1));
        output.write(rule1);
        ((Writer)output).close();
        String rule2 = "";
        rule2 = rule2 + "package org.drools.test\n";
        rule2 = rule2 + "global java.util.List list\n";
        rule2 = rule2 + "rule rule2\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "list.add( drools.getRule().getName() );\n";
        rule2 = rule2 + "end\n";
        File f2 = this.fileManager.newFile("rule2.drl");
        f2.deleteOnExit();
        output = new BufferedWriter(new FileWriter(f2));
        output.write(rule2);
        ((Writer)output).close();
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set drools-change-set-5.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='" + f1.toURI().toURL() + "' type='DRL' />";
        xml = xml + "        <resource source='" + f2.toURI().toURL() + "' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.newFile("changeset.xml");
        fxml.deleteOnExit();
        output = new BufferedWriter(new FileWriter(fxml));
        output.write(xml);
        ((Writer)output).close();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        ResourceChangeScannerConfiguration sconf = ResourceFactory.getResourceChangeScannerService().newResourceChangeScannerConfiguration();
        sconf.setProperty("drools.resource.scanner.interval", "2");
        ResourceFactory.getResourceChangeScannerService().configure(sconf);
        KnowledgeAgentConfiguration aconf = KnowledgeAgentFactory.newKnowledgeAgentConfiguration();
        aconf.setProperty("drools.agent.scanDirectories", "true");
        aconf.setProperty("drools.agent.scanResources", "true");
        aconf.setProperty("drools.agent.newInstance", "true");
        KnowledgeAgent kagent = KnowledgeAgentFactory.newKnowledgeAgent((String)"test agent", (KnowledgeBase)kbase, (KnowledgeAgentConfiguration)aconf);
        kagent.applyChangeSet(ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        KnowledgeAgentTest.assertEquals((int)2, (int)list.size());
        KnowledgeAgentTest.assertTrue((boolean)list.contains("rule1"));
        KnowledgeAgentTest.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        Thread.sleep(2000L);
        rule1 = "";
        rule1 = rule1 + "package org.drools.test\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule rule3\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "list.add( drools.getRule().getName() );\n";
        rule1 = rule1 + "end\n";
        output = new BufferedWriter(new FileWriter(f1));
        output.write(rule1);
        ((Writer)output).close();
        Thread.sleep(3000L);
        ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        KnowledgeAgentTest.assertEquals((int)2, (int)list.size());
        KnowledgeAgentTest.assertTrue((boolean)list.contains("rule3"));
        KnowledgeAgentTest.assertTrue((boolean)list.contains("rule2"));
        kagent.monitorResourceChangeEvents(false);
    }

    public void testModifyDirectory() throws IOException, InterruptedException {
        String rule1 = "";
        rule1 = rule1 + "package org.drools.test\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule rule1\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "list.add( drools.getRule().getName() );\n";
        rule1 = rule1 + "end\n";
        File f1 = this.fileManager.newFile("rule1.drl");
        BufferedWriter output = new BufferedWriter(new FileWriter(f1));
        output.write(rule1);
        ((Writer)output).close();
        String rule2 = "";
        rule2 = rule2 + "package org.drools.test\n";
        rule2 = rule2 + "global java.util.List list\n";
        rule2 = rule2 + "rule rule2\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "list.add( drools.getRule().getName() );\n";
        rule2 = rule2 + "end\n";
        File f2 = this.fileManager.newFile("rule2.drl");
        output = new BufferedWriter(new FileWriter(f2));
        output.write(rule2);
        ((Writer)output).close();
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set drools-change-set-5.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='" + f1.getParentFile().toURI().toURL() + "' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File newDir = this.fileManager.newFile("changeset");
        newDir.mkdir();
        File fxml = this.fileManager.newFile(newDir, "changeset.xml");
        output = new BufferedWriter(new FileWriter(fxml));
        output.write(xml);
        ((Writer)output).close();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        ResourceChangeScannerConfiguration sconf = ResourceFactory.getResourceChangeScannerService().newResourceChangeScannerConfiguration();
        sconf.setProperty("drools.resource.scanner.interval", "2");
        ResourceFactory.getResourceChangeScannerService().configure(sconf);
        KnowledgeAgentConfiguration aconf = KnowledgeAgentFactory.newKnowledgeAgentConfiguration();
        aconf.setProperty("drools.agent.scanDirectories", "true");
        aconf.setProperty("drools.agent.newInstance", "true");
        KnowledgeAgent kagent = KnowledgeAgentFactory.newKnowledgeAgent((String)"test agent", (KnowledgeBase)kbase, (KnowledgeAgentConfiguration)aconf);
        kagent.applyChangeSet(ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        Thread.sleep(3000L);
        StatefulKnowledgeSession ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        KnowledgeAgentTest.assertEquals((int)2, (int)list.size());
        KnowledgeAgentTest.assertTrue((boolean)list.contains("rule1"));
        KnowledgeAgentTest.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        String rule3 = "";
        rule3 = rule3 + "package org.drools.test\n";
        rule3 = rule3 + "global java.util.List list\n";
        rule3 = rule3 + "rule rule3\n";
        rule3 = rule3 + "when\n";
        rule3 = rule3 + "then\n";
        rule3 = rule3 + "list.add( drools.getRule().getName() );\n";
        rule3 = rule3 + "end\n";
        File f3 = this.fileManager.newFile("rule3.drl");
        output = new BufferedWriter(new FileWriter(f3));
        output.write(rule3);
        ((Writer)output).close();
        KnowledgeAgentTest.assertTrue((boolean)f1.delete());
        Thread.sleep(3000L);
        ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        KnowledgeAgentTest.assertEquals((int)2, (int)list.size());
        KnowledgeAgentTest.assertTrue((boolean)list.contains("rule2"));
        KnowledgeAgentTest.assertTrue((boolean)list.contains("rule3"));
        kagent.monitorResourceChangeEvents(false);
    }
}

