/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.drools.guvnor.client.modeldriven.DropDownData;
import org.drools.guvnor.client.modeldriven.SuggestionCompletionEngine;
import org.drools.guvnor.client.modeldriven.brl.ActionFieldValue;
import org.drools.guvnor.client.modeldriven.brl.FactPattern;
import org.drools.guvnor.client.modeldriven.brl.FieldConstraint;
import org.drools.guvnor.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.guvnor.server.rules.SuggestionCompletionLoader;

public class SuggestionCompletionEngineTest
extends TestCase {
    public void testNestedImports() {
        String pkg = "package org.test\n import org.drools.guvnor.client.modeldriven.SuggestionCompletionEngineTest.NestedClass";
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine engine = loader.getSuggestionEngine(pkg, new ArrayList(), new ArrayList());
        SuggestionCompletionEngineTest.assertEquals((String)"String", (String)engine.getFieldType("SuggestionCompletionEngineTest$NestedClass", "name"));
    }

    public void testStringNonNumeric() {
        String pkg = "package org.test\n import org.drools.guvnor.client.modeldriven.Alert";
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine engine = loader.getSuggestionEngine(pkg, new ArrayList(), new ArrayList());
        SuggestionCompletionEngineTest.assertEquals((String)"String", (String)engine.getFieldType("Alert", "message"));
    }

    public void testDataEnums() {
        String pkg = "package org.test\n import org.drools.guvnor.client.modeldriven.SuggestionCompletionEngineTest.NestedClass";
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        ArrayList<String> enums = new ArrayList<String>();
        enums.add("'Person.age' : [42, 43] \n 'Person.sex' : ['M', 'F']");
        enums.add("'Driver.sex' : ['M', 'F']");
        SuggestionCompletionEngine engine = loader.getSuggestionEngine(pkg, new ArrayList(), new ArrayList(), enums);
        SuggestionCompletionEngineTest.assertEquals((String)"String", (String)engine.getFieldType("SuggestionCompletionEngineTest$NestedClass", "name"));
        SuggestionCompletionEngineTest.assertEquals((int)3, (int)engine.dataEnumLists.size());
        String[] items = (String[])engine.dataEnumLists.get("Person.age");
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)items.length);
        SuggestionCompletionEngineTest.assertEquals((String)"42", (String)items[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"43", (String)items[1]);
        items = engine.getEnums((FactPattern)new FactPattern((String)"Person"), (String)"age").fixedList;
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)items.length);
        SuggestionCompletionEngineTest.assertEquals((String)"42", (String)items[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"43", (String)items[1]);
        SuggestionCompletionEngineTest.assertNull((Object)engine.getEnums(new FactPattern("Nothing"), "age"));
        SuggestionCompletionEngineTest.assertEquals(null, (Object)engine.getEnums(new FactPattern("Something"), "else"));
    }

    public void testCompletions() {
        SuggestionCompletionEngine com = new SuggestionCompletionEngine();
        com.factTypes = new String[]{"Person", "Vehicle"};
        com.fieldsForType = new HashMap(){
            {
                this.put("Person", new String[]{"age", "name", "rank"});
                this.put("Vehicle", new String[]{"type", "make"});
            }
        };
        com.fieldTypes = new HashMap(){
            {
                this.put("Person.age", "Numeric");
                this.put("Person.rank", "Comparable");
                this.put("Person.name", "String");
                this.put("Vehicle.make", "String");
                this.put("Vehicle.type", "String");
            }
        };
        com.globalTypes = new HashMap(){
            {
                this.put("bar", "Person");
                this.put("baz", "Vehicle");
            }
        };
        String[] c = com.getConditionalElements();
        SuggestionCompletionEngineTest.assertEquals((String)"not", (String)c[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"exists", (String)c[1]);
        SuggestionCompletionEngineTest.assertEquals((String)"or", (String)c[2]);
        c = com.getFactTypes();
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)c.length);
        this.assertContains("Person", c);
        this.assertContains("Vehicle", c);
        c = com.getFieldCompletions("Person");
        SuggestionCompletionEngineTest.assertEquals((String)"age", (String)c[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"name", (String)c[1]);
        c = com.getFieldCompletions("Vehicle");
        SuggestionCompletionEngineTest.assertEquals((String)"type", (String)c[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"make", (String)c[1]);
        c = com.getOperatorCompletions("Person", "name");
        SuggestionCompletionEngineTest.assertEquals((int)4, (int)c.length);
        SuggestionCompletionEngineTest.assertEquals((String)"==", (String)c[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"!=", (String)c[1]);
        SuggestionCompletionEngineTest.assertEquals((String)"matches", (String)c[2]);
        c = com.getOperatorCompletions("Person", "age");
        SuggestionCompletionEngineTest.assertEquals((int)6, (int)c.length);
        SuggestionCompletionEngineTest.assertEquals((String)c[0], (String)"==");
        SuggestionCompletionEngineTest.assertEquals((String)c[1], (String)"!=");
        SuggestionCompletionEngineTest.assertEquals((String)c[2], (String)"<");
        SuggestionCompletionEngineTest.assertEquals((String)c[3], (String)">");
        c = com.getOperatorCompletions("Person", "rank");
        SuggestionCompletionEngineTest.assertEquals((int)6, (int)c.length);
        SuggestionCompletionEngineTest.assertEquals((String)c[0], (String)"==");
        SuggestionCompletionEngineTest.assertEquals((String)c[1], (String)"!=");
        SuggestionCompletionEngineTest.assertEquals((String)c[2], (String)"<");
        SuggestionCompletionEngineTest.assertEquals((String)c[3], (String)">");
        c = com.getConnectiveOperatorCompletions("Vehicle", "make");
        SuggestionCompletionEngineTest.assertEquals((int)5, (int)c.length);
        SuggestionCompletionEngineTest.assertEquals((String)"|| ==", (String)c[0]);
        c = com.getGlobalVariables();
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)c.length);
        SuggestionCompletionEngineTest.assertEquals((String)"baz", (String)c[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"bar", (String)c[1]);
        c = com.getFieldCompletionsForGlobalVariable("bar");
        SuggestionCompletionEngineTest.assertEquals((int)3, (int)c.length);
        SuggestionCompletionEngineTest.assertEquals((String)"age", (String)c[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"name", (String)c[1]);
        c = com.getFieldCompletionsForGlobalVariable("baz");
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)c.length);
        SuggestionCompletionEngineTest.assertEquals((String)"type", (String)c[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"make", (String)c[1]);
        c = com.getOperatorCompletions("Person", "wankle");
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)c.length);
        SuggestionCompletionEngineTest.assertEquals((String)"Numeric", (String)com.getFieldType("Person", "age"));
    }

    public void testAdd() {
        SuggestionCompletionEngine com = new SuggestionCompletionEngine();
        com.factTypes = new String[]{"Foo"};
        com.fieldsForType = new HashMap(){
            {
                this.put("Foo", new String[]{"a"});
            }
        };
        SuggestionCompletionEngineTest.assertEquals((int)1, (int)com.getFactTypes().length);
        SuggestionCompletionEngineTest.assertEquals((String)"Foo", (String)com.getFactTypes()[0]);
        SuggestionCompletionEngineTest.assertEquals((int)1, (int)com.getFieldCompletions("Foo").length);
        SuggestionCompletionEngineTest.assertEquals((String)"a", (String)com.getFieldCompletions("Foo")[0]);
    }

    public void testSmartEnums() {
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.dataEnumLists = new HashMap();
        sce.dataEnumLists.put("Fact.type", new String[]{"sex", "colour"});
        sce.dataEnumLists.put("Fact.value[type=sex]", new String[]{"M", "F"});
        sce.dataEnumLists.put("Fact.value[type=colour]", new String[]{"RED", "WHITE", "BLUE"});
        FactPattern pat = new FactPattern("Fact");
        SingleFieldConstraint sfc = new SingleFieldConstraint("type");
        sfc.value = "sex";
        pat.addConstraint((FieldConstraint)sfc);
        String[] result = sce.getEnums((FactPattern)pat, (String)"value").fixedList;
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)result.length);
        SuggestionCompletionEngineTest.assertEquals((String)"M", (String)result[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"F", (String)result[1]);
        pat = new FactPattern("Fact");
        sfc = new SingleFieldConstraint("type");
        sfc.value = "colour";
        pat.addConstraint((FieldConstraint)sfc);
        result = sce.getEnums((FactPattern)pat, (String)"value").fixedList;
        SuggestionCompletionEngineTest.assertEquals((int)3, (int)result.length);
        SuggestionCompletionEngineTest.assertEquals((String)"RED", (String)result[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"WHITE", (String)result[1]);
        SuggestionCompletionEngineTest.assertEquals((String)"BLUE", (String)result[2]);
        result = sce.getEnums((FactPattern)pat, (String)"type").fixedList;
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)result.length);
        SuggestionCompletionEngineTest.assertEquals((String)"sex", (String)result[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"colour", (String)result[1]);
        ActionFieldValue[] vals = new ActionFieldValue[]{new ActionFieldValue("type", "sex", "blah"), new ActionFieldValue("value", null, "blah")};
        result = sce.getEnums((String)"Fact", (ActionFieldValue[])vals, (String)"value").fixedList;
        SuggestionCompletionEngineTest.assertNotNull((Object)result);
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)result.length);
        SuggestionCompletionEngineTest.assertEquals((String)"M", (String)result[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"F", (String)result[1]);
        SuggestionCompletionEngineTest.assertNull((Object)sce.getEnums("Nothing", vals, "value"));
    }

    public void testSmarterLookupEnums() {
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.dataEnumLists = new HashMap();
        sce.dataEnumLists.put("Fact.type", new String[]{"sex", "colour"});
        sce.dataEnumLists.put("Fact.value[f1, f2]", new String[]{"select something from database where x=@{f1} and y=@{f2}"});
        FactPattern fp = new FactPattern("Fact");
        String[] drops = sce.getEnums((FactPattern)fp, (String)"type").fixedList;
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)drops.length);
        SuggestionCompletionEngineTest.assertEquals((String)"sex", (String)drops[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"colour", (String)drops[1]);
        Map lookupFields = sce.loadDataEnumLookupFields();
        SuggestionCompletionEngineTest.assertEquals((int)1, (int)lookupFields.size());
        String[] flds = (String[])lookupFields.get("Fact.value");
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)flds.length);
        SuggestionCompletionEngineTest.assertEquals((String)"f1", (String)flds[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"f2", (String)flds[1]);
        FactPattern pat = new FactPattern("Fact");
        SingleFieldConstraint sfc = new SingleFieldConstraint("f1");
        sfc.value = "f1val";
        pat.addConstraint((FieldConstraint)sfc);
        sfc = new SingleFieldConstraint("f2");
        sfc.value = "f2val";
        pat.addConstraint((FieldConstraint)sfc);
        DropDownData dd = sce.getEnums(pat, "value");
        SuggestionCompletionEngineTest.assertNull((Object)dd.fixedList);
        SuggestionCompletionEngineTest.assertNotNull((Object)dd.queryExpression);
        SuggestionCompletionEngineTest.assertNotNull((Object)dd.valuePairs);
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)dd.valuePairs.length);
        SuggestionCompletionEngineTest.assertEquals((String)"select something from database where x=@{f1} and y=@{f2}", (String)dd.queryExpression);
        SuggestionCompletionEngineTest.assertEquals((String)"f1=f1val", (String)dd.valuePairs[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"f2=f2val", (String)dd.valuePairs[1]);
        ActionFieldValue[] vals = new ActionFieldValue[]{new ActionFieldValue("f1", "f1val", "blah"), new ActionFieldValue("f2", "f2val", "blah")};
        dd = sce.getEnums("Fact", vals, "value");
        SuggestionCompletionEngineTest.assertNull((Object)dd.fixedList);
        SuggestionCompletionEngineTest.assertNotNull((Object)dd.queryExpression);
        SuggestionCompletionEngineTest.assertNotNull((Object)dd.valuePairs);
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)dd.valuePairs.length);
        SuggestionCompletionEngineTest.assertEquals((String)"select something from database where x=@{f1} and y=@{f2}", (String)dd.queryExpression);
        SuggestionCompletionEngineTest.assertEquals((String)"f1=f1val", (String)dd.valuePairs[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"f2=f2val", (String)dd.valuePairs[1]);
    }

    public void testSimpleEnums() {
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.dataEnumLists = new HashMap();
        sce.dataEnumLists.put("Fact.type", new String[]{"sex", "colour"});
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)sce.getEnumValues("Fact", "type").length);
        SuggestionCompletionEngineTest.assertEquals((String)"sex", (String)sce.getEnumValues("Fact", "type")[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"colour", (String)sce.getEnumValues("Fact", "type")[1]);
    }

    private void assertContains(String string, String[] c) {
        for (int i = 0; i < c.length; ++i) {
            if (!string.equals(c[i])) continue;
            return;
        }
        SuggestionCompletionEngineTest.fail((String)("String array did not contain: " + string));
    }

    public void testGlobalAndFacts() {
        SuggestionCompletionEngine com = new SuggestionCompletionEngine();
        com.globalTypes = new HashMap(){
            {
                this.put("y", "Foo");
            }
        };
        com.fieldsForType = new HashMap(){
            {
                this.put("Foo", new String[]{"a"});
            }
        };
        SuggestionCompletionEngineTest.assertFalse((boolean)com.isGlobalVariable("x"));
        SuggestionCompletionEngineTest.assertTrue((boolean)com.isGlobalVariable("y"));
    }

    public void testDataDropDown() {
        SuggestionCompletionEngineTest.assertNull((Object)DropDownData.create(null));
        SuggestionCompletionEngineTest.assertNull((Object)DropDownData.create(null, null));
        SuggestionCompletionEngineTest.assertTrue((boolean)(DropDownData.create((String[])new String[]{"hey"}) instanceof DropDownData));
        SuggestionCompletionEngineTest.assertTrue((boolean)(DropDownData.create((String)"abc", (String[])new String[]{"hey"}) instanceof DropDownData));
    }

    public static class NestedClass {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

