/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.modeldriven;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.drools.guvnor.server.util.DataEnumLoader;
import org.mvel2.MVEL;
import org.mvel2.templates.TemplateRuntime;

public class DataEnumLoaderTest
extends TestCase {
    public void testEnumGeneration() throws Exception {
        Object result = MVEL.eval((String)"[2, 3, 4, ]", new HashMap());
        DataEnumLoaderTest.assertTrue((boolean)(result instanceof List));
        List l = (List)result;
        DataEnumLoaderTest.assertEquals((int)3, (int)l.size());
        result = MVEL.eval((String)"['Person.age' : [2, 3]\n 'Person.name' : ['qqq', \n'ccc']]", new HashMap());
        DataEnumLoader loader = new DataEnumLoader(this.readLines().toString());
        DataEnumLoaderTest.assertFalse((String)loader.getErrors().toString(), (boolean)loader.hasErrors());
        Map enumeration = loader.getData();
        DataEnumLoaderTest.assertEquals((String)loader.getErrors().toString(), (int)0, (int)loader.getErrors().size());
        DataEnumLoaderTest.assertEquals((int)3, (int)enumeration.size());
        String[] list = (String[])enumeration.get("Person.age");
        DataEnumLoaderTest.assertEquals((int)4, (int)list.length);
        DataEnumLoaderTest.assertEquals((String)"1", (String)list[0]);
        DataEnumLoaderTest.assertEquals((String)"2", (String)list[1]);
        list = (String[])enumeration.get("Person.rating");
        DataEnumLoaderTest.assertEquals((int)2, (int)list.length);
        DataEnumLoaderTest.assertEquals((String)"High", (String)list[0]);
        DataEnumLoaderTest.assertEquals((String)"Low", (String)list[1]);
        loader = new DataEnumLoader("goober poo error");
        DataEnumLoaderTest.assertEquals((int)0, (int)loader.getData().size());
        DataEnumLoaderTest.assertFalse((loader.getErrors().size() == 0 ? 1 : 0) != 0);
        DataEnumLoaderTest.assertTrue((boolean)loader.hasErrors());
    }

    public void testNoOp() {
        DataEnumLoader loader = new DataEnumLoader(" ");
        DataEnumLoaderTest.assertFalse((boolean)loader.hasErrors());
        DataEnumLoaderTest.assertEquals((int)0, (int)loader.getData().size());
        loader = new DataEnumLoader("");
        DataEnumLoaderTest.assertFalse((boolean)loader.hasErrors());
        DataEnumLoaderTest.assertEquals((int)0, (int)loader.getData().size());
    }

    public void testLiteralHelperUtilityClass() {
        DataEnumLoader loader = new DataEnumLoader("=(new org.drools.guvnor.modeldriven.SampleDataSource2()).loadData()");
        DataEnumLoaderTest.assertFalse((boolean)loader.hasErrors());
        DataEnumLoaderTest.assertEquals((int)1, (int)loader.getData().size());
        String[] res = (String[])loader.getData().get("whee");
        DataEnumLoaderTest.assertEquals((int)2, (int)res.length);
        DataEnumLoaderTest.assertEquals((String)"hey", (String)res[0]);
        DataEnumLoaderTest.assertEquals((String)"ho", (String)res[1]);
    }

    public void testNewLines() {
        String s = "yeah yeah, \nyeah \nyeah";
        DataEnumLoaderTest.assertEquals((String)"yeah yeah,\nyeah,\nyeah", (String)DataEnumLoader.addCommasForNewLines((String)s));
    }

    public void testLazyString() {
        DataEnumLoader loader = new DataEnumLoader("'Person.type[sex]' : 'something @{sex}'");
        DataEnumLoaderTest.assertFalse((boolean)loader.hasErrors());
        Map data = loader.getData();
        String[] sl = (String[])data.get("Person.type[sex]");
        String s = sl[0];
        DataEnumLoaderTest.assertEquals((String)"something @{sex}", (String)s);
        HashMap context = new HashMap(){
            {
                this.put("sex", "cool");
            }
        };
        Object r = TemplateRuntime.eval((String)s, (Map)context);
        DataEnumLoaderTest.assertEquals((Object)"something cool", (Object)r);
        loader = new DataEnumLoader("'Person.type[sex, money]' : '@{sex} @{money}'");
        DataEnumLoaderTest.assertFalse((boolean)loader.hasErrors());
        sl = (String[])loader.getData().get("Person.type[sex, money]");
        s = sl[0];
        DataEnumLoaderTest.assertEquals((String)"@{sex} @{money}", (String)s);
    }

    private StringBuffer readLines() throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("Some.enumeration")));
        String line = "";
        StringBuffer buf = new StringBuffer();
        while ((line = r.readLine()) != null) {
            buf.append(line);
            buf.append('\n');
        }
        return buf;
    }
}

