/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import junit.framework.TestCase;
import org.drools.guvnor.client.modeldriven.dt.ActionInsertFactCol;
import org.drools.guvnor.client.modeldriven.dt.ActionSetFieldCol;
import org.drools.guvnor.client.modeldriven.dt.AttributeCol;
import org.drools.guvnor.client.modeldriven.dt.ConditionCol;
import org.drools.guvnor.client.modeldriven.dt.GuidedDecisionTable;
import org.drools.guvnor.client.modeldriven.dt.MetadataCol;
import org.drools.guvnor.server.util.GuidedDTXMLPersistence;

public class GuidedDTXMLPersistenceTest
extends TestCase {
    public void testRoundTrip() {
        GuidedDecisionTable dt = new GuidedDecisionTable();
        dt.actionCols.add(new ActionInsertFactCol());
        dt.actionCols.add(new ActionSetFieldCol());
        dt.getMetadataCols().add(new MetadataCol());
        dt.attributeCols.add(new AttributeCol());
        dt.conditionCols.add(new ConditionCol());
        dt.data = new String[][]{{"hola"}};
        dt.tableName = "blah";
        dt.descriptionWidth = 42;
        String xml = GuidedDTXMLPersistence.getInstance().marshal(dt);
        GuidedDTXMLPersistenceTest.assertNotNull((Object)xml);
        GuidedDTXMLPersistenceTest.assertEquals((int)-1, (int)xml.indexOf("ActionSetField"));
        GuidedDTXMLPersistenceTest.assertEquals((int)-1, (int)xml.indexOf("ConditionCol"));
        GuidedDTXMLPersistenceTest.assertEquals((int)-1, (int)xml.indexOf("GuidedDecisionTable"));
        GuidedDecisionTable dt_ = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        GuidedDTXMLPersistenceTest.assertNotNull((Object)dt_);
        GuidedDTXMLPersistenceTest.assertEquals((int)42, (int)dt_.descriptionWidth);
        GuidedDTXMLPersistenceTest.assertEquals((String)"blah", (String)dt_.tableName);
        GuidedDTXMLPersistenceTest.assertEquals((int)1, (int)dt_.getMetadataCols().size());
        GuidedDTXMLPersistenceTest.assertEquals((int)1, (int)dt_.attributeCols.size());
        GuidedDTXMLPersistenceTest.assertEquals((int)2, (int)dt_.actionCols.size());
        GuidedDTXMLPersistenceTest.assertEquals((int)1, (int)dt_.conditionCols.size());
    }
}

