/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import junit.framework.TestCase;
import org.drools.guvnor.client.modeldriven.SuggestionCompletionEngine;
import org.drools.guvnor.server.util.SuggestionCompletionEngineBuilder;
import org.drools.lang.dsl.AbstractDSLMappingEntry;
import org.drools.lang.dsl.DSLMappingEntry;

public class SuggestionCompletionEngineBuilderTest
extends TestCase {
    SuggestionCompletionEngineBuilder builder = new SuggestionCompletionEngineBuilder();

    protected void setUp() throws Exception {
        super.setUp();
        this.builder.newCompletionEngine();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAddDSLSentence() {
        String input = "{This} is a {pattern} considered pretty \\{{easy}\\} by most \\{people\\}. What do you {say}?";
        this.builder.addDSLActionSentence("{This} is a {pattern} considered pretty \\{{easy}\\} by most \\{people\\}. What do you {say}?");
        this.builder.addDSLConditionSentence("foo bar");
        SuggestionCompletionEngine engine = this.builder.getInstance();
        SuggestionCompletionEngineBuilderTest.assertEquals((int)1, (int)engine.actionDSLSentences.length);
        SuggestionCompletionEngineBuilderTest.assertEquals((int)1, (int)engine.conditionDSLSentences.length);
    }

    public void testAddSentenceMultipleTypes() {
        this.builder.addDSLMapping((AbstractDSLMappingEntry)new DSLMap(DSLMappingEntry.CONDITION, "cond"));
        this.builder.addDSLMapping((AbstractDSLMappingEntry)new DSLMap(DSLMappingEntry.CONSEQUENCE, "cons"));
        this.builder.addDSLMapping((AbstractDSLMappingEntry)new DSLMap(DSLMappingEntry.ANY, "any"));
        this.builder.addDSLMapping((AbstractDSLMappingEntry)new DSLMap(DSLMappingEntry.KEYWORD, "key"));
        SuggestionCompletionEngine engine = this.builder.getInstance();
        SuggestionCompletionEngineBuilderTest.assertEquals((int)1, (int)engine.actionDSLSentences.length);
        SuggestionCompletionEngineBuilderTest.assertEquals((int)1, (int)engine.conditionDSLSentences.length);
        SuggestionCompletionEngineBuilderTest.assertEquals((int)1, (int)engine.keywordDSLItems.length);
        SuggestionCompletionEngineBuilderTest.assertEquals((int)1, (int)engine.anyScopeDSLItems.length);
        SuggestionCompletionEngineBuilderTest.assertEquals((String)"cond", (String)engine.conditionDSLSentences[0].sentence);
    }

    class DSLMap
    extends AbstractDSLMappingEntry {
        DSLMap(DSLMappingEntry.Section sec, String sentence) {
            this.section = sec;
            this.sentence = sentence;
        }
    }
}

