/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.drools.ClockType;
import org.drools.OrderEvent;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.SessionConfiguration;
import org.drools.StatefulSession;
import org.drools.StockTick;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.integrationtests.SerializationHelper;
import org.drools.lang.descr.PackageDescr;
import org.drools.rule.Package;
import org.drools.time.SessionPseudoClock;
import org.drools.time.impl.PseudoClockScheduler;

public class CepEspTest
extends TestCase {
    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }

    protected RuleBase getRuleBase(RuleBaseConfiguration config) throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }

    private RuleBase loadRuleBase(Reader reader) throws IOException, DroolsParserException, Exception {
        return this.loadRuleBase(reader, null);
    }

    private RuleBase loadRuleBase(Reader reader, RuleBaseConfiguration conf) throws IOException, DroolsParserException, Exception {
        DrlParser parser = new DrlParser();
        PackageDescr packageDescr = parser.parse(reader);
        if (parser.hasErrors()) {
            System.out.println(parser.getErrors());
            Assert.fail((String)"Error messages in parser, need to sort this our (or else collect error messages)");
        }
        PackageBuilder builder = new PackageBuilder();
        builder.addPackage(packageDescr);
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase(conf);
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        return ruleBase;
    }

    public void testEventAssertion() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_CEP_SimpleEventAssertion.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        SessionConfiguration conf = new SessionConfiguration();
        conf.setClockType(ClockType.PSEUDO_CLOCK);
        StatefulSession session = ruleBase.newStatefulSession(conf);
        ArrayList results = new ArrayList();
        session.setGlobal("results", results);
        StockTick tick1 = new StockTick(1L, "DROO", 50.0, 10000L);
        StockTick tick2 = new StockTick(2L, "ACME", 10.0, 10010L);
        StockTick tick3 = new StockTick(3L, "ACME", 10.0, 10100L);
        StockTick tick4 = new StockTick(4L, "DROO", 50.0, 11000L);
        InternalFactHandle handle1 = (InternalFactHandle)session.insert((Object)tick1);
        InternalFactHandle handle2 = (InternalFactHandle)session.insert((Object)tick2);
        InternalFactHandle handle3 = (InternalFactHandle)session.insert((Object)tick3);
        InternalFactHandle handle4 = (InternalFactHandle)session.insert((Object)tick4);
        CepEspTest.assertNotNull((Object)handle1);
        CepEspTest.assertNotNull((Object)handle2);
        CepEspTest.assertNotNull((Object)handle3);
        CepEspTest.assertNotNull((Object)handle4);
        CepEspTest.assertTrue((boolean)handle1.isEvent());
        CepEspTest.assertTrue((boolean)handle2.isEvent());
        CepEspTest.assertTrue((boolean)handle3.isEvent());
        CepEspTest.assertTrue((boolean)handle4.isEvent());
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        session.fireAllRules();
        CepEspTest.assertEquals((int)2, (int)((List)session.getGlobal("results")).size());
    }

    public void testEventAssertionWithDuration() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_CEP_SimpleEventAssertionWithDuration.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        SessionConfiguration conf = new SessionConfiguration();
        conf.setClockType(ClockType.PSEUDO_CLOCK);
        StatefulSession wm = ruleBase.newStatefulSession(conf);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        StockTick tick1 = new StockTick(1L, "DROO", 50.0, 10000L, 5L);
        StockTick tick2 = new StockTick(2L, "ACME", 10.0, 11000L, 10L);
        StockTick tick3 = new StockTick(3L, "ACME", 10.0, 12000L, 8L);
        StockTick tick4 = new StockTick(4L, "DROO", 50.0, 13000L, 7L);
        InternalFactHandle handle1 = (InternalFactHandle)wm.insert((Object)tick1);
        InternalFactHandle handle2 = (InternalFactHandle)wm.insert((Object)tick2);
        InternalFactHandle handle3 = (InternalFactHandle)wm.insert((Object)tick3);
        InternalFactHandle handle4 = (InternalFactHandle)wm.insert((Object)tick4);
        CepEspTest.assertNotNull((Object)handle1);
        CepEspTest.assertNotNull((Object)handle2);
        CepEspTest.assertNotNull((Object)handle3);
        CepEspTest.assertNotNull((Object)handle4);
        CepEspTest.assertTrue((boolean)handle1.isEvent());
        CepEspTest.assertTrue((boolean)handle2.isEvent());
        CepEspTest.assertTrue((boolean)handle3.isEvent());
        CepEspTest.assertTrue((boolean)handle4.isEvent());
        EventFactHandle eh1 = (EventFactHandle)handle1;
        EventFactHandle eh2 = (EventFactHandle)handle2;
        EventFactHandle eh3 = (EventFactHandle)handle3;
        EventFactHandle eh4 = (EventFactHandle)handle4;
        CepEspTest.assertEquals((long)tick1.getTime(), (long)eh1.getStartTimestamp());
        CepEspTest.assertEquals((long)tick2.getTime(), (long)eh2.getStartTimestamp());
        CepEspTest.assertEquals((long)tick3.getTime(), (long)eh3.getStartTimestamp());
        CepEspTest.assertEquals((long)tick4.getTime(), (long)eh4.getStartTimestamp());
        CepEspTest.assertEquals((long)tick1.getDuration(), (long)eh1.getDuration());
        CepEspTest.assertEquals((long)tick2.getDuration(), (long)eh2.getDuration());
        CepEspTest.assertEquals((long)tick3.getDuration(), (long)eh3.getDuration());
        CepEspTest.assertEquals((long)tick4.getDuration(), (long)eh4.getDuration());
        wm.fireAllRules();
        CepEspTest.assertEquals((int)2, (int)results.size());
    }

    public void testEventAssertionWithDateTimestamp() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_CEP_SimpleEventAssertionWithDateTimestamp.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        SessionConfiguration conf = new SessionConfiguration();
        conf.setClockType(ClockType.PSEUDO_CLOCK);
        StatefulSession wm = ruleBase.newStatefulSession(conf);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        StockTick tick1 = new StockTick(1L, "DROO", 50.0, 10000L, 5L);
        StockTick tick2 = new StockTick(2L, "ACME", 10.0, 11000L, 10L);
        StockTick tick3 = new StockTick(3L, "ACME", 10.0, 12000L, 8L);
        StockTick tick4 = new StockTick(4L, "DROO", 50.0, 13000L, 7L);
        InternalFactHandle handle1 = (InternalFactHandle)wm.insert((Object)tick1);
        InternalFactHandle handle2 = (InternalFactHandle)wm.insert((Object)tick2);
        InternalFactHandle handle3 = (InternalFactHandle)wm.insert((Object)tick3);
        InternalFactHandle handle4 = (InternalFactHandle)wm.insert((Object)tick4);
        CepEspTest.assertNotNull((Object)handle1);
        CepEspTest.assertNotNull((Object)handle2);
        CepEspTest.assertNotNull((Object)handle3);
        CepEspTest.assertNotNull((Object)handle4);
        CepEspTest.assertTrue((boolean)handle1.isEvent());
        CepEspTest.assertTrue((boolean)handle2.isEvent());
        CepEspTest.assertTrue((boolean)handle3.isEvent());
        CepEspTest.assertTrue((boolean)handle4.isEvent());
        EventFactHandle eh1 = (EventFactHandle)handle1;
        EventFactHandle eh2 = (EventFactHandle)handle2;
        EventFactHandle eh3 = (EventFactHandle)handle3;
        EventFactHandle eh4 = (EventFactHandle)handle4;
        CepEspTest.assertEquals((long)tick1.getTime(), (long)eh1.getStartTimestamp());
        CepEspTest.assertEquals((long)tick2.getTime(), (long)eh2.getStartTimestamp());
        CepEspTest.assertEquals((long)tick3.getTime(), (long)eh3.getStartTimestamp());
        CepEspTest.assertEquals((long)tick4.getTime(), (long)eh4.getStartTimestamp());
        wm.fireAllRules();
        CepEspTest.assertEquals((int)2, (int)results.size());
    }

    public void testTimeRelationalOperators() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_CEP_TimeRelationalOperators.drl"));
        RuleBaseConfiguration rbconf = new RuleBaseConfiguration();
        rbconf.setEventProcessingMode(RuleBaseConfiguration.EventProcessingMode.STREAM);
        RuleBase ruleBase = this.loadRuleBase(reader, rbconf);
        SessionConfiguration conf = new SessionConfiguration();
        conf.setClockType(ClockType.PSEUDO_CLOCK);
        StatefulSession wm = ruleBase.newStatefulSession(conf);
        PseudoClockScheduler clock = (PseudoClockScheduler)wm.getSessionClock();
        clock.setStartupTime(1000);
        ArrayList results_coincides = new ArrayList();
        ArrayList results_before = new ArrayList();
        ArrayList results_after = new ArrayList();
        ArrayList results_meets = new ArrayList();
        ArrayList results_met_by = new ArrayList();
        ArrayList results_overlaps = new ArrayList();
        ArrayList results_overlapped_by = new ArrayList();
        ArrayList results_during = new ArrayList();
        ArrayList results_includes = new ArrayList();
        ArrayList results_starts = new ArrayList();
        ArrayList results_started_by = new ArrayList();
        ArrayList results_finishes = new ArrayList();
        ArrayList results_finished_by = new ArrayList();
        wm.setGlobal("results_coincides", results_coincides);
        wm.setGlobal("results_before", results_before);
        wm.setGlobal("results_after", results_after);
        wm.setGlobal("results_meets", results_meets);
        wm.setGlobal("results_met_by", results_met_by);
        wm.setGlobal("results_overlaps", results_overlaps);
        wm.setGlobal("results_overlapped_by", results_overlapped_by);
        wm.setGlobal("results_during", results_during);
        wm.setGlobal("results_includes", results_includes);
        wm.setGlobal("results_starts", results_starts);
        wm.setGlobal("results_started_by", results_started_by);
        wm.setGlobal("results_finishes", results_finishes);
        wm.setGlobal("results_finished_by", results_finished_by);
        StockTick tick1 = new StockTick(1L, "DROO", 50.0, System.currentTimeMillis(), 3L);
        StockTick tick2 = new StockTick(2L, "ACME", 10.0, System.currentTimeMillis(), 3L);
        StockTick tick3 = new StockTick(3L, "ACME", 10.0, System.currentTimeMillis(), 3L);
        StockTick tick4 = new StockTick(4L, "DROO", 50.0, System.currentTimeMillis(), 5L);
        StockTick tick5 = new StockTick(5L, "ACME", 10.0, System.currentTimeMillis(), 5L);
        StockTick tick6 = new StockTick(6L, "ACME", 10.0, System.currentTimeMillis(), 3L);
        StockTick tick7 = new StockTick(7L, "ACME", 10.0, System.currentTimeMillis(), 5L);
        StockTick tick8 = new StockTick(8L, "ACME", 10.0, System.currentTimeMillis(), 3L);
        InternalFactHandle handle1 = (InternalFactHandle)wm.insert((Object)tick1);
        clock.advanceTime(4L, TimeUnit.MILLISECONDS);
        InternalFactHandle handle2 = (InternalFactHandle)wm.insert((Object)tick2);
        clock.advanceTime(4L, TimeUnit.MILLISECONDS);
        InternalFactHandle handle3 = (InternalFactHandle)wm.insert((Object)tick3);
        clock.advanceTime(4L, TimeUnit.MILLISECONDS);
        InternalFactHandle handle4 = (InternalFactHandle)wm.insert((Object)tick4);
        InternalFactHandle handle5 = (InternalFactHandle)wm.insert((Object)tick5);
        clock.advanceTime(1L, TimeUnit.MILLISECONDS);
        InternalFactHandle handle6 = (InternalFactHandle)wm.insert((Object)tick6);
        InternalFactHandle handle7 = (InternalFactHandle)wm.insert((Object)tick7);
        clock.advanceTime(2L, TimeUnit.MILLISECONDS);
        InternalFactHandle handle8 = (InternalFactHandle)wm.insert((Object)tick8);
        CepEspTest.assertNotNull((Object)handle1);
        CepEspTest.assertNotNull((Object)handle2);
        CepEspTest.assertNotNull((Object)handle3);
        CepEspTest.assertNotNull((Object)handle4);
        CepEspTest.assertNotNull((Object)handle5);
        CepEspTest.assertNotNull((Object)handle6);
        CepEspTest.assertNotNull((Object)handle7);
        CepEspTest.assertNotNull((Object)handle8);
        CepEspTest.assertTrue((boolean)handle1.isEvent());
        CepEspTest.assertTrue((boolean)handle2.isEvent());
        CepEspTest.assertTrue((boolean)handle3.isEvent());
        CepEspTest.assertTrue((boolean)handle4.isEvent());
        CepEspTest.assertTrue((boolean)handle6.isEvent());
        CepEspTest.assertTrue((boolean)handle7.isEvent());
        CepEspTest.assertTrue((boolean)handle8.isEvent());
        wm.fireAllRules();
        CepEspTest.assertEquals((int)1, (int)results_coincides.size());
        CepEspTest.assertEquals((Object)tick5, results_coincides.get(0));
        CepEspTest.assertEquals((int)1, (int)results_before.size());
        CepEspTest.assertEquals((Object)tick2, results_before.get(0));
        CepEspTest.assertEquals((int)1, (int)results_after.size());
        CepEspTest.assertEquals((Object)tick3, results_after.get(0));
        CepEspTest.assertEquals((int)1, (int)results_meets.size());
        CepEspTest.assertEquals((Object)tick3, results_meets.get(0));
        CepEspTest.assertEquals((int)1, (int)results_met_by.size());
        CepEspTest.assertEquals((Object)tick2, results_met_by.get(0));
        CepEspTest.assertEquals((int)1, (int)results_met_by.size());
        CepEspTest.assertEquals((Object)tick2, results_met_by.get(0));
        CepEspTest.assertEquals((int)1, (int)results_overlaps.size());
        CepEspTest.assertEquals((Object)tick4, results_overlaps.get(0));
        CepEspTest.assertEquals((int)1, (int)results_overlapped_by.size());
        CepEspTest.assertEquals((Object)tick8, results_overlapped_by.get(0));
        CepEspTest.assertEquals((int)1, (int)results_during.size());
        CepEspTest.assertEquals((Object)tick6, results_during.get(0));
        CepEspTest.assertEquals((int)1, (int)results_includes.size());
        CepEspTest.assertEquals((Object)tick4, results_includes.get(0));
        CepEspTest.assertEquals((int)1, (int)results_starts.size());
        CepEspTest.assertEquals((Object)tick6, results_starts.get(0));
        CepEspTest.assertEquals((int)1, (int)results_started_by.size());
        CepEspTest.assertEquals((Object)tick7, results_started_by.get(0));
        CepEspTest.assertEquals((int)1, (int)results_finishes.size());
        CepEspTest.assertEquals((Object)tick8, results_finishes.get(0));
        CepEspTest.assertEquals((int)1, (int)results_finished_by.size());
        CepEspTest.assertEquals((Object)tick7, results_finished_by.get(0));
    }

    public void FIXME_testSimpleTimeWindow() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_CEP_SimpleTimeWindow.drl"));
        RuleBaseConfiguration rbconf = new RuleBaseConfiguration();
        rbconf.setEventProcessingMode(RuleBaseConfiguration.EventProcessingMode.STREAM);
        RuleBase ruleBase = this.loadRuleBase(reader, rbconf);
        SessionConfiguration conf = new SessionConfiguration();
        conf.setClockType(ClockType.PSEUDO_CLOCK);
        StatefulSession wm = ruleBase.newStatefulSession(conf);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        SessionPseudoClock clock = (SessionPseudoClock)wm.getSessionClock();
        clock.advanceTime(5L, TimeUnit.SECONDS);
        EventFactHandle handle1 = (EventFactHandle)wm.insert((Object)new OrderEvent("1", "customer A", 70.0));
        CepEspTest.assertEquals((long)5000L, (long)handle1.getStartTimestamp());
        CepEspTest.assertEquals((long)0L, (long)handle1.getDuration());
        wm.fireAllRules();
        CepEspTest.assertEquals((int)1, (int)results.size());
        CepEspTest.assertEquals((int)70, (int)((Number)results.get(0)).intValue());
        clock.advanceTime(10L, TimeUnit.SECONDS);
        EventFactHandle handle2 = (EventFactHandle)wm.insert((Object)new OrderEvent("2", "customer A", 60.0));
        CepEspTest.assertEquals((long)15000L, (long)handle2.getStartTimestamp());
        CepEspTest.assertEquals((long)0L, (long)handle2.getDuration());
        wm.fireAllRules();
        CepEspTest.assertEquals((int)2, (int)results.size());
        CepEspTest.assertEquals((int)65, (int)((Number)results.get(1)).intValue());
        clock.advanceTime(10L, TimeUnit.SECONDS);
        EventFactHandle handle3 = (EventFactHandle)wm.insert((Object)new OrderEvent("3", "customer A", 50.0));
        CepEspTest.assertEquals((long)25000L, (long)handle3.getStartTimestamp());
        CepEspTest.assertEquals((long)0L, (long)handle3.getDuration());
        wm.fireAllRules();
        CepEspTest.assertEquals((int)3, (int)results.size());
        CepEspTest.assertEquals((int)60, (int)((Number)results.get(2)).intValue());
        clock.advanceTime(10L, TimeUnit.SECONDS);
        EventFactHandle handle4 = (EventFactHandle)wm.insert((Object)new OrderEvent("4", "customer A", 25.0));
        CepEspTest.assertEquals((long)35000L, (long)handle4.getStartTimestamp());
        CepEspTest.assertEquals((long)0L, (long)handle4.getDuration());
        wm.fireAllRules();
        CepEspTest.assertEquals((int)3, (int)results.size());
        clock.advanceTime(10L, TimeUnit.SECONDS);
        EventFactHandle handle5 = (EventFactHandle)wm.insert((Object)new OrderEvent("5", "customer A", 70.0));
        CepEspTest.assertEquals((long)45000L, (long)handle5.getStartTimestamp());
        CepEspTest.assertEquals((long)0L, (long)handle5.getDuration());
        wm.fireAllRules();
        CepEspTest.assertEquals((int)3, (int)results.size());
        clock.advanceTime(10L, TimeUnit.SECONDS);
        EventFactHandle handle6 = (EventFactHandle)wm.insert((Object)new OrderEvent("6", "customer A", 115.0));
        CepEspTest.assertEquals((long)55000L, (long)handle6.getStartTimestamp());
        CepEspTest.assertEquals((long)0L, (long)handle6.getDuration());
        wm.fireAllRules();
        CepEspTest.assertEquals((int)4, (int)results.size());
        CepEspTest.assertEquals((int)70, (int)((Number)results.get(3)).intValue());
    }

    public void testSimpleLengthWindow() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_CEP_SimpleLengthWindow.drl"));
        RuleBaseConfiguration rbconf = new RuleBaseConfiguration();
        rbconf.setEventProcessingMode(RuleBaseConfiguration.EventProcessingMode.STREAM);
        RuleBase ruleBase = this.loadRuleBase(reader, rbconf);
        SessionConfiguration conf = new SessionConfiguration();
        conf.setClockType(ClockType.REALTIME_CLOCK);
        StatefulSession wm = ruleBase.newStatefulSession(conf);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        EventFactHandle handle1 = (EventFactHandle)wm.insert((Object)new OrderEvent("1", "customer A", 70.0));
        wm.fireAllRules();
        CepEspTest.assertEquals((int)1, (int)results.size());
        CepEspTest.assertEquals((int)70, (int)((Number)results.get(0)).intValue());
        EventFactHandle handle2 = (EventFactHandle)wm.insert((Object)new OrderEvent("2", "customer A", 60.0));
        wm.fireAllRules();
        CepEspTest.assertEquals((int)2, (int)results.size());
        CepEspTest.assertEquals((int)65, (int)((Number)results.get(1)).intValue());
        EventFactHandle handle3 = (EventFactHandle)wm.insert((Object)new OrderEvent("3", "customer A", 50.0));
        wm.fireAllRules();
        CepEspTest.assertEquals((int)3, (int)results.size());
        CepEspTest.assertEquals((int)60, (int)((Number)results.get(2)).intValue());
        EventFactHandle handle4 = (EventFactHandle)wm.insert((Object)new OrderEvent("4", "customer A", 25.0));
        wm.fireAllRules();
        CepEspTest.assertEquals((int)3, (int)results.size());
        EventFactHandle handle5 = (EventFactHandle)wm.insert((Object)new OrderEvent("5", "customer A", 70.0));
        wm.fireAllRules();
        CepEspTest.assertEquals((int)3, (int)results.size());
        EventFactHandle handle6 = (EventFactHandle)wm.insert((Object)new OrderEvent("6", "customer A", 115.0));
        wm.fireAllRules();
        CepEspTest.assertEquals((int)4, (int)results.size());
        CepEspTest.assertEquals((int)70, (int)((Number)results.get(3)).intValue());
    }
}

