/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.FactA;
import org.drools.FactB;
import org.drools.Order;
import org.drools.OrderItem;
import org.drools.Person;
import org.drools.Precondition;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.common.InternalFactHandle;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.integrationtests.SerializationHelper;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.rule.Package;
import org.drools.runtime.rule.FactHandle;

public class DynamicRulesTest
extends TestCase {
    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }

    protected RuleBase getRuleBase(RuleBaseConfiguration config) throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }

    public void testDynamicRuleAdditions() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic1.drl"));
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)reader);
        Package pkg1 = SerializationHelper.serializeObject(builder.getPackage());
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg1);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.setGlobal("total", (Object)new Integer(0));
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Person bob = new Person("bob", "stilton");
        bob.setStatus("Not evaluated");
        workingMemory.insert((Object)bob);
        Cheese stilton = new Cheese("stilton", 5);
        workingMemory.insert((Object)stilton);
        Cheese cheddar = new Cheese("cheddar", 5);
        workingMemory.insert((Object)cheddar);
        workingMemory.fireAllRules();
        DynamicRulesTest.assertEquals((int)1, (int)list.size());
        DynamicRulesTest.assertEquals((Object)"stilton", list.get(0));
        reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic2.drl"));
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)reader);
        Package pkg2 = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg2);
        DynamicRulesTest.assertEquals((int)3, (int)list.size());
        DynamicRulesTest.assertEquals((Object)"stilton", list.get(0));
        DynamicRulesTest.assertTrue(("cheddar".equals(list.get(1)) || "cheddar".equals(list.get(2)) ? 1 : 0) != 0);
        DynamicRulesTest.assertTrue(("stilton".equals(list.get(1)) || "stilton".equals(list.get(2)) ? 1 : 0) != 0);
        list.clear();
        reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic3.drl"));
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)reader);
        Package pkg3 = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg3);
        Assert.assertEquals((String)"Rule from package 3 should have been fired", (String)"match Person ok", (String)bob.getStatus());
        DynamicRulesTest.assertEquals((int)1, (int)list.size());
        DynamicRulesTest.assertEquals((Object)bob, list.get(0));
        reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic4.drl"));
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)reader);
        Package pkg4 = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg4);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        Assert.assertEquals((String)"Rule from package 4 should have been fired", (String)"Who likes Stilton ok", (String)bob.getStatus());
        DynamicRulesTest.assertEquals((int)2, (int)list.size());
        DynamicRulesTest.assertEquals((Object)bob, list.get(1));
    }

    public void testDynamicRuleRemovals() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic1.drl")));
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic3.drl")));
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic4.drl")));
        Package pkg = SerializationHelper.serializeObject(builder.getPackage());
        ReteooRuleBase reteooRuleBase = null;
        RuleBase ruleBase = this.getRuleBase();
        reteooRuleBase = (ReteooRuleBase)ruleBase;
        ruleBase.addPackage(pkg);
        PackageBuilder builder2 = new PackageBuilder();
        builder2.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic2.drl")));
        ruleBase.addPackage(SerializationHelper.serializeObject(builder2.getPackage()));
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Person bob = new Person("bob", "stilton");
        bob.setStatus("Not evaluated");
        workingMemory.insert((Object)bob);
        Cheese stilton1 = new Cheese("stilton", 5);
        workingMemory.insert((Object)stilton1);
        Cheese stilton2 = new Cheese("stilton", 3);
        workingMemory.insert((Object)stilton2);
        Cheese stilton3 = new Cheese("stilton", 1);
        workingMemory.insert((Object)stilton3);
        Cheese cheddar = new Cheese("cheddar", 5);
        workingMemory.insert((Object)cheddar);
        DynamicRulesTest.assertEquals((int)15, (int)workingMemory.getAgenda().getActivations().length);
        reteooRuleBase.removeRule("org.drools.test", "Who likes Stilton");
        DynamicRulesTest.assertEquals((int)12, (int)workingMemory.getAgenda().getActivations().length);
        reteooRuleBase.removeRule("org.drools.test", "like cheese");
        Cheese muzzarela = new Cheese("muzzarela", 5);
        DynamicRulesTest.assertEquals((int)8, (int)workingMemory.getAgenda().getActivations().length);
        workingMemory.insert((Object)muzzarela);
        DynamicRulesTest.assertEquals((int)9, (int)workingMemory.getAgenda().getActivations().length);
        reteooRuleBase.removePackage("org.drools.test");
        reteooRuleBase = SerializationHelper.serializeObject(reteooRuleBase);
        DynamicRulesTest.assertEquals((int)0, (int)workingMemory.getAgenda().getActivations().length);
    }

    public void testDynamicRuleRemovalsUnusedWorkingMemory() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic1.drl")));
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic2.drl")));
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic3.drl")));
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic4.drl")));
        Package pkg = builder.getPackage();
        ReteooRuleBase reteooRuleBase = null;
        RuleBase ruleBase = this.getRuleBase();
        reteooRuleBase = (ReteooRuleBase)ruleBase;
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        if (reteooRuleBase != null) {
            DynamicRulesTest.assertEquals((int)1, (int)reteooRuleBase.getPackages().length);
            DynamicRulesTest.assertEquals((int)5, (int)reteooRuleBase.getPackages()[0].getRules().length);
            reteooRuleBase.removeRule("org.drools.test", "Who likes Stilton");
            DynamicRulesTest.assertEquals((int)4, (int)reteooRuleBase.getPackages()[0].getRules().length);
            reteooRuleBase.removeRule("org.drools.test", "like cheese");
            DynamicRulesTest.assertEquals((int)3, (int)reteooRuleBase.getPackages()[0].getRules().length);
            reteooRuleBase.removePackage("org.drools.test");
            DynamicRulesTest.assertEquals((int)0, (int)reteooRuleBase.getPackages().length);
        }
    }

    public void testDynamicFunction() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DynamicFunction1.drl")));
        Package pkg = SerializationHelper.serializeObject(builder.getPackage());
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        workingMemory.insert((Object)stilton);
        workingMemory.fireAllRules();
        DynamicRulesTest.assertEquals((Object)new Integer(5), list.get(0));
        ruleBase.removeFunction("org.drools.test", "addFive");
        Cheese cheddar = new Cheese("cheddar", 5);
        workingMemory.insert((Object)cheddar);
        try {
            workingMemory.fireAllRules();
            DynamicRulesTest.fail((String)"Function should have been removed and NoClassDefFoundError thrown from the Consequence");
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DynamicFunction2.drl")));
        ruleBase.addPackage(SerializationHelper.serializeObject(builder.getPackage()));
        Cheese brie = new Cheese("brie", 5);
        workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        DynamicRulesTest.assertEquals((Object)new Integer(6), list.get(1));
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DynamicFunction3.drl")));
        ruleBase.addPackage(SerializationHelper.serializeObject(builder.getPackage()));
        Cheese feta = new Cheese("feta", 5);
        workingMemory.insert((Object)feta);
        workingMemory.fireAllRules();
        DynamicRulesTest.assertEquals((Object)new Integer(5), list.get(2));
    }

    public void testRemovePackage() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_RemovePackage.drl")));
        RuleBase ruleBase = this.getRuleBase();
        String packageName = builder.getPackage().getName();
        ruleBase.addPackage(SerializationHelper.serializeObject(builder.getPackage()));
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        session.insert((Object)new Precondition("genericcode", "genericvalue"));
        session.fireAllRules();
        RuleBase ruleBaseWM = session.getRuleBase();
        ruleBaseWM.removePackage(packageName);
        PackageBuilder builder1 = new PackageBuilder();
        builder1.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_RemovePackage.drl")));
        ruleBaseWM.addPackage(SerializationHelper.serializeObject(builder1.getPackage()));
        ruleBaseWM = SerializationHelper.serializeObject(ruleBaseWM);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        session.fireAllRules();
        ruleBaseWM.removePackage(packageName);
        ruleBaseWM.addPackage(SerializationHelper.serializeObject(builder1.getPackage()));
        ruleBaseWM.removePackage(packageName);
        ruleBaseWM.addPackage(SerializationHelper.serializeObject(builder1.getPackage()));
    }

    public void testDynamicRules() throws Exception {
        RuleBase ruleBase = this.getRuleBase();
        StatefulSession session = ruleBase.newStatefulSession();
        Cheese a = new Cheese("stilton", 10);
        Cheese b = new Cheese("stilton", 15);
        Cheese c = new Cheese("stilton", 20);
        session.insert((Object)a);
        session.insert((Object)b);
        session.insert((Object)c);
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DynamicRules.drl")));
        Package pkg = builder.getPackage();
        ruleBase.addPackage(SerializationHelper.serializeObject(pkg));
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        session.fireAllRules();
    }

    public void testDynamicRules2() throws Exception {
        RuleBase ruleBase = this.getRuleBase();
        StatefulSession session = ruleBase.newStatefulSession();
        FactA a = new FactA("hello", new Integer(1), new Float(3.14));
        FactB b = new FactB("hello", new Integer(2), new Float(6.28));
        session.insert((Object)a);
        session.insert((Object)b);
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DynamicRules2.drl")));
        Package pkg = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        session.fireAllRules();
    }

    public void testRuleBaseAddRemove() throws Exception {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic1.drl")));
        Package pkg = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg);
        ruleBase.removePackage(pkg.getName());
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic1.drl")));
        pkg = SerializationHelper.serializeObject(builder.getPackage());
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        ruleBase.removePackage(pkg.getName());
    }

    public void testClassLoaderSwitchsUsingConf() throws Exception {
        try {
            SubvertedClassLoader loader1 = new SubvertedClassLoader(new URL[]{((Object)((Object)this)).getClass().getResource("/")}, ((Object)((Object)this)).getClass().getClassLoader());
            Class<?> cheeseClass = loader1.loadClass("org.drools.Cheese");
            PackageBuilderConfiguration conf = new PackageBuilderConfiguration((ClassLoader)loader1);
            PackageBuilder builder = new PackageBuilder(conf);
            builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic1.drl")));
            RuleBaseConfiguration rbconf = new RuleBaseConfiguration((ClassLoader)loader1);
            RuleBase ruleBase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)rbconf);
            Package pkg = SerializationHelper.serializeObject(builder.getPackage());
            ruleBase.addPackage(pkg);
            StatefulSession wm = ruleBase.newStatefulSession();
            wm.insert(cheeseClass.newInstance());
            wm.fireAllRules();
            SubvertedClassLoader loader2 = new SubvertedClassLoader(new URL[]{((Object)((Object)this)).getClass().getResource("/")}, ((Object)((Object)this)).getClass().getClassLoader());
            cheeseClass = loader2.loadClass("org.drools.Cheese");
            conf = new PackageBuilderConfiguration((ClassLoader)loader2);
            builder = new PackageBuilder(conf);
            builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic1.drl")));
            rbconf = new RuleBaseConfiguration((ClassLoader)loader2);
            ruleBase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)rbconf);
            pkg = SerializationHelper.serializeObject(builder.getPackage());
            ruleBase.addPackage(pkg);
            wm = ruleBase.newStatefulSession();
            wm.insert(cheeseClass.newInstance());
            wm.fireAllRules();
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            DynamicRulesTest.fail((String)"No ClassCastException should be raised.");
        }
    }

    public void testClassLoaderSwitchsUsingContext() throws Exception {
        try {
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            SubvertedClassLoader loader1 = new SubvertedClassLoader(new URL[]{((Object)((Object)this)).getClass().getResource("/")}, ((Object)((Object)this)).getClass().getClassLoader());
            Thread.currentThread().setContextClassLoader(loader1);
            Class<?> cheeseClass = loader1.loadClass("org.drools.Cheese");
            PackageBuilder builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic1.drl")));
            RuleBase ruleBase = RuleBaseFactory.newRuleBase();
            Package pkg = SerializationHelper.serializeObject(builder.getPackage());
            ruleBase.addPackage(pkg);
            StatefulSession wm = ruleBase.newStatefulSession();
            wm.insert(cheeseClass.newInstance());
            wm.fireAllRules();
            SubvertedClassLoader loader2 = new SubvertedClassLoader(new URL[]{((Object)((Object)this)).getClass().getResource("/")}, ((Object)((Object)this)).getClass().getClassLoader());
            Thread.currentThread().setContextClassLoader(loader2);
            cheeseClass = loader2.loadClass("org.drools.Cheese");
            builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic1.drl")));
            ruleBase = RuleBaseFactory.newRuleBase();
            pkg = SerializationHelper.serializeObject(builder.getPackage());
            ruleBase.addPackage(pkg);
            wm = ruleBase.newStatefulSession();
            wm.insert(cheeseClass.newInstance());
            wm.fireAllRules();
            Thread.currentThread().setContextClassLoader(original);
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            DynamicRulesTest.fail((String)"No ClassCastException should be raised.");
        }
    }

    public void testCollectDynamicRules() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_CollectDynamicRules1.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        workingMemory.insert((Object)new Cheese("stilton", 10));
        workingMemory.insert((Object)new Cheese("brie", 10));
        workingMemory.insert((Object)new Cheese("stilton", 10));
        workingMemory.insert((Object)new Cheese("muzzarela", 10));
        PackageBuilder builder2 = new PackageBuilder();
        builder2.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_CollectDynamicRules2.drl")));
        Package pkg2 = builder2.getPackage();
        ruleBase.addPackage(pkg2);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        DynamicRulesTest.assertEquals((int)1, (int)list.size());
        DynamicRulesTest.assertEquals((int)2, (int)((List)list.get(0)).size());
    }

    public void testDynamicNotNode() throws Exception {
        PackageBuilder builderInit = new PackageBuilder();
        builderInit.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_CollectDynamicRules1.drl")));
        Package pkgInit = builderInit.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkgInit);
        StatefulSession session = ruleBase.newStatefulSession();
        List results = new ArrayList();
        session.setGlobal("results", results);
        Cheese a = new Cheese("stilton", 10);
        Cheese b = new Cheese("stilton", 15);
        Cheese c = new Cheese("stilton", 20);
        session.insert((Object)a);
        session.insert((Object)b);
        session.insert((Object)c);
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DynamicNotNode.drl")));
        Package pkg = builder.getPackage();
        ruleBase.addPackage(SerializationHelper.serializeObject(pkg));
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        results = (List)session.getGlobal("results");
        session.fireAllRules();
        DynamicRulesTest.assertEquals((int)0, (int)results.size());
        ruleBase.removePackage("org.drools");
        session.retract((FactHandle)session.getFactHandle((Object)b));
        PackageBuilder builder1 = new PackageBuilder();
        builder1.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DynamicNotNode.drl")));
        Package pkg1 = builder.getPackage();
        ruleBase.addPackage(SerializationHelper.serializeObject(pkg1));
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        results = (List)session.getGlobal("results");
        session.fireAllRules();
        DynamicRulesTest.assertEquals((int)1, (int)results.size());
    }

    public void testDynamicRulesAddRemove() {
        try {
            RuleBase ruleBase = RuleBaseFactory.newRuleBase();
            PackageBuilder tomBuilder = new PackageBuilder();
            tomBuilder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DynamicRulesTom.drl")));
            ruleBase.addPackage(tomBuilder.getPackage());
            StatefulSession session = ruleBase.newStatefulSession();
            ArrayList results = new ArrayList();
            session.setGlobal("results", results);
            InternalFactHandle h1 = (InternalFactHandle)session.insert((Object)new Person("tom", 1));
            InternalFactHandle h2 = (InternalFactHandle)session.insert((Object)new Person("fred", 2));
            InternalFactHandle h3 = (InternalFactHandle)session.insert((Object)new Person("harry", 3));
            InternalFactHandle h4 = (InternalFactHandle)session.insert((Object)new Person("fred", 4));
            InternalFactHandle h5 = (InternalFactHandle)session.insert((Object)new Person("ed", 5));
            InternalFactHandle h6 = (InternalFactHandle)session.insert((Object)new Person("tom", 6));
            InternalFactHandle h7 = (InternalFactHandle)session.insert((Object)new Person("sreeni", 7));
            InternalFactHandle h8 = (InternalFactHandle)session.insert((Object)new Person("jill", 8));
            InternalFactHandle h9 = (InternalFactHandle)session.insert((Object)new Person("ed", 9));
            InternalFactHandle h10 = (InternalFactHandle)session.insert((Object)new Person("tom", 10));
            session.fireAllRules();
            DynamicRulesTest.assertEquals((int)3, (int)results.size());
            DynamicRulesTest.assertTrue((boolean)results.contains(h1.getObject()));
            DynamicRulesTest.assertTrue((boolean)results.contains(h6.getObject()));
            DynamicRulesTest.assertTrue((boolean)results.contains(h10.getObject()));
            results.clear();
            PackageBuilder fredBuilder = new PackageBuilder();
            fredBuilder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DynamicRulesFred.drl")));
            ruleBase.addPackage(fredBuilder.getPackage());
            DynamicRulesTest.assertEquals((int)2, (int)results.size());
            DynamicRulesTest.assertTrue((boolean)results.contains(h2.getObject()));
            DynamicRulesTest.assertTrue((boolean)results.contains(h4.getObject()));
            results.clear();
            ruleBase.removePackage("tom");
            PackageBuilder edBuilder = new PackageBuilder();
            edBuilder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DynamicRulesEd.drl")));
            ruleBase.addPackage(edBuilder.getPackage());
            DynamicRulesTest.assertEquals((int)2, (int)results.size());
            DynamicRulesTest.assertTrue((boolean)results.contains(h5.getObject()));
            DynamicRulesTest.assertTrue((boolean)results.contains(h9.getObject()));
            results.clear();
            ((Person)h3.getObject()).setName("ed");
            session.update((FactHandle)h3, h3.getObject());
            session.fireAllRules();
            DynamicRulesTest.assertEquals((int)1, (int)results.size());
            DynamicRulesTest.assertTrue((boolean)results.contains(h3.getObject()));
        }
        catch (Exception e) {
            e.printStackTrace();
            DynamicRulesTest.fail((String)("Should not raise any exception: " + e.getMessage()));
        }
    }

    public void testDynamicRuleRemovalsSubNetwork() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DynamicRulesWithSubnetwork1.drl")));
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DynamicRulesWithSubnetwork.drl")));
        Package pkg = SerializationHelper.serializeObject(builder.getPackage());
        ReteooRuleBase reteooRuleBase = null;
        RuleBase ruleBase = this.getRuleBase();
        reteooRuleBase = (ReteooRuleBase)ruleBase;
        ruleBase.addPackage(pkg);
        PackageBuilder builder2 = new PackageBuilder();
        builder2.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DynamicRulesWithSubnetwork2.drl")));
        ruleBase.addPackage(SerializationHelper.serializeObject(builder2.getPackage()));
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("results", list);
        Order order = new Order();
        OrderItem item1 = new OrderItem(order, 1, "Adventure Guide Brazil", 1, 24);
        order.addItem(item1);
        session.insert((Object)item1);
        OrderItem item2 = new OrderItem(order, 2, "Prehistoric Britain", 1, 15);
        order.addItem(item2);
        session.insert((Object)item2);
        OrderItem item3 = new OrderItem(order, 3, "Holiday Music", 2, 9);
        order.addItem(item3);
        session.insert((Object)item3);
        OrderItem item4 = new OrderItem(order, 4, "Very Best of Mick Jagger", 2, 11);
        order.addItem(item4);
        session.insert((Object)item4);
        session.insert((Object)order);
        DynamicRulesTest.assertEquals((int)11, (int)session.getAgenda().getActivations().length);
        reteooRuleBase.removeRule("org.drools", "Apply Discount on all books");
        DynamicRulesTest.assertEquals((int)10, (int)session.getAgenda().getActivations().length);
        reteooRuleBase.removeRule("org.drools", "like book");
        OrderItem item5 = new OrderItem(order, 5, "Sinatra : Vegas", 2, 5);
        DynamicRulesTest.assertEquals((int)8, (int)session.getAgenda().getActivations().length);
        session.insert((Object)item5);
        DynamicRulesTest.assertEquals((int)10, (int)session.getAgenda().getActivations().length);
        reteooRuleBase.removePackage("org.drools");
        DynamicRulesTest.assertEquals((int)0, (int)session.getAgenda().getActivations().length);
    }

    public void testDynamicRuleRemovalsUnusedWorkingMemorySubNetwork() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DynamicRulesWithSubnetwork1.drl")));
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DynamicRulesWithSubnetwork2.drl")));
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DynamicRulesWithSubnetwork.drl")));
        Package pkg = builder.getPackage();
        ReteooRuleBase reteooRuleBase = null;
        RuleBase ruleBase = this.getRuleBase();
        reteooRuleBase = (ReteooRuleBase)ruleBase;
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        if (reteooRuleBase != null) {
            DynamicRulesTest.assertEquals((int)1, (int)reteooRuleBase.getPackages().length);
            DynamicRulesTest.assertEquals((int)4, (int)reteooRuleBase.getPackages()[0].getRules().length);
            reteooRuleBase.removeRule("org.drools", "Apply Discount on all books");
            DynamicRulesTest.assertEquals((int)3, (int)reteooRuleBase.getPackages()[0].getRules().length);
            reteooRuleBase.removeRule("org.drools", "like book");
            DynamicRulesTest.assertEquals((int)2, (int)reteooRuleBase.getPackages()[0].getRules().length);
            reteooRuleBase.removePackage("org.drools");
            DynamicRulesTest.assertEquals((int)0, (int)reteooRuleBase.getPackages().length);
        }
    }

    public void testRemovePackageSubNetwork() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DynamicRulesWithSubnetwork.drl")));
        RuleBase ruleBase = this.getRuleBase();
        String packageName = builder.getPackage().getName();
        ruleBase.addPackage(SerializationHelper.serializeObject(builder.getPackage()));
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        List results = new ArrayList();
        workingMemory.setGlobal("results", results);
        Order order = new Order();
        OrderItem item1 = new OrderItem(order, 1, "Adventure Guide Brazil", 1, 24);
        OrderItem item2 = new OrderItem(order, 2, "Prehistoric Britain", 1, 15);
        OrderItem item3 = new OrderItem(order, 3, "Holiday Music", 2, 9);
        OrderItem item4 = new OrderItem(order, 4, "Very Best of Mick Jagger", 2, 11);
        OrderItem item5 = new OrderItem(order, 5, "The Master and Margarita", 1, 29);
        order.addItem(item1);
        order.addItem(item2);
        order.addItem(item3);
        order.addItem(item4);
        order.addItem(item5);
        workingMemory.insert((Object)order);
        workingMemory.fireAllRules();
        DynamicRulesTest.assertEquals((int)1, (int)results.size());
        DynamicRulesTest.assertEquals((int)3, (int)((List)results.get(0)).size());
        results.clear();
        RuleBase ruleBaseWM = workingMemory.getRuleBase();
        ruleBaseWM.removePackage(packageName);
        PackageBuilder builder1 = new PackageBuilder();
        builder1.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DynamicRulesWithSubnetwork.drl")));
        ruleBaseWM.addPackage(SerializationHelper.serializeObject(builder1.getPackage()));
        workingMemory.fireAllRules();
        results = (List)workingMemory.getGlobal("results");
        DynamicRulesTest.assertEquals((int)1, (int)results.size());
        DynamicRulesTest.assertEquals((int)3, (int)((List)results.get(0)).size());
        results.clear();
        ruleBaseWM.removePackage(packageName);
        ruleBaseWM.addPackage(SerializationHelper.serializeObject(builder1.getPackage()));
        DynamicRulesTest.assertEquals((int)1, (int)results.size());
        DynamicRulesTest.assertEquals((int)3, (int)((List)results.get(0)).size());
        results.clear();
        ruleBaseWM.removePackage(packageName);
        ruleBaseWM.addPackage(SerializationHelper.serializeObject(builder1.getPackage()));
        DynamicRulesTest.assertEquals((int)1, (int)results.size());
        DynamicRulesTest.assertEquals((int)3, (int)((List)results.get(0)).size());
        results.clear();
    }

    public void testRuleBaseAddRemoveSubNetworks() throws Exception {
        try {
            RuleBase ruleBase = RuleBaseFactory.newRuleBase();
            PackageBuilder builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DynamicRulesWithSubnetwork.drl")));
            Package pkg = SerializationHelper.serializeObject(builder.getPackage());
            ruleBase.addPackage(pkg);
            ruleBase.removePackage(pkg.getName());
            builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DynamicRulesWithSubnetwork.drl")));
            pkg = SerializationHelper.serializeObject(builder.getPackage());
            ruleBase.addPackage(pkg);
            ruleBase.removePackage(pkg.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
            DynamicRulesTest.fail((String)"Should not raise any exception");
        }
    }

    public class SubvertedClassLoader
    extends URLClassLoader {
        private static final long serialVersionUID = 400L;

        public SubvertedClassLoader(URL[] urls, ClassLoader parentClassLoader) {
            super(urls, parentClassLoader);
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    c = super.loadClass(name, resolve);
                }
            }
            return c;
        }
    }
}

