/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.Person;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.base.mvel.MVELDebugHandler;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.integrationtests.SerializationHelper;
import org.drools.lang.descr.PackageDescr;
import org.drools.rule.Package;
import org.drools.util.DateUtils;
import org.mvel2.MVEL;

public class MVELTest
extends TestCase {
    public void testHelloWorld() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_mvel.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        ArrayList list2 = new ArrayList();
        workingMemory.setGlobal("list2", list2);
        Cheese c = new Cheese("stilton", 10);
        workingMemory.insert((Object)c);
        workingMemory.fireAllRules();
        MVELTest.assertEquals((int)2, (int)list.size());
        MVELTest.assertEquals((Object)new Integer(30), list.get(0));
        MVELTest.assertEquals((Object)new Integer(22), list.get(1));
        MVELTest.assertEquals((Object)"hello world", list2.get(0));
        Date dt = DateUtils.parseDate((String)"10-Jul-1974");
        MVELTest.assertEquals((Object)dt, (Object)c.getUsedBy());
    }

    public void testLocalVariableMVELConsequence() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_LocalVariableMVELConsequence.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        workingMemory.insert((Object)new Person("bob", "stilton"));
        workingMemory.insert((Object)new Person("mark", "brie"));
        try {
            workingMemory.fireAllRules();
            MVELTest.assertEquals((String)"should have fired twice", (int)2, (int)list.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            MVELTest.fail((String)"Should not raise any exception");
        }
    }

    public void testMVELUsingGlobalsInDebugMode() throws Exception {
        MVELDebugHandler.setDebugMode((boolean)true);
        try {
            PackageBuilder builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_MVELGlobalDebug.drl")));
            Package pkg = builder.getPackage();
            RuleBase ruleBase = this.getRuleBase();
            ruleBase.addPackage(pkg);
            ruleBase = SerializationHelper.serializeObject(ruleBase);
            StatefulSession session = ruleBase.newStatefulSession();
            session.dispose();
            MVELDebugHandler.setDebugMode((boolean)false);
        }
        catch (Exception e) {
            MVELDebugHandler.setDebugMode((boolean)false);
            e.printStackTrace();
            MVELTest.fail((String)"Should not raise exceptions");
        }
    }

    public void testDuplicateLocalVariableMVELConsequence() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DuplicateLocalVariableMVELConsequence.drl")));
        MVELTest.assertTrue((boolean)builder.hasErrors());
    }

    public Object compiledExecute(String ex) {
        Serializable compiled = MVEL.compileExpression((String)ex);
        return MVEL.executeExpression((Object)compiled, (Object)new Object(), new HashMap());
    }

    private RuleBase loadRuleBase(Reader reader) throws IOException, DroolsParserException, Exception {
        DrlParser parser = new DrlParser();
        PackageDescr packageDescr = parser.parse(reader);
        if (parser.hasErrors()) {
            Assert.fail((String)"Error messages in parser, need to sort this our (or else collect error messages)");
        }
        PackageBuilder builder = new PackageBuilder();
        builder.addPackage(packageDescr);
        System.out.println(builder.getErrors());
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        return ruleBase;
    }

    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }
}

