/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.drools.Person;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.compiler.PackageBuilder;
import org.drools.integrationtests.SerializationHelper;
import org.drools.marshalling.DefaultMarshaller;
import org.drools.marshalling.Marshaller;
import org.drools.process.instance.ProcessInstance;
import org.drools.process.instance.context.variable.VariableScopeInstance;
import org.drools.rule.Package;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;

public class ProcessMarchallingTest
extends TestCase {
    public void test1() throws Exception {
        String rule = "package org.test;\n";
        rule = rule + "import org.drools.Person\n";
        rule = rule + "global java.util.List list\n";
        rule = rule + "rule \"Rule 1\"\n";
        rule = rule + "  ruleflow-group \"hello\"\n";
        rule = rule + "when\n";
        rule = rule + "    $p : Person( ) \n";
        rule = rule + "then\n";
        rule = rule + "    list.add( $p );\n";
        rule = rule + "end";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(rule));
        String process = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n    type=\"RuleFlow\" name=\"ruleflow\" id=\"org.test.ruleflow\" package-name=\"org.test\" >\n  <header>\n  </header>\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <ruleSet id=\"2\" name=\"Hello\" ruleFlowGroup=\"hello\" />\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n  <connections>\n    <connection from=\"1\" to=\"2\"/>\n    <connection from=\"2\" to=\"3\"/>\n  </connections>\n</process>";
        builder.addProcessFromXml((Reader)new StringReader(process));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Person p = new Person("bobba fet", 32);
        session.insert((Object)p);
        session.startProcess("org.test.ruleflow");
        ProcessMarchallingTest.assertEquals((int)1, (int)session.getProcessInstances().size());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        ProcessMarchallingTest.assertEquals((int)1, (int)session.getProcessInstances().size());
        session.fireAllRules();
        ProcessMarchallingTest.assertEquals((int)1, (int)((List)session.getGlobal("list")).size());
        ProcessMarchallingTest.assertEquals((Object)p, ((List)session.getGlobal("list")).get(0));
        ProcessMarchallingTest.assertEquals((int)0, (int)session.getProcessInstances().size());
    }

    public void test2() throws Exception {
        String process = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n    type=\"RuleFlow\" name=\"ruleflow\" id=\"org.test.ruleflow\" package-name=\"org.test\" >\n  <header>\n    <variables>\n      <variable name=\"myVariable\" >\n        <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n        <value>OldValue</value>\n      </variable>\n    </variables>\n  </header>\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <workItem id=\"2\" name=\"Email\" >\n      <work name=\"Email\" >\n        <parameter name=\"Subject\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n          <value>Mail</value>\n        </parameter>\n        <parameter name=\"Text\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n          <value>This is an email</value>\n        </parameter>\n        <parameter name=\"To\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n          <value>you@mail.com</value>\n        </parameter>\n        <parameter name=\"From\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n          <value>me@mail.com</value>\n        </parameter>\n      </work>\n    </workItem>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n  <connections>\n    <connection from=\"1\" to=\"2\"/>\n    <connection from=\"2\" to=\"3\"/>\n  </connections>\n</process>";
        PackageBuilder builder = new PackageBuilder();
        builder.addProcessFromXml((Reader)new StringReader(process));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        TestWorkItemHandler handler = new TestWorkItemHandler();
        session.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)handler);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("myVariable", "ThisIsMyValue");
        session.startProcess("org.test.ruleflow", variables);
        ProcessMarchallingTest.assertEquals((int)1, (int)session.getProcessInstances().size());
        ProcessMarchallingTest.assertTrue((handler.getWorkItem() != null ? 1 : 0) != 0);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        ProcessMarchallingTest.assertEquals((int)1, (int)session.getProcessInstances().size());
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)((ProcessInstance)session.getProcessInstances().iterator().next()).getContextInstance("VariableScope");
        ProcessMarchallingTest.assertEquals((Object)"ThisIsMyValue", (Object)variableScopeInstance.getVariable("myVariable"));
        session.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        ProcessMarchallingTest.assertEquals((int)0, (int)session.getProcessInstances().size());
    }

    public void test3() throws Exception {
        String process1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n  xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n  type=\"RuleFlow\" name=\"ruleflow\" id=\"com.sample.ruleflow\" package-name=\"com.sample\" >\n\n  <header>\n    <imports>\n      <import name=\"org.drools.Person\" />\n    </imports>\n    <swimlanes>\n      <swimlane name=\"swimlane\" />\n    </swimlanes>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <end id=\"4\" name=\"End\" />\n    <split id=\"5\" name=\"AND\" type=\"1\" />\n    <subProcess id=\"6\" name=\"SubProcess\" processId=\"com.sample.subflow\" />\n    <actionNode id=\"7\" name=\"Action\" >\n      <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Executing action 1\");</action>\n\t </actionNode>\n    <join id=\"8\" name=\"AND\" type=\"1\" />\n    <actionNode id=\"9\" name=\"Action\" >\n      <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Executing action 2\");</action>\n    </actionNode>\n    <ruleSet id=\"10\" name=\"RuleSet\" ruleFlowGroup=\"flowgroup\" />\n    <milestone id=\"11\" name=\"Event Wait\" >\n      <constraint type=\"rule\" dialect=\"mvel\" >Person( )</constraint>\n    </milestone>\n    <workItem id=\"12\" name=\"Log\" >\n      <work name=\"Log\" >\n        <parameter name=\"Message\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n          <value>This is a log message</value>\n        </parameter>\n      </work>\n    </workItem>\n    <composite id=\"13\" name=\"CompositeNode\" >\n      <variables>\n        <variable name=\"x\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n          <value>x-value</value>\n        </variable>\n      </variables>\n      <nodes>\n        <humanTask id=\"1\" name=\"Human Task\" swimlane=\"swimlane\" >\n          <work name=\"Human Task\" >\n            <parameter name=\"ActorId\" >\n              <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n              <value>John Doe</value>\n            </parameter>\n            <parameter name=\"Priority\" >\n              <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n            </parameter>\n            <parameter name=\"TaskName\" >\n              <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n              <value>Do something !</value>\n            </parameter>\n            <parameter name=\"Comment\" >\n              <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n            </parameter>\n          </work>\n        </humanTask>\n        <humanTask id=\"2\" name=\"Human Task\" swimlane=\"swimlane\" >\n          <work name=\"Human Task\" >\n            <parameter name=\"ActorId\" >\n              <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n            </parameter>\n            <parameter name=\"Priority\" >\n              <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n            </parameter>\n            <parameter name=\"TaskName\" >\n              <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n              <value>Do something else !</value>\n            </parameter>\n            <parameter name=\"Comment\" >\n              <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n            </parameter>\n          </work>\n          <mapping type=\"in\" from=\"x\" to=\"Priority\" />\n        </humanTask>\n      </nodes>\n      <connections>\n        <connection from=\"1\" to=\"2\" />\n      </connections>\n      <in-ports>\n        <in-port type=\"DROOLS_DEFAULT\" nodeId=\"1\" nodeInType=\"DROOLS_DEFAULT\" />\n      </in-ports>\n      <out-ports>\n        <out-port type=\"DROOLS_DEFAULT\" nodeId=\"2\" nodeOutType=\"DROOLS_DEFAULT\" />\n      </out-ports>\n    </composite>\n  </nodes>\n\n  <connections>\n    <connection from=\"9\" to=\"4\" />\n    <connection from=\"1\" to=\"5\" />\n    <connection from=\"5\" to=\"6\" />\n    <connection from=\"5\" to=\"7\" />\n    <connection from=\"7\" to=\"8\" />\n    <connection from=\"6\" to=\"8\" />\n    <connection from=\"10\" to=\"8\" />\n    <connection from=\"11\" to=\"8\" />\n    <connection from=\"12\" to=\"8\" />\n    <connection from=\"13\" to=\"8\" />\n    <connection from=\"8\" to=\"9\" />\n    <connection from=\"5\" to=\"10\" />\n    <connection from=\"5\" to=\"11\" />\n    <connection from=\"5\" to=\"12\" />\n    <connection from=\"5\" to=\"13\" />\n  </connections>\n\n</process>\n";
        PackageBuilder builder = new PackageBuilder();
        builder.addProcessFromXml((Reader)new StringReader(process1));
        String process2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"com.sample.subflow\" package-name=\"com.sample\" >\n\n  <header>\n    <imports>\n      <import name=\"org.drools.Person\" />\n    </imports>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <milestone id=\"2\" name=\"Event Wait\" >\n      <constraint type=\"rule\" dialect=\"mvel\" >Person( )</constraint>\n    </milestone>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>\n";
        builder.addProcessFromXml((Reader)new StringReader(process2));
        String rule = "package com.sample\nimport org.drools.Person;\nrule \"Hello\" ruleflow-group \"flowgroup\"\n    when\n    then\n        System.out.println( \"Hello\" );\nend";
        builder.addPackageFromDrl((Reader)new StringReader(rule));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        TestWorkItemHandler handler1 = new TestWorkItemHandler();
        session.getWorkItemManager().registerWorkItemHandler("Log", (WorkItemHandler)handler1);
        TestWorkItemHandler handler2 = new TestWorkItemHandler();
        session.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler2);
        session.startProcess("com.sample.ruleflow");
        ProcessMarchallingTest.assertEquals((int)2, (int)session.getProcessInstances().size());
        ProcessMarchallingTest.assertTrue((handler1.getWorkItem() != null ? 1 : 0) != 0);
        long workItemId = handler2.getWorkItem().getId();
        ProcessMarchallingTest.assertTrue((workItemId != -1L ? 1 : 0) != 0);
        session = SerializationHelper.getSerialisedStatefulSession(session);
        session.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler2);
        ProcessMarchallingTest.assertEquals((int)2, (int)session.getProcessInstances().size());
        handler2.reset();
        session.getWorkItemManager().completeWorkItem(workItemId, null);
        ProcessMarchallingTest.assertTrue((handler2.getWorkItem() != null ? 1 : 0) != 0);
        ProcessMarchallingTest.assertEquals((Object)"John Doe", (Object)handler2.getWorkItem().getParameter("ActorId"));
        ProcessMarchallingTest.assertEquals((Object)"x-value", (Object)handler2.getWorkItem().getParameter("Priority"));
        session.getWorkItemManager().completeWorkItem(handler1.getWorkItem().getId(), null);
        session.getWorkItemManager().completeWorkItem(handler2.getWorkItem().getId(), null);
        session.insert((Object)new Person());
        session.fireAllRules();
        ProcessMarchallingTest.assertEquals((int)0, (int)session.getProcessInstances().size());
    }

    public void test4() throws Exception {
        String process = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n  xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n  type=\"RuleFlow\" name=\"ruleflow\" id=\"com.sample.ruleflow\" package-name=\"com.sample\" >\n\n    <header>\n      <variables>\n        <variable name=\"list\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.ObjectDataType\" className=\"java.util.List\" />\n        </variable>\n      </variables>\n    </header>\n\n    <nodes>\n      <forEach id=\"4\" name=\"ForEach\" variableName=\"item\" collectionExpression=\"list\" >\n        <nodes>\n          <humanTask id=\"1\" name=\"Human Task\" >\n            <work name=\"Human Task\" >\n              <parameter name=\"Comment\" >\n                <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n              </parameter>\n              <parameter name=\"ActorId\" >\n                <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n              </parameter>\n              <parameter name=\"Priority\" >\n                <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n              </parameter>\n              <parameter name=\"TaskName\" >\n                <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n                <value>Do something: #{item}</value>\n              </parameter>\n            </work>\n          </humanTask>\n        </nodes>\n        <connections>\n        </connections>\n        <in-ports>\n          <in-port type=\"DROOLS_DEFAULT\" nodeId=\"1\" nodeInType=\"DROOLS_DEFAULT\" />\n        </in-ports>\n        <out-ports>\n          <out-port type=\"DROOLS_DEFAULT\" nodeId=\"1\" nodeOutType=\"DROOLS_DEFAULT\" />\n        </out-ports>\n      </forEach>\n      <start id=\"1\" name=\"Start\" />\n      <end id=\"3\" name=\"End\" />\n    </nodes>\n\n    <connections>\n      <connection from=\"1\" to=\"4\" />\n      <connection from=\"4\" to=\"3\" />\n    </connections>\n\n</process>\n";
        PackageBuilder builder = new PackageBuilder();
        builder.addProcessFromXml((Reader)new StringReader(process));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        TestListWorkItemHandler handler = new TestListWorkItemHandler();
        session.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        list.add("three");
        HashMap<String, ArrayList<String>> parameters = new HashMap<String, ArrayList<String>>();
        parameters.put("list", list);
        session.startProcess("com.sample.ruleflow", parameters);
        ProcessMarchallingTest.assertEquals((int)1, (int)session.getProcessInstances().size());
        ProcessMarchallingTest.assertEquals((int)3, (int)handler.getWorkItems().size());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        for (WorkItem workItem : handler.getWorkItems()) {
            session.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        }
        ProcessMarchallingTest.assertEquals((int)0, (int)session.getProcessInstances().size());
    }

    public void test5() throws Exception {
        String process = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n  xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n  type=\"RuleFlow\" name=\"ruleflow\" id=\"com.sample.ruleflow\" package-name=\"com.sample\" >\n\n    <header>\n    </header>\n\n    <nodes>\n      <start id=\"1\" name=\"Start\" />\n      <timerNode id=\"4\" name=\"Timer\" delay=\"200\" />\n      <end id=\"3\" name=\"End\" />\n    </nodes>\n\n    <connections>\n      <connection from=\"1\" to=\"4\" />\n      <connection from=\"4\" to=\"3\" />\n    </connections>\n\n</process>\n";
        PackageBuilder builder = new PackageBuilder();
        builder.addProcessFromXml((Reader)new StringReader(process));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        session.startProcess("com.sample.ruleflow", null);
        ProcessMarchallingTest.assertEquals((int)1, (int)session.getProcessInstances().size());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        Thread.sleep(400L);
        ProcessMarchallingTest.assertEquals((int)0, (int)session.getProcessInstances().size());
    }

    public void test6() throws Exception {
        String process = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n  xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n  type=\"RuleFlow\" name=\"ruleflow\" id=\"com.sample.ruleflow\" package-name=\"com.sample\" >\n\n    <header>\n    </header>\n\n    <nodes>\n      <start id=\"1\" name=\"Start\" />\n      <timerNode id=\"4\" name=\"Timer\" delay=\"200\" />\n      <end id=\"3\" name=\"End\" />\n    </nodes>\n\n    <connections>\n      <connection from=\"1\" to=\"4\" />\n      <connection from=\"4\" to=\"3\" />\n    </connections>\n\n</process>\n";
        PackageBuilder builder = new PackageBuilder();
        builder.addProcessFromXml((Reader)new StringReader(process));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        session.startProcess("com.sample.ruleflow", null);
        ProcessMarchallingTest.assertEquals((int)1, (int)session.getProcessInstances().size());
        DefaultMarshaller marshaller = new DefaultMarshaller();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ruleBase.writeStatefulSession(session, (OutputStream)baos, (Marshaller)marshaller);
        byte[] b1 = baos.toByteArray();
        session.dispose();
        Thread.sleep(400L);
        ByteArrayInputStream bais = new ByteArrayInputStream(b1);
        session = ruleBase.readStatefulSession((InputStream)bais, true, (Marshaller)marshaller);
        Thread.sleep(100L);
        ProcessMarchallingTest.assertEquals((int)0, (int)session.getProcessInstances().size());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestListWorkItemHandler
    implements WorkItemHandler {
        private List<WorkItem> workItems = new ArrayList<WorkItem>();

        private TestListWorkItemHandler() {
        }

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            System.out.println("Executing workItem " + workItem.getParameter("TaskName"));
            this.workItems.add(workItem);
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
            this.workItems.remove(workItem);
        }

        public List<WorkItem> getWorkItems() {
            return this.workItems;
        }

        public void reset() {
            this.workItems.clear();
        }
    }

    private static class TestWorkItemHandler
    implements WorkItemHandler {
        private WorkItem workItem;

        private TestWorkItemHandler() {
        }

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            this.workItem = workItem;
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }

        public WorkItem getWorkItem() {
            return this.workItem;
        }

        public void reset() {
            this.workItem = null;
        }
    }
}

