/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.drools.Message;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.compiler.DroolsError;
import org.drools.compiler.PackageBuilder;
import org.drools.integrationtests.SerializationHelper;
import org.drools.process.instance.ProcessInstance;
import org.drools.rule.Package;

public class ProcessTimerTest
extends TestCase {
    public void testSimpleProcess() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.timer\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <imports>\n      <import name=\"org.drools.Message\" />\n    </imports>\n    <globals>\n      <global identifier=\"myList\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <end id=\"2\" name=\"End\" />\n    <timerNode id=\"3\" name=\"Timer\" delay=\"800\" period=\"200\" />\n    <actionNode id=\"4\" name=\"Action\" >\n      <action type=\"expression\" dialect=\"java\" >System.out.println(\"Triggered\");\nmyList.add( new Message() );\ninsert( new Message() );\n</action>\n    </actionNode>\n    <milestone id=\"5\" name=\"Wait\" >\n      <constraint type=\"rule\" dialect=\"mvel\" >Number( intValue &gt;= 5 ) from accumulate ( m: Message( ), count( m ) )</constraint>\n    </milestone>\n  </nodes>\n\n  <connections>\n    <connection from=\"5\" to=\"2\" />\n    <connection from=\"1\" to=\"3\" />\n    <connection from=\"3\" to=\"4\" />\n    <connection from=\"4\" to=\"5\" />\n  </connections>\n\n</process>");
        builder.addRuleFlow((Reader)source);
        if (!builder.getErrors().isEmpty()) {
            for (DroolsError error : builder.getErrors().getErrors()) {
                System.err.println(error);
            }
            ProcessTimerTest.fail((String)"Could not build process");
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        List myList = new ArrayList();
        session.setGlobal("myList", myList);
        ProcessInstance processInstance = session.startProcess("org.drools.timer");
        ProcessTimerTest.assertEquals((int)0, (int)myList.size());
        ProcessTimerTest.assertEquals((int)1, (int)processInstance.getState());
        ProcessTimerTest.assertEquals((int)1, (int)session.getTimerManager().getTimers().size());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        myList = (List)session.getGlobal("myList");
        processInstance = session.getProcessInstance(processInstance.getId());
        ProcessTimerTest.assertEquals((int)1, (int)session.getTimerManager().getTimers().size());
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        ProcessTimerTest.assertEquals((int)0, (int)myList.size());
        try {
            Thread.sleep(1300L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        session.fireAllRules();
        ProcessTimerTest.assertEquals((int)5, (int)myList.size());
        ProcessTimerTest.assertEquals((int)2, (int)processInstance.getState());
    }

    public void testOnEntryTimerExecuted() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.timer\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <globals>\n      <global identifier=\"myList\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <milestone id=\"2\" name=\"Wait\" >\n      <timers>\n        <timer id=\"1\" delay=\"300\" >\n          <action type=\"expression\" dialect=\"java\" >myList.add(\"Executing timer\");</action>\n        </timer>\n      </timers>\n      <constraint type=\"rule\" dialect=\"mvel\" >eval(false)</constraint>\n    </milestone>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        builder.addRuleFlow((Reader)source);
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        List myList = new ArrayList();
        session.setGlobal("myList", myList);
        ProcessInstance processInstance = session.startProcess("org.drools.timer");
        ProcessTimerTest.assertEquals((int)0, (int)myList.size());
        ProcessTimerTest.assertEquals((int)1, (int)processInstance.getState());
        ProcessTimerTest.assertEquals((int)1, (int)session.getTimerManager().getTimers().size());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        myList = (List)session.getGlobal("myList");
        processInstance = session.getProcessInstance(processInstance.getId());
        ProcessTimerTest.assertEquals((int)1, (int)session.getTimerManager().getTimers().size());
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        ProcessTimerTest.assertEquals((int)1, (int)myList.size());
    }

    public void testOnEntryTimerExecutedMultipleTimes() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.timer\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <globals>\n      <global identifier=\"myList\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <milestone id=\"2\" name=\"Wait\" >\n      <timers>\n        <timer id=\"1\" delay=\"300\" period =\"200\" >\n          <action type=\"expression\" dialect=\"java\" >myList.add(\"Executing timer\");</action>\n        </timer>\n      </timers>\n      <constraint type=\"rule\" dialect=\"mvel\" >eval(false)</constraint>\n    </milestone>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        builder.addRuleFlow((Reader)source);
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        List myList = new ArrayList();
        session.setGlobal("myList", myList);
        ProcessInstance processInstance = session.startProcess("org.drools.timer");
        ProcessTimerTest.assertEquals((int)0, (int)myList.size());
        ProcessTimerTest.assertEquals((int)1, (int)processInstance.getState());
        ProcessTimerTest.assertEquals((int)1, (int)session.getTimerManager().getTimers().size());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        myList = (List)session.getGlobal("myList");
        processInstance = session.getProcessInstance(processInstance.getId());
        ProcessTimerTest.assertEquals((int)1, (int)session.getTimerManager().getTimers().size());
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        ProcessTimerTest.assertEquals((int)2, (int)myList.size());
    }

    public void testMultipleTimers() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.timer\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <globals>\n      <global identifier=\"myList\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <milestone id=\"2\" name=\"Wait\" >\n      <timers>\n        <timer id=\"1\" delay=\"600\" >\n          <action type=\"expression\" dialect=\"java\" >myList.add(\"Executing timer1\");</action>\n        </timer>\n        <timer id=\"2\" delay=\"200\" >\n          <action type=\"expression\" dialect=\"java\" >myList.add(\"Executing timer2\");</action>\n        </timer>\n      </timers>\n      <constraint type=\"rule\" dialect=\"mvel\" >eval(false)</constraint>\n    </milestone>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        builder.addRuleFlow((Reader)source);
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        List myList = new ArrayList();
        session.setGlobal("myList", myList);
        ProcessInstance processInstance = session.startProcess("org.drools.timer");
        ProcessTimerTest.assertEquals((int)0, (int)myList.size());
        ProcessTimerTest.assertEquals((int)1, (int)processInstance.getState());
        ProcessTimerTest.assertEquals((int)2, (int)session.getTimerManager().getTimers().size());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        myList = (List)session.getGlobal("myList");
        ProcessTimerTest.assertEquals((int)2, (int)session.getTimerManager().getTimers().size());
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        ProcessTimerTest.assertEquals((int)1, (int)myList.size());
        ProcessTimerTest.assertEquals((String)"Executing timer2", (String)((String)myList.get(0)));
        session = SerializationHelper.getSerialisedStatefulSession(session);
        myList = (List)session.getGlobal("myList");
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        ProcessTimerTest.assertEquals((int)2, (int)myList.size());
    }

    public void testOnEntryTimerCancelled() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.timer\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <globals>\n      <global identifier=\"myList\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <milestone id=\"2\" name=\"Wait\" >\n      <timers>\n        <timer id=\"1\" delay=\"2000\" >\n          <action type=\"expression\" dialect=\"java\" >myList.add(\"Executing timer\");</action>\n        </timer>\n      </timers>\n      <constraint type=\"rule\" dialect=\"mvel\" >org.drools.Message( )</constraint>\n    </milestone>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        builder.addRuleFlow((Reader)source);
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        List myList = new ArrayList();
        session.setGlobal("myList", myList);
        ProcessInstance processInstance = session.startProcess("org.drools.timer");
        ProcessTimerTest.assertEquals((int)0, (int)myList.size());
        ProcessTimerTest.assertEquals((int)1, (int)processInstance.getState());
        ProcessTimerTest.assertEquals((int)1, (int)session.getTimerManager().getTimers().size());
        session = SerializationHelper.getSerialisedStatefulSession(session);
        myList = (List)session.getGlobal("myList");
        session.insert((Object)new Message());
        ProcessTimerTest.assertEquals((int)0, (int)myList.size());
        ProcessTimerTest.assertEquals((int)0, (int)session.getTimerManager().getTimers().size());
    }
}

