/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.drools.RuleBase;
import org.drools.StatefulSession;
import org.drools.marshalling.DefaultMarshaller;
import org.drools.marshalling.Marshaller;
import org.drools.util.DroolsStreamUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializationHelper {
    public static <T> T serializeObject(T obj) throws IOException, ClassNotFoundException {
        return SerializationHelper.serializeObject(obj, null);
    }

    public static <T> T serializeObject(T obj, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        return (T)DroolsStreamUtils.streamIn((byte[])DroolsStreamUtils.streamOut(obj), (ClassLoader)classLoader);
    }

    public static StatefulSession getSerialisedStatefulSession(StatefulSession session) throws Exception {
        return SerializationHelper.getSerialisedStatefulSession(session, true);
    }

    public static StatefulSession getSerialisedStatefulSession(StatefulSession session, RuleBase ruleBase) throws Exception {
        return SerializationHelper.getSerialisedStatefulSession(session, ruleBase, true);
    }

    public static StatefulSession getSerialisedStatefulSession(StatefulSession session, boolean dispose) throws Exception {
        return SerializationHelper.getSerialisedStatefulSession(session, session.getRuleBase(), dispose);
    }

    public static StatefulSession getSerialisedStatefulSession(StatefulSession session, RuleBase ruleBase, boolean dispose) throws Exception {
        DefaultMarshaller marshaller = new DefaultMarshaller();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ruleBase.writeStatefulSession(session, (OutputStream)baos, (Marshaller)marshaller);
        byte[] b1 = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(b1);
        StatefulSession session2 = ruleBase.readStatefulSession((InputStream)bais, true, (Marshaller)marshaller);
        marshaller = new DefaultMarshaller();
        baos = new ByteArrayOutputStream();
        ruleBase.writeStatefulSession(session2, (OutputStream)baos, (Marshaller)marshaller);
        byte[] b2 = baos.toByteArray();
        if (!SerializationHelper.areByteArraysEqual(b1, b2)) {
            throw new IllegalArgumentException("byte streams for serialisation test are not equal");
        }
        session2.setGlobalResolver(session.getGlobalResolver());
        if (dispose) {
            session.dispose();
        }
        return session2;
    }

    public static boolean areByteArraysEqual(byte[] b1, byte[] b2) {
        if (b1.length != b2.length) {
            return false;
        }
        int length = b1.length;
        for (int i = 0; i < length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }
}

