/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.Cheesery;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.StatelessSession;
import org.drools.StatelessSessionResult;
import org.drools.base.CopyIdentifiersGlobalExporter;
import org.drools.base.MapGlobalResolver;
import org.drools.base.ReferenceOriginalGlobalExporter;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.compiler.PackageBuilder;
import org.drools.integrationtests.SerializationHelper;
import org.drools.io.ResourceFactory;
import org.drools.rule.Package;
import org.drools.runtime.GlobalResolver;
import org.drools.runtime.Parameters;
import org.drools.runtime.StatelessKnowledgeSession;
import org.drools.runtime.StatelessKnowledgeSessionResults;
import org.drools.spi.GlobalExporter;

public class StatelessSessionTest
extends TestCase {
    final List list = new ArrayList();
    final Cheesery cheesery = new Cheesery();
    final org.drools.spi.GlobalResolver globalResolver = new MapGlobalResolver();

    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }

    protected RuleBase getRuleBase(RuleBaseConfiguration config) throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }

    public void testSingleObjectAssert() throws Exception {
        StatelessKnowledgeSession session = this.getSession2("literal_rule_test.drl");
        Cheese stilton = new Cheese("stilton", 5);
        session.executeObject((Object)stilton);
        StatelessSessionTest.assertEquals((Object)"stilton", this.list.get(0));
    }

    public void testArrayObjectAssert() throws Exception {
        StatelessKnowledgeSession session = this.getSession2("literal_rule_test.drl");
        Cheese stilton = new Cheese("stilton", 5);
        session.executeIterable(Arrays.asList(stilton));
        StatelessSessionTest.assertEquals((Object)"stilton", this.list.get(0));
    }

    public void testCollectionObjectAssert() throws Exception {
        StatelessKnowledgeSession session = this.getSession2("literal_rule_test.drl");
        Cheese stilton = new Cheese("stilton", 5);
        ArrayList<Cheese> collection = new ArrayList<Cheese>();
        collection.add(stilton);
        session.executeIterable(collection);
        StatelessSessionTest.assertEquals((Object)"stilton", this.list.get(0));
    }

    public void testSingleObjectAssertWithResults() throws Exception {
        StatelessKnowledgeSession session = this.getSession2("literal_rule_test.drl");
        Parameters parameters = session.newParameters();
        parameters.getGlobalParams().setOut(Arrays.asList("list"));
        Cheese stilton = new Cheese("stilton", 5);
        StatelessKnowledgeSessionResults results = session.executeObjectWithParameters((Object)stilton, parameters);
        StatelessSessionTest.assertEquals((int)1, (int)results.getIdentifiers().size());
        StatelessSessionTest.assertTrue((boolean)results.getIdentifiers().contains("list"));
        StatelessSessionTest.assertEquals((Object)"stilton", ((List)results.getValue("list")).get(0));
        StatelessSessionTest.assertNull((Object)results.getValue("cheesery"));
    }

    public void testArrayObjectAssertWithResults() throws Exception {
        StatelessKnowledgeSession session = this.getSession2("literal_rule_test.drl");
        Parameters parameters = session.newParameters();
        parameters.getGlobalParams().setOut(Arrays.asList("list"));
        Cheese stilton = new Cheese("stilton", 5);
        StatelessKnowledgeSessionResults results = session.executeIterableWithParameters(Arrays.asList(stilton), parameters);
        StatelessSessionTest.assertEquals((int)1, (int)results.getIdentifiers().size());
        StatelessSessionTest.assertTrue((boolean)results.getIdentifiers().contains("list"));
        StatelessSessionTest.assertEquals((Object)"stilton", ((List)results.getValue("list")).get(0));
        StatelessSessionTest.assertNull((Object)results.getValue("cheesery"));
    }

    public void testCollectionObjectAssertWithResults() throws Exception {
        StatelessKnowledgeSession session = this.getSession2("literal_rule_test.drl");
        Parameters parameters = session.newParameters();
        parameters.getGlobalParams().setOut(Arrays.asList("list"));
        Cheese stilton = new Cheese("stilton", 5);
        ArrayList<Cheese> collection = new ArrayList<Cheese>();
        collection.add(stilton);
        StatelessKnowledgeSessionResults results = session.executeIterableWithParameters(collection, parameters);
        StatelessSessionTest.assertEquals((int)1, (int)results.getIdentifiers().size());
        StatelessSessionTest.assertTrue((boolean)results.getIdentifiers().contains("list"));
        StatelessSessionTest.assertEquals((Object)"stilton", ((List)results.getValue("list")).get(0));
        StatelessSessionTest.assertNull((Object)results.getValue("cheesery"));
    }

    public void testInAndOutParams() throws Exception {
        StatelessKnowledgeSession session = this.getSession2("testStatelessKnowledgeSessionInOutParams.drl");
        Cheese stilton = new Cheese("stilton", 5);
        Cheese cheddar = new Cheese("cheddar", 25);
        Parameters parameters = session.newParameters();
        HashMap<String, String> globalsIn = new HashMap<String, String>();
        globalsIn.put("inString", "string");
        parameters.getGlobalParams().setIn(globalsIn);
        parameters.getGlobalParams().setOut(Arrays.asList("list"));
        HashMap<String, Cheese> factIn = new HashMap<String, Cheese>();
        factIn.put("inCheese", cheddar);
        parameters.getFactParams().setIn(factIn);
        parameters.getFactParams().setOut(Arrays.asList("outCheese"));
        StatelessKnowledgeSessionResults results = session.executeObjectWithParameters((Object)stilton, parameters);
        StatelessSessionTest.assertEquals((int)2, (int)results.getIdentifiers().size());
        StatelessSessionTest.assertTrue((boolean)results.getIdentifiers().contains("list"));
        StatelessSessionTest.assertTrue((boolean)results.getIdentifiers().contains("outCheese"));
        StatelessSessionTest.assertEquals((Object)new Cheese("brie", 50), (Object)results.getValue("outCheese"));
        StatelessSessionTest.assertEquals((Object)"rule1 cheddar", ((List)results.getValue("list")).get(0));
        StatelessSessionTest.assertEquals((Object)"rule2 stilton", ((List)results.getValue("list")).get(1));
        StatelessSessionTest.assertEquals((Object)"rule3 brie", ((List)results.getValue("list")).get(2));
        StatelessSessionTest.assertEquals((Object)"rule4 string", ((List)results.getValue("list")).get(3));
        StatelessSessionTest.assertNull((Object)results.getValue("cheesery"));
    }

    public void testInOutAndOutParams() throws Exception {
        StatelessKnowledgeSession session = this.getSession2("testStatelessKnowledgeSessionInOutParams.drl");
        Cheese stilton = new Cheese("stilton", 5);
        Cheese cheddar = new Cheese("cheddar", 25);
        Parameters parameters = session.newParameters();
        HashMap<String, String> globalsInOut = new HashMap<String, String>();
        globalsInOut.put("inString", "string");
        parameters.getGlobalParams().setInOut(globalsInOut);
        parameters.getGlobalParams().setOut(Arrays.asList("list"));
        HashMap<String, Cheese> factInOut = new HashMap<String, Cheese>();
        factInOut.put("inCheese", cheddar);
        parameters.getFactParams().setInOut(factInOut);
        parameters.getFactParams().setOut(Arrays.asList("outCheese"));
        StatelessKnowledgeSessionResults results = session.executeObjectWithParameters((Object)stilton, parameters);
        StatelessSessionTest.assertEquals((int)4, (int)results.getIdentifiers().size());
        StatelessSessionTest.assertTrue((boolean)results.getIdentifiers().contains("list"));
        StatelessSessionTest.assertTrue((boolean)results.getIdentifiers().contains("inString"));
        StatelessSessionTest.assertTrue((boolean)results.getIdentifiers().contains("inCheese"));
        StatelessSessionTest.assertTrue((boolean)results.getIdentifiers().contains("outCheese"));
        StatelessSessionTest.assertEquals((Object)new Cheese("brie", 50), (Object)results.getValue("outCheese"));
        StatelessSessionTest.assertEquals((Object)"rule1 cheddar", ((List)results.getValue("list")).get(0));
        StatelessSessionTest.assertEquals((Object)"rule2 stilton", ((List)results.getValue("list")).get(1));
        StatelessSessionTest.assertEquals((Object)"rule3 brie", ((List)results.getValue("list")).get(2));
        StatelessSessionTest.assertEquals((Object)"rule4 string", ((List)results.getValue("list")).get(3));
        StatelessSessionTest.assertNull((Object)results.getValue("cheesery"));
    }

    public void testAsynSingleOjbectcAssert() throws Exception {
        StatelessSession session = this.getSession();
        Cheese stilton = new Cheese("stilton", 5);
        session.asyncExecute((Object)stilton);
        Thread.sleep(300L);
        StatelessSessionTest.assertEquals((Object)"stilton", this.list.get(0));
    }

    public void testAsynArrayOjbectcAssert() throws Exception {
        StatelessSession session = this.getSession();
        Cheese stilton = new Cheese("stilton", 5);
        session.asyncExecute(new Object[]{stilton});
        Thread.sleep(100L);
        StatelessSessionTest.assertEquals((Object)"stilton", this.list.get(0));
    }

    public void testAsynCollectionOjbectcAssert() throws Exception {
        StatelessSession session = this.getSession();
        Cheese stilton = new Cheese("stilton", 5);
        ArrayList<Cheese> collection = new ArrayList<Cheese>();
        collection.add(stilton);
        session.execute(collection);
        Thread.sleep(100L);
        StatelessSessionTest.assertEquals((Object)"stilton", this.list.get(0));
    }

    public void testCopyIdentifierGlobalExporterOneValue() throws Exception {
        StatelessSession session = this.getSession();
        session.setGlobalExporter((GlobalExporter)new CopyIdentifiersGlobalExporter(new String[]{"list"}));
        StatelessSessionResult result = session.executeWithResults((Object)null);
        StatelessSessionTest.assertSame((Object)this.list, (Object)result.getGlobal("list"));
        StatelessSessionTest.assertNull((Object)result.getGlobal("cheesery"));
        StatelessSessionTest.assertNotSame((Object)this.globalResolver, (Object)result.getGlobalResolver());
    }

    public void testCopyIdentifierGlobalExporterTwoValues() throws Exception {
        StatelessSession session = this.getSession();
        session.setGlobalExporter((GlobalExporter)new CopyIdentifiersGlobalExporter(new String[]{"list", "cheesery"}));
        StatelessSessionResult result = session.executeWithResults((Object)null);
        StatelessSessionTest.assertSame((Object)this.list, (Object)result.getGlobal("list"));
        StatelessSessionTest.assertSame((Object)this.cheesery, (Object)result.getGlobal("cheesery"));
        StatelessSessionTest.assertNotSame((Object)this.globalResolver, (Object)result.getGlobalResolver());
    }

    public void testCopyIdentifierGlobalExporterAllValues() throws Exception {
        StatelessSession session = this.getSession();
        session.setGlobalExporter((GlobalExporter)new CopyIdentifiersGlobalExporter());
        StatelessSessionResult result = session.executeWithResults((Object)null);
        StatelessSessionTest.assertSame((Object)this.list, (Object)result.getGlobal("list"));
        StatelessSessionTest.assertSame((Object)this.cheesery, (Object)result.getGlobal("cheesery"));
        StatelessSessionTest.assertNotSame((Object)this.globalResolver, (Object)result.getGlobalResolver());
    }

    public void testReferenceOriginalGlobalExporter() throws Exception {
        StatelessSession session = this.getSession();
        session.setGlobalExporter((GlobalExporter)new ReferenceOriginalGlobalExporter());
        StatelessSessionResult result = session.executeWithResults((Object)null);
        StatelessSessionTest.assertSame((Object)this.list, (Object)result.getGlobal("list"));
        StatelessSessionTest.assertSame((Object)this.cheesery, (Object)result.getGlobal("cheesery"));
        StatelessSessionTest.assertSame((Object)this.globalResolver, (Object)result.getGlobalResolver());
    }

    private StatelessSession getSession() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("literal_rule_test.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatelessSession session = ruleBase.newStatelessSession();
        session = SerializationHelper.serializeObject(session);
        session.setGlobalResolver(this.globalResolver);
        session.setGlobal("list", (Object)this.list);
        session.setGlobal("cheesery", (Object)this.cheesery);
        return session;
    }

    private StatelessKnowledgeSession getSession2(String fileName) throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)fileName, ((Object)((Object)this)).getClass()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            System.out.println(kbuilder.getErrors());
        }
        StatelessSessionTest.assertFalse((boolean)kbuilder.hasErrors());
        Collection pkgs = kbuilder.getKnowledgePackages();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(pkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        StatelessKnowledgeSession session = kbase.newStatelessKnowledgeSession();
        session.setGlobalResolver((GlobalResolver)this.globalResolver);
        session.setGlobal("list", (Object)this.list);
        session.setGlobal("cheesery", (Object)this.cheesery);
        return session;
    }
}

