/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang;

import java.util.LinkedList;
import junit.framework.TestCase;
import org.antlr.runtime.RecognitionException;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.lang.DroolsSentence;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.RuleDescr;

public class DRLIncompleteCodeTest
extends TestCase {
    public void testIncompleteCode1() throws DroolsParserException, RecognitionException {
        String input = "package a.b.c import a.b.c.* query MyQuery rule MyRule when Class ( property memberOf collexction ";
        DrlParser parser = new DrlParser();
        PackageDescr descr = parser.parse(true, input);
        DRLIncompleteCodeTest.assertNotNull((Object)descr);
        DRLIncompleteCodeTest.assertEquals((String)"a.b.c", (String)descr.getNamespace());
        DRLIncompleteCodeTest.assertEquals((String)"a.b.c.*", (String)((ImportDescr)descr.getImports().get(0)).getTarget());
        DRLIncompleteCodeTest.assertEquals((int)103, (int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorSentences().get(2)).getContent()));
    }

    public void testIncompleteCode2() throws DroolsParserException, RecognitionException {
        String input = "rule MyRule when Class ( property memberOf collection ";
        DrlParser parser = new DrlParser();
        PackageDescr descr = parser.parse(true, input);
        DRLIncompleteCodeTest.assertNotNull((Object)descr);
        DRLIncompleteCodeTest.assertEquals((int)103, (int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorSentences().get(0)).getContent()));
    }

    public void testIncompleteCode3() throws DroolsParserException, RecognitionException {
        String input = "rule MyRule when Class ( property memberOf collection ) then end query MyQuery Class ( property memberOf collection ) end ";
        DrlParser parser = new DrlParser();
        PackageDescr descr = parser.parse(true, input);
        DRLIncompleteCodeTest.assertNotNull((Object)descr);
        DRLIncompleteCodeTest.assertEquals((String)"MyRule", (String)((RuleDescr)descr.getRules().get(0)).getName());
        DRLIncompleteCodeTest.assertNotNull((Object)descr);
        DRLIncompleteCodeTest.assertEquals((String)"MyQuery", (String)((RuleDescr)descr.getRules().get(1)).getName());
        DRLIncompleteCodeTest.assertEquals((int)1000, (int)this.getLastIntegerValue(((DroolsSentence)parser.getEditorSentences().get(0)).getContent()));
    }

    public void testIncompleteCode4() throws DroolsParserException, RecognitionException {
        String input = "package a.b.c import a.b.c.* rule MyRule when Class ( property memberOf collection ) then end  query MyQuery Class ( property memberOf collection ) end ";
        DrlParser parser = new DrlParser();
        PackageDescr descr = parser.parse(true, input);
        DRLIncompleteCodeTest.assertEquals((String)"a.b.c", (String)descr.getNamespace());
        DRLIncompleteCodeTest.assertEquals((String)"a.b.c.*", (String)((ImportDescr)descr.getImports().get(0)).getTarget());
        DRLIncompleteCodeTest.assertNotNull((Object)descr);
        DRLIncompleteCodeTest.assertEquals((String)"MyRule", (String)((RuleDescr)descr.getRules().get(0)).getName());
        DRLIncompleteCodeTest.assertNotNull((Object)descr);
        DRLIncompleteCodeTest.assertEquals((String)"MyQuery", (String)((RuleDescr)descr.getRules().get(1)).getName());
    }

    public void testIncompleteCode5() throws DroolsParserException, RecognitionException {
        String input = "packe a.b.c import a.b.c.* rule MyRule when Class ( property memberOf collection ) then end  query MyQuery Class ( property memberOf collection ) end ";
        DrlParser parser = new DrlParser();
        PackageDescr descr = parser.parse(true, input);
        DRLIncompleteCodeTest.assertNotNull((Object)descr);
    }

    public void testIncompleteCode6() throws DroolsParserException, RecognitionException {
        String input = "packe 1111.111 import a.b.c.* rule MyRule when Class ( property memberOf collection ) then end  query MyQuery Class ( property memberOf collection ) end ";
        DrlParser parser = new DrlParser();
        PackageDescr descr = parser.parse(true, input);
        DRLIncompleteCodeTest.assertNull((Object)descr);
    }

    public void testIncompleteCode7() throws DroolsParserException, RecognitionException {
        String input = "package a.b.c imrt a.b.c.* rule MyRule when Class ( property memberOf collection ) then end  query MyQuery Class ( property memberOf collection ) end ";
        DrlParser parser = new DrlParser();
        PackageDescr descr = parser.parse(true, input);
        DRLIncompleteCodeTest.assertNotNull((Object)descr);
    }

    public void testIncompleteCode8() throws DroolsParserException, RecognitionException {
        String input = "package a.b.c import a.1111.c.* rule MyRule when Class ( property memberOf collection ) then end  query MyQuery Class ( property memberOf collection ) end ";
        DrlParser parser = new DrlParser();
        PackageDescr descr = parser.parse(true, input);
        DRLIncompleteCodeTest.assertEquals((String)"a.b.c", (String)descr.getNamespace());
        DRLIncompleteCodeTest.assertEquals((int)2, (int)descr.getRules().size());
        DRLIncompleteCodeTest.assertEquals((boolean)true, (boolean)parser.hasErrors());
    }

    public void testIncompleteCode9() throws DroolsParserException, RecognitionException {
        String input = "package a.b.c import a.b.c.* rule MyRule xxxxx Class ( property memberOf collection ) then end  query MyQuery Class ( property memberOf collection ) end ";
        DrlParser parser = new DrlParser();
        PackageDescr descr = parser.parse(true, input);
        DRLIncompleteCodeTest.assertEquals((String)"a.b.c", (String)descr.getNamespace());
        DRLIncompleteCodeTest.assertEquals((String)"a.b.c.*", (String)((ImportDescr)descr.getImports().get(0)).getTarget());
        DRLIncompleteCodeTest.assertEquals((int)1, (int)descr.getRules().size());
        DRLIncompleteCodeTest.assertEquals((String)"MyQuery", (String)((RuleDescr)descr.getRules().get(0)).getName());
    }

    public void testIncompleteCode10() throws DroolsParserException, RecognitionException {
        String input = "package a.b.c import a.b.c.* rule MyRule xxxxx Class ( property memberOf  query MyQuery Class ( property memberOf collection ) end ";
        DrlParser parser = new DrlParser();
        PackageDescr descr = parser.parse(true, input);
        DRLIncompleteCodeTest.assertEquals((String)"a.b.c", (String)descr.getNamespace());
        DRLIncompleteCodeTest.assertEquals((String)"a.b.c.*", (String)((ImportDescr)descr.getImports().get(0)).getTarget());
        DRLIncompleteCodeTest.assertEquals((int)0, (int)descr.getRules().size());
    }

    public void testIncompleteCode11() throws DroolsParserException, RecognitionException {
        String input = "package a.b.c import a.b.c.* rule MyRule when Class ( property memberOf collection ) then end  qzzzzuery MyQuery Class ( property ";
        DrlParser parser = new DrlParser();
        PackageDescr descr = parser.parse(true, input);
        DRLIncompleteCodeTest.assertEquals((String)"a.b.c", (String)descr.getNamespace());
        DRLIncompleteCodeTest.assertEquals((String)"a.b.c.*", (String)((ImportDescr)descr.getImports().get(0)).getTarget());
        DRLIncompleteCodeTest.assertNotNull((Object)descr);
        DRLIncompleteCodeTest.assertEquals((String)"MyRule", (String)((RuleDescr)descr.getRules().get(0)).getName());
    }

    public void testIncompleteCode12() throws DroolsParserException, RecognitionException {
        String input = "package a.b.c import a.b.c.* rule MyRule  when     m: Message(  )       thenend ";
        DrlParser parser = new DrlParser();
        PackageDescr descr = parser.parse(true, input);
        DRLIncompleteCodeTest.assertNotNull((Object)descr);
        DRLIncompleteCodeTest.assertEquals((String)"a.b.c", (String)descr.getNamespace());
        DRLIncompleteCodeTest.assertEquals((String)"a.b.c.*", (String)((ImportDescr)descr.getImports().get(0)).getTarget());
    }

    public void testIncompleteCode13() throws DroolsParserException, RecognitionException {
        String input = "package com.sample import com.sample.DroolsTest.Message; rule \"Hello World\"  when   then     \\\" end ";
        DrlParser parser = new DrlParser();
        PackageDescr descr = parser.parse(true, input);
        DRLIncompleteCodeTest.assertNotNull((Object)descr);
    }

    private int getLastIntegerValue(LinkedList list) {
        int lastIntergerValue = -1;
        for (Object object : list) {
            if (!(object instanceof Integer)) continue;
            lastIntergerValue = (Integer)object;
        }
        return lastIntergerValue;
    }
}

