/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeAdaptor;
import org.antlr.runtime.tree.TreeNodeStream;
import org.drools.base.evaluators.MatchesEvaluatorsDefinition;
import org.drools.base.evaluators.SetEvaluatorsDefinition;
import org.drools.lang.DRLLexer;
import org.drools.lang.DRLParser;
import org.drools.lang.DescrBuilderTree;
import org.drools.lang.DroolsTree;
import org.drools.lang.DroolsTreeAdaptor;
import org.drools.lang.MVELDumper;
import org.drools.lang.descr.FieldConstraintDescr;
import org.drools.lang.descr.PatternDescr;

public class MVELDumperTest
extends TestCase {
    private MVELDumper dumper;

    protected void setUp() throws Exception {
        super.setUp();
        new SetEvaluatorsDefinition();
        new MatchesEvaluatorsDefinition();
        this.dumper = new MVELDumper();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testDump() throws Exception {
        String input = "Cheese( price > 10 && < 20 || == $val || == 30 )";
        String expected = "( ( price > 10 && price < 20 ) || price == $val || price == 30 )";
        PatternDescr pattern = (PatternDescr)this.parse("lhs_pattern", "lhs_pattern", input);
        FieldConstraintDescr fieldDescr = (FieldConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        String result = this.dumper.dump(fieldDescr);
        MVELDumperTest.assertEquals((String)expected, (String)result);
    }

    public void testDumpMatches() throws Exception {
        String input = "Cheese( type.toString matches \"something\\swith\\tsingle escapes\" )";
        String expected = "type.toString ~= \"something\\\\swith\\\\tsingle escapes\"";
        PatternDescr pattern = (PatternDescr)this.parse("lhs_pattern", "lhs_pattern", input);
        FieldConstraintDescr fieldDescr = (FieldConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        String result = this.dumper.dump(fieldDescr);
        MVELDumperTest.assertEquals((String)expected, (String)result);
    }

    public void testDumpMatches2() throws Exception {
        String input = "Cheese( type.toString matches 'something\\swith\\tsingle escapes' )";
        String expected = "type.toString ~= \"something\\\\swith\\\\tsingle escapes\"";
        PatternDescr pattern = (PatternDescr)this.parse("lhs_pattern", "lhs_pattern", input);
        FieldConstraintDescr fieldDescr = (FieldConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        String result = this.dumper.dump(fieldDescr);
        MVELDumperTest.assertEquals((String)expected, (String)result);
    }

    public void testDumpMatches3() throws Exception {
        String input = "Map( this[\"content\"] matches \"hello ;=\" )";
        String expected = "this[\"content\"] ~= \"hello ;=\"";
        PatternDescr pattern = (PatternDescr)this.parse("lhs_pattern", "lhs_pattern", input);
        FieldConstraintDescr fieldDescr = (FieldConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        String result = this.dumper.dump(fieldDescr);
        MVELDumperTest.assertEquals((String)expected, (String)result);
    }

    public void testDumpWithDateAttr() throws Exception {
        String input = "Person( son.birthDate == \"01-jan-2000\" )";
        String expected = "son.birthDate == org.drools.util.DateUtils.parseDate( \"01-jan-2000\" )";
        PatternDescr pattern = (PatternDescr)this.parse("lhs_pattern", "lhs_pattern", input);
        FieldConstraintDescr fieldDescr = (FieldConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        String result = this.dumper.dump(fieldDescr, true);
        MVELDumperTest.assertEquals((String)expected, (String)result);
    }

    private Object parse(String parserRuleName, String treeRuleName, String text) throws Exception {
        return this.newParser(parserRuleName, treeRuleName, this.newCharStream(text));
    }

    private CharStream newCharStream(String text) {
        return new ANTLRStringStream(text);
    }

    private Object newParser(String parserRuleName, String treeRuleName, CharStream charStream) {
        return this.execTreeParser(parserRuleName, treeRuleName, charStream);
    }

    public Object execTreeParser(String testRuleName, String testTreeRuleName, CharStream charStream) {
        Object treeRuleReturn;
        block11: {
            treeRuleReturn = null;
            try {
                DRLLexer lexer = new DRLLexer(charStream);
                CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
                DRLParser parser = new DRLParser((TokenStream)tokens);
                parser.setTreeAdaptor((TreeAdaptor)new DroolsTreeAdaptor());
                Method ruleName = Class.forName("org.drools.lang.DRLParser").getMethod(testRuleName, new Class[0]);
                Object ruleReturn = ruleName.invoke((Object)parser, new Object[0]);
                if (!parser.hasErrors()) {
                    Class<?> _return = Class.forName("org.drools.lang.DRLParser$" + testRuleName + "_return");
                    Method returnName = _return.getMethod("getTree", new Class[0]);
                    DroolsTree tree = (DroolsTree)returnName.invoke(ruleReturn, new Object[0]);
                    CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)tree);
                    nodes.setTokenStream((TokenStream)tokens);
                    DescrBuilderTree walker = new DescrBuilderTree((TreeNodeStream)nodes);
                    Method treeRuleName = Class.forName("org.drools.lang.DescrBuilderTree").getMethod(testTreeRuleName, new Class[0]);
                    treeRuleReturn = treeRuleName.invoke((Object)walker, new Object[0]);
                }
                if (treeRuleReturn == null || treeRuleReturn.toString().indexOf(testTreeRuleName + "_return") <= 0) break block11;
                try {
                    Field[] fields;
                    Class<?> _treeReturn = Class.forName("org.drools.lang.DescrBuilderTree$" + testTreeRuleName + "_return");
                    for (Field field : fields = _treeReturn.getDeclaredFields()) {
                        if (!field.getType().getName().contains("org.drools.lang.descr.")) continue;
                        return field.get(treeRuleReturn);
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return treeRuleReturn;
    }
}

