/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import junit.framework.TestCase;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeAdaptor;
import org.antlr.runtime.tree.TreeNodeStream;
import org.drools.base.evaluators.EvaluatorRegistry;
import org.drools.compiler.DrlParser;
import org.drools.lang.DRLLexer;
import org.drools.lang.DRLParser;
import org.drools.lang.DescrBuilderTree;
import org.drools.lang.DroolsTree;
import org.drools.lang.DroolsTreeAdaptor;
import org.drools.lang.descr.AccessorDescr;
import org.drools.lang.descr.AccumulateDescr;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.CollectDescr;
import org.drools.lang.descr.EntryPointDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.FactTemplateDescr;
import org.drools.lang.descr.FieldAccessDescr;
import org.drools.lang.descr.FieldBindingDescr;
import org.drools.lang.descr.FieldConstraintDescr;
import org.drools.lang.descr.FieldTemplateDescr;
import org.drools.lang.descr.ForallDescr;
import org.drools.lang.descr.FromDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.FunctionImportDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.LiteralRestrictionDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.QualifiedIdentifierRestrictionDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.RestrictionConnectiveDescr;
import org.drools.lang.descr.RestrictionDescr;
import org.drools.lang.descr.ReturnValueRestrictionDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.lang.descr.SlidingWindowDescr;
import org.drools.lang.descr.TypeDeclarationDescr;
import org.drools.lang.descr.TypeFieldDescr;
import org.drools.lang.descr.VariableRestrictionDescr;

public class RuleParserTest
extends TestCase {
    private DescrBuilderTree walker;
    DRLParser parser;

    protected void setUp() throws Exception {
        super.setUp();
        this.walker = null;
        new EvaluatorRegistry();
    }

    protected void tearDown() throws Exception {
        this.walker = null;
        super.tearDown();
    }

    public void testFromComplexAcessor() throws Exception {
        String source = "rule \"Invalid customer id\" ruleflow-group \"validate\" lock-on-active true \n when \n o: Order( ) \n not( Customer( ) from customerService.getCustomer(o.getCustomerId()) ) \n then \n System.err.println(\"Invalid customer id found!\"); \n o.addError(\"Invalid customer id\"); \nend \n";
        this.parse("compilation_unit", "compilation_unit", source);
        RuleDescr rule = (RuleDescr)this.walker.getPackageDescr().getRules().get(0);
        RuleParserTest.assertEquals((String)"Invalid customer id", (String)rule.getName());
        RuleParserTest.assertFalse((boolean)this.parser.hasErrors());
    }

    public void testOrWithSpecialBind() throws Exception {
        String source = "rule \"A and (B or C or D)\" \n    when \n        pdo1 : ParametricDataObject( paramID == 101, stringValue == \"1000\" ) and \n        pdo2 :(ParametricDataObject( paramID == 101, stringValue == \"1001\" ) or \n               ParametricDataObject( paramID == 101, stringValue == \"1002\" ) or \n               ParametricDataObject( paramID == 101, stringValue == \"1003\" )) \n    then \n        System.out.println( \"Rule: A and (B or C or D) Fired. pdo1: \" + pdo1 +  \" pdo2: \"+ pdo2); \nend\n";
        this.parse("compilation_unit", "compilation_unit", source);
        RuleParserTest.assertFalse((boolean)this.parser.hasErrors());
    }

    public void testCompatibleRestriction() throws Exception {
        String source = "package com.sample  rule test  when  Test( ( text == null || text2 matches \"\" ) )  then  end";
        this.parse("compilation_unit", "compilation_unit", source);
        RuleParserTest.assertEquals((String)"com.sample", (String)this.walker.getPackageDescr().getName());
        RuleDescr rule = (RuleDescr)this.walker.getPackageDescr().getRules().get(0);
        RuleParserTest.assertEquals((String)"test", (String)rule.getName());
        OrDescr or = (OrDescr)((PatternDescr)rule.getLhs().getDescrs().get(0)).getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        RuleParserTest.assertEquals((String)"text", (String)((FieldConstraintDescr)or.getDescrs().get(0)).getFieldName());
        RuleParserTest.assertEquals((String)"text2", (String)((FieldConstraintDescr)or.getDescrs().get(1)).getFieldName());
    }

    public void testSimpleRestriction() throws Exception {
        String source = "package com.sample  rule test  when  Test( ( text == null || matches \"\" ) )  then  end";
        this.parse("compilation_unit", "compilation_unit", source);
        RuleParserTest.assertEquals((String)"com.sample", (String)this.walker.getPackageDescr().getName());
        RuleDescr rule = (RuleDescr)this.walker.getPackageDescr().getRules().get(0);
        RuleParserTest.assertEquals((String)"test", (String)rule.getName());
        FieldConstraintDescr fieldConstr = (FieldConstraintDescr)((PatternDescr)rule.getLhs().getDescrs().get(0)).getDescrs().get(0);
        RestrictionConnectiveDescr restConnective = (RestrictionConnectiveDescr)fieldConstr.getRestrictions().get(0);
        RuleParserTest.assertEquals((int)2, (int)restConnective.getRestrictions().size());
    }

    public void testPackage_OneSegment() throws Exception {
        String packageName = (String)this.parse("package_statement", "package_statement", "package foo");
        RuleParserTest.assertEquals((String)"foo", (String)packageName);
    }

    public void testPackage_MultipleSegments() throws Exception {
        String packageName = (String)this.parse("package_statement", "package_statement", "package foo.bar.baz;");
        RuleParserTest.assertEquals((String)"foo.bar.baz", (String)packageName);
    }

    public void testEmptyPackage() throws Exception {
        String source = "package foo.bar.baz";
        DrlParser parser = new DrlParser();
        PackageDescr pkg = parser.parse((Reader)new StringReader("package foo.bar.baz"));
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
        RuleParserTest.assertEquals((String)"foo.bar.baz", (String)pkg.getName());
    }

    public void testCompilationUnit() throws Exception {
        String source = "package foo; import com.foo.Bar; import com.foo.Baz;";
        this.parse("compilation_unit", "compilation_unit", "package foo; import com.foo.Bar; import com.foo.Baz;");
        RuleParserTest.assertEquals((String)"foo", (String)this.walker.getPackageDescr().getName());
        RuleParserTest.assertEquals((int)2, (int)this.walker.getPackageDescr().getImports().size());
        ImportDescr impdescr = (ImportDescr)this.walker.getPackageDescr().getImports().get(0);
        RuleParserTest.assertEquals((String)"com.foo.Bar", (String)impdescr.getTarget());
        RuleParserTest.assertEquals((int)"package foo; import com.foo.Bar; import com.foo.Baz;".indexOf("import " + impdescr.getTarget()), (int)impdescr.getStartCharacter());
        RuleParserTest.assertEquals((int)("package foo; import com.foo.Bar; import com.foo.Baz;".indexOf("import " + impdescr.getTarget()) + ("import " + impdescr.getTarget()).length() - 1), (int)impdescr.getEndCharacter());
        impdescr = (ImportDescr)this.walker.getPackageDescr().getImports().get(1);
        RuleParserTest.assertEquals((String)"com.foo.Baz", (String)impdescr.getTarget());
        RuleParserTest.assertEquals((int)"package foo; import com.foo.Bar; import com.foo.Baz;".indexOf("import " + impdescr.getTarget()), (int)impdescr.getStartCharacter());
        RuleParserTest.assertEquals((int)("package foo; import com.foo.Bar; import com.foo.Baz;".indexOf("import " + impdescr.getTarget()) + ("import " + impdescr.getTarget()).length() - 1), (int)impdescr.getEndCharacter());
    }

    public void testDialect() throws Exception {
        String source = "dialect 'mvel'";
        this.parse("compilation_unit", "compilation_unit", "dialect 'mvel'");
        AttributeDescr attr = (AttributeDescr)this.walker.getPackageDescr().getAttributes().get(0);
        RuleParserTest.assertEquals((String)"dialect", (String)attr.getName());
        RuleParserTest.assertEquals((String)"mvel", (String)attr.getValue());
    }

    public void testDialect2() throws Exception {
        String source = "dialect \"mvel\"";
        this.parse("compilation_unit", "compilation_unit", "dialect \"mvel\"");
        AttributeDescr attr = (AttributeDescr)this.walker.getPackageDescr().getAttributes().get(0);
        RuleParserTest.assertEquals((String)"dialect", (String)attr.getName());
        RuleParserTest.assertEquals((String)"mvel", (String)attr.getValue());
    }

    public void testEmptyRule() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule", "empty_rule.drl");
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"empty", (String)rule.getName());
        RuleParserTest.assertNotNull((Object)rule.getLhs());
        RuleParserTest.assertNotNull((Object)rule.getConsequence());
    }

    public void FIXME_testKeywordCollisions() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "eol_funny_business.drl");
        PackageDescr pkg = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
    }

    public void testTemplates() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "test_Templates.drl");
        PackageDescr pkg = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleParserTest.assertEquals((int)2, (int)pkg.getFactTemplates().size());
        FactTemplateDescr fact1 = (FactTemplateDescr)pkg.getFactTemplates().get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)fact1.getName());
        RuleParserTest.assertEquals((int)2, (int)fact1.getFields().size());
        RuleParserTest.assertEquals((String)"name", (String)((FieldTemplateDescr)fact1.getFields().get(0)).getName());
        RuleParserTest.assertEquals((String)"String", (String)((FieldTemplateDescr)fact1.getFields().get(0)).getClassType());
        RuleParserTest.assertEquals((String)"age", (String)((FieldTemplateDescr)fact1.getFields().get(1)).getName());
        RuleParserTest.assertEquals((String)"Integer", (String)((FieldTemplateDescr)fact1.getFields().get(1)).getClassType());
        fact1 = null;
        FactTemplateDescr fact2 = (FactTemplateDescr)pkg.getFactTemplates().get(1);
        RuleParserTest.assertEquals((String)"Wine", (String)fact2.getName());
        RuleParserTest.assertEquals((int)3, (int)fact2.getFields().size());
        RuleParserTest.assertEquals((String)"name", (String)((FieldTemplateDescr)fact2.getFields().get(0)).getName());
        RuleParserTest.assertEquals((String)"String", (String)((FieldTemplateDescr)fact2.getFields().get(0)).getClassType());
        RuleParserTest.assertEquals((String)"year", (String)((FieldTemplateDescr)fact2.getFields().get(1)).getName());
        RuleParserTest.assertEquals((String)"String", (String)((FieldTemplateDescr)fact2.getFields().get(1)).getClassType());
        RuleParserTest.assertEquals((String)"accolades", (String)((FieldTemplateDescr)fact2.getFields().get(2)).getName());
        RuleParserTest.assertEquals((String)"String[]", (String)((FieldTemplateDescr)fact2.getFields().get(2)).getClassType());
    }

    public void testTernaryExpression() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "ternary_expression.drl");
        PackageDescr pkg = this.walker.getPackageDescr();
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        this.assertEqualsIgnoreWhitespace("if (speed > speedLimit ? true : false;) pullEmOver();", (String)rule.getConsequence());
    }

    public void FIXME_testLatinChars() throws Exception {
        DrlParser parser = new DrlParser();
        InputStreamReader drl = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("latin-sample.dslr"));
        InputStreamReader dsl = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("latin.dsl"));
        PackageDescr pkg = parser.parse((Reader)drl, (Reader)dsl);
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
        RuleParserTest.assertEquals((String)"br.com.auster.drools.sample", (String)pkg.getName());
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
    }

    public void testFunctionWithArrays() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "function_arrays.drl");
        PackageDescr pkg = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((String)"foo", (String)pkg.getName());
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        this.assertEqualsIgnoreWhitespace("yourFunction(new String[3] {\"a\",\"b\",\"c\"});", (String)rule.getConsequence());
        FunctionDescr func = (FunctionDescr)pkg.getFunctions().get(0);
        RuleParserTest.assertEquals((String)"String[]", (String)func.getReturnType());
        RuleParserTest.assertEquals((String)"args[]", (String)((String)func.getParameterNames().get(0)));
        RuleParserTest.assertEquals((String)"String", (String)((String)func.getParameterTypes().get(0)));
    }

    public void testAlmostEmptyRule() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule", "almost_empty_rule.drl");
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"almost_empty", (String)rule.getName());
        RuleParserTest.assertNotNull((Object)rule.getLhs());
        RuleParserTest.assertEquals((String)"", (String)((String)rule.getConsequence()).trim());
    }

    public void testQuotedStringNameRule() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule", "quoted_string_name_rule.drl");
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"quoted string name", (String)rule.getName());
        RuleParserTest.assertNotNull((Object)rule.getLhs());
        RuleParserTest.assertEquals((String)"", (String)((String)rule.getConsequence()).trim());
    }

    public void testNoLoop() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule", "no-loop.drl");
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"rule1", (String)rule.getName());
        AttributeDescr att = (AttributeDescr)rule.getAttributes().get(0);
        RuleParserTest.assertEquals((String)"false", (String)att.getValue());
        RuleParserTest.assertEquals((String)"no-loop", (String)att.getName());
    }

    public void testAutofocus() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule", "autofocus.drl");
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"rule1", (String)rule.getName());
        AttributeDescr att = (AttributeDescr)rule.getAttributes().get(0);
        RuleParserTest.assertEquals((String)"true", (String)att.getValue());
        RuleParserTest.assertEquals((String)"auto-focus", (String)att.getName());
    }

    public void testRuleFlowGroup() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule", "ruleflowgroup.drl");
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"rule1", (String)rule.getName());
        AttributeDescr att = (AttributeDescr)rule.getAttributes().get(0);
        RuleParserTest.assertEquals((String)"a group", (String)att.getValue());
        RuleParserTest.assertEquals((String)"ruleflow-group", (String)att.getName());
    }

    public void testConsequenceWithDeclaration() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule", "declaration-in-consequence.drl");
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"myrule", (String)rule.getName());
        String expected = "int i = 0; i = 1; i / 1; i == 1; i(i); i = 'i'; i.i.i; i\\i; i<i; i>i; i=\"i\";  ++i;i++; --i; i--; i += i; i -= i; i *= i; i /= i;int i = 5;for(int j; j<i; ++j) {System.out.println(j);}Object o = new String(\"Hello\");String s = (String) o;";
        this.assertEqualsIgnoreWhitespace("int i = 0; i = 1; i / 1; i == 1; i(i); i = 'i'; i.i.i; i\\i; i<i; i>i; i=\"i\";  ++i;i++; --i; i--; i += i; i -= i; i *= i; i /= i;int i = 5;for(int j; j<i; ++j) {System.out.println(j);}Object o = new String(\"Hello\");String s = (String) o;", (String)rule.getConsequence());
        RuleParserTest.assertTrue((((String)rule.getConsequence()).indexOf("++") > 0 ? 1 : 0) != 0);
        RuleParserTest.assertTrue((((String)rule.getConsequence()).indexOf("--") > 0 ? 1 : 0) != 0);
        RuleParserTest.assertTrue((((String)rule.getConsequence()).indexOf("+=") > 0 ? 1 : 0) != 0);
        RuleParserTest.assertTrue((((String)rule.getConsequence()).indexOf("==") > 0 ? 1 : 0) != 0);
    }

    public void testRuleParseLhs() throws Exception {
        String text = "Person(age < 42, location==\"atlanta\") \nor\nPerson(name==\"bob\") \n";
        PatternDescr pattern = (PatternDescr)this.parse("lhs_pattern", "lhs_pattern", "Person(age < 42, location==\"atlanta\") \nor\nPerson(name==\"bob\") \n");
        RuleParserTest.assertNotNull((Object)pattern);
    }

    public void testRuleParseLhsWithStringQuotes() throws Exception {
        String text = "Person( location==\"atlanta\\\"\")\n";
        PatternDescr pattern = (PatternDescr)this.parse("lhs_pattern", "lhs_pattern", "Person( location==\"atlanta\\\"\")\n");
        RuleParserTest.assertNotNull((Object)pattern);
        FieldConstraintDescr field = (FieldConstraintDescr)pattern.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"location", (String)field.getFieldName());
        System.out.println(((RestrictionDescr)field.getRestriction().getRestrictions().get(0)).getText());
        RuleParserTest.assertEquals((String)"atlanta\\\"", (String)((RestrictionDescr)field.getRestriction().getRestrictions().get(0)).getText());
    }

    public void testLiteralBoolAndNegativeNumbersRule() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule", "literal_bool_and_negative.drl");
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        RuleParserTest.assertNotNull((Object)rule.getLhs());
        this.assertEqualsIgnoreWhitespace("cons();", (String)rule.getConsequence());
        AndDescr lhs = rule.getLhs();
        RuleParserTest.assertEquals((int)3, (int)lhs.getDescrs().size());
        PatternDescr pattern = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((int)1, (int)pattern.getConstraint().getDescrs().size());
        AndDescr fieldAnd = (AndDescr)pattern.getConstraint();
        FieldConstraintDescr fld = (FieldConstraintDescr)fieldAnd.getDescrs().get(0);
        LiteralRestrictionDescr lit = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"==", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"false", (String)lit.getText());
        RuleParserTest.assertEquals((String)"bar", (String)fld.getFieldName());
        pattern = (PatternDescr)lhs.getDescrs().get(1);
        RuleParserTest.assertEquals((int)1, (int)pattern.getConstraint().getDescrs().size());
        fieldAnd = (AndDescr)pattern.getConstraint();
        fld = (FieldConstraintDescr)fieldAnd.getDescrs().get(0);
        lit = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)">", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"-42", (String)lit.getText());
        RuleParserTest.assertEquals((String)"boo", (String)fld.getFieldName());
        pattern = (PatternDescr)lhs.getDescrs().get(2);
        RuleParserTest.assertEquals((int)1, (int)pattern.getConstraint().getDescrs().size());
        fieldAnd = (AndDescr)pattern.getConstraint();
        fld = (FieldConstraintDescr)fieldAnd.getDescrs().get(0);
        lit = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)">", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"-42.42", (String)lit.getText());
        RuleParserTest.assertEquals((String)"boo", (String)fld.getFieldName());
    }

    public void testChunkWithoutParens() throws Exception {
        String input = "( foo )";
        ReturnValueRestrictionDescr returnData = (ReturnValueRestrictionDescr)this.parse("paren_chunk", "fact_expression", input);
        RuleParserTest.assertEquals((String)"( foo )", (String)input.substring(returnData.getStartCharacter(), returnData.getEndCharacter()));
    }

    public void testChunkWithParens() throws Exception {
        String input = "(fnord())";
        ReturnValueRestrictionDescr returnData = (ReturnValueRestrictionDescr)this.parse("paren_chunk", "fact_expression", input);
        RuleParserTest.assertEquals((String)"(fnord())", (String)input.substring(returnData.getStartCharacter(), returnData.getEndCharacter()));
    }

    public void testChunkWithParensAndQuotedString() throws Exception {
        String input = "( fnord( \"cheese\" ) )";
        ReturnValueRestrictionDescr returnData = (ReturnValueRestrictionDescr)this.parse("paren_chunk", "fact_expression", input);
        RuleParserTest.assertEquals((String)"( fnord( \"cheese\" ) )", (String)input.substring(returnData.getStartCharacter(), returnData.getEndCharacter()));
    }

    public void testChunkWithRandomCharac5ters() throws Exception {
        String input = "( %*9dkj)";
        ReturnValueRestrictionDescr returnData = (ReturnValueRestrictionDescr)this.parse("paren_chunk", "fact_expression", input);
        RuleParserTest.assertEquals((String)"( %*9dkj)", (String)input.substring(returnData.getStartCharacter(), returnData.getEndCharacter()));
    }

    public void testEmptyPattern() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "test_EmptyPattern.drl");
        PackageDescr packageDescr = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)packageDescr.getRules().size());
        RuleDescr ruleDescr = (RuleDescr)packageDescr.getRules().get(0);
        RuleParserTest.assertEquals((String)"simple rule", (String)ruleDescr.getName());
        RuleParserTest.assertNotNull((Object)ruleDescr.getLhs());
        RuleParserTest.assertEquals((int)1, (int)ruleDescr.getLhs().getDescrs().size());
        PatternDescr patternDescr = (PatternDescr)ruleDescr.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)0, (int)patternDescr.getConstraint().getDescrs().size());
        RuleParserTest.assertEquals((String)"Cheese", (String)patternDescr.getObjectType());
    }

    public void testSimpleMethodCallWithFrom() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule", "test_SimpleMethodCallWithFrom.drl");
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)pattern.getSource();
        AccessorDescr method = (AccessorDescr)from.getDataSource();
        RuleParserTest.assertEquals((String)"something.doIt( foo,bar,42,\"hello\",{ a => \"b\", \"something\" => 42, \"a\" => foo, x => {x=>y}},\"end\", [a, \"b\", 42] )", (String)method.toString());
    }

    public void testSimpleFunctionCallWithFrom() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule", "test_SimpleFunctionCallWithFrom.drl");
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)pattern.getSource();
        AccessorDescr func = (AccessorDescr)from.getDataSource();
        RuleParserTest.assertEquals((String)"doIt( foo,bar,42,\"hello\",{ a => \"b\", \"something\" => 42, \"a\" => foo, x => {x=>y}},\"end\", [a, \"b\", 42] )", (String)func.toString());
    }

    public void testSimpleAccessorWithFrom() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule", "test_SimpleAccessorWithFrom.drl");
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)pattern.getSource();
        AccessorDescr accessor = (AccessorDescr)from.getDataSource();
        RuleParserTest.assertNull((Object)((FieldAccessDescr)accessor.getInvokers().get(0)).getArgument());
        RuleParserTest.assertEquals((String)"something.doIt", (String)accessor.toString());
    }

    public void testSimpleAccessorAndArgWithFrom() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule", "test_SimpleAccessorArgWithFrom.drl");
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)pattern.getSource();
        AccessorDescr accessor = (AccessorDescr)from.getDataSource();
        RuleParserTest.assertNotNull((Object)((FieldAccessDescr)accessor.getInvokers().get(0)).getArgument());
        RuleParserTest.assertEquals((String)"something.doIt[\"key\"]", (String)accessor.toString());
    }

    public void testComplexChainedAcessor() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule", "test_ComplexChainedCallWithFrom.drl");
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)pattern.getSource();
        AccessorDescr accessor = (AccessorDescr)from.getDataSource();
        RuleParserTest.assertEquals((String)"doIt1( foo,bar,42,\"hello\",{ a => \"b\"}, [a, \"b\", 42] ).doIt2(bar, [a, \"b\", 42]).field[\"key\"]", (String)accessor.toString());
    }

    public void testSimpleRule() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule", "simple_rule.drl");
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        RuleParserTest.assertEquals((int)7, (int)rule.getConsequenceLine());
        RuleParserTest.assertEquals((int)2, (int)rule.getConsequencePattern());
        AndDescr lhs = rule.getLhs();
        RuleParserTest.assertNotNull((Object)lhs);
        RuleParserTest.assertEquals((int)3, (int)lhs.getDescrs().size());
        PatternDescr first = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"foo3", (String)first.getIdentifier());
        RuleParserTest.assertEquals((String)"Bar", (String)first.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)first.getConstraint().getDescrs().size());
        AndDescr fieldAnd = (AndDescr)first.getConstraint();
        FieldConstraintDescr fld = (FieldConstraintDescr)fieldAnd.getDescrs().get(0);
        LiteralRestrictionDescr constraint = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertNotNull((Object)constraint);
        RuleParserTest.assertEquals((String)"a", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)constraint.getEvaluator());
        RuleParserTest.assertEquals((String)"3", (String)constraint.getText());
        PatternDescr second = (PatternDescr)lhs.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"foo4", (String)second.getIdentifier());
        RuleParserTest.assertEquals((String)"Bar", (String)second.getObjectType());
        fieldAnd = (AndDescr)second.getConstraint();
        RuleParserTest.assertEquals((int)2, (int)fieldAnd.getDescrs().size());
        FieldBindingDescr fieldBindingDescr = (FieldBindingDescr)fieldAnd.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"a", (String)fieldBindingDescr.getFieldName());
        RuleParserTest.assertEquals((String)"a4", (String)fieldBindingDescr.getIdentifier());
        fld = (FieldConstraintDescr)fieldAnd.getDescrs().get(1);
        constraint = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertNotNull((Object)constraint);
        RuleParserTest.assertEquals((String)"a", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)constraint.getEvaluator());
        RuleParserTest.assertEquals((String)"4", (String)constraint.getText());
        PatternDescr third = (PatternDescr)lhs.getDescrs().get(2);
        RuleParserTest.assertNull((Object)third.getIdentifier());
        RuleParserTest.assertEquals((String)"Baz", (String)third.getObjectType());
        this.assertEqualsIgnoreWhitespace("if ( a == b ) {   assert( foo3 );} else {  retract( foo4 );}  System.out.println( a4 );", (String)rule.getConsequence());
    }

    public void testRestrictionsMultiple() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule", "restrictions_test.drl");
        RuleParserTest.assertNotNull((Object)rule);
        this.assertEqualsIgnoreWhitespace("consequence();", (String)rule.getConsequence());
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        RuleParserTest.assertEquals((int)2, (int)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)pattern.getConstraint().getDescrs().size());
        AndDescr and = (AndDescr)pattern.getConstraint();
        FieldConstraintDescr fld = (FieldConstraintDescr)and.getDescrs().get(0);
        RuleParserTest.assertEquals((Object)RestrictionConnectiveDescr.AND, (Object)fld.getRestriction().getConnective());
        RuleParserTest.assertEquals((int)2, (int)fld.getRestrictions().size());
        RuleParserTest.assertEquals((String)"age", (String)fld.getFieldName());
        LiteralRestrictionDescr lit = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)">", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"30", (String)lit.getText());
        lit = (LiteralRestrictionDescr)fld.getRestrictions().get(1);
        RuleParserTest.assertEquals((String)"<", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"40", (String)lit.getText());
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Vehicle", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((int)2, (int)pattern.getConstraint().getDescrs().size());
        and = (AndDescr)pattern.getConstraint();
        fld = (FieldConstraintDescr)and.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"type", (String)fld.getFieldName());
        RuleParserTest.assertEquals((int)1, (int)fld.getRestrictions().size());
        RestrictionConnectiveDescr or = (RestrictionConnectiveDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((Object)RestrictionConnectiveDescr.OR, (Object)or.getConnective());
        RuleParserTest.assertEquals((int)2, (int)or.getRestrictions().size());
        lit = (LiteralRestrictionDescr)or.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"==", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"sedan", (String)lit.getText());
        lit = (LiteralRestrictionDescr)or.getRestrictions().get(1);
        RuleParserTest.assertEquals((String)"==", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"wagon", (String)lit.getText());
        fld = (FieldConstraintDescr)and.getDescrs().get(1);
        RuleParserTest.assertEquals((int)1, (int)fld.getRestrictions().size());
        lit = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"<", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"3", (String)lit.getText());
    }

    public void testLineNumberInAST() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule", "simple_rule.drl");
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        RuleParserTest.assertEquals((int)7, (int)rule.getConsequenceLine());
        RuleParserTest.assertEquals((int)2, (int)rule.getConsequencePattern());
        AndDescr lhs = rule.getLhs();
        RuleParserTest.assertNotNull((Object)lhs);
        RuleParserTest.assertEquals((int)3, (int)lhs.getDescrs().size());
        PatternDescr first = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"foo3", (String)first.getIdentifier());
        RuleParserTest.assertEquals((String)"Bar", (String)first.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)first.getConstraint().getDescrs().size());
        PatternDescr second = (PatternDescr)lhs.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"foo4", (String)second.getIdentifier());
        RuleParserTest.assertEquals((String)"Bar", (String)second.getObjectType());
        PatternDescr third = (PatternDescr)lhs.getDescrs().get(2);
        RuleParserTest.assertEquals((String)"Baz", (String)third.getObjectType());
        RuleParserTest.assertEquals((int)4, (int)first.getLine());
        RuleParserTest.assertEquals((int)5, (int)second.getLine());
        RuleParserTest.assertEquals((int)6, (int)third.getLine());
    }

    public void testLineNumberIncludingCommentsInRHS() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "test_CommentLineNumbersInConsequence.drl");
        String rhs = (String)((RuleDescr)this.walker.getPackageDescr().getRules().get(0)).getConsequence();
        String expected = "  \t//woot\n  \tfirst\n  \t\n  \t//\n  \t\n  \t/* lala\n  \t\n  \t*/\n  \tsecond  \n";
        RuleParserTest.assertEquals((String)expected, (String)rhs);
    }

    public void testLhsSemicolonDelim() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule", "lhs_semicolon_delim.drl");
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        AndDescr lhs = rule.getLhs();
        RuleParserTest.assertNotNull((Object)lhs);
        RuleParserTest.assertEquals((int)3, (int)lhs.getDescrs().size());
        PatternDescr first = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"foo3", (String)first.getIdentifier());
        RuleParserTest.assertEquals((String)"Bar", (String)first.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)first.getConstraint().getDescrs().size());
        AndDescr and = (AndDescr)first.getConstraint();
        FieldConstraintDescr fld = (FieldConstraintDescr)and.getDescrs().get(0);
        LiteralRestrictionDescr constraint = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertNotNull((Object)constraint);
        RuleParserTest.assertEquals((String)"a", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)constraint.getEvaluator());
        RuleParserTest.assertEquals((String)"3", (String)constraint.getText());
        PatternDescr second = (PatternDescr)lhs.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"foo4", (String)second.getIdentifier());
        RuleParserTest.assertEquals((String)"Bar", (String)second.getObjectType());
        and = (AndDescr)second.getConstraint();
        RuleParserTest.assertEquals((int)2, (int)and.getDescrs().size());
        FieldBindingDescr fieldBindingDescr = (FieldBindingDescr)and.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"a", (String)fieldBindingDescr.getFieldName());
        RuleParserTest.assertEquals((String)"a4", (String)fieldBindingDescr.getIdentifier());
        fld = (FieldConstraintDescr)and.getDescrs().get(1);
        constraint = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertNotNull((Object)constraint);
        RuleParserTest.assertEquals((String)"a", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)constraint.getEvaluator());
        RuleParserTest.assertEquals((String)"4", (String)constraint.getText());
        PatternDescr third = (PatternDescr)lhs.getDescrs().get(2);
        RuleParserTest.assertNull((Object)third.getIdentifier());
        RuleParserTest.assertEquals((String)"Baz", (String)third.getObjectType());
        this.assertEqualsIgnoreWhitespace("if ( a == b ) {   assert( foo3 );} else {  retract( foo4 );}  System.out.println( a4 );", (String)rule.getConsequence());
    }

    public void testNotNode() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule", "rule_not.drl");
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        AndDescr lhs = rule.getLhs();
        RuleParserTest.assertEquals((int)1, (int)lhs.getDescrs().size());
        NotDescr not = (NotDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((int)1, (int)not.getDescrs().size());
        PatternDescr pattern = (PatternDescr)not.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)pattern.getConstraint().getDescrs().size());
        AndDescr and = (AndDescr)pattern.getConstraint();
        FieldConstraintDescr fld = (FieldConstraintDescr)and.getDescrs().get(0);
        LiteralRestrictionDescr lit = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"==", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"stilton", (String)lit.getText());
        RuleParserTest.assertEquals((String)"type", (String)fld.getFieldName());
    }

    public void testFunctionImport() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "test_FunctionImport.drl");
        PackageDescr pkg = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((int)2, (int)pkg.getFunctionImports().size());
        RuleParserTest.assertEquals((String)"abd.def.x", (String)((FunctionImportDescr)pkg.getFunctionImports().get(0)).getTarget());
        RuleParserTest.assertFalse((((FunctionImportDescr)pkg.getFunctionImports().get(0)).getStartCharacter() == -1 ? 1 : 0) != 0);
        RuleParserTest.assertFalse((((FunctionImportDescr)pkg.getFunctionImports().get(0)).getEndCharacter() == -1 ? 1 : 0) != 0);
        RuleParserTest.assertEquals((String)"qed.wah.*", (String)((FunctionImportDescr)pkg.getFunctionImports().get(1)).getTarget());
        RuleParserTest.assertFalse((((FunctionImportDescr)pkg.getFunctionImports().get(1)).getStartCharacter() == -1 ? 1 : 0) != 0);
        RuleParserTest.assertFalse((((FunctionImportDescr)pkg.getFunctionImports().get(1)).getEndCharacter() == -1 ? 1 : 0) != 0);
    }

    public void testNotExistWithBrackets() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "not_exist_with_brackets.drl");
        PackageDescr pkg = this.walker.getPackageDescr();
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        AndDescr lhs = rule.getLhs();
        RuleParserTest.assertEquals((int)2, (int)lhs.getDescrs().size());
        NotDescr not = (NotDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((int)1, (int)not.getDescrs().size());
        PatternDescr pattern = (PatternDescr)not.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)pattern.getObjectType());
        ExistsDescr ex = (ExistsDescr)lhs.getDescrs().get(1);
        RuleParserTest.assertEquals((int)1, (int)ex.getDescrs().size());
        PatternDescr exPattern = (PatternDescr)ex.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Foo", (String)exPattern.getObjectType());
    }

    public void testSimpleQuery() throws Exception {
        QueryDescr query = (QueryDescr)this.parseResource("query", "query", "simple_query.drl");
        RuleParserTest.assertNotNull((Object)query);
        RuleParserTest.assertEquals((String)"simple_query", (String)query.getName());
        AndDescr lhs = query.getLhs();
        RuleParserTest.assertNotNull((Object)lhs);
        RuleParserTest.assertEquals((int)3, (int)lhs.getDescrs().size());
        PatternDescr first = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"foo3", (String)first.getIdentifier());
        RuleParserTest.assertEquals((String)"Bar", (String)first.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)first.getConstraint().getDescrs().size());
        AndDescr and = (AndDescr)first.getConstraint();
        FieldConstraintDescr fld = (FieldConstraintDescr)and.getDescrs().get(0);
        LiteralRestrictionDescr constraint = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertNotNull((Object)constraint);
        RuleParserTest.assertEquals((String)"a", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)constraint.getEvaluator());
        RuleParserTest.assertEquals((String)"3", (String)constraint.getText());
        PatternDescr second = (PatternDescr)lhs.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"foo4", (String)second.getIdentifier());
        RuleParserTest.assertEquals((String)"Bar", (String)second.getObjectType());
        and = (AndDescr)second.getConstraint();
        RuleParserTest.assertEquals((int)2, (int)and.getDescrs().size());
        FieldBindingDescr fieldBindingDescr = (FieldBindingDescr)and.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"a", (String)fieldBindingDescr.getFieldName());
        RuleParserTest.assertEquals((String)"a4", (String)fieldBindingDescr.getIdentifier());
        fld = (FieldConstraintDescr)and.getDescrs().get(1);
        constraint = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertNotNull((Object)constraint);
        RuleParserTest.assertEquals((String)"a", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)constraint.getEvaluator());
        RuleParserTest.assertEquals((String)"4", (String)constraint.getText());
    }

    public void testQueryRuleMixed() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "query_and_rule.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((int)4, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((String)"bar", (String)rule.getName());
        QueryDescr query = (QueryDescr)pack.getRules().get(1);
        RuleParserTest.assertEquals((String)"simple_query", (String)query.getName());
        rule = (RuleDescr)pack.getRules().get(2);
        RuleParserTest.assertEquals((String)"bar2", (String)rule.getName());
        query = (QueryDescr)pack.getRules().get(3);
        RuleParserTest.assertEquals((String)"simple_query2", (String)query.getName());
    }

    public void testMultipleRules() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "multiple_rules.drl");
        PackageDescr pkg = this.walker.getPackageDescr();
        List rules = pkg.getRules();
        RuleParserTest.assertEquals((int)2, (int)rules.size());
        RuleDescr rule0 = (RuleDescr)rules.get(0);
        RuleParserTest.assertEquals((String)"Like Stilton", (String)rule0.getName());
        RuleDescr rule1 = (RuleDescr)rules.get(1);
        RuleParserTest.assertEquals((String)"Like Cheddar", (String)rule1.getName());
        AndDescr lhs = rule1.getLhs();
        RuleParserTest.assertNotNull((Object)lhs);
        RuleParserTest.assertEquals((int)1, (int)lhs.getDescrs().size());
        this.assertEqualsIgnoreWhitespace("System.out.println(\"I like \" + t);", (String)rule0.getConsequence());
        PatternDescr first = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)first.getObjectType());
        lhs = rule1.getLhs();
        RuleParserTest.assertNotNull((Object)lhs);
        RuleParserTest.assertEquals((int)1, (int)lhs.getDescrs().size());
        this.assertEqualsIgnoreWhitespace("System.out.println(\"I like \" + t);", (String)rule1.getConsequence());
        first = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)first.getObjectType());
    }

    public void testExpanderLineSpread() throws Exception {
        DrlParser parser = new DrlParser();
        PackageDescr pkg = parser.parse(this.getReader("expander_spread_lines.dslr"), this.getReader("complex.dsl"));
        RuleParserTest.assertFalse((String)parser.getErrors().toString(), (boolean)parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        RuleParserTest.assertNotNull((Object)((String)rule.getConsequence()));
    }

    public void testExpanderMultipleConstraints() throws Exception {
        DrlParser parser = new DrlParser();
        PackageDescr pkg = parser.parse(this.getReader("expander_multiple_constraints.dslr"), this.getReader("multiple_constraints.dsl"));
        RuleParserTest.assertFalse((String)parser.getErrors().toString(), (boolean)parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)2, (int)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((int)2, (int)pattern.getConstraint().getDescrs().size());
        RuleParserTest.assertEquals((String)"age", (String)((FieldConstraintDescr)pattern.getConstraint().getDescrs().get(0)).getFieldName());
        RuleParserTest.assertEquals((String)"location", (String)((FieldConstraintDescr)pattern.getConstraint().getDescrs().get(1)).getFieldName());
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Bar", (String)pattern.getObjectType());
        RuleParserTest.assertNotNull((Object)((String)rule.getConsequence()));
    }

    public void testExpanderMultipleConstraintsFlush() throws Exception {
        DrlParser parser = new DrlParser();
        PackageDescr pkg = parser.parse(this.getReader("expander_multiple_constraints_flush.dslr"), this.getReader("multiple_constraints.dsl"));
        RuleParserTest.assertFalse((String)parser.getErrors().toString(), (boolean)parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((int)2, (int)pattern.getConstraint().getDescrs().size());
        RuleParserTest.assertEquals((String)"age", (String)((FieldConstraintDescr)pattern.getConstraint().getDescrs().get(0)).getFieldName());
        RuleParserTest.assertEquals((String)"location", (String)((FieldConstraintDescr)pattern.getConstraint().getDescrs().get(1)).getFieldName());
        RuleParserTest.assertNotNull((Object)((String)rule.getConsequence()));
    }

    public void testBasicBinding() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "basic_binding.drl");
        PackageDescr pkg = this.walker.getPackageDescr();
        RuleDescr ruleDescr = (RuleDescr)pkg.getRules().get(0);
        AndDescr lhs = ruleDescr.getLhs();
        RuleParserTest.assertEquals((int)1, (int)lhs.getDescrs().size());
        PatternDescr cheese = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((int)1, (int)cheese.getConstraint().getDescrs().size());
        RuleParserTest.assertEquals((String)"Cheese", (String)cheese.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)lhs.getDescrs().size());
        FieldBindingDescr fieldBinding = (FieldBindingDescr)cheese.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"type", (String)fieldBinding.getFieldName());
    }

    public void testBoundVariables() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "bindings.drl");
        PackageDescr pkg = this.walker.getPackageDescr();
        RuleDescr ruleDescr = (RuleDescr)pkg.getRules().get(0);
        AndDescr lhs = ruleDescr.getLhs();
        RuleParserTest.assertEquals((int)2, (int)lhs.getDescrs().size());
        PatternDescr cheese = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)cheese.getObjectType());
        RuleParserTest.assertEquals((int)2, (int)lhs.getDescrs().size());
        FieldBindingDescr fieldBinding = (FieldBindingDescr)cheese.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"type", (String)fieldBinding.getFieldName());
        FieldConstraintDescr fld = (FieldConstraintDescr)cheese.getConstraint().getDescrs().get(1);
        LiteralRestrictionDescr literalDescr = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"type", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)literalDescr.getEvaluator());
        RuleParserTest.assertEquals((String)"stilton", (String)literalDescr.getText());
        PatternDescr person = (PatternDescr)lhs.getDescrs().get(1);
        fieldBinding = (FieldBindingDescr)person.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"name", (String)fieldBinding.getFieldName());
        fld = (FieldConstraintDescr)person.getConstraint().getDescrs().get(1);
        literalDescr = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"name", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)literalDescr.getEvaluator());
        RuleParserTest.assertEquals((String)"bob", (String)literalDescr.getText());
        fld = (FieldConstraintDescr)person.getConstraint().getDescrs().get(2);
        VariableRestrictionDescr variableDescr = (VariableRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"likes", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)variableDescr.getEvaluator());
        RuleParserTest.assertEquals((String)"$type", (String)variableDescr.getIdentifier());
    }

    public void testOrNesting() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "or_nesting.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        RuleParserTest.assertNotNull((Object)pack);
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        PatternDescr first = (PatternDescr)or.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)first.getObjectType());
        AndDescr and = (AndDescr)or.getDescrs().get(1);
        RuleParserTest.assertEquals((int)2, (int)and.getDescrs().size());
        PatternDescr left = (PatternDescr)and.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)left.getObjectType());
        PatternDescr right = (PatternDescr)and.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Cheese", (String)right.getObjectType());
    }

    public void testAndOrRules() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "and_or_rule.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        RuleParserTest.assertNotNull((Object)pack);
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        AndDescr and = rule.getLhs();
        RuleParserTest.assertEquals((int)2, (int)and.getDescrs().size());
        AndDescr join = (AndDescr)and.getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)join.getDescrs().size());
        PatternDescr left = (PatternDescr)join.getDescrs().get(0);
        PatternDescr right = (PatternDescr)join.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Person", (String)left.getObjectType());
        RuleParserTest.assertEquals((String)"Cheese", (String)right.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)left.getConstraint().getDescrs().size());
        FieldConstraintDescr fld = (FieldConstraintDescr)left.getConstraint().getDescrs().get(0);
        LiteralRestrictionDescr literal = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"==", (String)literal.getEvaluator());
        RuleParserTest.assertEquals((String)"name", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"mark", (String)literal.getText());
        RuleParserTest.assertEquals((int)1, (int)right.getConstraint().getDescrs().size());
        fld = (FieldConstraintDescr)right.getConstraint().getDescrs().get(0);
        literal = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"==", (String)literal.getEvaluator());
        RuleParserTest.assertEquals((String)"type", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"stilton", (String)literal.getText());
        OrDescr or = (OrDescr)and.getDescrs().get(1);
        RuleParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        left = (PatternDescr)or.getDescrs().get(0);
        right = (PatternDescr)or.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Person", (String)left.getObjectType());
        RuleParserTest.assertEquals((String)"Cheese", (String)right.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)left.getConstraint().getDescrs().size());
        fld = (FieldConstraintDescr)left.getConstraint().getDescrs().get(0);
        literal = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"==", (String)literal.getEvaluator());
        RuleParserTest.assertEquals((String)"name", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"mark", (String)literal.getText());
        RuleParserTest.assertEquals((int)1, (int)right.getConstraint().getDescrs().size());
        fld = (FieldConstraintDescr)right.getConstraint().getDescrs().get(0);
        literal = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"==", (String)literal.getEvaluator());
        RuleParserTest.assertEquals((String)"type", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"stilton", (String)literal.getText());
        this.assertEqualsIgnoreWhitespace("System.out.println( \"Mark and Michael\" );", (String)rule.getConsequence());
    }

    public void testOrWithBinding() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "or_binding.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)2, (int)rule.getLhs().getDescrs().size());
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        PatternDescr leftPattern = (PatternDescr)or.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)leftPattern.getObjectType());
        RuleParserTest.assertEquals((String)"foo", (String)leftPattern.getIdentifier());
        PatternDescr rightPattern = (PatternDescr)or.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Person", (String)rightPattern.getObjectType());
        RuleParserTest.assertEquals((String)"foo", (String)rightPattern.getIdentifier());
        PatternDescr cheeseDescr = (PatternDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Cheese", (String)cheeseDescr.getObjectType());
        RuleParserTest.assertEquals(null, (String)cheeseDescr.getIdentifier());
        this.assertEqualsIgnoreWhitespace("System.out.println( \"Mark and Michael\" + bar );", (String)rule.getConsequence());
    }

    public void testOrBindingComplex() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "or_binding_complex.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        PatternDescr firstFact = (PatternDescr)or.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)firstFact.getObjectType());
        RuleParserTest.assertEquals((String)"foo", (String)firstFact.getIdentifier());
        PatternDescr secondFact = (PatternDescr)or.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Person", (String)secondFact.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)secondFact.getConstraint().getDescrs().size());
        RuleParserTest.assertEquals((String)"foo", (String)secondFact.getIdentifier());
        this.assertEqualsIgnoreWhitespace("System.out.println( \"Mark and Michael\" + bar );", (String)rule.getConsequence());
    }

    public void testOrBindingWithBrackets() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "or_binding_with_brackets.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        PatternDescr firstFact = (PatternDescr)or.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)firstFact.getObjectType());
        RuleParserTest.assertEquals((String)"foo", (String)firstFact.getIdentifier());
        PatternDescr secondFact = (PatternDescr)or.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)secondFact.getObjectType());
        RuleParserTest.assertEquals((String)"foo", (String)secondFact.getIdentifier());
        this.assertEqualsIgnoreWhitespace("System.out.println( \"Mark and Michael\" + bar );", (String)rule.getConsequence());
    }

    public void testBracketsPrecedence() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "brackets_precedence.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        AndDescr rootAnd = (AndDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)rootAnd.getDescrs().size());
        OrDescr leftOr = (OrDescr)rootAnd.getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)leftOr.getDescrs().size());
        NotDescr not = (NotDescr)leftOr.getDescrs().get(0);
        PatternDescr foo1 = (PatternDescr)not.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Foo", (String)foo1.getObjectType());
        PatternDescr foo2 = (PatternDescr)leftOr.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Foo", (String)foo2.getObjectType());
        OrDescr rightOr = (OrDescr)rootAnd.getDescrs().get(1);
        RuleParserTest.assertEquals((int)2, (int)rightOr.getDescrs().size());
        PatternDescr shoes = (PatternDescr)rightOr.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Shoes", (String)shoes.getObjectType());
        PatternDescr butt = (PatternDescr)rightOr.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Butt", (String)butt.getObjectType());
    }

    public void testEvalMultiple() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "eval_multiple.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)4, (int)rule.getLhs().getDescrs().size());
        EvalDescr eval = (EvalDescr)rule.getLhs().getDescrs().get(0);
        this.assertEqualsIgnoreWhitespace("abc(\"foo\") + 5", (String)eval.getContent());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Foo", (String)pattern.getObjectType());
    }

    public void testWithEval() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "with_eval.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)3, (int)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Foo", (String)pattern.getObjectType());
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Bar", (String)pattern.getObjectType());
        EvalDescr eval = (EvalDescr)rule.getLhs().getDescrs().get(2);
        this.assertEqualsIgnoreWhitespace("abc(\"foo\")", (String)eval.getContent());
        this.assertEqualsIgnoreWhitespace("Kapow", (String)rule.getConsequence());
    }

    public void testWithRetval() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "with_retval.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr col = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)1, (int)col.getConstraint().getDescrs().size());
        RuleParserTest.assertEquals((String)"Foo", (String)col.getObjectType());
        FieldConstraintDescr fld = (FieldConstraintDescr)col.getConstraint().getDescrs().get(0);
        ReturnValueRestrictionDescr retval = (ReturnValueRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((Object)"a + b", (Object)retval.getContent());
        RuleParserTest.assertEquals((String)"name", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)retval.getEvaluator());
    }

    public void testWithPredicate() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "with_predicate.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr col = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AndDescr and = (AndDescr)col.getConstraint();
        RuleParserTest.assertEquals((int)2, (int)and.getDescrs().size());
        FieldBindingDescr field = (FieldBindingDescr)and.getDescrs().get(0);
        PredicateDescr pred = (PredicateDescr)and.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"age", (String)field.getFieldName());
        RuleParserTest.assertEquals((String)"$age2", (String)field.getIdentifier());
        this.assertEqualsIgnoreWhitespace("$age2 == $age1+2", (String)pred.getContent());
    }

    public void testNotWithConstraint() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "not_with_constraint.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)2, (int)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        FieldBindingDescr fieldBinding = (FieldBindingDescr)pattern.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"$likes", (String)fieldBinding.getIdentifier());
        NotDescr not = (NotDescr)rule.getLhs().getDescrs().get(1);
        pattern = (PatternDescr)not.getDescrs().get(0);
        FieldConstraintDescr fld = (FieldConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        VariableRestrictionDescr boundVariable = (VariableRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"type", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)boundVariable.getEvaluator());
        RuleParserTest.assertEquals((String)"$likes", (String)boundVariable.getIdentifier());
    }

    public void testGlobal() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "globals.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        RuleParserTest.assertEquals((int)1, (int)pack.getImports().size());
        RuleParserTest.assertEquals((int)2, (int)pack.getGlobals().size());
        GlobalDescr foo = (GlobalDescr)pack.getGlobals().get(0);
        RuleParserTest.assertEquals((String)"java.lang.String", (String)foo.getType());
        RuleParserTest.assertEquals((String)"foo", (String)foo.getIdentifier());
        GlobalDescr bar = (GlobalDescr)pack.getGlobals().get(1);
        RuleParserTest.assertEquals((String)"java.lang.Integer", (String)bar.getType());
        RuleParserTest.assertEquals((String)"bar", (String)bar.getIdentifier());
    }

    public void testFunctions() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "functions.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((int)2, (int)pack.getRules().size());
        List functions = pack.getFunctions();
        RuleParserTest.assertEquals((int)2, (int)functions.size());
        FunctionDescr func = (FunctionDescr)functions.get(0);
        RuleParserTest.assertEquals((String)"functionA", (String)func.getName());
        RuleParserTest.assertEquals((String)"String", (String)func.getReturnType());
        RuleParserTest.assertEquals((int)2, (int)func.getParameterNames().size());
        RuleParserTest.assertEquals((int)2, (int)func.getParameterTypes().size());
        RuleParserTest.assertEquals((int)4, (int)func.getLine());
        RuleParserTest.assertEquals((int)0, (int)func.getColumn());
        RuleParserTest.assertEquals((String)"String", (String)((String)func.getParameterTypes().get(0)));
        RuleParserTest.assertEquals((String)"s", (String)((String)func.getParameterNames().get(0)));
        RuleParserTest.assertEquals((String)"Integer", (String)((String)func.getParameterTypes().get(1)));
        RuleParserTest.assertEquals((String)"i", (String)((String)func.getParameterNames().get(1)));
        this.assertEqualsIgnoreWhitespace("foo();", func.getText());
        func = (FunctionDescr)functions.get(1);
        RuleParserTest.assertEquals((String)"functionB", (String)func.getName());
        this.assertEqualsIgnoreWhitespace("bar();", func.getText());
    }

    public void testComment() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "comment.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        RuleParserTest.assertNotNull((Object)pack);
        RuleParserTest.assertEquals((String)"foo.bar", (String)pack.getName());
    }

    public void testAttributes() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule", "rule_attributes.drl");
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        this.assertEqualsIgnoreWhitespace("bar();", (String)rule.getConsequence());
        List attrs = rule.getAttributes();
        RuleParserTest.assertEquals((int)6, (int)attrs.size());
        AttributeDescr at = (AttributeDescr)attrs.get(0);
        RuleParserTest.assertEquals((String)"salience", (String)at.getName());
        RuleParserTest.assertEquals((String)"42", (String)at.getValue());
        at = (AttributeDescr)attrs.get(1);
        RuleParserTest.assertEquals((String)"agenda-group", (String)at.getName());
        RuleParserTest.assertEquals((String)"my_group", (String)at.getValue());
        at = (AttributeDescr)attrs.get(2);
        RuleParserTest.assertEquals((String)"no-loop", (String)at.getName());
        RuleParserTest.assertEquals((String)"true", (String)at.getValue());
        at = (AttributeDescr)attrs.get(3);
        RuleParserTest.assertEquals((String)"duration", (String)at.getName());
        RuleParserTest.assertEquals((String)"42", (String)at.getValue());
        at = (AttributeDescr)attrs.get(4);
        RuleParserTest.assertEquals((String)"activation-group", (String)at.getName());
        RuleParserTest.assertEquals((String)"my_activation_group", (String)at.getValue());
        at = (AttributeDescr)attrs.get(5);
        RuleParserTest.assertEquals((String)"lock-on-active", (String)at.getName());
        RuleParserTest.assertEquals((String)"true", (String)at.getValue());
    }

    public void testEnabledExpression() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule", "rule_enabled_expression.drl");
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        this.assertEqualsIgnoreWhitespace("bar();", (String)rule.getConsequence());
        List attrs = rule.getAttributes();
        RuleParserTest.assertEquals((int)3, (int)attrs.size());
        AttributeDescr at = (AttributeDescr)attrs.get(0);
        RuleParserTest.assertEquals((String)"enabled", (String)at.getName());
        RuleParserTest.assertEquals((String)"( 1 + 1 == 2 )", (String)at.getValue());
        at = (AttributeDescr)attrs.get(1);
        RuleParserTest.assertEquals((String)"salience", (String)at.getName());
        RuleParserTest.assertEquals((String)"( 1+2 )", (String)at.getValue());
        at = (AttributeDescr)attrs.get(2);
        RuleParserTest.assertEquals((String)"lock-on-active", (String)at.getName());
        RuleParserTest.assertEquals((String)"true", (String)at.getValue());
    }

    public void testAttributes_alternateSyntax() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule", "rule_attributes_alt.drl");
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        this.assertEqualsIgnoreWhitespace("bar();", (String)rule.getConsequence());
        List attrs = rule.getAttributes();
        RuleParserTest.assertEquals((int)6, (int)attrs.size());
        AttributeDescr at = (AttributeDescr)attrs.get(0);
        RuleParserTest.assertEquals((String)"salience", (String)at.getName());
        RuleParserTest.assertEquals((String)"42", (String)at.getValue());
        at = (AttributeDescr)attrs.get(1);
        RuleParserTest.assertEquals((String)"agenda-group", (String)at.getName());
        RuleParserTest.assertEquals((String)"my_group", (String)at.getValue());
        at = (AttributeDescr)attrs.get(2);
        RuleParserTest.assertEquals((String)"no-loop", (String)at.getName());
        RuleParserTest.assertEquals((String)"true", (String)at.getValue());
        at = (AttributeDescr)attrs.get(3);
        RuleParserTest.assertEquals((String)"lock-on-active", (String)at.getName());
        RuleParserTest.assertEquals((String)"true", (String)at.getValue());
        at = (AttributeDescr)attrs.get(4);
        RuleParserTest.assertEquals((String)"duration", (String)at.getName());
        RuleParserTest.assertEquals((String)"42", (String)at.getValue());
        at = (AttributeDescr)attrs.get(5);
        RuleParserTest.assertEquals((String)"activation-group", (String)at.getName());
        RuleParserTest.assertEquals((String)"my_activation_group", (String)at.getValue());
    }

    public void testEnumeration() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule", "enumeration.drl");
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr col = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Foo", (String)col.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)col.getConstraint().getDescrs().size());
        FieldConstraintDescr fld = (FieldConstraintDescr)col.getConstraint().getDescrs().get(0);
        QualifiedIdentifierRestrictionDescr lit = (QualifiedIdentifierRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"bar", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"Foo.BAR", (String)lit.getText());
    }

    public void testExtraLhsNewline() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "extra_lhs_newline.drl");
    }

    public void testSoundsLike() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "soundslike_operator.drl");
        RuleDescr rule = (RuleDescr)this.walker.getPackageDescr().getRules().get(0);
        PatternDescr pat = (PatternDescr)rule.getLhs().getDescrs().get(0);
        pat.getConstraint();
    }

    public void testPackageAttributes() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "package_attributes.drl");
        PackageDescr pkg = this.walker.getPackageDescr();
        AttributeDescr at = (AttributeDescr)pkg.getAttributes().get(0);
        RuleParserTest.assertEquals((String)"agenda-group", (String)at.getName());
        RuleParserTest.assertEquals((String)"x", (String)at.getValue());
        at = (AttributeDescr)pkg.getAttributes().get(1);
        RuleParserTest.assertEquals((String)"dialect", (String)at.getName());
        RuleParserTest.assertEquals((String)"java", (String)at.getValue());
        RuleParserTest.assertEquals((int)2, (int)pkg.getRules().size());
        RuleParserTest.assertEquals((int)2, (int)pkg.getImports().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((String)"bar", (String)rule.getName());
        at = (AttributeDescr)rule.getAttributes().get(0);
        RuleParserTest.assertEquals((String)"agenda-group", (String)at.getName());
        RuleParserTest.assertEquals((String)"x", (String)at.getValue());
        at = (AttributeDescr)rule.getAttributes().get(1);
        RuleParserTest.assertEquals((String)"dialect", (String)at.getName());
        RuleParserTest.assertEquals((String)"java", (String)at.getValue());
        rule = (RuleDescr)pkg.getRules().get(1);
        RuleParserTest.assertEquals((String)"baz", (String)rule.getName());
        at = (AttributeDescr)rule.getAttributes().get(0);
        RuleParserTest.assertEquals((String)"dialect", (String)at.getName());
        RuleParserTest.assertEquals((String)"mvel", (String)at.getValue());
        at = (AttributeDescr)rule.getAttributes().get(1);
        RuleParserTest.assertEquals((String)"agenda-group", (String)at.getName());
        RuleParserTest.assertEquals((String)"x", (String)at.getValue());
    }

    public void testStatementOrdering1() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "statement_ordering_1.drl");
        PackageDescr pkg = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((int)2, (int)pkg.getRules().size());
        RuleParserTest.assertEquals((String)"foo", (String)((RuleDescr)pkg.getRules().get(0)).getName());
        RuleParserTest.assertEquals((String)"bar", (String)((RuleDescr)pkg.getRules().get(1)).getName());
        RuleParserTest.assertEquals((int)2, (int)pkg.getFunctions().size());
        RuleParserTest.assertEquals((String)"cheeseIt", (String)((FunctionDescr)pkg.getFunctions().get(0)).getName());
        RuleParserTest.assertEquals((String)"uncheeseIt", (String)((FunctionDescr)pkg.getFunctions().get(1)).getName());
        RuleParserTest.assertEquals((int)4, (int)pkg.getImports().size());
        RuleParserTest.assertEquals((String)"im.one", (String)((ImportDescr)pkg.getImports().get(0)).getTarget());
        RuleParserTest.assertEquals((String)"im.two", (String)((ImportDescr)pkg.getImports().get(1)).getTarget());
        RuleParserTest.assertEquals((String)"im.three", (String)((ImportDescr)pkg.getImports().get(2)).getTarget());
        RuleParserTest.assertEquals((String)"im.four", (String)((ImportDescr)pkg.getImports().get(3)).getTarget());
    }

    public void testRuleNamesStartingWithNumbers() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "rule_names_number_prefix.drl");
        PackageDescr pkg = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((int)2, (int)pkg.getRules().size());
        RuleParserTest.assertEquals((String)"1. Do Stuff!", (String)((RuleDescr)pkg.getRules().get(0)).getName());
        RuleParserTest.assertEquals((String)"2. Do More Stuff!", (String)((RuleDescr)pkg.getRules().get(1)).getName());
    }

    public void testEvalWithNewline() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "eval_with_newline.drl");
    }

    public void testEndPosition() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "test_EndPosition.drl");
        RuleDescr rule = (RuleDescr)this.walker.getPackageDescr().getRules().get(0);
        PatternDescr col = (PatternDescr)rule.getLhs().getDescrs().get(0);
    }

    public void testQualifiedClassname() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "qualified_classname.drl");
        PackageDescr pkg = this.walker.getPackageDescr();
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        PatternDescr p = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"com.cheeseco.Cheese", (String)p.getObjectType());
    }

    public void testAccumulate() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "accumulate.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr outPattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accum = (AccumulateDescr)outPattern.getSource();
        this.assertEqualsIgnoreWhitespace("int x = 0 ;", accum.getInitCode());
        this.assertEqualsIgnoreWhitespace("x++;", accum.getActionCode());
        RuleParserTest.assertNull((Object)accum.getReverseCode());
        this.assertEqualsIgnoreWhitespace("new Integer(x)", accum.getResultCode());
        RuleParserTest.assertFalse((boolean)accum.isExternalFunction());
        PatternDescr pattern = accum.getInputPattern();
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
    }

    public void testAccumulateWithBindings() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "accumulate_with_bindings.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr outPattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accum = (AccumulateDescr)outPattern.getSource();
        this.assertEqualsIgnoreWhitespace("$counter", outPattern.getIdentifier());
        this.assertEqualsIgnoreWhitespace("int x = 0 ;", accum.getInitCode());
        this.assertEqualsIgnoreWhitespace("x++;", accum.getActionCode());
        this.assertEqualsIgnoreWhitespace("new Integer(x)", accum.getResultCode());
        PatternDescr pattern = accum.getInputPattern();
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
    }

    public void testCollect() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "collect.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr outPattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        CollectDescr collect = (CollectDescr)outPattern.getSource();
        PatternDescr pattern = collect.getInputPattern();
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
    }

    public void testPredicate() throws Exception {
        PatternDescr pattern = (PatternDescr)this.parse("lhs_pattern", "lhs_pattern", "Foo ($var : attr -> ( $var.equals(\"xyz\") ))");
        List constraints = pattern.getConstraint().getDescrs();
        RuleParserTest.assertEquals((int)2, (int)constraints.size());
        FieldBindingDescr field = (FieldBindingDescr)constraints.get(0);
        PredicateDescr predicate = (PredicateDescr)constraints.get(1);
        RuleParserTest.assertEquals((String)"$var", (String)field.getIdentifier());
        RuleParserTest.assertEquals((String)"attr", (String)field.getFieldName());
        RuleParserTest.assertEquals((Object)" $var.equals(\"xyz\") ", (Object)predicate.getContent());
    }

    public void testPredicate2() throws Exception {
        PatternDescr pattern = (PatternDescr)this.parse("lhs_pattern", "lhs_pattern", "Foo(eval( $var.equals(\"xyz\") ))");
        List constraints = pattern.getConstraint().getDescrs();
        RuleParserTest.assertEquals((int)1, (int)constraints.size());
        PredicateDescr predicate = (PredicateDescr)constraints.get(0);
        RuleParserTest.assertEquals((Object)" $var.equals(\"xyz\") ", (Object)predicate.getContent());
    }

    public void testEscapedStrings() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule", "escaped-string.drl");
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"test_Quotes", (String)rule.getName());
        String expected = "String s = \"\\\"\\n\\t\\\\\";";
        this.assertEqualsIgnoreWhitespace("String s = \"\\\"\\n\\t\\\\\";", (String)rule.getConsequence());
    }

    public void testNestedCEs() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule", "nested_conditional_elements.drl");
        RuleParserTest.assertNotNull((Object)rule);
        AndDescr root = rule.getLhs();
        NotDescr not1 = (NotDescr)root.getDescrs().get(0);
        AndDescr and1 = (AndDescr)not1.getDescrs().get(0);
        PatternDescr state = (PatternDescr)and1.getDescrs().get(0);
        NotDescr not2 = (NotDescr)and1.getDescrs().get(1);
        AndDescr and2 = (AndDescr)not2.getDescrs().get(0);
        PatternDescr person = (PatternDescr)and2.getDescrs().get(0);
        PatternDescr cheese = (PatternDescr)and2.getDescrs().get(1);
        PatternDescr person2 = (PatternDescr)root.getDescrs().get(1);
        OrDescr or = (OrDescr)root.getDescrs().get(2);
        PatternDescr cheese2 = (PatternDescr)or.getDescrs().get(0);
        PatternDescr cheese3 = (PatternDescr)or.getDescrs().get(1);
        RuleParserTest.assertEquals((String)state.getObjectType(), (String)"State");
        RuleParserTest.assertEquals((String)person.getObjectType(), (String)"Person");
        RuleParserTest.assertEquals((String)cheese.getObjectType(), (String)"Cheese");
        RuleParserTest.assertEquals((String)person2.getObjectType(), (String)"Person");
        RuleParserTest.assertEquals((String)cheese2.getObjectType(), (String)"Cheese");
        RuleParserTest.assertEquals((String)cheese3.getObjectType(), (String)"Cheese");
    }

    public void testForall() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "forall.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        ForallDescr forall = (ForallDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)forall.getDescrs().size());
        PatternDescr pattern = forall.getBasePattern();
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
        List remaining = forall.getRemainingPatterns();
        RuleParserTest.assertEquals((int)1, (int)remaining.size());
        PatternDescr cheese = (PatternDescr)remaining.get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)cheese.getObjectType());
    }

    public void testMemberof() throws Exception {
        String text = "Country( $cities : city )\nPerson( city memberOf $cities )\n";
        AndDescr descrs = (AndDescr)this.parse("normal_lhs_block", "lhs_block", "Country( $cities : city )\nPerson( city memberOf $cities )\n");
        RuleParserTest.assertEquals((int)2, (int)descrs.getDescrs().size());
        PatternDescr pat = (PatternDescr)descrs.getDescrs().get(1);
        FieldConstraintDescr fieldConstr = (FieldConstraintDescr)pat.getConstraint().getDescrs().get(0);
        VariableRestrictionDescr restr = (VariableRestrictionDescr)fieldConstr.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"memberOf", (String)restr.getEvaluator());
        RuleParserTest.assertFalse((boolean)restr.isNegated());
        RuleParserTest.assertEquals((String)"$cities", (String)restr.getIdentifier());
    }

    public void testNotMemberof() throws Exception {
        String text = "Country( $cities : city )\nPerson( city not memberOf $cities )\n";
        AndDescr descrs = (AndDescr)this.parse("normal_lhs_block", "lhs_block", "Country( $cities : city )\nPerson( city not memberOf $cities )\n");
        RuleParserTest.assertEquals((int)2, (int)descrs.getDescrs().size());
        PatternDescr pat = (PatternDescr)descrs.getDescrs().get(1);
        FieldConstraintDescr fieldConstr = (FieldConstraintDescr)pat.getConstraint().getDescrs().get(0);
        VariableRestrictionDescr restr = (VariableRestrictionDescr)fieldConstr.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"memberOf", (String)restr.getEvaluator());
        RuleParserTest.assertTrue((boolean)restr.isNegated());
        RuleParserTest.assertEquals((String)"$cities", (String)restr.getIdentifier());
    }

    public void testInOperator() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule", "in_operator_test.drl");
        RuleParserTest.assertNotNull((Object)rule);
        this.assertEqualsIgnoreWhitespace("consequence();", (String)rule.getConsequence());
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        RuleParserTest.assertEquals((int)2, (int)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)pattern.getConstraint().getDescrs().size());
        FieldConstraintDescr fld = (FieldConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((Object)RestrictionConnectiveDescr.AND, (Object)fld.getRestriction().getConnective());
        RuleParserTest.assertEquals((int)2, (int)fld.getRestrictions().size());
        RuleParserTest.assertEquals((String)"age", (String)fld.getFieldName());
        LiteralRestrictionDescr lit = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)">", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"30", (String)lit.getText());
        lit = (LiteralRestrictionDescr)fld.getRestrictions().get(1);
        RuleParserTest.assertEquals((String)"<", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"40", (String)lit.getText());
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Vehicle", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((int)2, (int)pattern.getConstraint().getDescrs().size());
        fld = (FieldConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"type", (String)fld.getFieldName());
        RuleParserTest.assertEquals((int)1, (int)fld.getRestrictions().size());
        RestrictionConnectiveDescr or = (RestrictionConnectiveDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((Object)RestrictionConnectiveDescr.OR, (Object)or.getConnective());
        RuleParserTest.assertEquals((int)2, (int)or.getRestrictions().size());
        lit = (LiteralRestrictionDescr)or.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"==", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"sedan", (String)lit.getText());
        lit = (LiteralRestrictionDescr)or.getRestrictions().get(1);
        RuleParserTest.assertEquals((String)"==", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"wagon", (String)lit.getText());
        fld = (FieldConstraintDescr)pattern.getConstraint().getDescrs().get(1);
        RuleParserTest.assertEquals((int)1, (int)fld.getRestrictions().size());
        lit = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"<", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"3", (String)lit.getText());
    }

    public void testNotInOperator() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule", "notin_operator_test.drl");
        RuleParserTest.assertNotNull((Object)rule);
        this.assertEqualsIgnoreWhitespace("consequence();", (String)rule.getConsequence());
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        RuleParserTest.assertEquals((int)2, (int)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)pattern.getConstraint().getDescrs().size());
        FieldConstraintDescr fld = (FieldConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)fld.getRestrictions().size());
        RuleParserTest.assertEquals((String)"age", (String)fld.getFieldName());
        LiteralRestrictionDescr lit = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)">", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"30", (String)lit.getText());
        lit = (LiteralRestrictionDescr)fld.getRestrictions().get(1);
        RuleParserTest.assertEquals((String)"<", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"40", (String)lit.getText());
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Vehicle", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((int)2, (int)pattern.getConstraint().getDescrs().size());
        fld = (FieldConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)fld.getRestrictions().size());
        lit = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"type", (String)fld.getFieldName());
        RuleParserTest.assertEquals((String)"!=", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"sedan", (String)lit.getText());
        lit = (LiteralRestrictionDescr)fld.getRestrictions().get(1);
        RuleParserTest.assertEquals((String)"!=", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"wagon", (String)lit.getText());
        fld = (FieldConstraintDescr)pattern.getConstraint().getDescrs().get(1);
        RuleParserTest.assertEquals((int)1, (int)fld.getRestrictions().size());
        lit = (LiteralRestrictionDescr)fld.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"<", (String)lit.getEvaluator());
        RuleParserTest.assertEquals((String)"3", (String)lit.getText());
    }

    public void testCheckOrDescr() throws Exception {
        String text = "Person( eval( age == 25 ) || ( eval( name.equals( \"bob\" ) ) && eval( age == 30 ) ) )";
        PatternDescr pattern = (PatternDescr)this.parse("lhs_pattern", "lhs_pattern", "Person( eval( age == 25 ) || ( eval( name.equals( \"bob\" ) ) && eval( age == 30 ) ) )");
        RuleParserTest.assertEquals((int)1, (int)pattern.getDescrs().size());
        RuleParserTest.assertEquals(pattern.getConstraint().getClass(), AndDescr.class);
        RuleParserTest.assertEquals(((BaseDescr)pattern.getConstraint().getDescrs().get(0)).getClass(), OrDescr.class);
        OrDescr orDescr = (OrDescr)pattern.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals(orDescr.getDescrs().get(0).getClass(), PredicateDescr.class);
    }

    public void testConstraintAndConnective() throws Exception {
        String text = "Person( age < 42 && location==\"atlanta\")";
        PatternDescr pattern = (PatternDescr)this.parse("lhs_pattern", "lhs_pattern", "Person( age < 42 && location==\"atlanta\")");
        RuleParserTest.assertEquals((int)2, (int)pattern.getDescrs().size());
        FieldConstraintDescr fcd = (FieldConstraintDescr)pattern.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age", (String)fcd.getFieldName());
        fcd = (FieldConstraintDescr)pattern.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"location", (String)fcd.getFieldName());
    }

    public void testConstraintOrConnective() throws Exception {
        String text = "Person( age < 42 || location==\"atlanta\")";
        PatternDescr pattern = (PatternDescr)this.parse("lhs_pattern", "lhs_pattern", "Person( age < 42 || location==\"atlanta\")");
        RuleParserTest.assertEquals((int)1, (int)pattern.getDescrs().size());
        OrDescr or = (OrDescr)pattern.getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        FieldConstraintDescr fcd = (FieldConstraintDescr)or.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age", (String)fcd.getFieldName());
        fcd = (FieldConstraintDescr)or.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"location", (String)fcd.getFieldName());
    }

    public void testConstraintConnectivesPrecedence() throws Exception {
        String text = "Person( age < 42 && location==\"atlanta\" || age > 20 && location==\"Seatle\" || location == \"Chicago\")";
        PatternDescr pattern = (PatternDescr)this.parse("lhs_pattern", "lhs_pattern", "Person( age < 42 && location==\"atlanta\" || age > 20 && location==\"Seatle\" || location == \"Chicago\")");
        RuleParserTest.assertEquals((int)1, (int)pattern.getDescrs().size());
        OrDescr or = (OrDescr)pattern.getDescrs().get(0);
        RuleParserTest.assertEquals((int)3, (int)or.getDescrs().size());
        AndDescr and = (AndDescr)or.getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)and.getDescrs().size());
        FieldConstraintDescr fcd = (FieldConstraintDescr)and.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"<", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"42", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        fcd = (FieldConstraintDescr)and.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"location", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"atlanta", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        and = (AndDescr)or.getDescrs().get(1);
        RuleParserTest.assertEquals((int)2, (int)and.getDescrs().size());
        fcd = (FieldConstraintDescr)and.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)">", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"20", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        fcd = (FieldConstraintDescr)and.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"location", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"Seatle", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        fcd = (FieldConstraintDescr)or.getDescrs().get(2);
        RuleParserTest.assertEquals((String)"location", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"Chicago", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
    }

    public void testConstraintConnectivesPrecedenceWithBracks() throws Exception {
        String text = "Person( age < 42 && ( location==\"atlanta\" || age > 20 && location==\"Seatle\") || location == \"Chicago\")";
        PatternDescr pattern = (PatternDescr)this.parse("lhs_pattern", "lhs_pattern", "Person( age < 42 && ( location==\"atlanta\" || age > 20 && location==\"Seatle\") || location == \"Chicago\")");
        RuleParserTest.assertEquals((int)1, (int)pattern.getDescrs().size());
        OrDescr or1 = (OrDescr)pattern.getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)or1.getDescrs().size());
        AndDescr and1 = (AndDescr)or1.getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)and1.getDescrs().size());
        FieldConstraintDescr fcd = (FieldConstraintDescr)and1.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"<", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"42", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        OrDescr or2 = (OrDescr)and1.getDescrs().get(1);
        fcd = (FieldConstraintDescr)or2.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"location", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"atlanta", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        AndDescr and2 = (AndDescr)or2.getDescrs().get(1);
        RuleParserTest.assertEquals((int)2, (int)and2.getDescrs().size());
        fcd = (FieldConstraintDescr)and2.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)">", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"20", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        fcd = (FieldConstraintDescr)and2.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"location", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"Seatle", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        fcd = (FieldConstraintDescr)or1.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"location", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"Chicago", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
    }

    public void testConstraintConnectivesPrecedenceWithBracks2() throws Exception {
        String text = "Person( ( age == 70 && hair == \"black\" ) || ( age == 40 && hair == \"pink\" ) || ( age == 12 && ( hair == \"yellow\" || hair == \"blue\" ) ) )";
        PatternDescr pattern = (PatternDescr)this.parse("lhs_pattern", "lhs_pattern", "Person( ( age == 70 && hair == \"black\" ) || ( age == 40 && hair == \"pink\" ) || ( age == 12 && ( hair == \"yellow\" || hair == \"blue\" ) ) )");
        RuleParserTest.assertEquals((int)1, (int)pattern.getDescrs().size());
        OrDescr or1 = (OrDescr)pattern.getDescrs().get(0);
        RuleParserTest.assertEquals((int)3, (int)or1.getDescrs().size());
        AndDescr and1 = (AndDescr)or1.getDescrs().get(0);
        AndDescr and2 = (AndDescr)or1.getDescrs().get(1);
        AndDescr and3 = (AndDescr)or1.getDescrs().get(2);
        RuleParserTest.assertEquals((int)2, (int)and1.getDescrs().size());
        FieldConstraintDescr fcd = (FieldConstraintDescr)and1.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"70", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        fcd = (FieldConstraintDescr)and1.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"hair", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"black", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        RuleParserTest.assertEquals((int)2, (int)and2.getDescrs().size());
        fcd = (FieldConstraintDescr)and2.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"40", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        fcd = (FieldConstraintDescr)and2.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"hair", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"pink", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        RuleParserTest.assertEquals((int)2, (int)and3.getDescrs().size());
        fcd = (FieldConstraintDescr)and3.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"12", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        OrDescr or2 = (OrDescr)and3.getDescrs().get(1);
        fcd = (FieldConstraintDescr)or2.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"hair", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"yellow", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        fcd = (FieldConstraintDescr)or2.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"hair", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"blue", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
    }

    public void testSimpleRestrictionConnective() throws Exception {
        String text = "Person( age == 12 || ( test == 222 ))";
        PatternDescr pattern = (PatternDescr)this.parse("lhs_pattern", "lhs_pattern", "Person( age == 12 || ( test == 222 ))");
        RuleParserTest.assertEquals((int)1, (int)pattern.getDescrs().size());
    }

    public void testRestrictionConnectives() throws Exception {
        String text = "Person( ( age ( > 60 && < 70 ) || ( > 50 && < 55 ) && hair == \"black\" ) || ( age == 40 && hair == \"pink\" ) || ( age == 12 && ( hair == \"yellow\" || hair == \"blue\" ) ))";
        PatternDescr pattern = (PatternDescr)this.parse("lhs_pattern", "lhs_pattern", "Person( ( age ( > 60 && < 70 ) || ( > 50 && < 55 ) && hair == \"black\" ) || ( age == 40 && hair == \"pink\" ) || ( age == 12 && ( hair == \"yellow\" || hair == \"blue\" ) ))");
        RuleParserTest.assertEquals((int)1, (int)pattern.getDescrs().size());
        OrDescr orConstr = (OrDescr)pattern.getDescrs().get(0);
        RuleParserTest.assertEquals((int)3, (int)orConstr.getDescrs().size());
        AndDescr andConstr1 = (AndDescr)orConstr.getDescrs().get(0);
        FieldConstraintDescr fcd = (FieldConstraintDescr)andConstr1.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age", (String)fcd.getFieldName());
        RestrictionConnectiveDescr or = (RestrictionConnectiveDescr)fcd.getRestriction().getRestrictions().get(0);
        RestrictionConnectiveDescr and1 = (RestrictionConnectiveDescr)or.getRestrictions().get(0);
        RestrictionConnectiveDescr and2 = (RestrictionConnectiveDescr)or.getRestrictions().get(1);
        RuleParserTest.assertEquals((String)">", (String)((LiteralRestrictionDescr)and1.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"60", (String)((LiteralRestrictionDescr)and1.getRestrictions().get(0)).getText());
        RuleParserTest.assertEquals((String)"<", (String)((LiteralRestrictionDescr)and1.getRestrictions().get(1)).getEvaluator());
        RuleParserTest.assertEquals((String)"70", (String)((LiteralRestrictionDescr)and1.getRestrictions().get(1)).getText());
        RuleParserTest.assertEquals((String)">", (String)((LiteralRestrictionDescr)and2.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"50", (String)((LiteralRestrictionDescr)and2.getRestrictions().get(0)).getText());
        RuleParserTest.assertEquals((String)"<", (String)((LiteralRestrictionDescr)and2.getRestrictions().get(1)).getEvaluator());
        RuleParserTest.assertEquals((String)"55", (String)((LiteralRestrictionDescr)and2.getRestrictions().get(1)).getText());
        fcd = (FieldConstraintDescr)andConstr1.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"hair", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"black", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        AndDescr andConstr2 = (AndDescr)orConstr.getDescrs().get(1);
        RuleParserTest.assertEquals((int)2, (int)andConstr2.getDescrs().size());
        fcd = (FieldConstraintDescr)andConstr2.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"40", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        fcd = (FieldConstraintDescr)andConstr2.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"hair", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"pink", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        AndDescr andConstr3 = (AndDescr)orConstr.getDescrs().get(2);
        RuleParserTest.assertEquals((int)2, (int)andConstr3.getDescrs().size());
        fcd = (FieldConstraintDescr)andConstr3.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"12", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        OrDescr orConstr2 = (OrDescr)andConstr3.getDescrs().get(1);
        fcd = (FieldConstraintDescr)orConstr2.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"hair", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"yellow", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
        fcd = (FieldConstraintDescr)orConstr2.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"hair", (String)fcd.getFieldName());
        RuleParserTest.assertEquals((String)"==", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"blue", (String)((LiteralRestrictionDescr)fcd.getRestrictions().get(0)).getText());
    }

    public void testConstraintConnectivesMatches() throws Exception {
        String text = "Person( name matches \"mark\" || matches \"bob\" )";
        PatternDescr pattern = (PatternDescr)this.parse("lhs_pattern", "lhs_pattern", "Person( name matches \"mark\" || matches \"bob\" )");
        RuleParserTest.assertEquals((int)1, (int)pattern.getDescrs().size());
        FieldConstraintDescr fcd = (FieldConstraintDescr)pattern.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"name", (String)fcd.getFieldName());
        RestrictionConnectiveDescr or = (RestrictionConnectiveDescr)fcd.getRestrictions().get(0);
        RuleParserTest.assertEquals((int)2, (int)or.getRestrictions().size());
        RuleParserTest.assertEquals((String)"matches", (String)((LiteralRestrictionDescr)or.getRestrictions().get(0)).getEvaluator());
        RuleParserTest.assertEquals((String)"mark", (String)((LiteralRestrictionDescr)or.getRestrictions().get(0)).getText());
        RuleParserTest.assertEquals((String)"matches", (String)((LiteralRestrictionDescr)or.getRestrictions().get(1)).getEvaluator());
        RuleParserTest.assertEquals((String)"bob", (String)((LiteralRestrictionDescr)or.getRestrictions().get(1)).getText());
    }

    public void testNotContains() throws Exception {
        String text = "City( $city : city )\nCountry( cities not contains $city )\n";
        AndDescr descrs = (AndDescr)this.parse("normal_lhs_block", "lhs_block", "City( $city : city )\nCountry( cities not contains $city )\n");
        RuleParserTest.assertEquals((int)2, (int)descrs.getDescrs().size());
        PatternDescr pat = (PatternDescr)descrs.getDescrs().get(1);
        FieldConstraintDescr fieldConstr = (FieldConstraintDescr)pat.getConstraint().getDescrs().get(0);
        VariableRestrictionDescr restr = (VariableRestrictionDescr)fieldConstr.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"contains", (String)restr.getEvaluator());
        RuleParserTest.assertTrue((boolean)restr.isNegated());
        RuleParserTest.assertEquals((String)"$city", (String)restr.getIdentifier());
    }

    public void testNotMatches() throws Exception {
        String text = "Message( text not matches '[abc]*' )\n";
        AndDescr descrs = (AndDescr)this.parse("normal_lhs_block", "lhs_block", "Message( text not matches '[abc]*' )\n");
        RuleParserTest.assertEquals((int)1, (int)descrs.getDescrs().size());
        PatternDescr pat = (PatternDescr)descrs.getDescrs().get(0);
        FieldConstraintDescr fieldConstr = (FieldConstraintDescr)pat.getConstraint().getDescrs().get(0);
        LiteralRestrictionDescr restr = (LiteralRestrictionDescr)fieldConstr.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"matches", (String)restr.getEvaluator());
        RuleParserTest.assertTrue((boolean)restr.isNegated());
        RuleParserTest.assertEquals((String)"[abc]*", (String)restr.getText());
    }

    public void testRestrictions() throws Exception {
        String text = "Foo( bar > 1 || == 1 )\n";
        AndDescr descrs = (AndDescr)this.parse("normal_lhs_block", "lhs_block", "Foo( bar > 1 || == 1 )\n");
        RuleParserTest.assertEquals((int)1, (int)descrs.getDescrs().size());
        PatternDescr pat = (PatternDescr)descrs.getDescrs().get(0);
        FieldConstraintDescr fieldConstr = (FieldConstraintDescr)pat.getConstraint().getDescrs().get(0);
        RestrictionConnectiveDescr or = (RestrictionConnectiveDescr)fieldConstr.getRestrictions().get(0);
        LiteralRestrictionDescr gt1 = (LiteralRestrictionDescr)or.getRestrictions().get(0);
        LiteralRestrictionDescr eq1 = (LiteralRestrictionDescr)or.getRestrictions().get(1);
        RuleParserTest.assertEquals((String)">", (String)gt1.getEvaluator());
        RuleParserTest.assertEquals((boolean)false, (boolean)gt1.isNegated());
        RuleParserTest.assertEquals((int)1, (int)((Number)eq1.getValue()).intValue());
        RuleParserTest.assertEquals((String)"==", (String)eq1.getEvaluator());
        RuleParserTest.assertEquals((boolean)false, (boolean)eq1.isNegated());
        RuleParserTest.assertEquals((int)1, (int)((Number)eq1.getValue()).intValue());
    }

    public void testSemicolon() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "semicolon.drl");
        PackageDescr pkg = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((String)"org.drools", (String)pkg.getName());
        RuleParserTest.assertEquals((int)1, (int)pkg.getGlobals().size());
        RuleParserTest.assertEquals((int)3, (int)pkg.getRules().size());
        RuleDescr rule1 = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)2, (int)rule1.getLhs().getDescrs().size());
        RuleDescr query1 = (RuleDescr)pkg.getRules().get(1);
        RuleParserTest.assertEquals((int)3, (int)query1.getLhs().getDescrs().size());
        RuleDescr rule2 = (RuleDescr)pkg.getRules().get(2);
        RuleParserTest.assertEquals((int)2, (int)rule2.getLhs().getDescrs().size());
    }

    public void testEval() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "eval_parsing.drl");
        PackageDescr pkg = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((String)"org.drools", (String)pkg.getName());
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule1 = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule1.getLhs().getDescrs().size());
    }

    public void testAccumulateReverse() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "accumulateReverse.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accum = (AccumulateDescr)out.getSource();
        this.assertEqualsIgnoreWhitespace("int x = 0 ;", accum.getInitCode());
        this.assertEqualsIgnoreWhitespace("x++;", accum.getActionCode());
        this.assertEqualsIgnoreWhitespace("x--;", accum.getReverseCode());
        this.assertEqualsIgnoreWhitespace("new Integer(x)", accum.getResultCode());
        RuleParserTest.assertFalse((boolean)accum.isExternalFunction());
        PatternDescr pattern = accum.getInputPattern();
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
    }

    public void testAccumulateExternalFunction() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "accumulateExternalFunction.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accum = (AccumulateDescr)out.getSource();
        this.assertEqualsIgnoreWhitespace("$age", accum.getExpression());
        this.assertEqualsIgnoreWhitespace("average", accum.getFunctionIdentifier());
        RuleParserTest.assertTrue((boolean)accum.isExternalFunction());
        PatternDescr pattern = accum.getInputPattern();
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
    }

    public void testCollectWithNestedFrom() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "collect_with_nested_from.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        CollectDescr collect = (CollectDescr)out.getSource();
        PatternDescr person = collect.getInputPattern();
        RuleParserTest.assertEquals((String)"Person", (String)person.getObjectType());
        CollectDescr collect2 = (CollectDescr)person.getSource();
        PatternDescr people = collect2.getInputPattern();
        RuleParserTest.assertEquals((String)"People", (String)people.getObjectType());
    }

    public void testAccumulateWithNestedFrom() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "accumulate_with_nested_from.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accumulate = (AccumulateDescr)out.getSource();
        PatternDescr person = accumulate.getInputPattern();
        RuleParserTest.assertEquals((String)"Person", (String)person.getObjectType());
        CollectDescr collect2 = (CollectDescr)person.getSource();
        PatternDescr people = collect2.getInputPattern();
        RuleParserTest.assertEquals((String)"People", (String)people.getObjectType());
    }

    public void testAccessorPaths() throws Exception {
        String text = "org   .   drools/*comment*/\t  .Message( text not matches $c#comment\n. property )\n";
        PatternDescr pattern = (PatternDescr)this.parse("lhs_pattern", "lhs_pattern", "org   .   drools/*comment*/\t  .Message( text not matches $c#comment\n. property )\n");
        RuleParserTest.assertEquals((String)"org.drools.Message", (String)pattern.getObjectType());
        FieldConstraintDescr fieldConstr = (FieldConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        QualifiedIdentifierRestrictionDescr restr = (QualifiedIdentifierRestrictionDescr)fieldConstr.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"matches", (String)restr.getEvaluator());
        RuleParserTest.assertTrue((boolean)restr.isNegated());
        RuleParserTest.assertEquals((String)"$c.property", (String)restr.getText());
    }

    public void testOrCE() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "or_ce.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)2, (int)rule.getLhs().getDescrs().size());
        PatternDescr person = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)person.getObjectType());
        RuleParserTest.assertEquals((String)"$p", (String)person.getIdentifier());
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        PatternDescr cheese1 = (PatternDescr)or.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)cheese1.getObjectType());
        RuleParserTest.assertEquals((String)"$c", (String)cheese1.getIdentifier());
        PatternDescr cheese2 = (PatternDescr)or.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Cheese", (String)cheese2.getObjectType());
        RuleParserTest.assertNull((Object)cheese2.getIdentifier());
    }

    public void testRuleSingleLine() throws Exception {
        String text = "rule \"another test\" salience 10 when eval( true ) then System.out.println(1); end";
        RuleDescr rule = (RuleDescr)this.parse("rule", "rule", "rule \"another test\" salience 10 when eval( true ) then System.out.println(1); end");
        RuleParserTest.assertEquals((String)"another test", (String)rule.getName());
        RuleParserTest.assertEquals((Object)"System.out.println(1); ", (Object)rule.getConsequence());
    }

    public void testRuleTwoLines() throws Exception {
        String text = "rule \"another test\" salience 10 when eval( true ) then System.out.println(1);\n end";
        RuleDescr rule = (RuleDescr)this.parse("rule", "rule", "rule \"another test\" salience 10 when eval( true ) then System.out.println(1);\n end");
        RuleParserTest.assertEquals((String)"another test", (String)rule.getName());
        RuleParserTest.assertEquals((Object)"System.out.println(1);\n ", (Object)rule.getConsequence());
    }

    public void testRuleParseLhs3() throws Exception {
        String text = "(or\nnot Person()\n(and Cheese()\nMeat()\nWine()))";
        AndDescr pattern = (AndDescr)this.parse("normal_lhs_block", "lhs_block", "(or\nnot Person()\n(and Cheese()\nMeat()\nWine()))");
        RuleParserTest.assertEquals((int)1, (int)pattern.getDescrs().size());
        OrDescr or = (OrDescr)pattern.getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        NotDescr not = (NotDescr)or.getDescrs().get(0);
        AndDescr and = (AndDescr)or.getDescrs().get(1);
        RuleParserTest.assertEquals((int)1, (int)not.getDescrs().size());
        PatternDescr person = (PatternDescr)not.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)person.getObjectType());
        RuleParserTest.assertEquals((int)3, (int)and.getDescrs().size());
        PatternDescr cheese = (PatternDescr)and.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)cheese.getObjectType());
        PatternDescr meat = (PatternDescr)and.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Meat", (String)meat.getObjectType());
        PatternDescr wine = (PatternDescr)and.getDescrs().get(2);
        RuleParserTest.assertEquals((String)"Wine", (String)wine.getObjectType());
    }

    public void testAccumulateMultiPattern() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "accumulate_multi_pattern.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr outPattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accum = (AccumulateDescr)outPattern.getSource();
        this.assertEqualsIgnoreWhitespace("$counter", outPattern.getIdentifier());
        this.assertEqualsIgnoreWhitespace("int x = 0 ;", accum.getInitCode());
        this.assertEqualsIgnoreWhitespace("x++;", accum.getActionCode());
        this.assertEqualsIgnoreWhitespace("new Integer(x)", accum.getResultCode());
        AndDescr and = (AndDescr)accum.getInput();
        RuleParserTest.assertEquals((int)2, (int)and.getDescrs().size());
        PatternDescr person = (PatternDescr)and.getDescrs().get(0);
        PatternDescr cheese = (PatternDescr)and.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Person", (String)person.getObjectType());
        RuleParserTest.assertEquals((String)"Cheese", (String)cheese.getObjectType());
    }

    public void testPluggableOperators() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "pluggable_operators.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)5, (int)rule.getLhs().getDescrs().size());
        PatternDescr eventA = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"$a", (String)eventA.getIdentifier());
        RuleParserTest.assertEquals((String)"EventA", (String)eventA.getObjectType());
        PatternDescr eventB = (PatternDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((String)"$b", (String)eventB.getIdentifier());
        RuleParserTest.assertEquals((String)"EventB", (String)eventB.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)eventB.getConstraint().getDescrs().size());
        OrDescr or = (OrDescr)eventB.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        FieldConstraintDescr fcdB = (FieldConstraintDescr)or.getDescrs().get(0);
        RuleParserTest.assertEquals((int)1, (int)fcdB.getRestrictions().size());
        RuleParserTest.assertTrue((boolean)(fcdB.getRestrictions().get(0) instanceof VariableRestrictionDescr));
        VariableRestrictionDescr rb = (VariableRestrictionDescr)fcdB.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"after", (String)rb.getEvaluator());
        RuleParserTest.assertEquals((String)"$a", (String)rb.getText());
        RuleParserTest.assertEquals((String)"1,10", (String)rb.getParameterText());
        RuleParserTest.assertFalse((boolean)rb.isNegated());
        FieldConstraintDescr fcdB2 = (FieldConstraintDescr)or.getDescrs().get(1);
        RuleParserTest.assertEquals((int)1, (int)fcdB2.getRestrictions().size());
        RuleParserTest.assertTrue((boolean)(fcdB2.getRestrictions().get(0) instanceof VariableRestrictionDescr));
        VariableRestrictionDescr rb2 = (VariableRestrictionDescr)fcdB2.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"after", (String)rb2.getEvaluator());
        RuleParserTest.assertEquals((String)"$a", (String)rb2.getText());
        RuleParserTest.assertEquals((String)"15,20", (String)rb2.getParameterText());
        RuleParserTest.assertTrue((boolean)rb2.isNegated());
        PatternDescr eventC = (PatternDescr)rule.getLhs().getDescrs().get(2);
        RuleParserTest.assertEquals((String)"$c", (String)eventC.getIdentifier());
        RuleParserTest.assertEquals((String)"EventC", (String)eventC.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)eventC.getConstraint().getDescrs().size());
        FieldConstraintDescr fcdC = (FieldConstraintDescr)eventC.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((int)1, (int)fcdC.getRestrictions().size());
        RuleParserTest.assertTrue((boolean)(fcdC.getRestrictions().get(0) instanceof VariableRestrictionDescr));
        VariableRestrictionDescr rc = (VariableRestrictionDescr)fcdC.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"finishes", (String)rc.getEvaluator());
        RuleParserTest.assertEquals((String)"$b", (String)rc.getText());
        RuleParserTest.assertNull((Object)rc.getParameterText());
        RuleParserTest.assertFalse((boolean)rc.isNegated());
        PatternDescr eventD = (PatternDescr)rule.getLhs().getDescrs().get(3);
        RuleParserTest.assertEquals((String)"$d", (String)eventD.getIdentifier());
        RuleParserTest.assertEquals((String)"EventD", (String)eventD.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)eventD.getConstraint().getDescrs().size());
        FieldConstraintDescr fcdD = (FieldConstraintDescr)eventD.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((int)1, (int)fcdD.getRestrictions().size());
        RuleParserTest.assertTrue((boolean)(fcdD.getRestrictions().get(0) instanceof VariableRestrictionDescr));
        VariableRestrictionDescr rd = (VariableRestrictionDescr)fcdD.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"starts", (String)rd.getEvaluator());
        RuleParserTest.assertEquals((String)"$a", (String)rd.getText());
        RuleParserTest.assertNull((Object)rd.getParameterText());
        RuleParserTest.assertTrue((boolean)rd.isNegated());
        PatternDescr eventE = (PatternDescr)rule.getLhs().getDescrs().get(4);
        RuleParserTest.assertEquals((String)"$e", (String)eventE.getIdentifier());
        RuleParserTest.assertEquals((String)"EventE", (String)eventE.getObjectType());
        RuleParserTest.assertEquals((int)2, (int)eventE.getConstraint().getDescrs().size());
        AndDescr and = (AndDescr)eventE.getConstraint();
        FieldConstraintDescr fcdE = (FieldConstraintDescr)and.getDescrs().get(0);
        RuleParserTest.assertEquals((int)1, (int)fcdE.getRestrictions().size());
        RestrictionConnectiveDescr orrestr = (RestrictionConnectiveDescr)fcdE.getRestrictions().get(0);
        RuleParserTest.assertEquals((Object)RestrictionConnectiveDescr.OR, (Object)orrestr.getConnective());
        RuleParserTest.assertEquals((int)2, (int)orrestr.getRestrictions().size());
        RuleParserTest.assertTrue((boolean)(orrestr.getRestrictions().get(0) instanceof VariableRestrictionDescr));
        VariableRestrictionDescr re = (VariableRestrictionDescr)orrestr.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"before", (String)re.getEvaluator());
        RuleParserTest.assertEquals((String)"$b", (String)re.getText());
        RuleParserTest.assertEquals((String)"1, 10", (String)re.getParameterText());
        RuleParserTest.assertTrue((boolean)re.isNegated());
        re = (VariableRestrictionDescr)orrestr.getRestrictions().get(1);
        RuleParserTest.assertEquals((String)"after", (String)re.getEvaluator());
        RuleParserTest.assertEquals((String)"$c", (String)re.getText());
        RuleParserTest.assertEquals((String)"1, 10", (String)re.getParameterText());
        RuleParserTest.assertFalse((boolean)re.isNegated());
        fcdE = (FieldConstraintDescr)and.getDescrs().get(1);
        RuleParserTest.assertEquals((int)1, (int)fcdE.getRestrictions().size());
        RuleParserTest.assertTrue((boolean)(fcdE.getRestrictions().get(0) instanceof VariableRestrictionDescr));
        re = (VariableRestrictionDescr)fcdE.getRestrictions().get(0);
        RuleParserTest.assertEquals((String)"after", (String)re.getEvaluator());
        RuleParserTest.assertEquals((String)"$d", (String)re.getText());
        RuleParserTest.assertEquals((String)"1, 5", (String)re.getParameterText());
        RuleParserTest.assertFalse((boolean)re.isNegated());
    }

    public void testTypeDeclaration() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "declare_type.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        List declarations = pack.getTypeDeclarations();
        RuleParserTest.assertEquals((int)1, (int)declarations.size());
        TypeDeclarationDescr descr = (TypeDeclarationDescr)declarations.get(0);
        RuleParserTest.assertEquals((String)"event", (String)descr.getMetaAttribute("role"));
        RuleParserTest.assertEquals((String)"org.drools.events.Call", (String)descr.getMetaAttribute("class"));
        RuleParserTest.assertEquals((String)"duration", (String)descr.getMetaAttribute("duration"));
        RuleParserTest.assertEquals((String)"timestamp", (String)descr.getMetaAttribute("timestamp"));
    }

    public void testRuleMetadata() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "Rule_with_Metadata.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertTrue((boolean)rule.getMetaAttributes().containsKey("fooMeta1"));
        RuleParserTest.assertEquals((String)"barVal1", (String)rule.getMetaAttribute("fooMeta1"));
        RuleParserTest.assertTrue((boolean)rule.getMetaAttributes().containsKey("fooMeta2"));
        RuleParserTest.assertEquals((String)"barVal2", (String)rule.getMetaAttribute("fooMeta2"));
    }

    public void testRuleExtends() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "Rule_with_Extends.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertTrue((rule.getParentName() != null ? 1 : 0) != 0);
        RuleParserTest.assertEquals((String)"rule1", (String)rule.getParentName());
    }

    public void testTypeDeclarationWithFields() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "declare_type_with_fields.drl");
        PackageDescr pack = this.walker.getPackageDescr();
        List td = pack.getTypeDeclarations();
        RuleParserTest.assertEquals((int)2, (int)td.size());
        TypeDeclarationDescr d = (TypeDeclarationDescr)td.get(0);
        RuleParserTest.assertEquals((String)"SomeFact", (String)d.getTypeName());
        RuleParserTest.assertEquals((int)2, (int)d.getFields().size());
        RuleParserTest.assertTrue((boolean)d.getFields().containsKey("name"));
        RuleParserTest.assertTrue((boolean)d.getFields().containsKey("age"));
        TypeFieldDescr f = (TypeFieldDescr)d.getFields().get("name");
        RuleParserTest.assertEquals((String)"String", (String)f.getPattern().getObjectType());
        f = (TypeFieldDescr)d.getFields().get("age");
        RuleParserTest.assertEquals((String)"Integer", (String)f.getPattern().getObjectType());
        d = (TypeDeclarationDescr)td.get(1);
        RuleParserTest.assertEquals((String)"AnotherFact", (String)d.getTypeName());
    }

    public void testEntryPoint() throws Exception {
        String text = "StockTick( symbol==\"ACME\") from entry-point StreamA";
        PatternDescr pattern = (PatternDescr)this.parse("pattern_source", "lhs", "StockTick( symbol==\"ACME\") from entry-point StreamA");
        RuleParserTest.assertEquals((int)1, (int)pattern.getDescrs().size());
        FieldConstraintDescr fcd = (FieldConstraintDescr)pattern.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"symbol", (String)fcd.getFieldName());
        RuleParserTest.assertNotNull((Object)pattern.getSource());
        EntryPointDescr entry = (EntryPointDescr)pattern.getSource();
        RuleParserTest.assertEquals((String)"StreamA", (String)entry.getEntryId());
    }

    public void testEntryPoint2() throws Exception {
        String text = "StockTick( symbol==\"ACME\") from entry-point \"StreamA\"";
        PatternDescr pattern = (PatternDescr)this.parse("pattern_source", "lhs", "StockTick( symbol==\"ACME\") from entry-point \"StreamA\"");
        RuleParserTest.assertEquals((int)1, (int)pattern.getDescrs().size());
        FieldConstraintDescr fcd = (FieldConstraintDescr)pattern.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"symbol", (String)fcd.getFieldName());
        RuleParserTest.assertNotNull((Object)pattern.getSource());
        EntryPointDescr entry = (EntryPointDescr)pattern.getSource();
        RuleParserTest.assertEquals((String)"StreamA", (String)entry.getEntryId());
    }

    public void testSlidingWindow() throws Exception {
        String text = "StockTick( symbol==\"ACME\") over window:length(10)";
        PatternDescr pattern = (PatternDescr)this.parse("pattern_source", "lhs", "StockTick( symbol==\"ACME\") over window:length(10)");
        RuleParserTest.assertEquals((int)1, (int)pattern.getDescrs().size());
        FieldConstraintDescr fcd = (FieldConstraintDescr)pattern.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"symbol", (String)fcd.getFieldName());
        List behaviors = pattern.getBehaviors();
        RuleParserTest.assertNotNull((Object)behaviors);
        RuleParserTest.assertEquals((int)1, (int)behaviors.size());
        SlidingWindowDescr descr = (SlidingWindowDescr)behaviors.get(0);
        RuleParserTest.assertEquals((String)"length", (String)descr.getText());
        RuleParserTest.assertEquals((String)"length", (String)descr.getType());
        RuleParserTest.assertEquals((String)"10", (String)descr.getParameters());
    }

    public void testNesting() throws Exception {
        this.parseResource("compilation_unit", "compilation_unit", "not_pluggable_operator.drl");
        RuleParserTest.assertNotNull((Object)this.walker);
    }

    private Object parse(String parserRuleName, String treeRuleName, String text) throws Exception {
        return this.newParser(parserRuleName, treeRuleName, this.newCharStream(text));
    }

    private Object parse(String parserRuleName, String treeRuleName, String source, String text) throws Exception {
        return this.newParser(parserRuleName, treeRuleName, this.newCharStream(text));
    }

    private Reader getReader(String name) throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(name);
        return new InputStreamReader(in);
    }

    private Object parseResource(String parserRuleName, String treeRuleName, String name) throws Exception {
        Reader reader = this.getReader(name);
        StringBuffer text = new StringBuffer();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return this.parse(parserRuleName, treeRuleName, name, text.toString());
    }

    private CharStream newCharStream(String text) {
        return new ANTLRStringStream(text);
    }

    private Object newParser(String parserRuleName, String treeRuleName, CharStream charStream) {
        return this.execTreeParser(parserRuleName, treeRuleName, charStream);
    }

    public Object execTreeParser(String testRuleName, String testTreeRuleName, CharStream charStream) {
        Object treeRuleReturn;
        block12: {
            treeRuleReturn = null;
            try {
                DRLLexer lexer = new DRLLexer(charStream);
                CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
                this.parser = new DRLParser((TokenStream)tokens);
                this.parser.setTreeAdaptor((TreeAdaptor)new DroolsTreeAdaptor());
                Method ruleName = Class.forName("org.drools.lang.DRLParser").getMethod(testRuleName, new Class[0]);
                Object ruleReturn = ruleName.invoke((Object)this.parser, new Object[0]);
                if (!this.parser.hasErrors()) {
                    Class<?> _return = Class.forName("org.drools.lang.DRLParser$" + testRuleName + "_return");
                    Method returnName = _return.getMethod("getTree", new Class[0]);
                    DroolsTree tree = (DroolsTree)returnName.invoke(ruleReturn, new Object[0]);
                    CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)tree);
                    nodes.setTokenStream((TokenStream)tokens);
                    this.walker = new DescrBuilderTree((TreeNodeStream)nodes);
                    Method treeRuleName = Class.forName("org.drools.lang.DescrBuilderTree").getMethod(testTreeRuleName, new Class[0]);
                    treeRuleReturn = treeRuleName.invoke((Object)this.walker, new Object[0]);
                } else {
                    System.out.println(this.parser.getErrorMessages());
                }
                if (treeRuleReturn == null || treeRuleReturn.toString().indexOf(testTreeRuleName + "_return") <= 0) break block12;
                try {
                    Field[] fields;
                    Class<?> _treeReturn = Class.forName("org.drools.lang.DescrBuilderTree$" + testTreeRuleName + "_return");
                    for (Field field : fields = _treeReturn.getDeclaredFields()) {
                        if (!field.getType().getName().contains("org.drools.lang.descr.")) continue;
                        return field.get(treeRuleReturn);
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                RuleParserTest.fail((String)e.getMessage());
            }
            catch (SecurityException e) {
                e.printStackTrace();
                RuleParserTest.fail((String)e.getMessage());
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                RuleParserTest.fail((String)e.getMessage());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                RuleParserTest.fail((String)e.getMessage());
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                RuleParserTest.fail((String)e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                RuleParserTest.fail((String)e.getMessage());
            }
        }
        return treeRuleReturn;
    }

    private void assertEqualsIgnoreWhitespace(String expected, String actual) {
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = actual.replaceAll("\\s+", "");
        RuleParserTest.assertEquals((String)cleanExpected, (String)cleanActual);
    }
}

