/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect;

import java.io.InputStreamReader;
import java.io.Reader;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.compiler.PackageBuilder;
import org.drools.rule.Package;

public class JavaAndMVELCombinedTest
extends TestCase {
    private static final String FN1 = "mveljavarules.drl";
    private static final String FN2 = "mvelonly.drl";
    private static final String FN3 = "javaonly.drl";

    public void testMixed() {
        this.timing(FN1, "mveljava: ");
    }

    public void testMVEL() {
        this.timing(FN2, "    mvel: ");
    }

    public void testJAVA() {
        this.timing(FN3, "    java: ");
    }

    private void timing(String name, String msg) {
        long start = System.currentTimeMillis();
        this.readDRL(name);
        long time = System.currentTimeMillis() - start;
        System.out.println(msg + (double)time / 1000.0);
    }

    private void readDRL(String fn) {
        try {
            InputStreamReader source = new InputStreamReader(JavaAndMVELCombinedTest.class.getResourceAsStream(fn));
            PackageBuilder builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)source);
            Assert.assertEquals((int)0, (int)builder.getErrors().getErrors().length);
            Package pkg = builder.getPackage();
            RuleBase ruleBase = RuleBaseFactory.newRuleBase();
            ruleBase.addPackage(pkg);
            Assert.assertEquals((int)2, (int)pkg.getRules().length);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

