/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.antlr.runtime.RecognitionException;
import org.drools.rule.builder.dialect.java.JavaAnalysisResult;
import org.drools.rule.builder.dialect.java.JavaExprAnalyzer;

public class JavaExprAnalyzerTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAnalyzeBlock() {
        JavaExprAnalyzer analyzer = new JavaExprAnalyzer();
        String codeBlock = "int x;\nCheese cheese = new Cheese();\nfor( Iterator it = list.iterator(); it.hasNext(); ) {\n    int shouldNotBeIncluded = 1;\n}\n{\n    String anotherNonTopLevelVar = \"test\";\n}\ndouble thisIsAGoodVar = 0;\nmethod();\n";
        try {
            JavaAnalysisResult analysis = analyzer.analyzeBlock(codeBlock, new Set[0]);
            List vars = analysis.getLocalVariables();
            JavaExprAnalyzerTest.assertEquals((int)3, (int)vars.size());
            JavaExprAnalyzerTest.assertTrue((boolean)vars.contains("x"));
            JavaExprAnalyzerTest.assertTrue((boolean)vars.contains("cheese"));
            JavaExprAnalyzerTest.assertTrue((boolean)vars.contains("thisIsAGoodVar"));
        }
        catch (RecognitionException e) {
            e.printStackTrace();
            JavaExprAnalyzerTest.fail((String)("Not supposed to raise exception: " + e.getMessage()));
        }
    }
}

