/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.common.InternalWorkingMemory;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.ReturnValueDescr;
import org.drools.definition.process.Process;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.ProcessDescr;
import org.drools.rule.Package;
import org.drools.rule.builder.PackageBuildContext;
import org.drools.rule.builder.ProcessBuildContext;
import org.drools.rule.builder.dialect.java.JavaDialect;
import org.drools.rule.builder.dialect.java.JavaReturnValueEvaluatorBuilder;
import org.drools.ruleflow.instance.RuleFlowProcessInstance;
import org.drools.workflow.core.impl.WorkflowProcessImpl;
import org.drools.workflow.instance.WorkflowProcessInstance;
import org.drools.workflow.instance.impl.ReturnValueConstraintEvaluator;
import org.drools.workflow.instance.node.SplitInstance;

public class JavaReturnValueConstraintEvaluatorBuilderTest
extends TestCase {
    public void setUp() {
    }

    public void testSimpleReturnValueConstraintEvaluator() throws Exception {
        Package pkg = new Package("pkg1");
        ProcessDescr processDescr = new ProcessDescr();
        processDescr.setClassName("Process1");
        processDescr.setName("Process1");
        WorkflowProcessImpl process = new WorkflowProcessImpl();
        process.setName("Process1");
        process.setPackageName("pkg1");
        ReturnValueDescr descr = new ReturnValueDescr();
        descr.setText("return value;");
        PackageBuilder pkgBuilder = new PackageBuilder(pkg);
        PackageBuilderConfiguration conf = pkgBuilder.getPackageBuilderConfiguration();
        DialectCompiletimeRegistry dialectRegistry = pkgBuilder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
        JavaDialect javaDialect = (JavaDialect)dialectRegistry.getDialect("java");
        ProcessBuildContext context = new ProcessBuildContext(pkgBuilder, pkg, (Process)process, (BaseDescr)processDescr, dialectRegistry, (Dialect)javaDialect);
        pkgBuilder.addPackageFromDrl((Reader)new StringReader("package pkg1;\nglobal Boolean value;"));
        ReturnValueConstraintEvaluator node = new ReturnValueConstraintEvaluator();
        JavaReturnValueEvaluatorBuilder builder = new JavaReturnValueEvaluatorBuilder();
        builder.build((PackageBuildContext)context, node, descr);
        javaDialect.addProcess(context);
        javaDialect.compileAll();
        JavaReturnValueConstraintEvaluatorBuilderTest.assertEquals((int)0, (int)javaDialect.getResults().size());
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkgBuilder.getPackage());
        InternalWorkingMemory wm = (InternalWorkingMemory)ruleBase.newStatefulSession();
        wm.setGlobal("value", (Object)true);
        RuleFlowProcessInstance processInstance = new RuleFlowProcessInstance();
        processInstance.setWorkingMemory(wm);
        SplitInstance splitInstance = new SplitInstance();
        splitInstance.setProcessInstance((WorkflowProcessInstance)processInstance);
        JavaReturnValueConstraintEvaluatorBuilderTest.assertTrue((boolean)node.evaluate(splitInstance, null, null));
        wm.setGlobal("value", (Object)false);
        JavaReturnValueConstraintEvaluatorBuilderTest.assertFalse((boolean)node.evaluate(splitInstance, null, null));
    }
}

