/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.base.mvel.MVELReturnValueEvaluator;
import org.drools.common.InternalWorkingMemory;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.ReturnValueDescr;
import org.drools.rule.Package;
import org.drools.rule.builder.PackageBuildContext;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.rule.builder.dialect.mvel.MVELReturnValueEvaluatorBuilder;
import org.drools.ruleflow.instance.RuleFlowProcessInstance;
import org.drools.workflow.instance.WorkflowProcessInstance;
import org.drools.workflow.instance.impl.ReturnValueConstraintEvaluator;
import org.drools.workflow.instance.node.SplitInstance;

public class MVELReturnValueConstraintEvaluatorBuilderTest
extends TestCase {
    public void setUp() {
    }

    public void testSimpleReturnValueConstraintEvaluator() throws Exception {
        Package pkg = new Package("pkg1");
        ReturnValueDescr descr = new ReturnValueDescr();
        descr.setText("return value");
        PackageBuilder pkgBuilder = new PackageBuilder(pkg);
        PackageBuilderConfiguration conf = pkgBuilder.getPackageBuilderConfiguration();
        DialectCompiletimeRegistry dialectRegistry = pkgBuilder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
        MVELDialect mvelDialect = (MVELDialect)dialectRegistry.getDialect("mvel");
        PackageBuildContext context = new PackageBuildContext();
        context.init(pkgBuilder, pkg, null, dialectRegistry, (Dialect)mvelDialect, null);
        pkgBuilder.addPackageFromDrl((Reader)new StringReader("package pkg1;\nglobal Boolean value;"));
        ReturnValueConstraintEvaluator node = new ReturnValueConstraintEvaluator();
        MVELReturnValueEvaluatorBuilder builder = new MVELReturnValueEvaluatorBuilder();
        builder.build(context, node, descr);
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkgBuilder.getPackage());
        InternalWorkingMemory wm = (InternalWorkingMemory)ruleBase.newStatefulSession();
        wm.setGlobal("value", (Object)true);
        RuleFlowProcessInstance processInstance = new RuleFlowProcessInstance();
        processInstance.setWorkingMemory(wm);
        SplitInstance splitInstance = new SplitInstance();
        splitInstance.setProcessInstance((WorkflowProcessInstance)processInstance);
        ((MVELReturnValueEvaluator)node.getReturnValueEvaluator()).compile(Thread.currentThread().getContextClassLoader());
        MVELReturnValueConstraintEvaluatorBuilderTest.assertTrue((boolean)node.evaluate(splitInstance, null, null));
        wm.setGlobal("value", (Object)false);
        MVELReturnValueConstraintEvaluatorBuilderTest.assertFalse((boolean)node.evaluate(splitInstance, null, null));
    }
}

