/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testframework;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.drools.guvnor.client.modeldriven.testing.ExecutionTrace;
import org.drools.guvnor.client.modeldriven.testing.FactData;
import org.drools.guvnor.client.modeldriven.testing.Fixture;
import org.drools.guvnor.client.modeldriven.testing.RetractFact;
import org.drools.guvnor.client.modeldriven.testing.Scenario;
import org.drools.guvnor.client.modeldriven.testing.VerifyFact;
import org.drools.guvnor.client.modeldriven.testing.VerifyField;
import org.drools.guvnor.client.modeldriven.testing.VerifyRuleFired;

public class ScenarioTest
extends TestCase {
    public void testInsertBetween() {
        Scenario sc = new Scenario();
        VerifyRuleFired vf = new VerifyRuleFired();
        sc.insertBetween(null, (Fixture)vf);
        ScenarioTest.assertEquals((int)1, (int)sc.fixtures.size());
        ScenarioTest.assertEquals((Object)vf, sc.fixtures.get(0));
        VerifyRuleFired vf2 = new VerifyRuleFired();
        sc.fixtures.add(vf2);
        VerifyRuleFired vf3 = new VerifyRuleFired();
        sc.insertBetween((Fixture)vf, (Fixture)vf3);
        ScenarioTest.assertEquals((int)3, (int)sc.fixtures.size());
        ScenarioTest.assertEquals((Object)vf, sc.fixtures.get(0));
        ScenarioTest.assertEquals((Object)vf2, sc.fixtures.get(1));
        ScenarioTest.assertEquals((Object)vf3, sc.fixtures.get(2));
        VerifyRuleFired vf4 = new VerifyRuleFired();
        sc.insertBetween((Fixture)vf2, (Fixture)vf4);
        ScenarioTest.assertEquals((int)4, (int)sc.fixtures.size());
        ScenarioTest.assertEquals((int)3, (int)sc.fixtures.indexOf(vf4));
        ScenarioTest.assertEquals((int)2, (int)sc.fixtures.indexOf(vf3));
        ScenarioTest.assertEquals((int)1, (int)sc.fixtures.indexOf(vf2));
        ScenarioTest.assertEquals((int)0, (int)sc.fixtures.indexOf(vf));
        VerifyRuleFired vf5 = new VerifyRuleFired();
        sc.insertBetween(null, (Fixture)vf5);
        ScenarioTest.assertEquals((int)5, (int)sc.fixtures.size());
        ScenarioTest.assertEquals((int)4, (int)sc.fixtures.indexOf(vf5));
        sc = new Scenario();
        sc.fixtures.add(vf);
        ExecutionTrace ex = new ExecutionTrace();
        sc.fixtures.add(ex);
        sc.insertBetween(null, (Fixture)vf2);
        ScenarioTest.assertEquals((int)0, (int)sc.fixtures.indexOf(vf));
        ScenarioTest.assertEquals((int)1, (int)sc.fixtures.indexOf(vf2));
        ScenarioTest.assertEquals((int)2, (int)sc.fixtures.indexOf(ex));
        ScenarioTest.assertEquals((int)3, (int)sc.fixtures.size());
        sc.insertBetween((Fixture)ex, (Fixture)vf3);
        ScenarioTest.assertEquals((int)4, (int)sc.fixtures.size());
        ScenarioTest.assertEquals((int)0, (int)sc.fixtures.indexOf(vf));
        ScenarioTest.assertEquals((int)1, (int)sc.fixtures.indexOf(vf2));
        ScenarioTest.assertEquals((int)2, (int)sc.fixtures.indexOf(ex));
        ScenarioTest.assertEquals((int)3, (int)sc.fixtures.indexOf(vf3));
        ExecutionTrace ex2 = new ExecutionTrace();
        sc.fixtures.add(ex2);
        sc.insertBetween((Fixture)ex, (Fixture)vf4);
        ScenarioTest.assertEquals((int)6, (int)sc.fixtures.size());
        ScenarioTest.assertEquals((int)0, (int)sc.fixtures.indexOf(vf));
        ScenarioTest.assertEquals((int)1, (int)sc.fixtures.indexOf(vf2));
        ScenarioTest.assertEquals((int)2, (int)sc.fixtures.indexOf(ex));
        ScenarioTest.assertEquals((int)3, (int)sc.fixtures.indexOf(vf3));
        ScenarioTest.assertEquals((int)4, (int)sc.fixtures.indexOf(vf4));
        ScenarioTest.assertEquals((int)5, (int)sc.fixtures.indexOf(ex2));
        sc.insertBetween((Fixture)ex2, (Fixture)vf5);
        ScenarioTest.assertEquals((int)7, (int)sc.fixtures.size());
        ScenarioTest.assertEquals((int)0, (int)sc.fixtures.indexOf(vf));
        ScenarioTest.assertEquals((int)1, (int)sc.fixtures.indexOf(vf2));
        ScenarioTest.assertEquals((int)2, (int)sc.fixtures.indexOf(ex));
        ScenarioTest.assertEquals((int)3, (int)sc.fixtures.indexOf(vf3));
        ScenarioTest.assertEquals((int)4, (int)sc.fixtures.indexOf(vf4));
        ScenarioTest.assertEquals((int)5, (int)sc.fixtures.indexOf(ex2));
        ScenarioTest.assertEquals((int)6, (int)sc.fixtures.indexOf(vf5));
        sc = new Scenario();
        sc.fixtures.add(ex);
        sc.insertBetween(null, (Fixture)vf);
        ScenarioTest.assertEquals((int)2, (int)sc.fixtures.size());
        ScenarioTest.assertEquals((int)0, (int)sc.fixtures.indexOf(vf));
        ScenarioTest.assertEquals((int)1, (int)sc.fixtures.indexOf(ex));
    }

    public void testExecutionTrace() {
        Scenario sc = new Scenario();
        sc.globals.add(new FactData("A", "A", new ArrayList(), false));
        sc.fixtures.add(new FactData("B", "B", new ArrayList(), true));
        sc.fixtures.add(new FactData("C", "C", new ArrayList(), true));
        ExecutionTrace ex1 = new ExecutionTrace();
        sc.fixtures.add(ex1);
        sc.fixtures.add(new VerifyFact());
        sc.fixtures.add(new RetractFact());
        sc.fixtures.add(new FactData("D", "D", new ArrayList(), false));
        sc.fixtures.add(new FactData("E", "E", new ArrayList(), false));
        ExecutionTrace ex2 = new ExecutionTrace();
        sc.fixtures.add(ex2);
        sc.fixtures.add(new VerifyFact());
        sc.fixtures.add(new FactData("F", "F", new ArrayList(), false));
        ExecutionTrace ex3 = new ExecutionTrace();
        sc.fixtures.add(ex3);
        ScenarioTest.assertEquals((int)11, (int)sc.fixtures.size());
        sc.removeExecutionTrace(ex2);
        ScenarioTest.assertEquals((int)6, (int)sc.fixtures.size());
        ScenarioTest.assertTrue((boolean)sc.isFactNameExisting("A"));
        ScenarioTest.assertTrue((boolean)sc.isFactNameExisting("B"));
        ScenarioTest.assertTrue((boolean)sc.isFactNameExisting("C"));
        ScenarioTest.assertFalse((boolean)sc.isFactNameExisting("D"));
        ScenarioTest.assertFalse((boolean)sc.isFactNameExisting("E"));
        ScenarioTest.assertTrue((boolean)sc.isFactNameExisting("F"));
    }

    public void testRemoveFixture() {
        Scenario sc = new Scenario();
        VerifyRuleFired vf1 = new VerifyRuleFired();
        VerifyRuleFired vf2 = new VerifyRuleFired();
        VerifyRuleFired vf3 = new VerifyRuleFired();
        FactData fd = new FactData();
        sc.fixtures.add(vf1);
        sc.fixtures.add(vf2);
        sc.fixtures.add(vf3);
        sc.globals.add(fd);
        sc.removeFixture((Fixture)vf2);
        ScenarioTest.assertEquals((int)2, (int)sc.fixtures.size());
        ScenarioTest.assertEquals((Object)vf1, sc.fixtures.get(0));
        ScenarioTest.assertEquals((Object)vf3, sc.fixtures.get(1));
        ScenarioTest.assertEquals((int)1, (int)sc.globals.size());
        sc.removeFixture((Fixture)fd);
        ScenarioTest.assertEquals((int)0, (int)sc.globals.size());
        ScenarioTest.assertEquals((int)2, (int)sc.fixtures.size());
    }

    public void testMapFactTypes() {
        Scenario sc = new Scenario();
        sc.fixtures.add(new FactData("X", "q", null, false));
        sc.globals.add(new FactData("Q", "x", null, false));
        Map r = sc.getVariableTypes();
        ScenarioTest.assertEquals((int)2, (int)r.size());
        ScenarioTest.assertEquals((Object)"X", r.get("q"));
        ScenarioTest.assertEquals((Object)"Q", r.get("x"));
    }

    public void testVariablesInScope() {
        Scenario sc = new Scenario();
        sc.globals.add(new FactData("X", "x", new ArrayList(), false));
        sc.fixtures.add(new FactData("Q", "q", new ArrayList(), true));
        sc.fixtures.add(new FactData("Z", "z", new ArrayList(), false));
        ExecutionTrace ex1 = new ExecutionTrace();
        sc.fixtures.add(ex1);
        sc.fixtures.add(new RetractFact("z"));
        sc.fixtures.add(new FactData("Y", "y", new ArrayList(), false));
        ExecutionTrace ex2 = new ExecutionTrace();
        sc.fixtures.add(ex2);
        List l = sc.getFactNamesInScope(ex1, true);
        ScenarioTest.assertEquals((int)3, (int)l.size());
        ScenarioTest.assertEquals((Object)"q", l.get(0));
        ScenarioTest.assertEquals((Object)"z", l.get(1));
        ScenarioTest.assertEquals((Object)"x", l.get(2));
        l = sc.getFactNamesInScope(ex1, false);
        ScenarioTest.assertEquals((int)2, (int)l.size());
        ScenarioTest.assertFalse((boolean)l.contains(sc.globals.get(0)));
        l = sc.getFactNamesInScope(ex2, true);
        ScenarioTest.assertEquals((int)3, (int)l.size());
        ScenarioTest.assertEquals((Object)"q", l.get(0));
        ScenarioTest.assertEquals((Object)"y", l.get(1));
        ScenarioTest.assertEquals((Object)"x", l.get(2));
        l = sc.getFactNamesInScope(null, true);
        ScenarioTest.assertEquals((int)0, (int)l.size());
    }

    public void testAllowRemoveFact() {
        Scenario sc = new Scenario();
        FactData fd1 = new FactData("X", "x", new ArrayList(), false);
        sc.fixtures.add(fd1);
        FactData fd2 = new FactData("Q", "q", new ArrayList(), false);
        sc.fixtures.add(fd2);
        FactData fd3 = new FactData("Z", "z", new ArrayList(), false);
        sc.fixtures.add(fd3);
        ExecutionTrace ex1 = new ExecutionTrace();
        FactData fd4 = new FactData("I", "i", new ArrayList(), false);
        sc.globals.add(fd4);
        sc.fixtures.add(ex1);
        sc.fixtures.add(new RetractFact("z"));
        sc.fixtures.add(new FactData("Z", "z", new ArrayList(), true));
        sc.fixtures.add(new VerifyFact("q", new ArrayList()));
        ScenarioTest.assertFalse((boolean)sc.isFactNameUsed(fd1));
        ScenarioTest.assertTrue((boolean)sc.isFactNameUsed(fd2));
        ScenarioTest.assertTrue((boolean)sc.isFactNameUsed(fd3));
        ScenarioTest.assertFalse((boolean)sc.isFactNameUsed(fd4));
    }

    public void testIsFactNameUsed() {
        Scenario sc = new Scenario();
        sc.globals.add(new FactData("X", "x", null, false));
        sc.fixtures.add(new FactData("Q", "q", null, false));
        sc.fixtures.add(new ExecutionTrace());
        ScenarioTest.assertTrue((boolean)sc.isFactNameExisting("x"));
        ScenarioTest.assertTrue((boolean)sc.isFactNameExisting("q"));
        ScenarioTest.assertFalse((boolean)sc.isFactNameExisting("w"));
        sc = new Scenario();
        ScenarioTest.assertFalse((boolean)sc.isFactNameExisting("w"));
    }

    public void testCountSuccessFailures() {
        Scenario sc = new Scenario();
        sc.fixtures.add(new FactData());
        sc.fixtures.add(new ExecutionTrace());
        VerifyRuleFired vr = new VerifyRuleFired();
        vr.successResult = false;
        sc.fixtures.add(vr);
        VerifyField vf = new VerifyField();
        vf.successResult = true;
        VerifyField vf2 = new VerifyField();
        vf2.successResult = false;
        VerifyFact vfact = new VerifyFact();
        vfact.fieldValues.add(vf);
        vfact.fieldValues.add(vf2);
        sc.fixtures.add(vfact);
        int[] totals = sc.countFailuresTotal();
        ScenarioTest.assertEquals((int)2, (int)totals[0]);
        ScenarioTest.assertEquals((int)3, (int)totals[1]);
    }
}

