/*
 * Decompiled with CFR 0.152.
 */
package org.drools.xml.rules;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import junit.framework.Assert;
import org.drools.compiler.DrlParser;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.lang.DrlDumper;
import org.drools.lang.descr.PackageDescr;
import org.drools.xml.XmlDumper;
import org.drools.xml.XmlPackageReader;

public class DumperTestHelper
extends Assert {
    public static void XmlFile(String filename) throws Exception {
        PackageBuilderConfiguration conf = new PackageBuilderConfiguration();
        XmlPackageReader xmlPackageReader = new XmlPackageReader(conf.getSemanticModules());
        xmlPackageReader.read((Reader)new InputStreamReader(DumperTestHelper.class.getResourceAsStream(filename)));
        PackageDescr pkgOriginal = xmlPackageReader.getPackageDescr();
        XmlDumper dumper = new XmlDumper();
        String result = dumper.dump(pkgOriginal);
        String buffer = DumperTestHelper.readFile(filename);
        DumperTestHelper.assertEqualsIgnoreWhitespace(buffer, result);
        DumperTestHelper.assertNotNull((Object)result);
    }

    public static void DrlFile(String filename) throws Exception {
        DrlParser parser = new DrlParser();
        PackageDescr pkgOriginal = parser.parse((Reader)new InputStreamReader(DumperTestHelper.class.getResourceAsStream(filename)));
        DrlDumper dumper = new DrlDumper();
        String result = dumper.dump(pkgOriginal);
        parser = new DrlParser();
        String buffer = DumperTestHelper.readFile(filename);
        DumperTestHelper.assertEqualsIgnoreWhitespace(buffer.toString(), result);
    }

    private static void assertEqualsIgnoreWhitespace(String expected, String actual) {
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = actual.replaceAll("\\s+", "");
        DumperTestHelper.assertEquals((String)cleanExpected, (String)cleanActual);
    }

    private static String readFile(String file) throws IOException {
        InputStreamReader reader = new InputStreamReader(DumperTestHelper.class.getResourceAsStream(file));
        StringBuffer text = new StringBuffer();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return text.toString();
    }
}

