/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.util.HashSet;
import java.util.Set;
import org.drools.base.accumulators.AccumulateFunction;
import org.drools.base.accumulators.MVELAccumulatorFunctionExecutor;
import org.drools.base.mvel.MVELAccumulator;
import org.drools.base.mvel.MVELCompilationUnit;
import org.drools.base.mvel.MVELCompileable;
import org.drools.compiler.DescrBuildError;
import org.drools.compiler.Dialect;
import org.drools.lang.descr.AccumulateDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.rule.Accumulate;
import org.drools.rule.Declaration;
import org.drools.rule.MVELDialectRuntimeData;
import org.drools.rule.Pattern;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.builder.AccumulateBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleConditionBuilder;
import org.drools.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.spi.Accumulator;
import org.drools.spi.Wireable;

public class MVELAccumulateBuilder
implements AccumulateBuilder {
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        return this.build(context, descr, null);
    }

    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        try {
            AccumulateDescr accumDescr = (AccumulateDescr)descr;
            if (!accumDescr.hasValidInput()) {
                return null;
            }
            RuleConditionBuilder builder = context.getDialect().getBuilder(accumDescr.getInput().getClass());
            Declaration[] previousDeclarations = context.getDeclarationResolver().getDeclarations(context.getRule()).values().toArray(new Declaration[context.getDeclarationResolver().getDeclarations(context.getRule()).size()]);
            RuleConditionElement source = builder.build(context, accumDescr.getInput());
            if (source == null) {
                return null;
            }
            MVELDialect dialect = (MVELDialect)context.getDialect();
            Declaration[] sourceDeclArr = source.getOuterDeclarations().values().toArray(new Declaration[source.getOuterDeclarations().size()]);
            MVELAccumulatorFunctionExecutor accumulator = null;
            Declaration[] declarations = null;
            if (accumDescr.isExternalFunction()) {
                Dialect.AnalysisResult analysis = dialect.analyzeExpression(context, accumDescr, accumDescr.getExpression(), new Set[]{context.getDeclarationResolver().getDeclarations(context.getRule()).keySet(), context.getPkg().getGlobals().keySet()});
                MVELCompilationUnit unit = dialect.getMVELCompilationUnit(accumDescr.getExpression(), analysis, previousDeclarations, source.getOuterDeclarations().values().toArray(new Declaration[source.getOuterDeclarations().size()]), null, context);
                AccumulateFunction function = context.getConfiguration().getAccumulateFunction(accumDescr.getFunctionIdentifier());
                accumulator = new MVELAccumulatorFunctionExecutor(unit, function);
            } else {
                MVELAnalysisResult initCodeAnalysis = (MVELAnalysisResult)dialect.analyzeBlock(context, accumDescr, accumDescr.getInitCode(), new Set[]{context.getDeclarationResolver().getDeclarations(context.getRule()).keySet(), context.getPkg().getGlobals().keySet()});
                MVELAnalysisResult actionCodeAnalysis = (MVELAnalysisResult)dialect.analyzeBlock(context, accumDescr, null, accumDescr.getActionCode(), new Set[]{context.getDeclarationResolver().getDeclarations(context.getRule()).keySet(), context.getPkg().getGlobals().keySet()}, initCodeAnalysis.getMvelVariables());
                MVELAnalysisResult resultCodeAnalysis = (MVELAnalysisResult)dialect.analyzeExpression(context, accumDescr, accumDescr.getResultCode(), new Set[]{context.getDeclarationResolver().getDeclarations(context.getRule()).keySet(), context.getPkg().getGlobals().keySet()}, initCodeAnalysis.getMvelVariables());
                Dialect.AnalysisResult reverseCodeAnalysis = null;
                if (accumDescr.getReverseCode() != null) {
                    reverseCodeAnalysis = context.getDialect().analyzeBlock(context, accumDescr, accumDescr.getActionCode(), new Set[]{context.getDeclarationResolver().getDeclarations(context.getRule()).keySet(), context.getPkg().getGlobals().keySet()});
                }
                MVELCompilationUnit initUnit = dialect.getMVELCompilationUnit(accumDescr.getInitCode(), initCodeAnalysis, previousDeclarations, source.getOuterDeclarations().values().toArray(new Declaration[source.getOuterDeclarations().size()]), null, context);
                MVELCompilationUnit actionUnit = dialect.getMVELCompilationUnit(accumDescr.getActionCode(), actionCodeAnalysis, previousDeclarations, source.getOuterDeclarations().values().toArray(new Declaration[source.getOuterDeclarations().size()]), initCodeAnalysis.getMvelVariables(), context);
                MVELCompilationUnit reverseUnit = null;
                if (accumDescr.getReverseCode() != null) {
                    reverseUnit = dialect.getMVELCompilationUnit(accumDescr.getReverseCode(), resultCodeAnalysis, previousDeclarations, source.getOuterDeclarations().values().toArray(new Declaration[source.getOuterDeclarations().size()]), initCodeAnalysis.getMvelVariables(), context);
                }
                MVELCompilationUnit resultUnit = dialect.getMVELCompilationUnit(accumDescr.getResultCode(), resultCodeAnalysis, previousDeclarations, source.getOuterDeclarations().values().toArray(new Declaration[source.getOuterDeclarations().size()]), initCodeAnalysis.getMvelVariables(), context);
                if (reverseUnit != null) {
                    HashSet shadow = new HashSet(source.getOuterDeclarations().keySet());
                    shadow.retainAll(reverseCodeAnalysis.getNotBoundedIdentifiers());
                    shadow.addAll(reverseCodeAnalysis.getBoundIdentifiers()[0]);
                    reverseUnit.setShadowIdentifiers(shadow.toArray(new String[shadow.size()]));
                }
                accumulator = new MVELAccumulator(initUnit, actionUnit, reverseUnit, resultUnit);
            }
            Accumulate accumulate = new Accumulate(source, declarations, sourceDeclArr, (Accumulator)accumulator);
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
            data.addCompileable((Wireable)accumulate, (MVELCompileable)accumulator);
            ((MVELCompileable)accumulator).compile((ClassLoader)context.getPackageBuilder().getRootClassLoader());
            return accumulate;
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, e, "Unable to build expression for 'accumulate' : " + e.getMessage()));
            return null;
        }
    }
}

