/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder;

import java.util.Calendar;
import org.drools.RuntimeDroolsException;
import org.drools.base.EnabledBoolean;
import org.drools.base.SalienceInteger;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.GroupElement;
import org.drools.rule.Pattern;
import org.drools.rule.Rule;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleConditionBuilder;
import org.drools.spi.Salience;
import org.drools.time.TimeUtils;
import org.drools.util.DateUtils;

public class RuleBuilder {
    public void build(RuleBuildContext context) {
        Pattern prefixPattern;
        RuleDescr ruleDescr = context.getRuleDescr();
        if (null != ruleDescr.getParentName() && null != context.getPkg().getRule(ruleDescr.getParentName())) {
            context.getRule().setParent(context.getPkg().getRule(ruleDescr.getParentName()));
        }
        context.getRule().getMetaAttributes().putAll(ruleDescr.getMetaAttributes());
        RuleConditionBuilder builder = context.getDialect().getBuilder(ruleDescr.getLhs().getClass());
        if (builder != null) {
            prefixPattern = null;
            if (context.getRuleDescr() instanceof QueryDescr) {
                prefixPattern = context.getDialect().getQueryBuilder().build(context, (QueryDescr)context.getRuleDescr());
            }
        } else {
            throw new RuntimeDroolsException("BUG: builder not found for descriptor class " + ruleDescr.getLhs().getClass());
        }
        GroupElement ce = (GroupElement)builder.build(context, ruleDescr.getLhs(), prefixPattern);
        context.getRule().setLhs(ce);
        this.buildAttributes(context);
        if (!(ruleDescr instanceof QueryDescr)) {
            context.getDialect().getConsequenceBuilder().build(context);
        }
    }

    public void buildAttributes(RuleBuildContext context) {
        Rule rule = context.getRule();
        RuleDescr ruleDescr = context.getRuleDescr();
        for (AttributeDescr attributeDescr : ruleDescr.getAttributes().values()) {
            Calendar cal;
            String name = attributeDescr.getName();
            if (name.equals("no-loop")) {
                rule.setNoLoop(this.getBooleanValue(attributeDescr, true));
                continue;
            }
            if (name.equals("auto-focus")) {
                rule.setAutoFocus(this.getBooleanValue(attributeDescr, true));
                continue;
            }
            if (name.equals("agenda-group")) {
                rule.setAgendaGroup(attributeDescr.getValue());
                continue;
            }
            if (name.equals("activation-group")) {
                rule.setActivationGroup(attributeDescr.getValue());
                continue;
            }
            if (name.equals("ruleflow-group")) {
                rule.setRuleFlowGroup(attributeDescr.getValue());
                continue;
            }
            if (name.equals("lock-on-active")) {
                rule.setLockOnActive(this.getBooleanValue(attributeDescr, true));
                continue;
            }
            if (name.equals("duration")) {
                String duration = attributeDescr.getValue();
                if (duration.indexOf(40) >= 0) {
                    duration = duration.substring(duration.indexOf(40) + 1, duration.lastIndexOf(41));
                }
                rule.setDuration(TimeUtils.parseTimeString((String)duration));
                continue;
            }
            if (name.equals("date-effective")) {
                cal = Calendar.getInstance();
                cal.setTime(DateUtils.parseDate((String)attributeDescr.getValue()));
                rule.setDateEffective(cal);
                continue;
            }
            if (!name.equals("date-expires")) continue;
            cal = Calendar.getInstance();
            cal.setTime(DateUtils.parseDate((String)attributeDescr.getValue()));
            rule.setDateExpires(cal);
        }
        this.buildSalience(context);
        this.buildEnabled(context);
    }

    private boolean getBooleanValue(AttributeDescr attributeDescr, boolean defaultValue) {
        return attributeDescr.getValue() == null || "".equals(attributeDescr.getValue().trim()) ? defaultValue : Boolean.valueOf(attributeDescr.getValue());
    }

    private void buildEnabled(RuleBuildContext context) {
        String enabledText = context.getRuleDescr().getEnabled();
        if (enabledText != null) {
            if ("true".equalsIgnoreCase(enabledText.trim()) || "false".equalsIgnoreCase(enabledText.trim())) {
                if (Boolean.parseBoolean(enabledText)) {
                    context.getRule().setEnabled(EnabledBoolean.ENABLED_TRUE);
                } else {
                    context.getRule().setEnabled(EnabledBoolean.ENABLED_FALSE);
                }
            } else {
                context.getDialect().getEnabledBuilder().build(context);
            }
        }
    }

    private void buildSalience(RuleBuildContext context) {
        String salienceText = context.getRuleDescr().getSalience();
        if (salienceText != null && !salienceText.equals("")) {
            try {
                SalienceInteger salience = new SalienceInteger(Integer.parseInt(salienceText));
                context.getRule().setSalience((Salience)salience);
            }
            catch (Exception e) {
                context.getDialect().getSalienceBuilder().build(context);
            }
        }
    }
}

