/*
 * Decompiled with CFR 0.152.
 */
package org.drools;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.drools.OrderItem;

public class Order
implements Serializable {
    private int number;
    private String customer;
    private Map items;
    private OrderStatus status;
    private Date date;
    private double total;

    public double getTotal() {
        return this.total;
    }

    public void setTotal(double total) {
        this.total = total;
    }

    public Order() {
        this(0, "Bob");
    }

    public Order(int number, String customer) {
        this.number = number;
        this.items = new HashMap();
        this.customer = customer;
        this.date = new Date();
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public Map getItems() {
        return this.items;
    }

    public Collection getItemsValues() {
        return this.items.values();
    }

    public Collection getItemsKeys() {
        return this.items.keySet();
    }

    public void addItem(OrderItem item) {
        this.items.put(new Integer(item.getSeq()), item);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.number;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Order other = (Order)obj;
        return this.number == other.number;
    }

    public String getCustomer() {
        return this.customer;
    }

    public void setCustomer(String customer) {
        this.customer = customer;
    }

    public String toString() {
        return "Order( number=" + this.getNumber() + " customer=\"" + this.getCustomer() + "\" )";
    }

    public OrderStatus getStatus() {
        if (this.status == null) {
            this.status = new OrderStatus();
        }
        return this.status;
    }

    public void setStatus(OrderStatus status) {
        this.status = status;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public static class OrderStatus {
        private boolean active;

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }
    }
}

