/*
 * Decompiled with CFR 0.152.
 */
package org.drools.api;

import java.util.Collection;
import junit.framework.TestCase;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.definition.KnowledgePackage;
import org.drools.definition.process.Process;
import org.drools.definition.rule.Rule;
import org.drools.io.ResourceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnowledgeBuilderTest
extends TestCase {
    public void testKnowledgeProvider() {
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        KnowledgeBuilderTest.assertNotNull((Object)builder);
    }

    public void testKnowledgeProviderWithRules() {
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        String str = "";
        str = str + "package org.test1\n";
        str = str + "rule rule1\n";
        str = str + "when\n";
        str = str + "then\n";
        str = str + "end\n\n";
        str = str + "rule rule2\n";
        str = str + "when\n";
        str = str + "then\n";
        str = str + "end\n";
        builder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        str = "package org.test2\n";
        str = str + "rule rule3\n";
        str = str + "when\n";
        str = str + "then\n";
        str = str + "end\n\n";
        str = str + "rule rule4\n";
        str = str + "when\n";
        str = str + "then\n";
        str = str + "end\n";
        builder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        Collection pkgs = builder.getKnowledgePackages();
        KnowledgeBuilderTest.assertNotNull((Object)pkgs);
        KnowledgeBuilderTest.assertEquals((int)2, (int)pkgs.size());
        KnowledgePackage test1 = this.getKnowledgePackage(pkgs, "org.test1");
        Collection rules = test1.getRules();
        KnowledgeBuilderTest.assertEquals((int)2, (int)rules.size());
        Rule rule = this.getRule(rules, "rule1");
        KnowledgeBuilderTest.assertEquals((String)"rule1", (String)rule.getName());
        rule = this.getRule(rules, "rule2");
        KnowledgeBuilderTest.assertEquals((String)"rule2", (String)rule.getName());
        KnowledgePackage test2 = this.getKnowledgePackage(pkgs, "org.test2");
        rules = test2.getRules();
        KnowledgeBuilderTest.assertEquals((int)2, (int)rules.size());
        rule = this.getRule(rules, "rule3");
        KnowledgeBuilderTest.assertEquals((String)"rule3", (String)rule.getName());
        rule = this.getRule(rules, "rule4");
        KnowledgeBuilderTest.assertEquals((String)"rule4", (String)rule.getName());
    }

    public void testKnowledgeProviderWithProcesses() {
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        String str = "";
        str = str + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        str = str + "<process xmlns=\"http://drools.org/drools-5.0/process\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\" xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\" ";
        str = str + "         type=\"RuleFlow\" name=\"flow1\" id=\"0\" package-name=\"org.test1\" >";
        str = str + "  <header/>\n";
        str = str + "  <nodes><start id=\"1\" name=\"Start\" /><end id=\"2\" name=\"End\" /></nodes>\n";
        str = str + "  <connections><connection from=\"1\" to=\"2\"/></connections>";
        str = str + "</process>";
        builder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRF);
        str = "";
        str = str + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        str = str + "<process xmlns=\"http://drools.org/drools-5.0/process\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\" xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\" ";
        str = str + "         type=\"RuleFlow\" name=\"flow2\" id=\"0\" package-name=\"org.test2\" >";
        str = str + "  <header/>\n";
        str = str + "  <nodes><start id=\"1\" name=\"Start\" /><end id=\"2\" name=\"End\" /></nodes>\n";
        str = str + "  <connections><connection from=\"1\" to=\"2\"/></connections>";
        str = str + "</process>";
        builder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRF);
        Collection pkgs = builder.getKnowledgePackages();
        KnowledgeBuilderTest.assertNotNull((Object)pkgs);
        KnowledgeBuilderTest.assertEquals((int)2, (int)pkgs.size());
        KnowledgePackage test1 = this.getKnowledgePackage(pkgs, "org.test1");
        Collection processes = test1.getProcesses();
        KnowledgeBuilderTest.assertEquals((int)1, (int)processes.size());
        Process process = this.getProcess(processes, "flow1");
        KnowledgeBuilderTest.assertEquals((String)"flow1", (String)process.getName());
        KnowledgePackage test2 = this.getKnowledgePackage(pkgs, "org.test2");
        processes = test2.getProcesses();
        KnowledgeBuilderTest.assertEquals((int)1, (int)processes.size());
        process = this.getProcess(processes, "flow2");
        KnowledgeBuilderTest.assertEquals((String)"flow2", (String)process.getName());
    }

    public Rule getRule(Collection<Rule> rules, String name) {
        for (Rule rule : rules) {
            if (!rule.getName().equals(name)) continue;
            return rule;
        }
        return null;
    }

    public Process getProcess(Collection<Process> processes, String name) {
        for (Process process : processes) {
            if (!process.getName().equals(name)) continue;
            return process;
        }
        return null;
    }

    public KnowledgePackage getKnowledgePackage(Collection<KnowledgePackage> pkgs, String name) {
        for (KnowledgePackage pkg : pkgs) {
            if (!pkg.getName().equals(name)) continue;
            return pkg;
        }
        return null;
    }
}

