/*
 * Decompiled with CFR 0.152.
 */
package org.drools.builder;

import java.io.File;
import java.io.Serializable;
import junit.framework.TestCase;
import org.drools.base.accumulators.AverageAccumulateFunction;
import org.drools.base.accumulators.MaxAccumulateFunction;
import org.drools.base.evaluators.AfterEvaluatorDefinition;
import org.drools.base.evaluators.BeforeEvaluatorDefinition;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.conf.AccumulateFunctionOption;
import org.drools.builder.conf.DefaultDialectOption;
import org.drools.builder.conf.DefaultPackageNameOption;
import org.drools.builder.conf.DumpDirOption;
import org.drools.builder.conf.EvaluatorOption;
import org.drools.builder.conf.KnowledgeBuilderOption;
import org.drools.builder.conf.ProcessStringEscapesOption;
import org.drools.runtime.rule.AccumulateFunction;
import org.drools.runtime.rule.EvaluatorDefinition;

public class KnowledgeBuilderConfigurationTest
extends TestCase {
    private KnowledgeBuilderConfiguration config;

    protected void setUp() throws Exception {
        super.setUp();
        this.config = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
    }

    public void testDefaultDialectConfiguration() {
        this.config.setOption((KnowledgeBuilderOption)DefaultDialectOption.get((String)"mvel"));
        KnowledgeBuilderConfigurationTest.assertEquals((Object)DefaultDialectOption.get((String)"mvel"), (Object)this.config.getOption(DefaultDialectOption.class));
        KnowledgeBuilderConfigurationTest.assertEquals((String)"mvel", (String)((DefaultDialectOption)this.config.getOption(DefaultDialectOption.class)).getName());
        KnowledgeBuilderConfigurationTest.assertEquals((String)"mvel", (String)this.config.getProperty("drools.dialect.default"));
        this.config.setProperty("drools.dialect.default", "java");
        KnowledgeBuilderConfigurationTest.assertEquals((Object)DefaultDialectOption.get((String)"java"), (Object)this.config.getOption(DefaultDialectOption.class));
        KnowledgeBuilderConfigurationTest.assertEquals((String)"java", (String)((DefaultDialectOption)this.config.getOption(DefaultDialectOption.class)).getName());
        KnowledgeBuilderConfigurationTest.assertEquals((String)"java", (String)this.config.getProperty("drools.dialect.default"));
    }

    public void testAccumulateFunctionConfiguration() {
        AverageAccumulateFunction function = new AverageAccumulateFunction();
        AccumulateFunctionOption option = AccumulateFunctionOption.get((String)"avg", (AccumulateFunction)function);
        this.config.setOption((KnowledgeBuilderOption)option);
        KnowledgeBuilderConfigurationTest.assertEquals((Object)option, (Object)this.config.getOption(AccumulateFunctionOption.class, "avg"));
        KnowledgeBuilderConfigurationTest.assertEquals((String)"avg", (String)((AccumulateFunctionOption)this.config.getOption(AccumulateFunctionOption.class, "avg")).getName());
        KnowledgeBuilderConfigurationTest.assertEquals((Object)function, (Object)((AccumulateFunctionOption)this.config.getOption(AccumulateFunctionOption.class, "avg")).getFunction());
        KnowledgeBuilderConfigurationTest.assertEquals((String)AverageAccumulateFunction.class.getName(), (String)this.config.getProperty("drools.accumulate.function.avg"));
        this.config.setProperty("drools.accumulate.function.maximum", MaxAccumulateFunction.class.getName());
        MaxAccumulateFunction max = new MaxAccumulateFunction();
        KnowledgeBuilderConfigurationTest.assertEquals((Object)AccumulateFunctionOption.get((String)"maximum", (AccumulateFunction)max), (Object)this.config.getOption(AccumulateFunctionOption.class, "maximum"));
        KnowledgeBuilderConfigurationTest.assertEquals((String)"maximum", (String)((AccumulateFunctionOption)this.config.getOption(AccumulateFunctionOption.class, "maximum")).getName());
        KnowledgeBuilderConfigurationTest.assertEquals((String)max.getClass().getName(), (String)((AccumulateFunctionOption)this.config.getOption(AccumulateFunctionOption.class, "maximum")).getFunction().getClass().getName());
        KnowledgeBuilderConfigurationTest.assertEquals((String)MaxAccumulateFunction.class.getName(), (String)this.config.getProperty("drools.accumulate.function.maximum"));
        this.config.setProperty("drools.accumulate.function.inner", InnerAccumulateFuncion.class.getName());
        InnerAccumulateFuncion inner = new InnerAccumulateFuncion();
        KnowledgeBuilderConfigurationTest.assertEquals((Object)AccumulateFunctionOption.get((String)"inner", (AccumulateFunction)inner), (Object)this.config.getOption(AccumulateFunctionOption.class, "inner"));
        KnowledgeBuilderConfigurationTest.assertEquals((String)"inner", (String)((AccumulateFunctionOption)this.config.getOption(AccumulateFunctionOption.class, "inner")).getName());
        KnowledgeBuilderConfigurationTest.assertEquals((String)inner.getClass().getName(), (String)((AccumulateFunctionOption)this.config.getOption(AccumulateFunctionOption.class, "inner")).getFunction().getClass().getName());
        KnowledgeBuilderConfigurationTest.assertEquals((String)InnerAccumulateFuncion.class.getName(), (String)this.config.getProperty("drools.accumulate.function.inner"));
    }

    public void testDumpDirectoryConfiguration() {
        File dumpDir = new File("target");
        this.config.setOption((KnowledgeBuilderOption)DumpDirOption.get((File)dumpDir));
        KnowledgeBuilderConfigurationTest.assertEquals((Object)DumpDirOption.get((File)dumpDir), (Object)this.config.getOption(DumpDirOption.class));
        KnowledgeBuilderConfigurationTest.assertEquals((Object)dumpDir, (Object)((DumpDirOption)this.config.getOption(DumpDirOption.class)).getDirectory());
        KnowledgeBuilderConfigurationTest.assertEquals((String)dumpDir.toString(), (String)this.config.getProperty("drools.dump.dir"));
        dumpDir = new File("src/main/resources");
        this.config.setProperty("drools.dump.dir", "src/main/resources");
        KnowledgeBuilderConfigurationTest.assertEquals((Object)DumpDirOption.get((File)dumpDir), (Object)this.config.getOption(DumpDirOption.class));
        KnowledgeBuilderConfigurationTest.assertEquals((Object)dumpDir, (Object)((DumpDirOption)this.config.getOption(DumpDirOption.class)).getDirectory());
        KnowledgeBuilderConfigurationTest.assertEquals((String)dumpDir.toString(), (String)this.config.getProperty("drools.dump.dir"));
    }

    public void testEvaluatorConfiguration() {
        AfterEvaluatorDefinition afterDef = new AfterEvaluatorDefinition();
        KnowledgeBuilderConfigurationTest.assertNotNull((Object)afterDef);
        EvaluatorOption option = EvaluatorOption.get((String)"after", (EvaluatorDefinition)afterDef);
        this.config.setOption((KnowledgeBuilderOption)option);
        KnowledgeBuilderConfigurationTest.assertEquals((Object)option, (Object)this.config.getOption(EvaluatorOption.class, "after"));
        KnowledgeBuilderConfigurationTest.assertEquals((String)"after", (String)((EvaluatorOption)this.config.getOption(EvaluatorOption.class, "after")).getName());
        KnowledgeBuilderConfigurationTest.assertEquals((Object)afterDef, (Object)((EvaluatorOption)this.config.getOption(EvaluatorOption.class, "after")).getEvaluatorDefinition());
        KnowledgeBuilderConfigurationTest.assertEquals((String)AfterEvaluatorDefinition.class.getName(), (String)this.config.getProperty("drools.evaluator.after"));
        this.config.setProperty("drools.evaluator.before", BeforeEvaluatorDefinition.class.getName());
        BeforeEvaluatorDefinition beforeDef = new BeforeEvaluatorDefinition();
        KnowledgeBuilderConfigurationTest.assertEquals((Object)EvaluatorOption.get((String)"before", (EvaluatorDefinition)beforeDef), (Object)this.config.getOption(EvaluatorOption.class, "before"));
        KnowledgeBuilderConfigurationTest.assertEquals((String)"before", (String)((EvaluatorOption)this.config.getOption(EvaluatorOption.class, "before")).getName());
        KnowledgeBuilderConfigurationTest.assertEquals((String)beforeDef.getClass().getName(), (String)((EvaluatorOption)this.config.getOption(EvaluatorOption.class, "before")).getEvaluatorDefinition().getClass().getName());
        KnowledgeBuilderConfigurationTest.assertEquals((String)beforeDef.getClass().getName(), (String)this.config.getProperty("drools.evaluator.before"));
    }

    public void testProcessStringEscapesConfiguration() {
        this.config.setOption((KnowledgeBuilderOption)ProcessStringEscapesOption.YES);
        KnowledgeBuilderConfigurationTest.assertEquals((Object)ProcessStringEscapesOption.YES, (Object)this.config.getOption(ProcessStringEscapesOption.class));
        KnowledgeBuilderConfigurationTest.assertEquals((String)"true", (String)this.config.getProperty("drools.parser.processStringEscapes"));
        this.config.setProperty("drools.parser.processStringEscapes", "false");
        KnowledgeBuilderConfigurationTest.assertEquals((Object)ProcessStringEscapesOption.NO, (Object)this.config.getOption(ProcessStringEscapesOption.class));
        KnowledgeBuilderConfigurationTest.assertEquals((String)"false", (String)this.config.getProperty("drools.parser.processStringEscapes"));
    }

    public void testDefaultPackageNameConfiguration() {
        this.config.setOption((KnowledgeBuilderOption)DefaultPackageNameOption.get((String)"org.test"));
        KnowledgeBuilderConfigurationTest.assertEquals((Object)DefaultPackageNameOption.get((String)"org.test"), (Object)this.config.getOption(DefaultPackageNameOption.class));
        KnowledgeBuilderConfigurationTest.assertEquals((String)"org.test", (String)((DefaultPackageNameOption)this.config.getOption(DefaultPackageNameOption.class)).getPackageName());
        KnowledgeBuilderConfigurationTest.assertEquals((String)"org.test", (String)this.config.getProperty("drools.defaultPackageName"));
        this.config.setProperty("drools.defaultPackageName", "org.drools");
        KnowledgeBuilderConfigurationTest.assertEquals((Object)DefaultPackageNameOption.get((String)"org.drools"), (Object)this.config.getOption(DefaultPackageNameOption.class));
        KnowledgeBuilderConfigurationTest.assertEquals((String)"org.drools", (String)((DefaultPackageNameOption)this.config.getOption(DefaultPackageNameOption.class)).getPackageName());
        KnowledgeBuilderConfigurationTest.assertEquals((String)"org.drools", (String)this.config.getProperty("drools.defaultPackageName"));
    }

    public static class InnerAccumulateFuncion
    implements AccumulateFunction {
        public void accumulate(Serializable context, Object value) {
        }

        public Serializable createContext() {
            return null;
        }

        public Object getResult(Serializable context) throws Exception {
            return null;
        }

        public void init(Serializable context) throws Exception {
        }

        public void reverse(Serializable context, Object value) throws Exception {
        }

        public boolean supportsReverse() {
            return false;
        }
    }
}

