/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.Cheese;
import org.drools.DroolsTestCase;
import org.drools.FactHandle;
import org.drools.Primitives;
import org.drools.QueryResults;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.StockTick;
import org.drools.WorkingMemory;
import org.drools.base.ClassObjectType;
import org.drools.base.DefaultKnowledgeHelper;
import org.drools.common.ActivationGroupNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.LogicalDependency;
import org.drools.common.RuleFlowGroupNode;
import org.drools.commons.jci.compilers.EclipseJavaCompiler;
import org.drools.commons.jci.compilers.JaninoJavaCompiler;
import org.drools.commons.jci.compilers.JavaCompiler;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.ParserError;
import org.drools.facttemplates.Fact;
import org.drools.integrationtests.SerializationHelper;
import org.drools.io.Resource;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.BehaviorDescr;
import org.drools.lang.descr.ConditionalElementDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.FactTemplateDescr;
import org.drools.lang.descr.FieldBindingDescr;
import org.drools.lang.descr.FieldConstraintDescr;
import org.drools.lang.descr.FieldTemplateDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.LiteralRestrictionDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.RestrictionDescr;
import org.drools.lang.descr.ReturnValueRestrictionDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.lang.descr.SlidingWindowDescr;
import org.drools.lang.descr.TypeDeclarationDescr;
import org.drools.lang.descr.TypeFieldDescr;
import org.drools.lang.descr.VariableRestrictionDescr;
import org.drools.process.core.Context;
import org.drools.process.core.Process;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.rule.Behavior;
import org.drools.rule.CompositeClassLoader;
import org.drools.rule.Declaration;
import org.drools.rule.EvalCondition;
import org.drools.rule.GroupElement;
import org.drools.rule.JavaDialectRuntimeData;
import org.drools.rule.LiteralConstraint;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.PredicateConstraint;
import org.drools.rule.ReturnValueConstraint;
import org.drools.rule.Rule;
import org.drools.rule.SlidingTimeWindow;
import org.drools.rule.TypeDeclaration;
import org.drools.rule.builder.dialect.java.JavaDialectConfiguration;
import org.drools.spi.Activation;
import org.drools.spi.AgendaGroup;
import org.drools.spi.CompiledInvoker;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.PropagationContext;
import org.drools.spi.Tuple;
import org.drools.util.DroolsStreamUtils;
import org.drools.util.LinkedList;
import org.drools.workflow.core.impl.WorkflowProcessImpl;

public class PackageBuilderTest
extends DroolsTestCase {
    public void testErrors() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr pattern = new PatternDescr(Cheese.class.getName(), "stilton");
        lhs.addDescr((BaseDescr)pattern);
        FieldBindingDescr fieldBindingDescr = new FieldBindingDescr("price", "x");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        fieldBindingDescr = new FieldBindingDescr("price", "y");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        packageDescr.addGlobal(new GlobalDescr("map", "java.util.Map"));
        FieldConstraintDescr returnValue = new FieldConstraintDescr("price");
        returnValue.addRestriction((RestrictionDescr)new ReturnValueRestrictionDescr("==", (Object)"x"));
        pattern.addConstraint((BaseDescr)returnValue);
        ruleDescr.setConsequence((Object)"update(m);");
        builder.addPackage(packageDescr);
        this.assertLength(1, builder.getErrors().getErrors());
    }

    public void testErrorsInParser() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("bad_rule.drl")));
        PackageBuilderTest.assertTrue((boolean)builder.hasErrors());
    }

    public void testReload() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        packageDescr.addGlobal(new GlobalDescr("map", "java.util.Map"));
        ruleDescr.setConsequence((Object)"map.put(\"value\", new Integer(1) );");
        builder.addPackage(packageDescr);
        Package pkg = builder.getPackage();
        Rule rule = pkg.getRule("rule-1");
        this.assertLength(0, builder.getErrors().getErrors());
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        ruleBase.getGlobals().put("map", Map.class);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        HashMap map = new HashMap();
        workingMemory.setGlobal("map", map);
        MockTuple tuple = new MockTuple(new HashMap());
        MockActivation activation = new MockActivation(rule, 0, rule.getLhs(), tuple);
        DefaultKnowledgeHelper knowledgeHelper = new DefaultKnowledgeHelper((WorkingMemory)workingMemory);
        knowledgeHelper.setActivation((Activation)activation);
        rule.getConsequence().evaluate((KnowledgeHelper)knowledgeHelper, (WorkingMemory)workingMemory);
        PackageBuilderTest.assertEquals((Object)new Integer(1), map.get("value"));
        ruleDescr.setConsequence((Object)"map.put(\"value\", new Integer(2) );");
        pkg.removeRule(rule);
        PackageBuilderTest.assertEquals((int)0, (int)((JavaDialectRuntimeData)pkg.getDialectRuntimeRegistry().getDialectData("java")).list().length);
        builder.addPackage(packageDescr);
        pkg = builder.getPackage();
        rule = pkg.getRule("rule-1");
        knowledgeHelper = new DefaultKnowledgeHelper((WorkingMemory)workingMemory);
        knowledgeHelper.setActivation((Activation)activation);
        rule.getConsequence().evaluate((KnowledgeHelper)knowledgeHelper, (WorkingMemory)workingMemory);
        PackageBuilderTest.assertEquals((Object)new Integer(2), map.get("value"));
    }

    public void testSerializable() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        packageDescr.addGlobal(new GlobalDescr("map", "java.util.Map"));
        ruleDescr.setConsequence((Object)"map.put(\"value\", new Integer(1) );");
        PackageDescr back = SerializationHelper.serializeObject(packageDescr);
        PackageBuilderTest.assertNotNull((Object)back);
        PackageBuilderTest.assertEquals((String)"p1", (String)back.getName());
        builder.addPackage(packageDescr);
        Package pkg = builder.getPackage();
        Rule rule = pkg.getRule("rule-1");
        this.assertLength(0, builder.getErrors().getErrors());
        Package newPkg = SerializationHelper.serializeObject(pkg);
        Rule newRule = newPkg.getRule("rule-1");
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        newPkg.getDialectRuntimeRegistry().onAdd(ruleBase.getRootClassLoader());
        newPkg.getDialectRuntimeRegistry().onBeforeExecute();
        ruleBase.getGlobals().put("map", Map.class);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        HashMap map = new HashMap();
        workingMemory.setGlobal("map", map);
        MockTuple tuple = new MockTuple(new HashMap());
        MockActivation activation = new MockActivation(newRule, 0, newRule.getLhs(), tuple);
        DefaultKnowledgeHelper knowledgeHelper = new DefaultKnowledgeHelper((WorkingMemory)workingMemory);
        knowledgeHelper.setActivation((Activation)activation);
        newRule.getConsequence().evaluate((KnowledgeHelper)knowledgeHelper, (WorkingMemory)workingMemory);
        PackageBuilderTest.assertEquals((Object)new Integer(1), map.get("value"));
    }

    public void FIXMEtestNoPackageName() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        try {
            builder.addPackage(new PackageDescr(null));
            PackageBuilderTest.fail((String)"should have errored here.");
        }
        catch (RuntimeException e) {
            PackageBuilderTest.assertNotNull((Object)e.getMessage());
        }
        try {
            builder.addPackage(new PackageDescr(""));
            PackageBuilderTest.fail((String)"should have errored here.");
        }
        catch (RuntimeException e) {
            PackageBuilderTest.assertNotNull((Object)e.getMessage());
        }
        builder.addPackageFromDrl((Reader)new StringReader("package foo"));
        builder.addPackageFromDrl((Reader)new StringReader("rule x then end"));
    }

    public void testErrorReset() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader("package foo \n rule ORB"));
        PackageBuilderTest.assertTrue((boolean)builder.hasErrors());
        builder.resetErrors();
        PackageBuilderTest.assertFalse((boolean)builder.hasErrors());
        builder.addPackageFromDrl((Reader)new StringReader("package foo \n rule ORB"));
        PackageBuilderTest.assertTrue((boolean)builder.hasErrors());
    }

    public void testFactTemplate() {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        FactTemplateDescr cheese = new FactTemplateDescr("Cheese");
        cheese.addFieldTemplate(new FieldTemplateDescr("name", "String"));
        cheese.addFieldTemplate(new FieldTemplateDescr("price", "Integer"));
        packageDescr.addFactTemplate(cheese);
        PatternDescr pattern = new PatternDescr("Cheese", "stilton");
        lhs.addDescr((BaseDescr)pattern);
        FieldConstraintDescr literalDescr = new FieldConstraintDescr("name");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", "stilton"));
        pattern.addConstraint((BaseDescr)literalDescr);
        ruleDescr.setConsequence((Object)"String result = stilton.getFieldValue( \"name\" ) + \" \" + stilton.getFieldValue( \"price\" );");
        builder.addPackage(packageDescr);
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        Package pkg = builder.getPackage();
        try {
            ruleBase.addPackage(pkg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Fact stilton = pkg.getFactTemplate("Cheese").createFact(1L);
        stilton.setFieldValue("name", (Object)"stilton");
        stilton.setFieldValue("price", (Object)new Integer(200));
        workingMemory.insert((Object)stilton);
        workingMemory.fireAllRules();
    }

    public void testLiteral() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr pattern = new PatternDescr(Cheese.class.getName(), "stilton");
        lhs.addDescr((BaseDescr)pattern);
        FieldConstraintDescr literalDescr = new FieldConstraintDescr("type");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", "stilton"));
        pattern.addConstraint((BaseDescr)literalDescr);
        ruleDescr.setConsequence((Object)"update(stilton);");
        builder.addPackage(packageDescr);
        this.assertLength(0, builder.getErrors().getErrors());
    }

    public void testReturnValue() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr pattern = new PatternDescr(Cheese.class.getName(), "stilton");
        lhs.addDescr((BaseDescr)pattern);
        FieldBindingDescr fieldBindingDescr = new FieldBindingDescr("price", "x");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        fieldBindingDescr = new FieldBindingDescr("price", "y");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        packageDescr.addGlobal(new GlobalDescr("map", "java.util.Map"));
        FieldConstraintDescr returnValue = new FieldConstraintDescr("price");
        returnValue.addRestriction((RestrictionDescr)new ReturnValueRestrictionDescr("==", (Object)"(( (Integer) map.get( new Integer( x )) ).intValue() * y)"));
        pattern.addConstraint((BaseDescr)returnValue);
        ruleDescr.setConsequence((Object)"update(stilton);");
        builder.addPackage(packageDescr);
        PackageBuilderTest.assertEquals((String)"Should not have any errors", (int)0, (int)builder.getErrors().getErrors().length);
    }

    public void testReturnValueMethodCompare() {
        PackageBuilder builder1 = new PackageBuilder();
        PackageDescr packageDescr1 = new PackageDescr("package1");
        this.createReturnValueRule(packageDescr1, " x + y ");
        builder1.addPackage(packageDescr1);
        Pattern pattern1 = (Pattern)builder1.getPackage().getRules()[0].getLhs().getChildren().get(0);
        ReturnValueConstraint returnValue1 = (ReturnValueConstraint)pattern1.getConstraints().get(2);
        PackageBuilder builder2 = new PackageBuilder();
        PackageDescr packageDescr2 = new PackageDescr("package2");
        this.createReturnValueRule(packageDescr2, " x + y ");
        builder2.addPackage(packageDescr2);
        Pattern pattern2 = (Pattern)builder2.getPackage().getRules()[0].getLhs().getChildren().get(0);
        ReturnValueConstraint returnValue2 = (ReturnValueConstraint)pattern2.getConstraints().get(2);
        PackageBuilder builder3 = new PackageBuilder();
        PackageDescr packageDescr3 = new PackageDescr("package3");
        this.createReturnValueRule(packageDescr3, " x - y ");
        builder3.addPackage(packageDescr3);
        Pattern pattern3 = (Pattern)builder3.getPackage().getRules()[0].getLhs().getChildren().get(0);
        ReturnValueConstraint returnValue3 = (ReturnValueConstraint)pattern3.getConstraints().get(2);
        PackageBuilderTest.assertEquals((Object)returnValue1, (Object)returnValue2);
        PackageBuilderTest.assertFalse((boolean)returnValue1.equals((Object)returnValue3));
        PackageBuilderTest.assertFalse((boolean)returnValue2.equals((Object)returnValue3));
    }

    public void testPredicate() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr pattern = new PatternDescr(Cheese.class.getName(), "stilton");
        lhs.addDescr((BaseDescr)pattern);
        FieldBindingDescr fieldBindingDescr = new FieldBindingDescr("price", "x");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        FieldBindingDescr fieldBindingDescr2 = new FieldBindingDescr("price", "y");
        pattern.addConstraint((BaseDescr)fieldBindingDescr2);
        packageDescr.addGlobal(new GlobalDescr("map", "java.util.Map"));
        PredicateDescr predicate = new PredicateDescr((Object)"( ( Integer )map.get( new Integer(x) ) ).intValue() == y");
        pattern.addConstraint((BaseDescr)predicate);
        ruleDescr.setConsequence((Object)"update(stilton);");
        builder.addPackage(packageDescr);
        this.assertLength(0, builder.getErrors().getErrors());
    }

    public void testPredicateMethodCompare() {
        PackageBuilder builder1 = new PackageBuilder();
        PackageDescr packageDescr1 = new PackageDescr("package1");
        this.createPredicateRule(packageDescr1, "x==y");
        builder1.addPackage(packageDescr1);
        Pattern pattern1 = (Pattern)builder1.getPackage().getRules()[0].getLhs().getChildren().get(0);
        PredicateConstraint predicate1 = (PredicateConstraint)pattern1.getConstraints().get(2);
        PackageBuilder builder2 = new PackageBuilder();
        PackageDescr packageDescr2 = new PackageDescr("package2");
        this.createPredicateRule(packageDescr2, "x==y");
        builder2.addPackage(packageDescr2);
        Pattern pattern2 = (Pattern)builder2.getPackage().getRules()[0].getLhs().getChildren().get(0);
        PredicateConstraint predicate2 = (PredicateConstraint)pattern2.getConstraints().get(2);
        PackageBuilder builder3 = new PackageBuilder();
        PackageDescr packageDescr3 = new PackageDescr("package3");
        this.createPredicateRule(packageDescr3, "x!=y");
        builder3.addPackage(packageDescr3);
        Pattern pattern3 = (Pattern)builder3.getPackage().getRules()[0].getLhs().getChildren().get(0);
        PredicateConstraint predicate3 = (PredicateConstraint)pattern3.getConstraints().get(2);
        PackageBuilderTest.assertEquals((Object)predicate1, (Object)predicate2);
        PackageBuilderTest.assertFalse((boolean)predicate1.equals((Object)predicate3));
        PackageBuilderTest.assertFalse((boolean)predicate2.equals((Object)predicate3));
    }

    public void testEval() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr pattern = new PatternDescr(Cheese.class.getName(), "stilton");
        lhs.addDescr((BaseDescr)pattern);
        FieldBindingDescr fieldBindingDescr = new FieldBindingDescr("price", "x");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        fieldBindingDescr = new FieldBindingDescr("price", "y");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        packageDescr.addGlobal(new GlobalDescr("map", "java.util.Map"));
        EvalDescr evalDescr = new EvalDescr((Object)"( ( Integer )map.get( new Integer(x) ) ).intValue() == y");
        lhs.addDescr((BaseDescr)evalDescr);
        ruleDescr.setConsequence((Object)"update(stilton);");
        builder.addPackage(packageDescr);
        this.assertLength(0, builder.getErrors().getErrors());
        Package pkg = builder.getPackage();
        Rule rule = pkg.getRule("rule-1");
        EvalCondition eval = (EvalCondition)rule.getLhs().getChildren().get(1);
        CompiledInvoker invoker = (CompiledInvoker)eval.getEvalExpression();
        List list = invoker.getMethodBytecode();
    }

    public void testEvalMethodCompare() {
        PackageBuilder builder1 = new PackageBuilder();
        PackageDescr packageDescr1 = new PackageDescr("package1");
        this.createEvalRule(packageDescr1, "1==1");
        builder1.addPackage(packageDescr1);
        EvalCondition eval1 = (EvalCondition)builder1.getPackage().getRules()[0].getLhs().getChildren().get(0);
        PackageBuilder builder2 = new PackageBuilder();
        PackageDescr packageDescr2 = new PackageDescr("package2");
        this.createEvalRule(packageDescr2, "1==1");
        builder2.addPackage(packageDescr2);
        EvalCondition eval2 = (EvalCondition)builder2.getPackage().getRules()[0].getLhs().getChildren().get(0);
        PackageBuilder builder3 = new PackageBuilder();
        PackageDescr packageDescr3 = new PackageDescr("package3");
        this.createEvalRule(packageDescr3, "1==3");
        builder3.addPackage(packageDescr3);
        EvalCondition eval3 = (EvalCondition)builder3.getPackage().getRules()[0].getLhs().getChildren().get(0);
        PackageBuilderTest.assertEquals((Object)eval1, (Object)eval2);
        PackageBuilderTest.assertFalse((boolean)eval1.equals((Object)eval3));
        PackageBuilderTest.assertFalse((boolean)eval2.equals((Object)eval3));
    }

    public void testOr() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        Rule rule = this.createRule((ConditionalElementDescr)new OrDescr(), builder, "update(stilton);");
        this.assertLength(0, builder.getErrors().getErrors());
        GroupElement lhs = rule.getLhs();
        this.assertLength(1, lhs.getChildren());
        GroupElement or = (GroupElement)lhs.getChildren().get(0);
        this.assertLength(1, or.getChildren());
        Pattern pattern = (Pattern)or.getChildren().get(0);
        LiteralConstraint literalConstarint = (LiteralConstraint)pattern.getConstraints().get(0);
    }

    public void testAnd() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        Rule rule = this.createRule((ConditionalElementDescr)new AndDescr(), builder, "update(stilton);");
        this.assertLength(0, builder.getErrors().getErrors());
        GroupElement lhs = rule.getLhs();
        this.assertLength(1, lhs.getChildren());
        GroupElement and = (GroupElement)lhs.getChildren().get(0);
        this.assertLength(1, and.getChildren());
        Pattern pattern = (Pattern)and.getChildren().get(0);
        LiteralConstraint literalConstraint = (LiteralConstraint)pattern.getConstraints().get(0);
    }

    public void testNot() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        Rule rule = this.createRule((ConditionalElementDescr)new NotDescr(), builder, "update(stilton);");
        PackageBuilderTest.assertEquals((int)1, (int)builder.getErrors().getErrors().length);
        builder = new PackageBuilder();
        rule = this.createRule((ConditionalElementDescr)new NotDescr(), builder, "");
        PackageBuilderTest.assertEquals((int)0, (int)builder.getErrors().getErrors().length);
        GroupElement lhs = rule.getLhs();
        this.assertLength(1, lhs.getChildren());
        GroupElement not = (GroupElement)lhs.getChildren().get(0);
        this.assertLength(1, not.getChildren());
        Pattern pattern = (Pattern)not.getChildren().get(0);
        LiteralConstraint literalConstarint = (LiteralConstraint)pattern.getConstraints().get(0);
    }

    public void testExists() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        Rule rule = this.createRule((ConditionalElementDescr)new ExistsDescr(), builder, "update(stilton);");
        PackageBuilderTest.assertEquals((int)1, (int)builder.getErrors().getErrors().length);
        builder = new PackageBuilder();
        rule = this.createRule((ConditionalElementDescr)new ExistsDescr(), builder, "");
        PackageBuilderTest.assertEquals((int)0, (int)builder.getErrors().getErrors().length);
        GroupElement lhs = rule.getLhs();
        this.assertLength(1, lhs.getChildren());
        GroupElement exists = (GroupElement)lhs.getChildren().get(0);
        this.assertLength(1, exists.getChildren());
        Pattern pattern = (Pattern)exists.getChildren().get(0);
        LiteralConstraint literalConstarint = (LiteralConstraint)pattern.getConstraints().get(0);
    }

    public void testNumbers() throws Exception {
        FieldConstraintDescr literalDescr = new FieldConstraintDescr("booleanPrimitive");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", "true"));
        this.createLiteralRule(literalDescr);
        literalDescr = new FieldConstraintDescr("booleanPrimitive");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", "false"));
        this.createLiteralRule(literalDescr);
        literalDescr = new FieldConstraintDescr("charPrimitive");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", "a"));
        this.createLiteralRule(literalDescr);
        literalDescr = new FieldConstraintDescr("bytePrimitive");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", "1"));
        this.createLiteralRule(literalDescr);
        literalDescr = new FieldConstraintDescr("bytePrimitive");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", "0"));
        this.createLiteralRule(literalDescr);
        literalDescr = new FieldConstraintDescr("bytePrimitive");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", "-1"));
        this.createLiteralRule(literalDescr);
        literalDescr = new FieldConstraintDescr("shortPrimitive");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", "1"));
        this.createLiteralRule(literalDescr);
        literalDescr = new FieldConstraintDescr("shortPrimitive");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", "0"));
        this.createLiteralRule(literalDescr);
        literalDescr = new FieldConstraintDescr("shortPrimitive");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", "-1"));
        this.createLiteralRule(literalDescr);
        literalDescr = new FieldConstraintDescr("intPrimitive");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", "1"));
        this.createLiteralRule(literalDescr);
        literalDescr = new FieldConstraintDescr("intPrimitive");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", "0"));
        this.createLiteralRule(literalDescr);
        literalDescr = new FieldConstraintDescr("intPrimitive");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", "-1"));
        this.createLiteralRule(literalDescr);
        literalDescr = new FieldConstraintDescr("longPrimitive");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", "1"));
        this.createLiteralRule(literalDescr);
        literalDescr = new FieldConstraintDescr("longPrimitive");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", "0"));
        this.createLiteralRule(literalDescr);
        literalDescr = new FieldConstraintDescr("longPrimitive");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", "0"));
        this.createLiteralRule(literalDescr);
        literalDescr = new FieldConstraintDescr("floatPrimitive");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", "1.1"));
        this.createLiteralRule(literalDescr);
        literalDescr = new FieldConstraintDescr("floatPrimitive");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", "0"));
        this.createLiteralRule(literalDescr);
        literalDescr = new FieldConstraintDescr("floatPrimitive");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", "-1.1"));
        this.createLiteralRule(literalDescr);
        literalDescr = new FieldConstraintDescr("doublePrimitive");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", "1.1"));
        this.createLiteralRule(literalDescr);
        literalDescr = new FieldConstraintDescr("doublePrimitive");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", "0"));
        this.createLiteralRule(literalDescr);
        literalDescr = new FieldConstraintDescr("floatPrimitive");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", "-1.1"));
        this.createLiteralRule(literalDescr);
    }

    public void testNull() {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr patternDescr = new PatternDescr(Cheese.class.getName(), "stilton");
        FieldConstraintDescr literalDescr = new FieldConstraintDescr("type");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", null));
        patternDescr.addConstraint((BaseDescr)literalDescr);
        ruleDescr.setConsequence((Object)"");
        builder.addPackage(packageDescr);
        Package pkg = builder.getPackage();
        Rule rule = pkg.getRule("rule-1");
        this.assertLength(0, builder.getErrors().getErrors());
    }

    public void testQuery() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr = new PackageDescr("p1");
        QueryDescr queryDescr = new QueryDescr("query1");
        queryDescr.setParameters(new String[]{"$type"});
        queryDescr.setParameterTypes(new String[]{"String"});
        packageDescr.addRule((RuleDescr)queryDescr);
        AndDescr lhs = new AndDescr();
        queryDescr.setLhs(lhs);
        PatternDescr pattern = new PatternDescr(Cheese.class.getName(), "stilton");
        lhs.addDescr((BaseDescr)pattern);
        FieldConstraintDescr literalDescr = new FieldConstraintDescr("type");
        literalDescr.addRestriction((RestrictionDescr)new VariableRestrictionDescr("==", "$type"));
        pattern.addConstraint((BaseDescr)literalDescr);
        queryDescr.setConsequence((Object)"update(stilton);");
        builder.addPackage(packageDescr);
        this.assertLength(0, builder.getErrors().getErrors());
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(builder.getPackage());
        StatefulSession session = ruleBase.newStatefulSession();
        session.insert((Object)new Cheese("stilton", 15));
        QueryResults results = session.getQueryResults("query1", new Object[]{"stilton"});
        PackageBuilderTest.assertEquals((int)1, (int)results.size());
        Object object = results.get(0).get(0);
        PackageBuilderTest.assertEquals((Object)new Cheese("stilton", 15), (Object)object);
        results = session.getQueryResults("query1", new Object[]{"cheddar"});
    }

    public void testDuplicateRuleNames() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr patternDescr = new PatternDescr(Cheese.class.getName(), "stilton");
        FieldConstraintDescr literalDescr = new FieldConstraintDescr("type");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", null));
        patternDescr.addConstraint((BaseDescr)literalDescr);
        ruleDescr.setConsequence((Object)"");
        ruleDescr = new RuleDescr("rule-1");
        ruleDescr.setLocation(42, 43);
        packageDescr.addRule(ruleDescr);
        lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        patternDescr = new PatternDescr(Cheese.class.getName(), "stilton");
        literalDescr = new FieldConstraintDescr("type");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("!=", null));
        patternDescr.addConstraint((BaseDescr)literalDescr);
        ruleDescr.setConsequence((Object)"");
        ruleDescr = new RuleDescr("rule-2");
        ruleDescr.setLocation(42, 43);
        packageDescr.addRule(ruleDescr);
        lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        patternDescr = new PatternDescr(Cheese.class.getName(), "stilton");
        literalDescr = new FieldConstraintDescr("type");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("!=", null));
        patternDescr.addConstraint((BaseDescr)literalDescr);
        ruleDescr.setConsequence((Object)"");
        builder.addPackage(packageDescr);
        this.assertLength(1, builder.getErrors().getErrors());
        ParserError err = (ParserError)builder.getErrors().getErrors()[0];
        PackageBuilderTest.assertEquals((int)42, (int)err.getRow());
        PackageBuilderTest.assertEquals((int)43, (int)err.getCol());
    }

    public void testDuplicateDeclaration() {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr pattern1 = new PatternDescr(Cheese.class.getName());
        lhs.addDescr((BaseDescr)pattern1);
        FieldBindingDescr fieldBindingDescr = new FieldBindingDescr("type", "$type");
        FieldConstraintDescr literalDescr = new FieldConstraintDescr("type");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", "stilton"));
        pattern1.addConstraint((BaseDescr)fieldBindingDescr);
        pattern1.addConstraint((BaseDescr)literalDescr);
        PatternDescr pattern2 = new PatternDescr(Cheese.class.getName());
        lhs.addDescr((BaseDescr)pattern2);
        pattern2.addConstraint((BaseDescr)fieldBindingDescr);
        ruleDescr.setConsequence((Object)"update(stilton);");
        builder.addPackage(packageDescr);
        this.assertLength(2, builder.getErrors().getErrors());
    }

    public void testCompilerConfiguration() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr pkgDescr = new PackageDescr("org.test");
        builder.addPackage(pkgDescr);
        DialectCompiletimeRegistry reg = builder.getPackageRegistry(pkgDescr.getName()).getDialectCompiletimeRegistry();
        Field dialectField = builder.getClass().getDeclaredField("defaultDialect");
        dialectField.setAccessible(true);
        String dialectName = (String)dialectField.get(builder);
        reg = builder.getPackageRegistry(pkgDescr.getName()).getDialectCompiletimeRegistry();
        Dialect dialect = reg.getDialect(dialectName);
        Field compilerField = dialect.getClass().getDeclaredField("compiler");
        compilerField.setAccessible(true);
        JavaCompiler compiler = (JavaCompiler)compilerField.get(dialect);
        PackageBuilderTest.assertSame(EclipseJavaCompiler.class, compiler.getClass());
        PackageBuilderConfiguration conf = new PackageBuilderConfiguration();
        JavaDialectConfiguration javaConf = (JavaDialectConfiguration)conf.getDialectConfiguration("java");
        javaConf.setCompiler(1);
        builder = new PackageBuilder(conf);
        builder.addPackage(pkgDescr);
        dialectName = (String)dialectField.get(builder);
        reg = builder.getPackageRegistry(pkgDescr.getName()).getDialectCompiletimeRegistry();
        dialect = reg.getDialect(dialectName);
        compiler = (JavaCompiler)compilerField.get(dialect);
        PackageBuilderTest.assertSame(JaninoJavaCompiler.class, compiler.getClass());
        conf = new PackageBuilderConfiguration();
        javaConf = (JavaDialectConfiguration)conf.getDialectConfiguration("java");
        javaConf.setCompiler(0);
        builder = new PackageBuilder(conf);
        builder.addPackage(pkgDescr);
        dialectName = (String)dialectField.get(builder);
        reg = builder.getPackageRegistry(pkgDescr.getName()).getDialectCompiletimeRegistry();
        dialect = reg.getDialect(dialectName);
        compiler = (JavaCompiler)compilerField.get(dialect);
        PackageBuilderTest.assertSame(EclipseJavaCompiler.class, compiler.getClass());
    }

    public void testTypeDeclaration() throws Exception {
        PackageDescr pkgDescr = new PackageDescr("org.test");
        TypeDeclarationDescr typeDescr = new TypeDeclarationDescr("StockTick");
        typeDescr.addMetaAttribute("role", "event");
        typeDescr.addMetaAttribute("class", "org.drools.StockTick");
        pkgDescr.addTypeDeclaration(typeDescr);
        PackageBuilder builder = new PackageBuilder();
        builder.addPackage(pkgDescr);
        Package pkg = builder.getPackage();
        PackageBuilderTest.assertEquals((int)1, (int)pkg.getTypeDeclarations().size());
        TypeDeclaration type = pkg.getTypeDeclaration("StockTick");
        PackageBuilderTest.assertEquals((String)"StockTick", (String)type.getTypeName());
        PackageBuilderTest.assertEquals((Object)TypeDeclaration.Role.EVENT, (Object)type.getRole());
        PackageBuilderTest.assertEquals(StockTick.class, (Object)type.getTypeClass());
    }

    public void testTypeDeclarationNewBean() throws Exception {
        PackageDescr pkgDescr = new PackageDescr("org.test");
        TypeDeclarationDescr typeDescr = new TypeDeclarationDescr("NewBean");
        TypeFieldDescr f1 = new TypeFieldDescr("name", new PatternDescr("String"));
        TypeFieldDescr f2 = new TypeFieldDescr("age", new PatternDescr("int"));
        typeDescr.addField(f1);
        typeDescr.addField(f2);
        pkgDescr.addTypeDeclaration(typeDescr);
        PackageBuilder builder = new PackageBuilder();
        builder.addPackage(pkgDescr);
        Package pkg = builder.getPackage();
        PackageBuilderTest.assertEquals((int)1, (int)pkg.getTypeDeclarations().size());
        TypeDeclaration type = pkg.getTypeDeclaration("NewBean");
        PackageBuilderTest.assertEquals((String)"NewBean", (String)type.getTypeName());
        PackageBuilderTest.assertEquals((Object)TypeDeclaration.Role.FACT, (Object)type.getRole());
        PackageBuilderTest.assertEquals((String)"org.test.NewBean", (String)type.getTypeClass().getName());
        PackageBuilderTest.assertFalse((boolean)builder.hasErrors());
        Package bp = builder.getPackage();
        CompositeClassLoader rootClassloader = new CompositeClassLoader(Thread.currentThread().getContextClassLoader());
        JavaDialectRuntimeData dialectData = (JavaDialectRuntimeData)bp.getDialectRuntimeRegistry().getDialectData("java");
        dialectData.onAdd(bp.getDialectRuntimeRegistry(), rootClassloader);
        Class newBean = rootClassloader.loadClass("org.test.NewBean");
        PackageBuilderTest.assertNotNull((Object)newBean);
    }

    public void testPackageMerge() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        try {
            builder.addPackage(new PackageDescr("org.drools"));
            builder.addPackageFromDrl((Reader)new StringReader("package org.drools\nfunction boolean testIt() {\n  return true;\n}\n"));
        }
        catch (RuntimeException e) {
            PackageBuilderTest.fail((String)("Should not raise any exception: " + e.getMessage()));
        }
    }

    private void createReturnValueRule(PackageDescr packageDescr, String expression) {
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr pattern = new PatternDescr(Cheese.class.getName(), "stilton");
        lhs.addDescr((BaseDescr)pattern);
        FieldBindingDescr fieldBindingDescr = new FieldBindingDescr("price", "x");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        fieldBindingDescr = new FieldBindingDescr("price", "y");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        packageDescr.addGlobal(new GlobalDescr("map", "java.util.Map"));
        FieldConstraintDescr returnValue = new FieldConstraintDescr("price");
        returnValue.addRestriction((RestrictionDescr)new ReturnValueRestrictionDescr("==", (Object)expression));
        pattern.addConstraint((BaseDescr)returnValue);
        ruleDescr.setConsequence((Object)"update(stilton);");
    }

    private void createPredicateRule(PackageDescr packageDescr, String expression) {
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr pattern = new PatternDescr(Cheese.class.getName(), "stilton");
        lhs.addDescr((BaseDescr)pattern);
        FieldBindingDescr fieldBindingDescr = new FieldBindingDescr("price", "x");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        FieldBindingDescr fieldBindingDescr2 = new FieldBindingDescr("price", "y");
        pattern.addConstraint((BaseDescr)fieldBindingDescr2);
        packageDescr.addGlobal(new GlobalDescr("map", "java.util.Map"));
        PredicateDescr predicate = new PredicateDescr((Object)expression);
        pattern.addConstraint((BaseDescr)predicate);
        ruleDescr.setConsequence((Object)"update(stilton);");
    }

    private void createEvalRule(PackageDescr packageDescr, String expression) {
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        packageDescr.addGlobal(new GlobalDescr("map", "java.util.Map"));
        EvalDescr evalDescr = new EvalDescr((Object)expression);
        lhs.addDescr((BaseDescr)evalDescr);
        ruleDescr.setConsequence((Object)"");
    }

    private void createLiteralRule(FieldConstraintDescr literalDescr) {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr pattern = new PatternDescr(Primitives.class.getName());
        lhs.addDescr((BaseDescr)pattern);
        pattern.addConstraint((BaseDescr)literalDescr);
        ruleDescr.setConsequence((Object)"");
        builder.addPackage(packageDescr);
        this.assertLength(0, builder.getErrors().getErrors());
    }

    private Rule createRule(ConditionalElementDescr ceDescr, PackageBuilder builder, String consequence) throws Exception {
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        lhs.addDescr((BaseDescr)ceDescr);
        PatternDescr patternDescr = new PatternDescr(Cheese.class.getName(), "stilton");
        FieldConstraintDescr literalDescr = new FieldConstraintDescr("type");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", "stilton"));
        patternDescr.addConstraint((BaseDescr)literalDescr);
        ceDescr.addDescr((BaseDescr)patternDescr);
        ruleDescr.setConsequence((Object)consequence);
        builder.addPackage(packageDescr);
        Package pkg = builder.getPackage();
        Rule rule = pkg.getRule("rule-1");
        PackageBuilderTest.assertEquals((String)"rule-1", (String)rule.getName());
        return rule;
    }

    public void testRuleFlow() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/org/drools/integrationtests/ruleflow.rfm");
        PackageBuilderTest.assertNotNull((Object)in);
        builder.addPackage(new PackageDescr("com.sample"));
        builder.addRuleFlow((Reader)new InputStreamReader(in));
        Package pkg = builder.getPackage();
        PackageBuilderTest.assertNotNull((Object)pkg);
        Map flows = pkg.getRuleFlows();
        PackageBuilderTest.assertNotNull((Object)flows);
        PackageBuilderTest.assertEquals((int)1, (int)flows.size());
        PackageBuilderTest.assertTrue((boolean)flows.containsKey("0"));
        Process p = (Process)flows.get("0");
        PackageBuilderTest.assertTrue((boolean)(p instanceof WorkflowProcessImpl));
        Package pkg2 = (Package)DroolsStreamUtils.streamIn((byte[])DroolsStreamUtils.streamOut((Object)pkg));
        PackageBuilderTest.assertNotNull((Object)pkg2);
        flows = pkg2.getRuleFlows();
        PackageBuilderTest.assertNotNull((Object)flows);
        PackageBuilderTest.assertEquals((int)1, (int)flows.size());
        PackageBuilderTest.assertTrue((boolean)flows.containsKey("0"));
        p = (Process)flows.get("0");
        PackageBuilderTest.assertTrue((boolean)(p instanceof WorkflowProcessImpl));
    }

    public void testRuleFlowUpgrade() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        System.setProperty("drools.ruleflow.port", "true");
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/org/drools/integrationtests/ruleflow40.rfm");
        PackageBuilderTest.assertNotNull((Object)in);
        builder.addPackage(new PackageDescr("com.sample"));
        builder.addRuleFlow((Reader)new InputStreamReader(in));
        Package pkg = builder.getPackage();
        PackageBuilderTest.assertNotNull((Object)pkg);
        Map flows = pkg.getRuleFlows();
        PackageBuilderTest.assertNotNull((Object)flows);
        PackageBuilderTest.assertEquals((int)1, (int)flows.size());
        PackageBuilderTest.assertTrue((boolean)flows.containsKey("0"));
        Process p = (Process)flows.get("0");
        PackageBuilderTest.assertTrue((boolean)(p instanceof WorkflowProcessImpl));
        Package pkg2 = (Package)DroolsStreamUtils.streamIn((byte[])DroolsStreamUtils.streamOut((Object)pkg));
        PackageBuilderTest.assertNotNull((Object)pkg2);
        flows = pkg2.getRuleFlows();
        PackageBuilderTest.assertNotNull((Object)flows);
        PackageBuilderTest.assertEquals((int)1, (int)flows.size());
        PackageBuilderTest.assertTrue((boolean)flows.containsKey("0"));
        p = (Process)flows.get("0");
        PackageBuilderTest.assertTrue((boolean)(p instanceof WorkflowProcessImpl));
        System.setProperty("drools.ruleflow.port", "false");
    }

    public void testPackageRuleFlows() throws Exception {
        Package pkg = new Package("boo");
        MockRuleFlow rf = new MockRuleFlow("1");
        pkg.addProcess((org.drools.definition.process.Process)rf);
        PackageBuilderTest.assertTrue((boolean)pkg.getRuleFlows().containsKey("1"));
        PackageBuilderTest.assertSame((Object)rf, pkg.getRuleFlows().get("1"));
        MockRuleFlow rf2 = new MockRuleFlow("2");
        pkg.addProcess((org.drools.definition.process.Process)rf2);
        PackageBuilderTest.assertTrue((boolean)pkg.getRuleFlows().containsKey("1"));
        PackageBuilderTest.assertSame((Object)rf, pkg.getRuleFlows().get("1"));
        PackageBuilderTest.assertTrue((boolean)pkg.getRuleFlows().containsKey("2"));
        PackageBuilderTest.assertSame((Object)rf2, pkg.getRuleFlows().get("2"));
        pkg.removeRuleFlow("1");
        PackageBuilderTest.assertTrue((boolean)pkg.getRuleFlows().containsKey("2"));
        PackageBuilderTest.assertSame((Object)rf2, pkg.getRuleFlows().get("2"));
        PackageBuilderTest.assertFalse((boolean)pkg.getRuleFlows().containsKey("1"));
    }

    public void testJaninoWithStaticImports() throws Exception {
        PackageBuilderConfiguration cfg = new PackageBuilderConfiguration();
        JavaDialectConfiguration javaConf = (JavaDialectConfiguration)cfg.getDialectConfiguration("java");
        javaConf.setCompiler(1);
        PackageBuilder bldr = new PackageBuilder(cfg);
        bldr.addPackageFromDrl((Reader)new StringReader("package testBuilderPackageConfig \n import java.util.List"));
        bldr.addPackageFromDrl((Reader)new StringReader("package testBuilderPackageConfig \n function void doSomething() {\n System.err.println(List.class.toString()); }"));
        PackageBuilderTest.assertFalse((boolean)bldr.hasErrors());
    }

    public void testSinglePackage() throws Exception {
        PackageBuilderConfiguration cfg = new PackageBuilderConfiguration();
        cfg.setAllowMultipleNamespaces(false);
        PackageBuilder bldr = new PackageBuilder(cfg);
        bldr.addPackageFromDrl((Reader)new StringReader("package whee\n import org.drools.Cheese"));
        PackageBuilderTest.assertFalse((boolean)bldr.hasErrors());
        bldr.addPackageFromDrl((Reader)new StringReader("package whee\n import org.drools.Person"));
        PackageBuilderTest.assertFalse((boolean)bldr.hasErrors());
        bldr.addPackageFromDrl((Reader)new StringReader("package whee2\n import org.drools.Person"));
        PackageBuilderTest.assertFalse((boolean)bldr.hasErrors());
        PackageBuilderTest.assertEquals((int)1, (int)bldr.getPackages().length);
        cfg = new PackageBuilderConfiguration();
        PackageBuilderTest.assertEquals((boolean)true, (boolean)cfg.isAllowMultipleNamespaces());
        bldr = new PackageBuilder(cfg);
        bldr.addPackageFromDrl((Reader)new StringReader("package whee\n import org.drools.Cheese"));
        PackageBuilderTest.assertFalse((boolean)bldr.hasErrors());
        bldr.addPackageFromDrl((Reader)new StringReader("import org.drools.Person"));
        PackageBuilderTest.assertFalse((boolean)bldr.hasErrors());
        bldr.addPackageFromDrl((Reader)new StringReader("package whee2\n import org.drools.Person"));
        PackageBuilderTest.assertFalse((boolean)bldr.hasErrors());
        PackageBuilderTest.assertEquals((int)3, (int)bldr.getPackages().length);
    }

    public void testTimeWindowBehavior() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr patternDescr = new PatternDescr(StockTick.class.getName(), "$tick");
        SlidingWindowDescr windowDescr = new SlidingWindowDescr("time", "60000");
        patternDescr.addBehavior((BehaviorDescr)windowDescr);
        lhs.addDescr((BaseDescr)patternDescr);
        ruleDescr.setConsequence((Object)"System.out.println( $tick );");
        builder.addPackage(packageDescr);
        this.assertLength(0, builder.getErrors().getErrors());
        Package pkg = builder.getPackage();
        Rule rule = pkg.getRule("rule-1");
        PackageBuilderTest.assertNotNull((Object)rule);
        Pattern pattern = (Pattern)rule.getLhs().getChildren().get(0);
        PackageBuilderTest.assertEquals((String)StockTick.class.getName(), (String)((ClassObjectType)pattern.getObjectType()).getClassType().getName());
        Behavior window = (Behavior)pattern.getBehaviors().get(0);
        PackageBuilderTest.assertEquals((Object)Behavior.BehaviorType.TIME_WINDOW, (Object)window.getType());
        PackageBuilderTest.assertEquals((long)60000L, (long)((SlidingTimeWindow)window).getSize());
    }

    class MockTuple
    implements Tuple {
        private Map declarations;

        public MockTuple(Map declarations) {
            this.declarations = declarations;
        }

        public InternalFactHandle get(int patern) {
            return null;
        }

        public InternalFactHandle get(Declaration declaration) {
            return (InternalFactHandle)this.declarations.get(declaration);
        }

        public InternalFactHandle[] getFactHandles() {
            return (InternalFactHandle[])this.declarations.values().toArray(new FactHandle[0]);
        }

        public boolean dependsOn(FactHandle handle) {
            return false;
        }

        public void setActivation(Activation activation) {
        }

        public long getRecency() {
            return 0L;
        }

        public int size() {
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MockActivation
    implements Activation {
        private Rule rule;
        private int salience;
        private final GroupElement subrule;
        private Tuple tuple;

        public MockActivation(Rule rule, int salience, GroupElement subrule, Tuple tuple) {
            this.rule = rule;
            this.salience = salience;
            this.tuple = tuple;
            this.subrule = subrule;
        }

        public Rule getRule() {
            return this.rule;
        }

        public int getSalience() {
            return this.salience;
        }

        public Tuple getTuple() {
            return this.tuple;
        }

        public PropagationContext getPropagationContext() {
            return null;
        }

        public long getActivationNumber() {
            return 0L;
        }

        public void remove() {
        }

        public void addLogicalDependency(LogicalDependency node) {
        }

        public LinkedList getLogicalDependencies() {
            return null;
        }

        public boolean isActivated() {
            return false;
        }

        public void setActivated(boolean activated) {
        }

        public ActivationGroupNode getActivationGroupNode() {
            return null;
        }

        public void setActivationGroupNode(ActivationGroupNode activationGroupNode) {
        }

        public GroupElement getSubRule() {
            return this.subrule;
        }

        public AgendaGroup getAgendaGroup() {
            return null;
        }

        public RuleFlowGroupNode getRuleFlowGroupNode() {
            return null;
        }

        public void setRuleFlowGroupNode(RuleFlowGroupNode ruleFlowGroupNode) {
        }

        public void setLogicalDependencies(LinkedList justified) {
        }

        public Collection<FactHandle> getFactHandles() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MockRuleFlow
    implements Process {
        private String id;

        MockRuleFlow(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return null;
        }

        public String getType() {
            return null;
        }

        public String getVersion() {
            return null;
        }

        public String getPackageName() {
            return null;
        }

        public void setId(String id) {
        }

        public void setName(String name) {
        }

        public void setType(String type) {
        }

        public void setVersion(String version) {
        }

        public void setPackageName(String packageName) {
        }

        public void addContext(Context context) {
        }

        public List<Context> getContexts(String contextId) {
            return null;
        }

        public Context getDefaultContext(String contextId) {
            return null;
        }

        public void setDefaultContext(Context context) {
        }

        public Context getContext(String contextType, long id) {
            return null;
        }

        public Object getMetaData(String name) {
            return null;
        }

        public void setMetaData(String name, Object value) {
        }

        public Resource getResource() {
            return null;
        }

        public void setResource(Resource resource) {
        }

        public String[] getGlobalNames() {
            return null;
        }

        public Map<String, String> getGlobals() {
            return null;
        }

        public List<String> getImports() {
            return null;
        }

        public void setGlobals(Map<String, String> globals) {
        }

        public void setImports(List<String> imports) {
        }

        public List<String> getFunctionImports() {
            return null;
        }

        public void setFunctionImports(List<String> functionImports) {
        }
    }
}

