/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.modeldriven;

import com.thoughtworks.xstream.XStream;
import java.util.List;
import junit.framework.TestCase;
import org.drools.guvnor.client.modeldriven.brl.ActionRetractFact;
import org.drools.guvnor.client.modeldriven.brl.ActionSetField;
import org.drools.guvnor.client.modeldriven.brl.CompositeFactPattern;
import org.drools.guvnor.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.guvnor.client.modeldriven.brl.ConnectiveConstraint;
import org.drools.guvnor.client.modeldriven.brl.DSLSentence;
import org.drools.guvnor.client.modeldriven.brl.FactPattern;
import org.drools.guvnor.client.modeldriven.brl.FieldConstraint;
import org.drools.guvnor.client.modeldriven.brl.IAction;
import org.drools.guvnor.client.modeldriven.brl.IPattern;
import org.drools.guvnor.client.modeldriven.brl.ISingleFieldConstraint;
import org.drools.guvnor.client.modeldriven.brl.RuleAttribute;
import org.drools.guvnor.client.modeldriven.brl.RuleMetadata;
import org.drools.guvnor.client.modeldriven.brl.RuleModel;
import org.drools.guvnor.client.modeldriven.brl.SingleFieldConstraint;

public class RuleModelTest
extends TestCase {
    public void testAddItemLhs() {
        RuleModel model = new RuleModel();
        FactPattern x = new FactPattern();
        model.addLhsItem((IPattern)x);
        RuleModelTest.assertEquals((int)1, (int)model.lhs.length);
        FactPattern y = new FactPattern();
        model.addLhsItem((IPattern)y);
        RuleModelTest.assertEquals((int)2, (int)model.lhs.length);
        RuleModelTest.assertEquals((Object)x, (Object)model.lhs[0]);
        RuleModelTest.assertEquals((Object)y, (Object)model.lhs[1]);
    }

    public void testAddItemRhs() {
        RuleModel model = new RuleModel();
        ActionSetField a0 = new ActionSetField();
        ActionSetField a1 = new ActionSetField();
        model.addRhsItem((IAction)a0);
        RuleModelTest.assertEquals((int)1, (int)model.rhs.length);
        model.addRhsItem((IAction)a1);
        RuleModelTest.assertEquals((int)2, (int)model.rhs.length);
        RuleModelTest.assertEquals((Object)a0, (Object)model.rhs[0]);
        RuleModelTest.assertEquals((Object)a1, (Object)model.rhs[1]);
    }

    public void testAllVariableBindings() {
        RuleModel model = new RuleModel();
        model.lhs = new IPattern[2];
        FactPattern x = new FactPattern("Car");
        model.lhs[0] = x;
        x.boundName = "boundFact";
        SingleFieldConstraint sfc = new SingleFieldConstraint("q");
        x.addConstraint((FieldConstraint)sfc);
        sfc.fieldBinding = "field1";
        SingleFieldConstraint sfc2 = new SingleFieldConstraint("q");
        x.addConstraint((FieldConstraint)sfc2);
        sfc2.fieldBinding = "field2";
        model.lhs[1] = new CompositeFactPattern();
        List vars = model.getAllVariables();
        RuleModelTest.assertEquals((int)3, (int)vars.size());
        RuleModelTest.assertEquals((Object)"boundFact", vars.get(0));
        RuleModelTest.assertEquals((Object)"field1", vars.get(1));
        RuleModelTest.assertEquals((Object)"field2", vars.get(2));
        RuleModelTest.assertTrue((boolean)model.isVariableNameUsed("field2"));
    }

    public void testAttributes() {
        RuleModel m = new RuleModel();
        RuleAttribute at = new RuleAttribute("salience", "42");
        m.addAttribute(at);
        RuleModelTest.assertEquals((int)1, (int)m.attributes.length);
        RuleModelTest.assertEquals((Object)at, (Object)m.attributes[0]);
        RuleAttribute at2 = new RuleAttribute("agenda-group", "x");
        m.addAttribute(at2);
        RuleModelTest.assertEquals((int)2, (int)m.attributes.length);
        RuleModelTest.assertEquals((Object)at2, (Object)m.attributes[1]);
        m.removeAttribute(0);
        RuleModelTest.assertEquals((int)1, (int)m.attributes.length);
        RuleModelTest.assertEquals((Object)at2, (Object)m.attributes[0]);
    }

    public void testBindingList() {
        RuleModel model = new RuleModel();
        model.lhs = new IPattern[3];
        FactPattern x = new FactPattern("Car");
        model.lhs[0] = x;
        x.boundName = "x";
        FactPattern y = new FactPattern("Car");
        model.lhs[1] = y;
        y.boundName = "y";
        FactPattern other = new FactPattern("House");
        model.lhs[2] = other;
        List b = model.getBoundFacts();
        RuleModelTest.assertEquals((int)2, (int)b.size());
        RuleModelTest.assertEquals((Object)"x", b.get(0));
        RuleModelTest.assertEquals((Object)"y", b.get(1));
    }

    public void testBoundFactFinder() {
        RuleModel model = new RuleModel();
        RuleModelTest.assertNull((Object)model.getBoundFact("x"));
        model.lhs = new IPattern[3];
        FactPattern x = new FactPattern("Car");
        model.lhs[0] = x;
        x.boundName = "x";
        RuleModelTest.assertNotNull((Object)model.getBoundFact("x"));
        RuleModelTest.assertEquals((Object)x, (Object)model.getBoundFact("x"));
        FactPattern y = new FactPattern("Car");
        model.lhs[1] = y;
        y.boundName = "y";
        FactPattern other = new FactPattern("House");
        model.lhs[2] = other;
        RuleModelTest.assertEquals((Object)y, (Object)model.getBoundFact("y"));
        RuleModelTest.assertEquals((Object)x, (Object)model.getBoundFact("x"));
        model.rhs = new IAction[1];
        ActionSetField set = new ActionSetField();
        set.variable = "x";
        model.rhs[0] = set;
        RuleModelTest.assertTrue((boolean)model.isBoundFactUsed("x"));
        RuleModelTest.assertFalse((boolean)model.isBoundFactUsed("y"));
        RuleModelTest.assertEquals((int)3, (int)model.lhs.length);
        RuleModelTest.assertFalse((boolean)model.removeLhsItem(0));
        RuleModelTest.assertEquals((int)3, (int)model.lhs.length);
        ActionRetractFact fact = new ActionRetractFact("q");
        model.rhs[0] = fact;
        RuleModelTest.assertTrue((boolean)model.isBoundFactUsed("q"));
        RuleModelTest.assertFalse((boolean)model.isBoundFactUsed("x"));
        XStream xt = new XStream();
        xt.alias("rule", RuleModel.class);
        xt.alias("fact", FactPattern.class);
        xt.alias("retract", ActionRetractFact.class);
        String brl = xt.toXML((Object)model);
        System.out.println(brl);
    }

    public void testGetVariableNameForRHS() {
        RuleModel m = new RuleModel();
        m.name = "blah";
        FactPattern pat = new FactPattern();
        pat.boundName = "pat";
        pat.factType = "Person";
        m.addLhsItem((IPattern)pat);
        List l = m.getAllVariables();
        RuleModelTest.assertEquals((int)1, (int)l.size());
        RuleModelTest.assertEquals((Object)"pat", l.get(0));
    }

    public void testIsDSLEnhanced() throws Exception {
        RuleModel m = new RuleModel();
        RuleModelTest.assertFalse((boolean)m.hasDSLSentences());
        m.addLhsItem((IPattern)new FactPattern());
        RuleModelTest.assertFalse((boolean)m.hasDSLSentences());
        m.addRhsItem((IAction)new ActionSetField("q"));
        RuleModelTest.assertFalse((boolean)m.hasDSLSentences());
        m.addLhsItem((IPattern)new DSLSentence());
        RuleModelTest.assertTrue((boolean)m.hasDSLSentences());
        m.addRhsItem((IAction)new DSLSentence());
        RuleModelTest.assertTrue((boolean)m.hasDSLSentences());
        m = new RuleModel();
        m.addLhsItem((IPattern)new DSLSentence());
        RuleModelTest.assertTrue((boolean)m.hasDSLSentences());
        m = new RuleModel();
        m.addRhsItem((IAction)new DSLSentence());
        RuleModelTest.assertTrue((boolean)m.hasDSLSentences());
    }

    public void testMetaData() {
        RuleModel m = new RuleModel();
        RuleMetadata rm = new RuleMetadata("foo", "bar");
        m.addMetadata(rm);
        RuleModelTest.assertEquals((int)1, (int)m.metadataList.length);
        RuleModelTest.assertEquals((Object)rm, (Object)m.metadataList[0]);
        RuleMetadata gm = m.getMetaData("foo");
        RuleModelTest.assertNotNull((Object)gm);
        RuleMetadata rm2 = new RuleMetadata("foo2", "bar2");
        m.addMetadata(rm2);
        RuleModelTest.assertEquals((int)2, (int)m.metadataList.length);
        RuleModelTest.assertEquals((Object)rm2, (Object)m.metadataList[1]);
        RuleModelTest.assertEquals((String)"@foo(bar)", (String)rm.toString());
        m.removeMetadata(0);
        RuleModelTest.assertEquals((int)1, (int)m.metadataList.length);
        RuleModelTest.assertEquals((Object)rm2, (Object)m.metadataList[0]);
        RuleModelTest.assertEquals((String)"@foo2(bar2)", (String)m.metadataList[0].toString());
        gm = m.getMetaData("foo");
        RuleModelTest.assertNull((Object)gm);
        m.updateMetadata(rm);
        gm = m.getMetaData("foo");
        RuleModelTest.assertNotNull((Object)gm);
        rm.value = "bar2";
        m.updateMetadata(rm);
        gm = m.getMetaData("foo");
        RuleModelTest.assertNotNull((Object)gm);
        RuleModelTest.assertEquals((String)"bar2", (String)gm.value);
    }

    public void testRemoveItemLhs() {
        RuleModel model = new RuleModel();
        model.lhs = new IPattern[3];
        FactPattern x = new FactPattern("Car");
        model.lhs[0] = x;
        x.boundName = "x";
        FactPattern y = new FactPattern("Car");
        model.lhs[1] = y;
        y.boundName = "y";
        FactPattern other = new FactPattern("House");
        model.lhs[2] = other;
        RuleModelTest.assertEquals((int)3, (int)model.lhs.length);
        RuleModelTest.assertEquals((Object)x, (Object)model.lhs[0]);
        model.removeLhsItem(0);
        RuleModelTest.assertEquals((int)2, (int)model.lhs.length);
        RuleModelTest.assertEquals((Object)y, (Object)model.lhs[0]);
    }

    public void testRemoveItemRhs() {
        RuleModel model = new RuleModel();
        model.rhs = new IAction[3];
        ActionRetractFact r0 = new ActionRetractFact("x");
        ActionRetractFact r1 = new ActionRetractFact("y");
        ActionRetractFact r2 = new ActionRetractFact("z");
        model.rhs[0] = r0;
        model.rhs[1] = r1;
        model.rhs[2] = r2;
        model.removeRhsItem(1);
        RuleModelTest.assertEquals((int)2, (int)model.rhs.length);
        RuleModelTest.assertEquals((Object)r0, (Object)model.rhs[0]);
        RuleModelTest.assertEquals((Object)r2, (Object)model.rhs[1]);
    }

    public void testScopedVariables() {
        RuleModel model = new RuleModel();
        model.lhs = new IPattern[3];
        FactPattern x = new FactPattern("Car");
        model.lhs[0] = x;
        x.boundName = "x";
        FactPattern y = new FactPattern("Car");
        model.lhs[1] = y;
        y.boundName = "y";
        SingleFieldConstraint[] cons = new SingleFieldConstraint[2];
        y.constraintList = new CompositeFieldConstraint();
        y.constraintList.constraints = cons;
        cons[0] = new SingleFieldConstraint("age");
        cons[1] = new SingleFieldConstraint("make");
        cons[0].fieldBinding = "qbc";
        cons[0].connectives = new ConnectiveConstraint[1];
        cons[0].connectives[0] = new ConnectiveConstraint("&", "x");
        cons[0].connectives[0].constraintValueType = 1;
        FactPattern other = new FactPattern("House");
        model.lhs[2] = other;
        other.boundName = "q";
        SingleFieldConstraint[] cons2 = new SingleFieldConstraint[]{new SingleFieldConstraint()};
        other.constraintList = new CompositeFieldConstraint();
        other.constraintList.constraints = cons2;
        List vars = model.getBoundVariablesInScope((ISingleFieldConstraint)cons[0]);
        RuleModelTest.assertEquals((int)1, (int)vars.size());
        RuleModelTest.assertEquals((Object)"x", vars.get(0));
        vars = model.getBoundVariablesInScope((ISingleFieldConstraint)cons[0].connectives[0]);
        RuleModelTest.assertEquals((int)1, (int)vars.size());
        RuleModelTest.assertEquals((Object)"x", vars.get(0));
        vars = model.getBoundVariablesInScope((ISingleFieldConstraint)cons[1]);
        RuleModelTest.assertEquals((int)2, (int)vars.size());
        RuleModelTest.assertEquals((Object)"x", vars.get(0));
        RuleModelTest.assertEquals((Object)"qbc", vars.get(1));
        vars = model.getBoundVariablesInScope((ISingleFieldConstraint)cons[0]);
        RuleModelTest.assertEquals((int)1, (int)vars.size());
        RuleModelTest.assertEquals((Object)"x", vars.get(0));
        vars = model.getBoundVariablesInScope((ISingleFieldConstraint)cons2[0]);
        RuleModelTest.assertEquals((int)3, (int)vars.size());
        RuleModelTest.assertEquals((Object)"x", vars.get(0));
        RuleModelTest.assertEquals((Object)"qbc", vars.get(1));
        RuleModelTest.assertEquals((Object)"y", vars.get(2));
    }

    public void testScopedVariablesWithCompositeFact() {
        RuleModel m = new RuleModel();
        FactPattern p = new FactPattern();
        CompositeFieldConstraint cf = new CompositeFieldConstraint();
        cf.addConstraint((FieldConstraint)new SingleFieldConstraint("x"));
        p.addConstraint((FieldConstraint)cf);
        SingleFieldConstraint sf = new SingleFieldConstraint("q");
        sf.fieldBinding = "abc";
        p.addConstraint((FieldConstraint)sf);
        SingleFieldConstraint sf2 = new SingleFieldConstraint("q");
        sf2.fieldBinding = "qed";
        cf.addConstraint((FieldConstraint)sf2);
        m.addLhsItem((IPattern)p);
        List vars = m.getAllVariables();
        RuleModelTest.assertEquals((int)1, (int)vars.size());
        RuleModelTest.assertEquals((Object)"abc", vars.get(0));
    }
}

