/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.Person;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.base.mvel.MVELDebugHandler;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.integrationtests.SerializationHelper;
import org.drools.integrationtests.TestObject;
import org.drools.io.ResourceFactory;
import org.drools.lang.descr.PackageDescr;
import org.drools.rule.Package;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.util.DateUtils;
import org.mvel2.MVEL;

public class MVELTest
extends TestCase {
    public void testHelloWorld() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_mvel.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        ArrayList list2 = new ArrayList();
        workingMemory.setGlobal("list2", list2);
        Cheese c = new Cheese("stilton", 10);
        workingMemory.insert((Object)c);
        workingMemory.fireAllRules();
        MVELTest.assertEquals((int)2, (int)list.size());
        MVELTest.assertEquals((Object)new Integer(30), list.get(0));
        MVELTest.assertEquals((Object)new Integer(22), list.get(1));
        MVELTest.assertEquals((Object)"hello world", list2.get(0));
        Date dt = DateUtils.parseDate((String)"10-Jul-1974");
        MVELTest.assertEquals((Object)dt, (Object)c.getUsedBy());
    }

    public void testIncrementOperator() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 \n";
        str = str + "    dialect \"mvel\" \n";
        str = str + "when \n";
        str = str + "    $I : Integer() \n";
        str = str + "then \n";
        str = str + "    i = $I.intValue(); \n";
        str = str + "    i += 5; \n";
        str = str + "    list.add( i ); \n";
        str = str + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        MVELTest.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)5);
        ksession.fireAllRules();
        MVELTest.assertEquals((int)1, (int)list.size());
        MVELTest.assertEquals((Object)10, list.get(0));
    }

    public void testEvalWithBigDecimal() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import java.math.BigDecimal; \n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 \n";
        str = str + "    dialect \"mvel\" \n";
        str = str + "when \n";
        str = str + "    $bd : BigDecimal() \n";
        str = str + "    eval( $bd.compareTo( BigDecimal.ZERO ) > 0 ) \n";
        str = str + "then \n";
        str = str + "    list.add( $bd ); \n";
        str = str + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            System.err.println(kbuilder.getErrors());
        }
        MVELTest.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new BigDecimal(1.5));
        ksession.fireAllRules();
        MVELTest.assertEquals((int)1, (int)list.size());
        MVELTest.assertEquals((Object)new BigDecimal(1.5), list.get(0));
    }

    public void testLocalVariableMVELConsequence() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_LocalVariableMVELConsequence.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        workingMemory.insert((Object)new Person("bob", "stilton"));
        workingMemory.insert((Object)new Person("mark", "brie"));
        try {
            workingMemory.fireAllRules();
            MVELTest.assertEquals((String)"should have fired twice", (int)2, (int)list.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            MVELTest.fail((String)"Should not raise any exception");
        }
    }

    public void testMVELUsingGlobalsInDebugMode() throws Exception {
        MVELDebugHandler.setDebugMode((boolean)true);
        try {
            PackageBuilder builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_MVELGlobalDebug.drl")));
            Package pkg = builder.getPackage();
            RuleBase ruleBase = this.getRuleBase();
            ruleBase.addPackage(pkg);
            ruleBase = SerializationHelper.serializeObject(ruleBase);
            StatefulSession session = ruleBase.newStatefulSession();
            session.dispose();
            MVELDebugHandler.setDebugMode((boolean)false);
        }
        catch (Exception e) {
            MVELDebugHandler.setDebugMode((boolean)false);
            e.printStackTrace();
            MVELTest.fail((String)"Should not raise exceptions");
        }
    }

    public void testDuplicateLocalVariableMVELConsequence() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DuplicateLocalVariableMVELConsequence.drl")));
        MVELTest.assertTrue((boolean)builder.hasErrors());
    }

    public void testArrays() throws Exception {
        String text = "package test_mvel;\n";
        text = text + "import org.drools.integrationtests.TestObject;\n";
        text = text + "import function org.drools.integrationtests.TestObject.array;\n";
        text = text + "no-loop true\n";
        text = text + "dialect \"mvel\"\n";
        text = text + "rule \"1\"\n";
        text = text + "salience 1\n";
        text = text + "when\n";
        text = text + "    $fact: TestObject()\n";
        text = text + "    eval($fact.checkHighestPriority(\"mvel\", 2))\n";
        text = text + "    eval($fact.stayHasDaysOfWeek(\"mvel\", false, new String[][]{{\"2008-04-01\", \"2008-04-10\"}}))\n";
        text = text + "then\n";
        text = text + "    $fact.applyValueAddPromo(1,2,3,4,\"mvel\");\n";
        text = text + "end";
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(this.compileRule(text.replaceAll("mvel", "java")));
        ruleBase.addPackage(this.compileRule(text));
        ArrayList list = new ArrayList();
        ruleBase.newStatelessSession().execute((Object)new TestObject(list));
        MVELTest.assertEquals((int)6, (int)list.size());
        MVELTest.assertEquals((String)"TestObject.checkHighestPriority: java|2", (String)((String)list.get(0)));
        MVELTest.assertEquals((String)"TestObject.stayHasDaysOfWeek: java|false|[2008-04-01, 2008-04-10]", (String)((String)list.get(1)));
        MVELTest.assertEquals((String)"TestObject.checkHighestPriority: mvel|2", (String)((String)list.get(2)));
        MVELTest.assertEquals((String)"TestObject.stayHasDaysOfWeek: mvel|false|[2008-04-01, 2008-04-10]", (String)((String)list.get(3)));
        MVELTest.assertEquals((String)"TestObject.applyValueAddPromo: 1|2|3|4|java", (String)((String)list.get(4)));
        MVELTest.assertEquals((String)"TestObject.applyValueAddPromo: 1|2|3|4|mvel", (String)((String)list.get(5)));
    }

    private Package compileRule(String drl) throws Exception {
        PackageBuilder builder = new PackageBuilder(new PackageBuilderConfiguration());
        builder.addPackageFromDrl((Reader)new StringReader(drl));
        Package pkg = builder.getPackage();
        if (!pkg.isValid()) {
            throw new DroolsParserException(pkg.getErrorSummary());
        }
        return pkg;
    }

    public Object compiledExecute(String ex) {
        Serializable compiled = MVEL.compileExpression((String)ex);
        return MVEL.executeExpression((Object)compiled, (Object)new Object(), new HashMap());
    }

    private RuleBase loadRuleBase(Reader reader) throws IOException, DroolsParserException, Exception {
        DrlParser parser = new DrlParser();
        PackageDescr packageDescr = parser.parse(reader);
        if (parser.hasErrors()) {
            Assert.fail((String)"Error messages in parser, need to sort this our (or else collect error messages)");
        }
        PackageBuilder builder = new PackageBuilder();
        builder.addPackage(packageDescr);
        System.out.println(builder.getErrors());
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        return ruleBase;
    }

    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }
}

