/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import junit.framework.TestCase;
import org.drools.Child;
import org.drools.GrandParent;
import org.drools.Order;
import org.drools.Parent;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.compiler.PackageBuilder;
import org.drools.integrationtests.SerializationHelper;

public class MultithreadTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRuleBaseConcurrentCompilation() {
        int THREAD_COUNT = 30;
        try {
            int i;
            boolean success = true;
            PackageBuilder builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_MultithreadRulebaseSharing.drl")));
            RuleBase ruleBase = RuleBaseFactory.newRuleBase();
            ruleBase.addPackage(builder.getPackage());
            ruleBase = SerializationHelper.serializeObject(ruleBase);
            Thread[] t = new Thread[30];
            RulebaseRunner[] r = new RulebaseRunner[30];
            for (i = 0; i < t.length; ++i) {
                r[i] = new RulebaseRunner(i, ruleBase);
                t[i] = new Thread((Runnable)r[i], "thread-" + i);
                t[i].start();
            }
            for (i = 0; i < t.length; ++i) {
                t[i].join();
                if (r[i].getStatus() != RulebaseRunner.Status.FAIL) continue;
                success = false;
            }
            if (!success) {
                MultithreadTest.fail((String)"Multithread test failed. Look at the stack traces for details. ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MultithreadTest.fail((String)("Should not raise any exception: " + e.getMessage()));
        }
    }

    public void testExpectedFires() {
        try {
            int i;
            PackageBuilder packageBuilder = new PackageBuilder();
            packageBuilder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_MultithreadFiringCheck.drl")));
            final RuleBase ruleBase = RuleBaseFactory.newRuleBase();
            ruleBase.addPackage(packageBuilder.getPackage());
            final ConcurrentLinkedQueue errorList = new ConcurrentLinkedQueue();
            Thread[] t = new Thread[50];
            for (i = 0; i < t.length; ++i) {
                final int count = i;
                t[i] = new Thread(new Runnable(){

                    public void run() {
                        try {
                            int iterations = count * 15 + 3000;
                            ArrayList results = new ArrayList();
                            StatefulSession session2 = ruleBase.newStatefulSession();
                            session2.setGlobal("results", results);
                            session2.insert((Object)new Integer(-1));
                            for (int k = 0; k < iterations; ++k) {
                                session2.insert((Object)new Integer(k));
                                if (k + 1 == session2.getAgenda().agendaSize()) continue;
                                errorList.add("THREAD-" + count + " ERROR: expected agenda size=" + (k + 1) + " but was " + session2.getAgenda().agendaSize());
                            }
                            session2.fireAllRules();
                            session2.dispose();
                            if (results.size() != iterations) {
                                errorList.add("THREAD-" + count + " ERROR: expected fire count=" + iterations + " but was " + results.size());
                            }
                        }
                        catch (Exception e) {
                            errorList.add("THREAD-" + count + " EXCEPTION: " + e.getMessage());
                            e.printStackTrace();
                        }
                    }
                });
                t[i].start();
            }
            for (i = 0; i < t.length; ++i) {
                t[i].join();
            }
            MultithreadTest.assertTrue((String)("Errors during execution: " + ((Object)errorList).toString()), (boolean)errorList.isEmpty());
        }
        catch (Exception e) {
            e.printStackTrace();
            MultithreadTest.fail((String)("No exception should have been raised: " + e.getMessage()));
        }
    }

    public void testMultithreadDateStringConstraints() {
        try {
            int THREAD_COUNT = 10;
            PackageBuilder packageBuilder = new PackageBuilder();
            packageBuilder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_MultithreadDateStringConstraints.drl")));
            final RuleBase ruleBase = RuleBaseFactory.newRuleBase();
            ruleBase.addPackage(packageBuilder.getPackage());
            final Vector errors = new Vector();
            Thread[] t = new Thread[10];
            for (int j = 0; j < 10; ++j) {
                int i;
                for (i = 0; i < t.length; ++i) {
                    t[i] = new Thread(){

                        public void run() {
                            try {
                                int ITERATIONS = 300;
                                StatefulSession session = ruleBase.newStatefulSession();
                                ArrayList results = new ArrayList();
                                session.setGlobal("results", results);
                                for (int k = 0; k < 300; ++k) {
                                    session.insert((Object)new Order());
                                }
                                session.fireAllRules();
                                session.dispose();
                                if (results.size() != 300) {
                                    errors.add("Rules did not fired correctly. Expected: 300. Actual: " + results.size());
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                errors.add(ex);
                            }
                        }
                    };
                    t[i].start();
                }
                for (i = 0; i < t.length; ++i) {
                    t[i].join();
                }
            }
            if (!errors.isEmpty()) {
                MultithreadTest.fail((String)" Errors occured during execution ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MultithreadTest.fail((String)"Should not raise exception");
        }
    }

    public static class RulebaseRunner
    implements Runnable {
        private static final int ITERATIONS = 300;
        private final int id;
        private final RuleBase rulebase;
        private Status status;

        public RulebaseRunner(int id, RuleBase rulebase) {
            this.id = id;
            this.rulebase = rulebase;
            this.status = Status.SUCCESS;
        }

        public void run() {
            try {
                StatefulSession session2 = this.rulebase.newStatefulSession();
                for (int k = 0; k < 300; ++k) {
                    GrandParent gp = new GrandParent("bob");
                    Parent parent = new Parent("mark");
                    parent.setGrandParent(gp);
                    Child child = new Child("mike");
                    child.setParent(parent);
                    session2.insert((Object)gp);
                    session2.insert((Object)parent);
                    session2.insert((Object)child);
                }
                session2.fireAllRules();
                session2.dispose();
            }
            catch (Exception e) {
                this.status = Status.FAIL;
                System.out.println(Thread.currentThread().getName() + " failed: " + e.getMessage());
                e.printStackTrace();
            }
        }

        public int getId() {
            return this.id;
        }

        public Status getStatus() {
            return this.status;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Status {
            SUCCESS,
            FAIL;

        }
    }
}

