/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.compiler.PackageBuilder;
import org.drools.event.RuleFlowCompletedEvent;
import org.drools.event.RuleFlowEventListener;
import org.drools.event.RuleFlowEventListenerExtension;
import org.drools.event.RuleFlowGroupActivatedEvent;
import org.drools.event.RuleFlowGroupDeactivatedEvent;
import org.drools.event.RuleFlowNodeTriggeredEvent;
import org.drools.event.RuleFlowStartedEvent;
import org.drools.event.RuleFlowVariableChangeEvent;
import org.drools.process.instance.ProcessInstance;
import org.drools.process.instance.context.variable.VariableScopeInstance;
import org.drools.rule.Package;

public class ProcessEventListenerTest
extends TestCase {
    public void testInternalNodeSignalEvent() {
        PackageBuilder builder = new PackageBuilder();
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.event\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <variables>\n      <variable name=\"MyVar\" >\n        <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n        <value>SomeText</value>\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <eventNode id=\"2\" name=\"Event\" variableName=\"MyVar\" >\n      <eventFilters>\n        <eventFilter type=\"eventType\" eventType=\"MyEvent\" />\n      </eventFilters>\n    </eventNode>\n    <actionNode id=\"3\" name=\"Signal Event\" >\n      <action type=\"expression\" dialect=\"java\" >context.getProcessInstance().signalEvent(\"MyEvent\", \"MyValue\");</action>\n    </actionNode>\n    <join id=\"4\" name=\"Join\" type=\"1\" />\n    <end id=\"5\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"3\" />\n    <connection from=\"2\" to=\"4\" />\n    <connection from=\"3\" to=\"4\" />\n    <connection from=\"4\" to=\"5\" />\n  </connections>\n\n</process>");
        builder.addRuleFlow((Reader)source);
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession session = ruleBase.newStatefulSession();
        final ArrayList processEventList = new ArrayList();
        RuleFlowEventListenerExtension listener = new RuleFlowEventListenerExtension(){

            public void beforeVariableChange(RuleFlowVariableChangeEvent event, WorkingMemory workingMemory) {
                processEventList.add(event);
            }

            public void afterVariableChange(RuleFlowVariableChangeEvent event, WorkingMemory workingMemory) {
                processEventList.add(event);
            }

            public void beforeRuleFlowStarted(RuleFlowStartedEvent event, WorkingMemory workingMemory) {
                processEventList.add(event);
            }

            public void afterRuleFlowStarted(RuleFlowStartedEvent event, WorkingMemory workingMemory) {
                processEventList.add(event);
            }

            public void beforeRuleFlowCompleted(RuleFlowCompletedEvent event, WorkingMemory workingMemory) {
                processEventList.add(event);
            }

            public void afterRuleFlowCompleted(RuleFlowCompletedEvent event, WorkingMemory workingMemory) {
                processEventList.add(event);
            }

            public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event, WorkingMemory workingMemory) {
            }

            public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event, WorkingMemory workingMemory) {
            }

            public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event, WorkingMemory workingMemory) {
            }

            public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event, WorkingMemory workingMemory) {
            }

            public void beforeRuleFlowNodeTriggered(RuleFlowNodeTriggeredEvent event, WorkingMemory workingMemory) {
                processEventList.add(event);
            }

            public void afterRuleFlowNodeTriggered(RuleFlowNodeTriggeredEvent event, WorkingMemory workingMemory) {
                processEventList.add(event);
            }

            public void beforeRuleFlowNodeLeft(RuleFlowNodeTriggeredEvent event, WorkingMemory workingMemory) {
                processEventList.add(event);
            }

            public void afterRuleFlowNodeLeft(RuleFlowNodeTriggeredEvent event, WorkingMemory workingMemory) {
                processEventList.add(event);
            }
        };
        session.addEventListener((RuleFlowEventListener)listener);
        ProcessInstance processInstance = session.startProcess("org.drools.event");
        ProcessEventListenerTest.assertEquals((int)2, (int)processInstance.getState());
        ProcessEventListenerTest.assertEquals((Object)"MyValue", (Object)((VariableScopeInstance)processInstance.getContextInstance("VariableScope")).getVariable("MyVar"));
        ProcessEventListenerTest.assertEquals((int)28, (int)processEventList.size());
        ProcessEventListenerTest.assertEquals((String)"org.drools.event", (String)((RuleFlowStartedEvent)processEventList.get(0)).getProcessInstance().getProcessId());
        ProcessEventListenerTest.assertEquals((String)"MyVar", (String)((RuleFlowVariableChangeEvent)processEventList.get(4)).getName());
        ProcessEventListenerTest.assertEquals((Object)"SomeText", (Object)((RuleFlowVariableChangeEvent)processEventList.get(4)).getValue());
        ProcessEventListenerTest.assertEquals((String)"MyVar", (String)((RuleFlowVariableChangeEvent)processEventList.get(5)).getName());
        ProcessEventListenerTest.assertEquals((Object)"MyValue", (Object)((RuleFlowVariableChangeEvent)processEventList.get(5)).getValue());
    }
}

