/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import junit.framework.TestCase;
import org.drools.Person;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.compiler.DroolsError;
import org.drools.compiler.PackageBuilder;
import org.drools.process.instance.ProcessInstance;
import org.drools.process.instance.context.variable.VariableScopeInstance;
import org.drools.rule.Package;
import org.drools.ruleflow.instance.RuleFlowProcessInstance;

public class ProcessMilestoneTest
extends TestCase {
    public void testMilestone() {
        PackageBuilder builder = new PackageBuilder();
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.milestone\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <imports>\n      <import name=\"org.drools.Person\" />\n    </imports>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <milestone id=\"2\" name=\"Milestone\" >\n      <constraint type=\"rule\" dialect=\"mvel\" >Person( name == \"John Doe\" )</constraint>    </milestone>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        builder.addRuleFlow((Reader)source);
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ProcessInstance processInstance = workingMemory.startProcess("org.drools.milestone");
        ProcessMilestoneTest.assertEquals((int)1, (int)processInstance.getState());
        workingMemory.insert((Object)new Person("Jane Doe", 20));
        ProcessMilestoneTest.assertEquals((int)1, (int)processInstance.getState());
        workingMemory.insert((Object)new Person("John Doe", 50));
        ProcessMilestoneTest.assertEquals((int)2, (int)processInstance.getState());
    }

    public void testMilestoneWithProcessInstanceConstraint() {
        PackageBuilder builder = new PackageBuilder();
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.milestone\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <imports>\n      <import name=\"org.drools.Person\" />\n      <import name=\"org.drools.integrationtests.ProcessMilestoneTest.ProcessUtils\" />\n    </imports>\n    <variables>\n      <variable name=\"name\" >\n        <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <milestone id=\"2\" name=\"Milestone\" >\n      <constraint type=\"rule\" dialect=\"mvel\" >processInstance: org.drools.ruleflow.instance.RuleFlowProcessInstance()\nPerson( name == (ProcessUtils.getValue(processInstance, \"name\")) )</constraint>    </milestone>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        builder.addRuleFlow((Reader)source);
        Package pkg = builder.getPackage();
        for (DroolsError error : builder.getErrors().getErrors()) {
            System.err.println(error);
        }
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Person john = new Person("John Doe", 20);
        Person jane = new Person("Jane Doe", 20);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", john.getName());
        ProcessInstance processInstanceJohn = workingMemory.startProcess("org.drools.milestone", params);
        workingMemory.insert((Object)processInstanceJohn);
        ProcessMilestoneTest.assertEquals((int)1, (int)processInstanceJohn.getState());
        params = new HashMap();
        params.put("name", jane.getName());
        ProcessInstance processInstanceJane = workingMemory.startProcess("org.drools.milestone", params);
        workingMemory.insert((Object)processInstanceJane);
        ProcessMilestoneTest.assertEquals((int)1, (int)processInstanceJane.getState());
        workingMemory.insert((Object)jane);
        ProcessMilestoneTest.assertEquals((int)1, (int)processInstanceJohn.getState());
        ProcessMilestoneTest.assertEquals((int)2, (int)processInstanceJane.getState());
        workingMemory.insert((Object)john);
        ProcessMilestoneTest.assertEquals((int)2, (int)processInstanceJohn.getState());
    }

    public static class ProcessUtils {
        public static Object getValue(RuleFlowProcessInstance processInstance, String name) {
            VariableScopeInstance scope = (VariableScopeInstance)processInstance.getContextInstance("VariableScope");
            return scope.getVariable(name);
        }
    }
}

