/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import junit.framework.TestCase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.Person;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.drools.runtime.process.WorkflowProcessInstance;

public class ProcessWorkItemTest
extends TestCase {
    public void testWorkItem() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <variables>\n      <variable name=\"UserName\" >\n        <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n        <value>John Doe</value>\n      </variable>\n      <variable name=\"Person\" >\n        <type name=\"org.drools.process.core.datatype.impl.type.ObjectDataType\" className=\"org.drools.Person\" />\n      </variable>\n      <variable name=\"MyObject\" >\n        <type name=\"org.drools.process.core.datatype.impl.type.ObjectDataType\" className=\"java.lang.Object\" />\n      </variable>\n      <variable name=\"Number\" >\n        <type name=\"org.drools.process.core.datatype.impl.type.IntegerDataType\" />\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <workItem id=\"2\" name=\"HumanTask\" >\n      <work name=\"Human Task\" >\n        <parameter name=\"ActorId\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n          <value>#{UserName}</value>\n        </parameter>\n        <parameter name=\"Content\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n          <value>#{Person.name}</value>\n        </parameter>\n        <parameter name=\"TaskName\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n          <value>Do something</value>\n        </parameter>\n        <parameter name=\"Priority\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n        <parameter name=\"Comment\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n        <parameter name=\"Attachment\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.ObjectDataType\" className=\"java.lang.Object\" />\n        </parameter>\n      </work>\n      <mapping type=\"in\" from=\"MyObject\" to=\"Attachment\" />      <mapping type=\"in\" from=\"Person.name\" to=\"Comment\" />      <mapping type=\"out\" from=\"Result\" to=\"MyObject\" />      <mapping type=\"out\" from=\"Result.length()\" to=\"Number\" />    </workItem>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        kbuilder.add(ResourceFactory.newReaderResource((Reader)source), ResourceType.DRF);
        Collection kpkgs = kbuilder.getKnowledgePackages();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kpkgs);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        TestWorkItemHandler handler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("UserName", "John Doe");
        Person person = new Person();
        person.setName("John Doe");
        parameters.put("Person", person);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("org.drools.actions", parameters);
        ProcessWorkItemTest.assertEquals((int)1, (int)processInstance.getState());
        WorkItem workItem = handler.getWorkItem();
        ProcessWorkItemTest.assertNotNull((Object)workItem);
        ProcessWorkItemTest.assertEquals((Object)"John Doe", (Object)workItem.getParameter("ActorId"));
        ProcessWorkItemTest.assertEquals((Object)"John Doe", (Object)workItem.getParameter("Content"));
        ProcessWorkItemTest.assertEquals((Object)"John Doe", (Object)workItem.getParameter("Comment"));
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        ProcessWorkItemTest.assertEquals((int)2, (int)processInstance.getState());
        parameters = new HashMap();
        parameters.put("UserName", "Jane Doe");
        parameters.put("MyObject", "SomeString");
        person = new Person();
        person.setName("Jane Doe");
        parameters.put("Person", person);
        processInstance = (WorkflowProcessInstance)ksession.startProcess("org.drools.actions", parameters);
        ProcessWorkItemTest.assertEquals((int)1, (int)processInstance.getState());
        workItem = handler.getWorkItem();
        ProcessWorkItemTest.assertNotNull((Object)workItem);
        ProcessWorkItemTest.assertEquals((Object)"Jane Doe", (Object)workItem.getParameter("ActorId"));
        ProcessWorkItemTest.assertEquals((Object)"SomeString", (Object)workItem.getParameter("Attachment"));
        ProcessWorkItemTest.assertEquals((Object)"Jane Doe", (Object)workItem.getParameter("Content"));
        ProcessWorkItemTest.assertEquals((Object)"Jane Doe", (Object)workItem.getParameter("Comment"));
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("Result", "SomeOtherString");
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), results);
        ProcessWorkItemTest.assertEquals((int)2, (int)processInstance.getState());
        ProcessWorkItemTest.assertEquals((Object)"SomeOtherString", (Object)processInstance.getVariable("MyObject"));
        ProcessWorkItemTest.assertEquals((Object)15, (Object)processInstance.getVariable("Number"));
    }

    public void testWorkItemImmediateCompletion() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <variables>\n      <variable name=\"UserName\" >\n        <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n        <value>John Doe</value>\n      </variable>\n      <variable name=\"Person\" >\n        <type name=\"org.drools.process.core.datatype.impl.type.ObjectDataType\" className=\"org.drools.Person\" />\n      </variable>\n      <variable name=\"MyObject\" >\n        <type name=\"org.drools.process.core.datatype.impl.type.ObjectDataType\" className=\"java.lang.Object\" />\n      </variable>\n      <variable name=\"Number\" >\n        <type name=\"org.drools.process.core.datatype.impl.type.IntegerDataType\" />\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <workItem id=\"2\" name=\"HumanTask\" >\n      <work name=\"Human Task\" >\n        <parameter name=\"ActorId\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n          <value>#{UserName}</value>\n        </parameter>\n        <parameter name=\"Content\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n          <value>#{Person.name}</value>\n        </parameter>\n        <parameter name=\"TaskName\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n          <value>Do something</value>\n        </parameter>\n        <parameter name=\"Priority\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n        <parameter name=\"Comment\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n        </parameter>\n        <parameter name=\"Attachment\" >\n          <type name=\"org.drools.process.core.datatype.impl.type.ObjectDataType\" className=\"java.lang.Object\" />\n        </parameter>\n      </work>\n      <mapping type=\"in\" from=\"MyObject\" to=\"Attachment\" />      <mapping type=\"in\" from=\"Person.name\" to=\"Comment\" />      <mapping type=\"out\" from=\"Result\" to=\"MyObject\" />      <mapping type=\"out\" from=\"Result.length()\" to=\"Number\" />    </workItem>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        kbuilder.add(ResourceFactory.newReaderResource((Reader)source), ResourceType.DRF);
        Collection kpkgs = kbuilder.getKnowledgePackages();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kpkgs);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ImmediateTestWorkItemHandler handler = new ImmediateTestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("UserName", "John Doe");
        Person person = new Person();
        person.setName("John Doe");
        parameters.put("Person", person);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("org.drools.actions", parameters);
        ProcessWorkItemTest.assertEquals((int)2, (int)processInstance.getState());
    }

    private static class ImmediateTestWorkItemHandler
    implements WorkItemHandler {
        private ImmediateTestWorkItemHandler() {
        }

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            manager.completeWorkItem(workItem.getId(), null);
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }
    }

    private static class TestWorkItemHandler
    implements WorkItemHandler {
        private WorkItem workItem;

        private TestWorkItemHandler() {
        }

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            this.workItem = workItem;
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }

        public WorkItem getWorkItem() {
            return this.workItem;
        }
    }
}

