/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderErrors;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.pipeline.KnowledgeRuntimeCommand;
import org.drools.runtime.pipeline.Pipeline;
import org.drools.runtime.pipeline.PipelineFactory;
import org.drools.runtime.pipeline.Receiver;
import org.drools.runtime.pipeline.ResultHandler;
import org.drools.runtime.pipeline.impl.ExecuteResultHandler;
import org.drools.runtime.pipeline.impl.StatefulKnowledgeSessionPipelineImpl;
import org.drools.runtime.pipeline.impl.StatefulKnowledgeSessionSetGlobalStage;
import org.drools.runtime.pipeline.impl.StatefulKnowledgeSessionSignalEventStage;
import org.drools.runtime.pipeline.impl.StatefulKnowledgeSessionStartProcessStage;
import org.drools.runtime.process.ProcessInstance;

public class StatefulKnowledgeSessionPipelineTest
extends TestCase {
    public void testInsertObject() {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        KnowledgeRuntimeCommand insertStage = PipelineFactory.newStatefulKnowledgeSessionInsert();
        ExecuteResultHandler resultHandlerStage = new ExecuteResultHandler();
        insertStage.setReceiver((Receiver)resultHandlerStage);
        Pipeline pipeline = PipelineFactory.newStatefulKnowledgeSessionPipeline((StatefulKnowledgeSession)ksession);
        pipeline.setReceiver((Receiver)insertStage);
        StatefulKnowledgeSessionPipelineTest.assertEquals((int)0, (int)ksession.getObjects().size());
        ResultHandlerImpl resultHanadle = new ResultHandlerImpl();
        pipeline.insert((Object)"Hello", (ResultHandler)resultHanadle);
        StatefulKnowledgeSessionPipelineTest.assertEquals((int)1, (int)resultHanadle.getHandles().size());
    }

    public void testStartProcess() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.actions\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <actionNode id=\"2\" name=\"MyActionNode\" >\n      <action type=\"expression\" dialect=\"java\" >        String variable = (String) context.getVariable(\"variable\");\n        list.add(variable);\n       </action>\n    </actionNode>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>");
        kbuilder.add(ResourceFactory.newReaderResource((Reader)source), ResourceType.DRF);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (!errors.isEmpty()) {
            for (KnowledgeBuilderError error : errors) {
                System.err.println(error);
            }
            StatefulKnowledgeSessionPipelineTest.fail((String)"Errors while building package");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        HashMap globals = new HashMap();
        globals.put("list", list);
        StatefulKnowledgeSessionSetGlobalStage setGlobal = new StatefulKnowledgeSessionSetGlobalStage();
        StatefulKnowledgeSessionPipelineImpl pipeline = new StatefulKnowledgeSessionPipelineImpl(ksession);
        pipeline.setReceiver((Receiver)setGlobal);
        pipeline.insert(globals, null);
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable", "SomeText");
        StatefulKnowledgeSessionStartProcessStage startProcess = new StatefulKnowledgeSessionStartProcessStage("org.drools.actions");
        pipeline = new StatefulKnowledgeSessionPipelineImpl(ksession);
        pipeline.setReceiver((Receiver)startProcess);
        pipeline.insert(vars, null);
        StatefulKnowledgeSessionPipelineTest.assertEquals((int)1, (int)list.size());
        StatefulKnowledgeSessionPipelineTest.assertEquals((String)"SomeText", (String)((String)list.get(0)));
    }

    public void testSignalEvent() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"org.drools.event\" package-name=\"org.drools\" version=\"1\" >\n\n  <header>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n    <variables>\n      <variable name=\"MyVar\" >\n        <type name=\"org.drools.process.core.datatype.impl.type.StringDataType\" />\n        <value>SomeText</value>\n      </variable>\n    </variables>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <eventNode id=\"2\" name=\"Event\" variableName=\"MyVar\" >\n      <eventFilters>\n        <eventFilter type=\"eventType\" eventType=\"MyEvent\" />\n      </eventFilters>\n    </eventNode>\n    <actionNode id=\"3\" name=\"MyActionNode\" >\n      <action type=\"expression\" dialect=\"java\" >        String variable = (String) context.getVariable(\"MyVar\");\n        list.add(variable);\n       </action>\n    </actionNode>\n    <join id=\"4\" name=\"Join\" type=\"1\" />\n    <end id=\"5\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"4\" />\n    <connection from=\"2\" to=\"3\" />\n    <connection from=\"3\" to=\"4\" />\n    <connection from=\"4\" to=\"5\" />\n  </connections>\n\n</process>");
        kbuilder.add(ResourceFactory.newReaderResource((Reader)source), ResourceType.DRF);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (!errors.isEmpty()) {
            for (KnowledgeBuilderError error : errors) {
                System.err.println(error);
            }
            StatefulKnowledgeSessionPipelineTest.fail((String)"Errors while building package");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        HashMap globals = new HashMap();
        globals.put("list", list);
        StatefulKnowledgeSessionSetGlobalStage setGlobal = new StatefulKnowledgeSessionSetGlobalStage();
        StatefulKnowledgeSessionPipelineImpl pipeline = new StatefulKnowledgeSessionPipelineImpl(ksession);
        pipeline.setReceiver((Receiver)setGlobal);
        pipeline.insert(globals, null);
        ProcessInstance instance = ksession.startProcess("org.drools.event");
        StatefulKnowledgeSessionSignalEventStage signalEvent = new StatefulKnowledgeSessionSignalEventStage("MyEvent", instance.getId());
        pipeline = new StatefulKnowledgeSessionPipelineImpl(ksession);
        pipeline.setReceiver((Receiver)signalEvent);
        pipeline.insert((Object)"MyValue", null);
        StatefulKnowledgeSessionPipelineTest.assertEquals((int)1, (int)list.size());
        StatefulKnowledgeSessionPipelineTest.assertEquals((String)"MyValue", (String)((String)list.get(0)));
    }

    public static class ResultHandlerImpl
    implements ResultHandler {
        Map handles;

        public void handleResult(Object object) {
            this.handles = (Map)object;
        }

        public Map getHandles() {
            return this.handles;
        }
    }
}

