/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.drools.Person;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.base.ClassObjectType;
import org.drools.base.mvel.MVELSalienceExpression;
import org.drools.common.InternalFactHandle;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.PackageBuilder;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.reteoo.LeftTuple;
import org.drools.rule.Declaration;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.mvel.InstrumentedBuildContent;
import org.drools.rule.builder.dialect.mvel.InstrumentedDeclarationScopeResolver;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.rule.builder.dialect.mvel.MVELSalienceBuilder;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ObjectType;
import org.drools.spi.PatternExtractor;
import org.drools.spi.Salience;
import org.drools.spi.Tuple;

public class MVELSalienceBuilderTest
extends TestCase {
    private InstrumentedBuildContent context;
    private RuleBase ruleBase;

    protected void setUp() throws Exception {
        super.setUp();
        Package pkg = new Package("pkg1");
        RuleDescr ruleDescr = new RuleDescr("rule 1");
        ruleDescr.addAttribute(new AttributeDescr("salience", "(p.age + 20)/2"));
        ruleDescr.setConsequence((Object)"");
        PackageBuilder pkgBuilder = new PackageBuilder(pkg);
        DialectCompiletimeRegistry dialectRegistry = pkgBuilder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
        MVELDialect mvelDialect = (MVELDialect)dialectRegistry.getDialect("mvel");
        this.context = new InstrumentedBuildContent(pkgBuilder, ruleDescr, dialectRegistry, pkg, (Dialect)mvelDialect);
        InstrumentedDeclarationScopeResolver declarationResolver = new InstrumentedDeclarationScopeResolver();
        ClassObjectType personObjeectType = new ClassObjectType(Person.class);
        Pattern pattern = new Pattern(0, (ObjectType)personObjeectType);
        PatternExtractor extractor = new PatternExtractor((ObjectType)personObjeectType);
        Declaration declaration = new Declaration("p", (InternalReadAccessor)extractor, pattern);
        HashMap<String, Declaration> map = new HashMap<String, Declaration>();
        map.put("p", declaration);
        declarationResolver.setDeclarations(map);
        this.context.setDeclarationResolver(declarationResolver);
        this.ruleBase = RuleBaseFactory.newRuleBase();
        MVELSalienceBuilder salienceBuilder = new MVELSalienceBuilder();
        salienceBuilder.build((RuleBuildContext)this.context);
        ((MVELSalienceExpression)this.context.getRule().getSalience()).compile(Thread.currentThread().getContextClassLoader());
    }

    public void testSimpleExpression() {
        StatefulSession wm = this.ruleBase.newStatefulSession();
        Person p = new Person("mark", "", 31);
        InternalFactHandle f0 = (InternalFactHandle)wm.insert((Object)p);
        LeftTuple tuple = new LeftTuple(f0, null, true);
        MVELSalienceBuilderTest.assertEquals((int)25, (int)this.context.getRule().getSalience().getValue((Tuple)tuple, (WorkingMemory)wm));
    }

    public void testMultithreadSalienceExpression() {
        int i;
        int tcount = 10;
        SalienceEvaluator[] evals = new SalienceEvaluator[10];
        Thread[] threads = new Thread[10];
        for (i = 0; i < evals.length; ++i) {
            evals[i] = new SalienceEvaluator(this.ruleBase, this.context.getRule().getSalience(), new Person("bob" + i, 30 + i * 3));
            threads[i] = new Thread(evals[i]);
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        int errors = 0;
        for (int i2 = 0; i2 < evals.length; ++i2) {
            if (!evals[i2].isError()) continue;
            ++errors;
        }
        MVELSalienceBuilderTest.assertEquals((String)"There shouldn't be any threads in error: ", (int)0, (int)errors);
    }

    public static class SalienceEvaluator
    implements Runnable {
        public static final int iterations = 1000;
        private Salience salience;
        private LeftTuple tuple;
        private WorkingMemory wm;
        private final int result;
        private transient boolean halt;
        private boolean error;

        public SalienceEvaluator(RuleBase ruleBase, Salience salience, Person person) {
            this.wm = ruleBase.newStatefulSession();
            InternalFactHandle f0 = (InternalFactHandle)this.wm.insert((Object)person);
            this.tuple = new LeftTuple(f0, null, true);
            this.salience = salience;
            this.halt = false;
            this.error = false;
            this.result = (person.getAge() + 20) / 2;
        }

        public void run() {
            try {
                Thread.sleep(1000L);
                for (int i = 0; i < 1000 && !this.halt; ++i) {
                    Assert.assertEquals((int)this.result, (int)this.salience.getValue((Tuple)this.tuple, this.wm));
                    Thread.currentThread();
                    Thread.yield();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.error = true;
            }
        }

        public void halt() {
            this.halt = true;
        }

        public boolean isError() {
            return this.error;
        }

        public void setError(boolean error) {
            this.error = error;
        }
    }
}

