/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testframework;

import java.util.HashSet;
import junit.framework.TestCase;
import org.drools.event.AfterActivationFiredEvent;
import org.drools.spi.Activation;
import org.drools.testframework.MockActivation;
import org.drools.testframework.RuleCoverageListener;

public class RuleCoverageListenerTest
extends TestCase {
    public void testCoverage() throws Exception {
        HashSet<String> rules = new HashSet<String>();
        rules.add("rule1");
        rules.add("rule2");
        rules.add("rule3");
        RuleCoverageListener ls = new RuleCoverageListener(rules);
        RuleCoverageListenerTest.assertEquals((int)3, (int)ls.rules.size());
        RuleCoverageListenerTest.assertEquals((int)0, (int)ls.getPercentCovered());
        ls.afterActivationFired(new AfterActivationFiredEvent((Activation)new MockActivation("rule1")), null);
        RuleCoverageListenerTest.assertEquals((int)2, (int)ls.rules.size());
        RuleCoverageListenerTest.assertTrue((boolean)ls.rules.contains("rule2"));
        RuleCoverageListenerTest.assertTrue((boolean)ls.rules.contains("rule3"));
        RuleCoverageListenerTest.assertFalse((boolean)ls.rules.contains("rule1"));
        RuleCoverageListenerTest.assertEquals((int)33, (int)ls.getPercentCovered());
        ls.afterActivationFired(new AfterActivationFiredEvent((Activation)new MockActivation("rule2")), null);
        RuleCoverageListenerTest.assertEquals((int)1, (int)ls.rules.size());
        RuleCoverageListenerTest.assertFalse((boolean)ls.rules.contains("rule2"));
        RuleCoverageListenerTest.assertFalse((boolean)ls.rules.contains("rule1"));
        RuleCoverageListenerTest.assertTrue((boolean)ls.rules.contains("rule3"));
        RuleCoverageListenerTest.assertEquals((int)66, (int)ls.getPercentCovered());
        ls.afterActivationFired(new AfterActivationFiredEvent((Activation)new MockActivation("rule3")), null);
        RuleCoverageListenerTest.assertEquals((int)0, (int)ls.rules.size());
        RuleCoverageListenerTest.assertFalse((boolean)ls.rules.contains("rule2"));
        RuleCoverageListenerTest.assertFalse((boolean)ls.rules.contains("rule1"));
        RuleCoverageListenerTest.assertFalse((boolean)ls.rules.contains("rule3"));
        RuleCoverageListenerTest.assertEquals((int)100, (int)ls.getPercentCovered());
    }
}

