/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.rules;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.drools.base.ClassTypeResolver;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.ParserError;
import org.drools.guvnor.client.modeldriven.SuggestionCompletionEngine;
import org.drools.guvnor.server.util.ClassMethodInspector;
import org.drools.guvnor.server.util.DataEnumLoader;
import org.drools.guvnor.server.util.SuggestionCompletionEngineBuilder;
import org.drools.lang.descr.FactTemplateDescr;
import org.drools.lang.descr.FieldTemplateDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.TypeDeclarationDescr;
import org.drools.lang.descr.TypeFieldDescr;
import org.drools.lang.dsl.AbstractDSLMappingEntry;
import org.drools.lang.dsl.DSLMapping;
import org.drools.lang.dsl.DSLMappingEntry;
import org.drools.lang.dsl.DSLTokenizedMappingFile;
import org.drools.rule.MapBackedClassLoader;
import org.drools.util.asm.ClassFieldInspector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuggestionCompletionLoader {
    private final SuggestionCompletionEngineBuilder builder = new SuggestionCompletionEngineBuilder();
    private final DrlParser parser = new DrlParser();
    private final MapBackedClassLoader loader;
    protected List<String> errors = new ArrayList<String>();
    final ClassTypeResolver resolver;

    public SuggestionCompletionLoader() {
        this(null);
    }

    public SuggestionCompletionLoader(ClassLoader classLoader) {
        if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.loader = new MapBackedClassLoader(classLoader);
        this.resolver = new ClassTypeResolver(new HashSet(), (ClassLoader)this.loader);
    }

    public SuggestionCompletionEngine getSuggestionEngine(String header, List jars, List dsls) {
        return this.getSuggestionEngine(header, jars, dsls, Collections.EMPTY_LIST);
    }

    public SuggestionCompletionEngine getSuggestionEngine(String header, List jars, List dsls, List dataEnums) {
        this.builder.newCompletionEngine();
        if (!header.trim().equals("")) {
            this.processPackageHeader(header, jars);
        }
        this.populateDSLSentences(dsls);
        SuggestionCompletionEngine sce = this.builder.getInstance();
        this.populateDateEnums(dataEnums, sce);
        Arrays.sort(sce.factTypes);
        return sce;
    }

    private void populateDateEnums(List dataEnums, SuggestionCompletionEngine sce) {
        for (String enumFile : dataEnums) {
            DataEnumLoader enumLoader = new DataEnumLoader(enumFile);
            if (enumLoader.hasErrors()) {
                this.errors.addAll(enumLoader.getErrors());
                continue;
            }
            sce.dataEnumLists.putAll(enumLoader.getData());
        }
    }

    private void processPackageHeader(String header, List jars) {
        PackageDescr pkgDescr;
        try {
            pkgDescr = this.parser.parse(header);
        }
        catch (DroolsParserException e1) {
            throw new IllegalStateException("Serious error, unable to validate package.");
        }
        if (this.parser.hasErrors()) {
            for (ParserError element : this.parser.getErrors()) {
                this.errors.add(element.getMessage());
            }
        }
        if (pkgDescr != null) {
            this.populateModelInfo(pkgDescr, jars);
            this.populateGlobalInfo(pkgDescr, jars);
        }
    }

    private void populateDSLSentences(List dsls) {
        for (DSLTokenizedMappingFile file : dsls) {
            DSLMapping mapping = file.getMapping();
            for (AbstractDSLMappingEntry abstractDSLMappingEntry : mapping.getEntries()) {
                if (abstractDSLMappingEntry.getSection() == DSLMappingEntry.CONDITION) {
                    this.builder.addDSLConditionSentence(abstractDSLMappingEntry.getMappingKey());
                    continue;
                }
                if (abstractDSLMappingEntry.getSection() == DSLMappingEntry.CONSEQUENCE) {
                    this.builder.addDSLActionSentence(abstractDSLMappingEntry.getMappingKey());
                    continue;
                }
                if (abstractDSLMappingEntry.getSection() == DSLMappingEntry.KEYWORD) {
                    this.builder.addDSLMapping(abstractDSLMappingEntry);
                    continue;
                }
                if (abstractDSLMappingEntry.getSection() != DSLMappingEntry.ANY) continue;
            }
        }
    }

    private void populateGlobalInfo(PackageDescr pkgDescr, List jars) {
        for (GlobalDescr global : pkgDescr.getGlobals()) {
            try {
                String shortTypeName = this.getShortNameOfClass(global.getType());
                if (!this.builder.hasFieldsForType(shortTypeName)) {
                    Class clazz = this.loadClass(global.getType(), jars);
                    this.loadClassFields(clazz, shortTypeName);
                    this.builder.addGlobalType(global.getIdentifier(), shortTypeName);
                    if (clazz != null && Collection.class.isAssignableFrom(clazz)) {
                        this.builder.addGlobalCollection(global.getIdentifier());
                    }
                }
                this.builder.addGlobalType(global.getIdentifier(), shortTypeName);
            }
            catch (IOException e) {
                this.errors.add("Error while inspecting class for global: " + global.getType() + " error message: " + e.getMessage());
            }
        }
    }

    private void populateModelInfo(PackageDescr pkgDescr, List jars) {
        for (ImportDescr imp : pkgDescr.getImports()) {
            String className = imp.getTarget();
            if (className.endsWith("*")) {
                this.errors.add("Unable to introspect model for wild card imports (" + className + "). Please explicitly import each fact type you require.");
                continue;
            }
            this.resolver.addImport(className);
            Class clazz = this.loadClass(className, jars);
            if (clazz == null) continue;
            try {
                String shortTypeName = this.getShortNameOfClass(clazz.getName());
                this.loadClassFields(clazz, shortTypeName);
                this.builder.addFactType(shortTypeName);
            }
            catch (IOException e) {
                this.errors.add("Error while inspecting the class: " + className + ". The error was: " + e.getMessage());
            }
            catch (NoClassDefFoundError e) {
                this.errors.add("Unable to find the class: " + e.getMessage().replace('/', '.') + " which is required by: " + className + ". You may need to add more classes to the model.");
            }
        }
        HashSet<String> declaredTypes = new HashSet<String>();
        for (TypeDeclarationDescr td : pkgDescr.getTypeDeclarations()) {
            if (td.getFields().size() <= 0) continue;
            String declaredType = td.getTypeName();
            declaredTypes.add(declaredType);
            this.builder.addFactType(declaredType);
            ArrayList<String> fieldNames = new ArrayList<String>();
            for (Map.Entry<String, TypeFieldDescr> f : td.getFields().entrySet()) {
                String fieldName = f.getKey();
                fieldNames.add(fieldName);
                String fieldClass = f.getValue().getPattern().getObjectType();
                if (declaredTypes.contains(fieldClass)) {
                    this.builder.addFieldType(declaredType + "." + fieldName, fieldClass);
                    continue;
                }
                try {
                    Class clz = this.resolver.resolveType(fieldClass);
                    this.builder.addFieldType(declaredType + "." + fieldName, this.getFieldType(clz));
                }
                catch (ClassNotFoundException e) {
                    this.errors.add("Class of field not found: " + fieldClass);
                }
            }
            this.builder.addFieldsForType(declaredType, fieldNames.toArray(new String[fieldNames.size()]));
        }
        this.populateFactTemplateTypes(pkgDescr, this.resolver);
    }

    private void populateFactTemplateTypes(PackageDescr pkgDescr, ClassTypeResolver resolver) {
        for (FactTemplateDescr templ : pkgDescr.getFactTemplates()) {
            String factType = templ.getName();
            this.builder.addFactType(factType);
            Object[] fields = new String[templ.getFields().size()];
            int index = 0;
            for (FieldTemplateDescr fieldDescr : templ.getFields()) {
                fields[index++] = fieldDescr.getName();
                String fieldType = fieldDescr.getClassType();
                Class fieldTypeClass = null;
                try {
                    fieldTypeClass = resolver.resolveType(fieldType);
                }
                catch (ClassNotFoundException e) {
                    this.errors.add("Fact template field type not found: " + fieldType);
                }
                this.builder.addFieldType(factType + "." + fieldDescr.getName(), this.getFieldType(fieldTypeClass));
            }
            Arrays.sort(fields);
            this.builder.addFieldsForType(factType, (String[])fields);
        }
    }

    private Class loadClass(String className, List jars) {
        Class clazz = null;
        try {
            clazz = this.resolver.resolveType(className);
        }
        catch (ClassNotFoundException e1) {
            try {
                this.addJars(jars);
                clazz = this.resolver.resolveType(className);
            }
            catch (Exception e) {
                this.errors.add("Class not found: " + className);
            }
        }
        return clazz;
    }

    /*
     * WARNING - void declaration
     */
    private void loadClassFields(Class clazz, String shortTypeName) throws IOException {
        void var10_12;
        if (clazz == null) {
            return;
        }
        ClassFieldInspector inspector = new ClassFieldInspector(clazz);
        HashSet<Object> fieldSet = new HashSet<Object>();
        fieldSet.addAll(inspector.getFieldNames().keySet());
        fieldSet.add("this");
        Object[] fields = fieldSet.toArray(new String[0]);
        Arrays.sort(fields);
        fields = this.removeIrrelevantFields((String[])fields);
        this.builder.addFieldsForType(shortTypeName, (String[])fields);
        Method[] methods = clazz.getMethods();
        ArrayList<String> modifierStrings = new ArrayList<String>();
        Method[] arr$ = methods;
        int len$ = arr$.length;
        boolean bl = false;
        while (var10_12 < len$) {
            Method method = arr$[var10_12];
            modifierStrings.add(method.getName());
            ++var10_12;
        }
        String[] modifiers = new String[modifierStrings.size()];
        modifierStrings.toArray(modifiers);
        this.builder.addModifiersForType(shortTypeName, modifiers);
        fieldSet.remove("this");
        this.builder.addFieldType(shortTypeName + ".this", "Object");
        for (String string : fieldSet) {
            Class type = (Class)inspector.getFieldTypes().get(string);
            String fieldType = this.getFieldType(type);
            this.builder.addFieldType(shortTypeName + "." + string, fieldType);
        }
        ClassMethodInspector methodInspector = new ClassMethodInspector(clazz);
        this.builder.getInstance().addMethodInfo(shortTypeName, methodInspector.getMethodInfos());
    }

    String getShortNameOfClass(String clazz) {
        return clazz.substring(clazz.lastIndexOf(46) + 1);
    }

    String[] removeIrrelevantFields(String[] fields) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            if (field.equals("class") || field.equals("hashCode") || field.equals("toString")) continue;
            result.add(field);
        }
        return result.toArray(new String[result.size()]);
    }

    private void addJars(List jars) throws IOException {
        for (JarInputStream jis : jars) {
            JarEntry entry;
            byte[] buf = new byte[1024];
            while ((entry = jis.getNextJarEntry()) != null) {
                int len;
                if (entry.isDirectory()) continue;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while ((len = jis.read(buf)) >= 0) {
                    out.write(buf, 0, len);
                }
                this.loader.addResource(entry.getName(), out.toByteArray());
            }
        }
    }

    private String getFieldType(Class type) {
        String fieldType = null;
        if (type != null) {
            if (type.isPrimitive() && type != Boolean.TYPE) {
                fieldType = "Numeric";
            } else if (Number.class.isAssignableFrom(type)) {
                fieldType = "Numeric";
            } else if (String.class.isAssignableFrom(type)) {
                fieldType = "String";
            } else if (Collection.class.isAssignableFrom(type)) {
                fieldType = "Collection";
            } else if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
                fieldType = "Boolean";
            } else if (Date.class.isAssignableFrom(type)) {
                fieldType = "Date";
            } else if (Comparable.class.isAssignableFrom(type)) {
                fieldType = "Comparable";
            } else {
                try {
                    Class clazz = this.resolver.resolveType(type.getName());
                    fieldType = clazz.getSimpleName();
                }
                catch (ClassNotFoundException e) {
                    fieldType = "Object";
                }
            }
        }
        return fieldType;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public List<String> getErrors() {
        return this.errors;
    }
}

