/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URL;
import junit.framework.TestCase;
import org.drools.io.ResourceFactory;
import org.drools.io.impl.ResourceChangeNotifierImpl;
import org.drools.io.impl.ResourceChangeScannerImpl;
import org.drools.io.impl.UrlResource;
import org.drools.util.FileManager;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ResourceHandler;

public class UrlResourceTest
extends TestCase {
    private FileManager fileManager;
    private Server server;

    protected void setUp() throws Exception {
        super.setUp();
        this.fileManager = new FileManager();
        this.fileManager.setUp();
        ((ResourceChangeScannerImpl)ResourceFactory.getResourceChangeScannerService()).reset();
        ResourceFactory.getResourceChangeNotifierService().start();
        ResourceFactory.getResourceChangeScannerService().start();
        this.server = new Server(9000);
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setResourceBase(this.fileManager.getRootDirectory().getPath());
        System.out.println("root : " + this.fileManager.getRootDirectory().getPath());
        this.server.setHandler((Handler)resourceHandler);
        this.server.start();
    }

    protected void tearDown() throws Exception {
        this.fileManager.tearDown();
        ResourceFactory.getResourceChangeNotifierService().stop();
        ResourceFactory.getResourceChangeScannerService().stop();
        ((ResourceChangeNotifierImpl)ResourceFactory.getResourceChangeNotifierService()).reset();
        ((ResourceChangeScannerImpl)ResourceFactory.getResourceChangeScannerService()).reset();
        this.server.stop();
    }

    public void testWithCache() throws Exception {
        URL url = new URL("http://localhost:9000/rule1.drl");
        UrlResource ur = new UrlResource(url);
        UrlResource.CACHE_DIR = new File(".");
        File f1 = this.fileManager.newFile("rule1.drl");
        System.err.println("target file: " + f1.getAbsolutePath());
        BufferedWriter output = new BufferedWriter(new FileWriter(f1));
        output.write("Some data");
        ((Writer)output).close();
        long lm = ur.getLastModified();
        UrlResourceTest.assertTrue((lm > 0L ? 1 : 0) != 0);
        InputStream ins = ur.getInputStream();
        UrlResourceTest.assertNotNull((Object)ins);
        this.server.stop();
        UrlResourceTest.assertNotNull((Object)ur.getInputStream());
        UrlResourceTest.assertTrue((ur.getLastModified() > 0L ? 1 : 0) != 0);
        UrlResourceTest.assertTrue((boolean)(ur.getInputStream() instanceof FileInputStream));
        Thread.sleep(1000L);
        f1.delete();
        output = new BufferedWriter(new FileWriter(f1));
        output.write("More data...");
        ((Writer)output).close();
        this.server.start();
        UrlResourceTest.assertNotNull((Object)ur.getInputStream());
        UrlResourceTest.assertFalse((boolean)(ur.getInputStream() instanceof FileInputStream));
        long lm_ = ur.getLastModified();
        System.err.println("lm_ : " + lm_ + " lm : " + lm);
        UrlResourceTest.assertTrue((lm_ > lm ? 1 : 0) != 0);
        InputStream in_ = ur.getInputStream();
        BufferedReader rdr = new BufferedReader(new InputStreamReader(in_));
        String line = rdr.readLine();
        UrlResourceTest.assertEquals((String)"More data...", (String)line);
        this.server.stop();
        Thread.sleep(1000L);
        f1.delete();
        output = new BufferedWriter(new FileWriter(f1));
        output.write("Finally..");
        ((Writer)output).close();
        ur = new UrlResource(url);
        in_ = ur.getInputStream();
        rdr = new BufferedReader(new InputStreamReader(in_));
        line = rdr.readLine();
        UrlResourceTest.assertEquals((String)"More data...", (String)line);
        Thread.sleep(1000L);
        this.server.start();
        ur = new UrlResource(url);
        in_ = ur.getInputStream();
        rdr = new BufferedReader(new InputStreamReader(in_));
        line = rdr.readLine();
        UrlResourceTest.assertEquals((String)"Finally..", (String)line);
    }

    public void testWithoutCache() throws Exception {
        UrlResource ur = new UrlResource(new URL("http://localhost:9000/rule1.drl"));
        UrlResource.CACHE_DIR = null;
        File f1 = this.fileManager.newFile("rule1.drl");
        System.err.println("target file: " + f1.getAbsolutePath());
        BufferedWriter output = new BufferedWriter(new FileWriter(f1));
        output.write("Some data");
        ((Writer)output).close();
        long lm = ur.getLastModified();
        UrlResourceTest.assertTrue((lm > 0L ? 1 : 0) != 0);
        InputStream ins = ur.getInputStream();
        UrlResourceTest.assertNotNull((Object)ins);
        this.server.stop();
        UrlResourceTest.assertEquals((long)0L, (long)ur.getLastModified());
    }
}

