/*
 * Decompiled with CFR 0.152.
 */
package org.drools.conf;

import junit.framework.TestCase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.conf.AlphaThresholdOption;
import org.drools.conf.AssertBehaviorOption;
import org.drools.conf.CompositeKeyDepthOption;
import org.drools.conf.ConsequenceExceptionHandlerOption;
import org.drools.conf.EventProcessingOption;
import org.drools.conf.IndexLeftBetaMemoryOption;
import org.drools.conf.IndexRightBetaMemoryOption;
import org.drools.conf.KnowledgeBaseOption;
import org.drools.conf.LogicalOverrideOption;
import org.drools.conf.MaintainTMSOption;
import org.drools.conf.MaxThreadsOption;
import org.drools.conf.MultithreadEvaluationOption;
import org.drools.conf.RemoveIdentitiesOption;
import org.drools.conf.SequentialAgendaOption;
import org.drools.conf.SequentialOption;
import org.drools.conf.ShareAlphaNodesOption;
import org.drools.conf.ShareBetaNodesOption;
import org.drools.runtime.rule.impl.DefaultConsequenceExceptionHandler;

public class KnowledgeBaseConfigurationTest
extends TestCase {
    private KnowledgeBaseConfiguration config;

    protected void setUp() throws Exception {
        super.setUp();
        this.config = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
    }

    public void testMaintainTMSConfiguration() {
        this.config.setOption((KnowledgeBaseOption)MaintainTMSOption.YES);
        KnowledgeBaseConfigurationTest.assertEquals((Object)MaintainTMSOption.YES, (Object)this.config.getOption(MaintainTMSOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"true", (String)this.config.getProperty("drools.maintainTms"));
        this.config.setProperty("drools.maintainTms", "false");
        KnowledgeBaseConfigurationTest.assertEquals((Object)MaintainTMSOption.NO, (Object)this.config.getOption(MaintainTMSOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"false", (String)this.config.getProperty("drools.maintainTms"));
    }

    public void testSequentialConfiguration() {
        this.config.setOption((KnowledgeBaseOption)SequentialOption.YES);
        KnowledgeBaseConfigurationTest.assertEquals((Object)SequentialOption.YES, (Object)this.config.getOption(SequentialOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"true", (String)this.config.getProperty("drools.sequential"));
        this.config.setProperty("drools.sequential", "false");
        KnowledgeBaseConfigurationTest.assertEquals((Object)SequentialOption.NO, (Object)this.config.getOption(SequentialOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"false", (String)this.config.getProperty("drools.sequential"));
    }

    public void testRemoveIdentitiesConfiguration() {
        this.config.setOption((KnowledgeBaseOption)RemoveIdentitiesOption.YES);
        KnowledgeBaseConfigurationTest.assertEquals((Object)RemoveIdentitiesOption.YES, (Object)this.config.getOption(RemoveIdentitiesOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"true", (String)this.config.getProperty("drools.removeIdentities"));
        this.config.setProperty("drools.removeIdentities", "false");
        KnowledgeBaseConfigurationTest.assertEquals((Object)RemoveIdentitiesOption.NO, (Object)this.config.getOption(RemoveIdentitiesOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"false", (String)this.config.getProperty("drools.removeIdentities"));
    }

    public void testShareAlphaNodesConfiguration() {
        this.config.setOption((KnowledgeBaseOption)ShareAlphaNodesOption.YES);
        KnowledgeBaseConfigurationTest.assertEquals((Object)ShareAlphaNodesOption.YES, (Object)this.config.getOption(ShareAlphaNodesOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"true", (String)this.config.getProperty("drools.shareAlphaNodes"));
        this.config.setProperty("drools.shareAlphaNodes", "false");
        KnowledgeBaseConfigurationTest.assertEquals((Object)ShareAlphaNodesOption.NO, (Object)this.config.getOption(ShareAlphaNodesOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"false", (String)this.config.getProperty("drools.shareAlphaNodes"));
    }

    public void testShareBetaNodesConfiguration() {
        this.config.setOption((KnowledgeBaseOption)ShareBetaNodesOption.YES);
        KnowledgeBaseConfigurationTest.assertEquals((Object)ShareBetaNodesOption.YES, (Object)this.config.getOption(ShareBetaNodesOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"true", (String)this.config.getProperty("drools.shareBetaNodes"));
        this.config.setProperty("drools.shareBetaNodes", "false");
        KnowledgeBaseConfigurationTest.assertEquals((Object)ShareBetaNodesOption.NO, (Object)this.config.getOption(ShareBetaNodesOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"false", (String)this.config.getProperty("drools.shareBetaNodes"));
    }

    public void testIndexLeftBetaMemoryConfiguration() {
        this.config.setOption((KnowledgeBaseOption)IndexLeftBetaMemoryOption.YES);
        KnowledgeBaseConfigurationTest.assertEquals((Object)IndexLeftBetaMemoryOption.YES, (Object)this.config.getOption(IndexLeftBetaMemoryOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"true", (String)this.config.getProperty("drools.indexLeftBetaMemory"));
        this.config.setProperty("drools.indexLeftBetaMemory", "false");
        KnowledgeBaseConfigurationTest.assertEquals((Object)IndexLeftBetaMemoryOption.NO, (Object)this.config.getOption(IndexLeftBetaMemoryOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"false", (String)this.config.getProperty("drools.indexLeftBetaMemory"));
    }

    public void testIndexRightBetaMemoryConfiguration() {
        this.config.setOption((KnowledgeBaseOption)IndexRightBetaMemoryOption.YES);
        KnowledgeBaseConfigurationTest.assertEquals((Object)IndexRightBetaMemoryOption.YES, (Object)this.config.getOption(IndexRightBetaMemoryOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"true", (String)this.config.getProperty("drools.indexRightBetaMemory"));
        this.config.setProperty("drools.indexRightBetaMemory", "false");
        KnowledgeBaseConfigurationTest.assertEquals((Object)IndexRightBetaMemoryOption.NO, (Object)this.config.getOption(IndexRightBetaMemoryOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"false", (String)this.config.getProperty("drools.indexRightBetaMemory"));
    }

    public void testAssertBehaviorConfiguration() {
        this.config.setOption((KnowledgeBaseOption)AssertBehaviorOption.EQUALITY);
        KnowledgeBaseConfigurationTest.assertEquals((Object)AssertBehaviorOption.EQUALITY, (Object)this.config.getOption(AssertBehaviorOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"equality", (String)this.config.getProperty("drools.assertBehaviour"));
        this.config.setProperty("drools.assertBehaviour", "identity");
        KnowledgeBaseConfigurationTest.assertEquals((Object)AssertBehaviorOption.IDENTITY, (Object)this.config.getOption(AssertBehaviorOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"identity", (String)this.config.getProperty("drools.assertBehaviour"));
    }

    public void testLogicalOverrideConfiguration() {
        this.config.setOption((KnowledgeBaseOption)LogicalOverrideOption.PRESERVE);
        KnowledgeBaseConfigurationTest.assertEquals((Object)LogicalOverrideOption.PRESERVE, (Object)this.config.getOption(LogicalOverrideOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"preserve", (String)this.config.getProperty("drools.logicalOverride"));
        this.config.setProperty("drools.logicalOverride", "discard");
        KnowledgeBaseConfigurationTest.assertEquals((Object)LogicalOverrideOption.DISCARD, (Object)this.config.getOption(LogicalOverrideOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"discard", (String)this.config.getProperty("drools.logicalOverride"));
    }

    public void testSequentialAgendaConfiguration() {
        this.config.setOption((KnowledgeBaseOption)SequentialAgendaOption.DYNAMIC);
        KnowledgeBaseConfigurationTest.assertEquals((Object)SequentialAgendaOption.DYNAMIC, (Object)this.config.getOption(SequentialAgendaOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"dynamic", (String)this.config.getProperty("drools.sequential.agenda"));
        this.config.setProperty("drools.sequential.agenda", "sequential");
        KnowledgeBaseConfigurationTest.assertEquals((Object)SequentialAgendaOption.SEQUENTIAL, (Object)this.config.getOption(SequentialAgendaOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"sequential", (String)this.config.getProperty("drools.sequential.agenda"));
    }

    public void testAlphaThresholdConfiguration() {
        this.config.setOption((KnowledgeBaseOption)AlphaThresholdOption.get((int)5));
        KnowledgeBaseConfigurationTest.assertEquals((Object)AlphaThresholdOption.get((int)5), (Object)this.config.getOption(AlphaThresholdOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"5", (String)this.config.getProperty("drools.alphaNodeHashingThreshold"));
        this.config.setProperty("drools.alphaNodeHashingThreshold", "7");
        KnowledgeBaseConfigurationTest.assertEquals((Object)AlphaThresholdOption.get((int)7), (Object)this.config.getOption(AlphaThresholdOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"7", (String)this.config.getProperty("drools.alphaNodeHashingThreshold"));
    }

    public void testCompositeKeyDepthConfiguration() {
        this.config.setOption((KnowledgeBaseOption)CompositeKeyDepthOption.get((int)1));
        KnowledgeBaseConfigurationTest.assertEquals((Object)CompositeKeyDepthOption.get((int)1), (Object)this.config.getOption(CompositeKeyDepthOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"1", (String)this.config.getProperty("drools.compositeKeyDepth"));
        this.config.setProperty("drools.compositeKeyDepth", "2");
        KnowledgeBaseConfigurationTest.assertEquals((Object)CompositeKeyDepthOption.get((int)2), (Object)this.config.getOption(CompositeKeyDepthOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"2", (String)this.config.getProperty("drools.compositeKeyDepth"));
    }

    public void testConsequenceExceptionHandlerConfiguration() {
        Class<DefaultConsequenceExceptionHandler> handler = DefaultConsequenceExceptionHandler.class;
        this.config.setOption((KnowledgeBaseOption)ConsequenceExceptionHandlerOption.get(handler));
        KnowledgeBaseConfigurationTest.assertEquals((Object)ConsequenceExceptionHandlerOption.get(handler), (Object)this.config.getOption(ConsequenceExceptionHandlerOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)handler.getName(), (String)this.config.getProperty("drools.consequenceExceptionHandler"));
        this.config.setProperty("drools.consequenceExceptionHandler", handler.getName());
        KnowledgeBaseConfigurationTest.assertEquals((String)handler.getName(), (String)((ConsequenceExceptionHandlerOption)this.config.getOption(ConsequenceExceptionHandlerOption.class)).getHandler().getName());
        KnowledgeBaseConfigurationTest.assertEquals((String)handler.getName(), (String)this.config.getProperty("drools.consequenceExceptionHandler"));
    }

    public void testEventProcessingConfiguration() {
        this.config.setOption((KnowledgeBaseOption)EventProcessingOption.STREAM);
        KnowledgeBaseConfigurationTest.assertEquals((Object)EventProcessingOption.STREAM, (Object)this.config.getOption(EventProcessingOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"stream", (String)this.config.getProperty("drools.eventProcessingMode"));
        this.config.setProperty("drools.eventProcessingMode", "cloud");
        KnowledgeBaseConfigurationTest.assertEquals((Object)EventProcessingOption.CLOUD, (Object)this.config.getOption(EventProcessingOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"cloud", (String)this.config.getProperty("drools.eventProcessingMode"));
    }

    public void testMaxThreadsConfiguration() {
        this.config.setOption((KnowledgeBaseOption)MaxThreadsOption.get((int)5));
        KnowledgeBaseConfigurationTest.assertEquals((Object)MaxThreadsOption.get((int)5), (Object)this.config.getOption(MaxThreadsOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"5", (String)this.config.getProperty("drools.maxThreads"));
        this.config.setProperty("drools.maxThreads", "8");
        KnowledgeBaseConfigurationTest.assertEquals((Object)MaxThreadsOption.get((int)8), (Object)this.config.getOption(MaxThreadsOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"8", (String)this.config.getProperty("drools.maxThreads"));
    }

    public void testMultithreadEvaluationConfiguration() {
        this.config.setOption((KnowledgeBaseOption)MultithreadEvaluationOption.YES);
        KnowledgeBaseConfigurationTest.assertEquals((Object)MultithreadEvaluationOption.YES, (Object)this.config.getOption(MultithreadEvaluationOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"true", (String)this.config.getProperty("drools.multithreadEvaluation"));
        this.config.setProperty("drools.multithreadEvaluation", "false");
        KnowledgeBaseConfigurationTest.assertEquals((Object)MultithreadEvaluationOption.NO, (Object)this.config.getOption(MultithreadEvaluationOption.class));
        KnowledgeBaseConfigurationTest.assertEquals((String)"false", (String)this.config.getProperty("drools.multithreadEvaluation"));
    }

    public void testRulebaseSetUpdateHandler() {
        KnowledgeBaseConfigurationTest.assertEquals((String)"", (String)this.config.getProperty("drools.ruleBaseUpdateHandler"));
        this.config.setProperty("drools.ruleBaseUpdateHandler", "somethingElse");
        KnowledgeBaseConfigurationTest.assertEquals((String)"somethingElse", (String)this.config.getProperty("drools.ruleBaseUpdateHandler"));
        this.config.setProperty("drools.ruleBaseUpdateHandler", null);
        KnowledgeBaseConfigurationTest.assertEquals((String)"", (String)this.config.getProperty("drools.ruleBaseUpdateHandler"));
        this.config.setProperty("drools.ruleBaseUpdateHandler", "");
        KnowledgeBaseConfigurationTest.assertEquals((String)"", (String)this.config.getProperty("drools.ruleBaseUpdateHandler"));
    }
}

