/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarInputStream;
import junit.framework.TestCase;
import org.drools.guvnor.client.modeldriven.SuggestionCompletionEngine;
import org.drools.guvnor.server.rules.SuggestionCompletionLoader;

public class SuggestionCompletionEngine2Test
extends TestCase {
    public void testArrayList() {
        String pkg = "package org.test\n global java.util.ArrayList testList";
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine engine = loader.getSuggestionEngine(pkg, new ArrayList(), new ArrayList(), new ArrayList());
        List methodNames = engine.getMethodNames("ArrayList");
        SuggestionCompletionEngine2Test.assertNotNull((Object)methodNames);
        SuggestionCompletionEngine2Test.assertFalse((boolean)methodNames.isEmpty());
        for (String s : methodNames) {
            SuggestionCompletionEngine2Test.assertFalse((String)("Method " + s + " is not allowed."), (boolean)this.allowedMethod(s));
        }
    }

    public void testJarFileWithSourceFiles() {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        String header = "package foo \n import org.test.Person \n import org.test.Banana \n ";
        ArrayList<JarInputStream> jars = new ArrayList<JarInputStream>();
        JarInputStream jis = null;
        SuggestionCompletionEngine suggestionCompletionEngine = null;
        try {
            jis = new JarInputStream(((Object)((Object)this)).getClass().getResourceAsStream("/JarWithSourceFiles.jar"));
            jars.add(jis);
        }
        catch (IOException e) {
            SuggestionCompletionEngine2Test.fail((String)"Could not load jar");
        }
        try {
            suggestionCompletionEngine = loader.getSuggestionEngine(header, jars, new ArrayList());
        }
        catch (ClassFormatError e) {
            SuggestionCompletionEngine2Test.fail((String)("Can not load suggestions " + e));
        }
        SuggestionCompletionEngine2Test.assertNotNull((Object)jis);
        SuggestionCompletionEngine2Test.assertNotNull((Object)suggestionCompletionEngine);
        SuggestionCompletionEngine2Test.assertEquals((int)2, (int)suggestionCompletionEngine.getFactTypes().length);
        List<String> list = Arrays.asList(suggestionCompletionEngine.getFactTypes());
        SuggestionCompletionEngine2Test.assertTrue((boolean)list.contains("Person"));
        SuggestionCompletionEngine2Test.assertTrue((boolean)list.contains("Banana"));
    }

    private boolean allowedMethod(String methodName) {
        return "hashCode".equals(methodName) || "equals".equals(methodName) || "listIterator".equals(methodName) || "lastIndexOf".equals(methodName) || "indexOf".equals(methodName) || "subList".equals(methodName) || "get".equals(methodName) || "isEmpty".equals(methodName) || "containsKey".equals(methodName) || "values".equals(methodName) || "entrySet".equals(methodName) || "containsValue".equals(methodName) || "keySet".equals(methodName) || "size".equals(methodName) || "toArray".equals(methodName) || "iterator".equals(methodName) || "contains".equals(methodName) || "isEmpty".equals(methodName) || "containsAll".equals(methodName) || "size".equals(methodName);
    }
}

