/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.Message;
import org.drools.base.mvel.MVELDebugHandler;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderErrors;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.io.ResourceFactory;
import org.drools.logger.KnowledgeRuntimeLogger;
import org.drools.logger.KnowledgeRuntimeLoggerFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.mvel2.MVELRuntime;
import org.mvel2.debug.Debugger;
import org.mvel2.debug.Frame;

public class HelloWorldTest
extends TestCase {
    public void testHelloWorld() throws Exception {
        KnowledgeBase kbase = this.readKnowledgeBase();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        KnowledgeRuntimeLogger logger = KnowledgeRuntimeLoggerFactory.newFileLogger((KnowledgeRuntimeEventManager)ksession, (String)"test");
        Message message = new Message();
        message.setMessage("Hello World");
        message.setStatus(0);
        ksession.insert((Object)message);
        ksession.fireAllRules();
        logger.close();
    }

    public void testHelloWorldDebug() throws Exception {
        final ArrayList knownVariables = new ArrayList();
        MVELRuntime.resetDebugger();
        MVELDebugHandler.setDebugMode((boolean)true);
        MVELRuntime.setThreadDebugger((Debugger)new Debugger(){

            public int onBreak(Frame frame) {
                System.out.println("onBreak");
                for (String var : frame.getFactory().getKnownVariables()) {
                    System.out.println("  " + var);
                    knownVariables.add(var);
                }
                return 0;
            }
        });
        String source = "org.drools.integrationtests.Rule_Hello_World_0";
        MVELRuntime.registerBreakpoint((String)source, (int)1);
        KnowledgeBase kbase = this.readKnowledgeBase();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        KnowledgeRuntimeLogger logger = KnowledgeRuntimeLoggerFactory.newFileLogger((KnowledgeRuntimeEventManager)ksession, (String)"test");
        Message message = new Message();
        message.setMessage("Hello World");
        message.setStatus(0);
        ksession.insert((Object)message);
        ksession.fireAllRules();
        logger.close();
        HelloWorldTest.assertEquals((int)2, (int)knownVariables.size());
        HelloWorldTest.assertTrue((boolean)knownVariables.contains("m"));
        HelloWorldTest.assertTrue((boolean)knownVariables.contains("myMessage"));
    }

    private KnowledgeBase readKnowledgeBase() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"Sample.drl", HelloWorldTest.class), ResourceType.DRL);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                System.err.println(error);
            }
            throw new IllegalArgumentException("Could not parse knowledge.");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }
}

