/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.compiler.DroolsError;
import org.drools.compiler.PackageBuilder;
import org.drools.process.instance.ProcessInstance;
import org.drools.rule.Package;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;

public class ProcessDynamicNodeTest
extends TestCase {
    public void testDynamicActions() {
        PackageBuilder builder = new PackageBuilder();
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.drools.dynamic\" package-name=\"org.drools\" >\n\n  <header>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <dynamic id=\"2\" name=\"DynamicNode\" >\n      <nodes>\n        <actionNode id=\"1\" name=\"Action1\" >\n          <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Action1\");\nlist.add(\"Action1\");</action>\n        </actionNode>\n        <actionNode id=\"2\" name=\"Action2\" >\n          <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Action2\");\nlist.add(\"Action2\");</action>\n        </actionNode>\n        <actionNode id=\"3\" name=\"Action3\" >\n          <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Action3\");\nlist.add(\"Action3\");</action>\n        </actionNode>\n      </nodes>\n      <connections>\n        <connection from=\"1\" to=\"3\" />\n      </connections>\n      <in-ports/>\n      <out-ports/>\n    </dynamic>\n    <actionNode id=\"3\" name=\"Action4\" >\n      <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Action4\");\nlist.add(\"Action4\");</action>\n    </actionNode>\n    <end id=\"4\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n    <connection from=\"3\" to=\"4\" />\n  </connections>\n</process>");
        builder.addRuleFlow((Reader)source);
        Package pkg = builder.getPackage();
        for (DroolsError error : builder.getErrors().getErrors()) {
            System.err.println(error);
        }
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        ProcessInstance processInstance = workingMemory.startProcess("org.drools.dynamic");
        ProcessDynamicNodeTest.assertEquals((int)2, (int)processInstance.getState());
        ProcessDynamicNodeTest.assertEquals((int)4, (int)list.size());
    }

    public void testDynamicAsyncActions() {
        PackageBuilder builder = new PackageBuilder();
        StringReader source = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"ruleflow\" id=\"org.drools.dynamic\" package-name=\"org.drools\" >\n\n  <header>\n    <globals>\n      <global identifier=\"list\" type=\"java.util.List\" />\n    </globals>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <dynamic id=\"2\" name=\"DynamicNode\" >\n      <nodes>\n        <workItem id=\"1\" name=\"Work\" >\n          <work name=\"Work\" />\n        </workItem>\n        <actionNode id=\"2\" name=\"Action2\" >\n          <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Action2\");\nlist.add(\"Action2\");</action>\n        </actionNode>\n        <actionNode id=\"3\" name=\"Action3\" >\n          <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Action3\");\nlist.add(\"Action3\");</action>\n        </actionNode>\n      </nodes>\n      <connections>\n        <connection from=\"1\" to=\"3\" />\n      </connections>\n      <in-ports/>\n      <out-ports/>\n    </dynamic>\n    <actionNode id=\"3\" name=\"Action4\" >\n      <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Action4\");\nlist.add(\"Action4\");</action>\n    </actionNode>\n    <end id=\"4\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n    <connection from=\"3\" to=\"4\" />\n  </connections>\n</process>");
        builder.addRuleFlow((Reader)source);
        Package pkg = builder.getPackage();
        for (DroolsError error : builder.getErrors().getErrors()) {
            System.err.println(error);
        }
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        TestWorkItemHandler testHandler = new TestWorkItemHandler();
        workingMemory.getWorkItemManager().registerWorkItemHandler("Work", (WorkItemHandler)testHandler);
        ProcessInstance processInstance = workingMemory.startProcess("org.drools.dynamic");
        ProcessDynamicNodeTest.assertEquals((int)1, (int)processInstance.getState());
        ProcessDynamicNodeTest.assertEquals((int)1, (int)list.size());
        WorkItem workItem = testHandler.getWorkItem();
        ProcessDynamicNodeTest.assertNotNull((Object)workItem);
        workingMemory.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        ProcessDynamicNodeTest.assertEquals((int)2, (int)processInstance.getState());
        ProcessDynamicNodeTest.assertEquals((int)3, (int)list.size());
    }

    private static class TestWorkItemHandler
    implements WorkItemHandler {
        private WorkItem workItem;

        private TestWorkItemHandler() {
        }

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            this.workItem = workItem;
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }

        public WorkItem getWorkItem() {
            return this.workItem;
        }
    }
}

