/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.compiler.DroolsError;
import org.drools.compiler.PackageBuilder;
import org.drools.integrationtests.SerializationHelper;
import org.drools.runtime.process.ProcessInstance;

public class ProcessMultiThreadTest
extends TestCase {
    public void testMultiThreadProcessInstanceSignalling() {
        int THREAD_COUNT = 2;
        try {
            int i;
            boolean success = true;
            Thread[] t = new Thread[2];
            PackageBuilder builder = new PackageBuilder();
            builder.addProcessFromXml((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ProcessMultithreadEvent.rf")));
            if (builder.getErrors().getErrors().length > 0) {
                for (DroolsError error : builder.getErrors().getErrors()) {
                    System.err.println(error);
                }
                ProcessMultiThreadTest.fail((String)"Could not parse process");
            }
            RuleBase ruleBase = RuleBaseFactory.newRuleBase();
            ruleBase.addPackage(builder.getPackage());
            ruleBase = SerializationHelper.serializeObject(ruleBase);
            StatefulSession session = ruleBase.newStatefulSession();
            session = SerializationHelper.getSerialisedStatefulSession(session);
            ArrayList list = new ArrayList();
            session.setGlobal("list", list);
            org.drools.process.instance.ProcessInstance processInstance = session.startProcess("org.drools.integrationtests.multithread");
            ProcessInstanceSignalRunner[] r = new ProcessInstanceSignalRunner[2];
            for (i = 0; i < t.length; ++i) {
                r[i] = new ProcessInstanceSignalRunner(i, (ProcessInstance)processInstance, "event" + (i + 1));
                t[i] = new Thread((Runnable)r[i], "thread-" + i);
                t[i].start();
            }
            for (i = 0; i < t.length; ++i) {
                t[i].join();
                if (r[i].getStatus() != ProcessInstanceSignalRunner.Status.FAIL) continue;
                success = false;
            }
            if (!success) {
                ProcessMultiThreadTest.fail((String)"Multithread test failed. Look at the stack traces for details. ");
            }
            ProcessMultiThreadTest.assertEquals((int)2, (int)list.size());
            ProcessMultiThreadTest.assertFalse((boolean)((String)list.get(0)).equals(list.get(1)));
            ProcessMultiThreadTest.assertEquals((int)2, (int)processInstance.getState());
        }
        catch (Exception e) {
            e.printStackTrace();
            ProcessMultiThreadTest.fail((String)("Should not raise any exception: " + e.getMessage()));
        }
    }

    public static class ProcessInstanceSignalRunner
    implements Runnable {
        private ProcessInstance processInstance;
        private String type;
        private Status status;
        private int id;

        public ProcessInstanceSignalRunner(int id, ProcessInstance processInstance, String type) {
            this.id = id;
            this.processInstance = processInstance;
            this.type = type;
            this.status = Status.SUCCESS;
        }

        public void run() {
            try {
                this.processInstance.signalEvent(this.type, null);
            }
            catch (Exception e) {
                this.status = Status.FAIL;
                System.out.println(Thread.currentThread().getName() + " failed: " + e.getMessage());
                e.printStackTrace();
            }
        }

        public int getId() {
            return this.id;
        }

        public Status getStatus() {
            return this.status;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Status {
            SUCCESS,
            FAIL;

        }
    }
}

