/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestCase;
import org.drools.ClockType;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.SessionConfiguration;
import org.drools.StockTick;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.common.InternalFactHandle;
import org.drools.compiler.DroolsParserException;
import org.drools.integrationtests.SerializationHelper;
import org.drools.io.ResourceFactory;
import org.drools.rule.EntryPoint;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.WorkingMemoryEntryPoint;

public class StreamsTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private KnowledgeBase loadKnowledgeBase(String fileName) throws IOException, DroolsParserException, Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)fileName, ((Object)((Object)this)).getClass()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            System.out.println(kbuilder.getErrors());
            return null;
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return SerializationHelper.serializeObject(kbase);
    }

    public void testEventAssertion() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_EntryPoint.drl");
        SessionConfiguration conf = new SessionConfiguration();
        conf.setClockType(ClockType.PSEUDO_CLOCK);
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession((KnowledgeSessionConfiguration)conf, null);
        ArrayList results = new ArrayList();
        session.setGlobal("results", results);
        StockTick tick1 = new StockTick(1L, "DROO", 50.0, System.currentTimeMillis());
        StockTick tick2 = new StockTick(2L, "ACME", 10.0, System.currentTimeMillis());
        StockTick tick3 = new StockTick(3L, "ACME", 10.0, System.currentTimeMillis());
        StockTick tick4 = new StockTick(4L, "DROO", 50.0, System.currentTimeMillis());
        InternalFactHandle handle1 = (InternalFactHandle)session.insert((Object)tick1);
        InternalFactHandle handle2 = (InternalFactHandle)session.insert((Object)tick2);
        InternalFactHandle handle3 = (InternalFactHandle)session.insert((Object)tick3);
        InternalFactHandle handle4 = (InternalFactHandle)session.insert((Object)tick4);
        StreamsTest.assertNotNull((Object)handle1);
        StreamsTest.assertNotNull((Object)handle2);
        StreamsTest.assertNotNull((Object)handle3);
        StreamsTest.assertNotNull((Object)handle4);
        StreamsTest.assertTrue((boolean)handle1.isEvent());
        StreamsTest.assertTrue((boolean)handle2.isEvent());
        StreamsTest.assertTrue((boolean)handle3.isEvent());
        StreamsTest.assertTrue((boolean)handle4.isEvent());
        session.fireAllRules();
        StreamsTest.assertEquals((int)0, (int)results.size());
        StockTick tick5 = new StockTick(5L, "DROO", 50.0, System.currentTimeMillis());
        StockTick tick6 = new StockTick(6L, "ACME", 10.0, System.currentTimeMillis());
        StockTick tick7 = new StockTick(7L, "ACME", 15.0, System.currentTimeMillis());
        StockTick tick8 = new StockTick(8L, "DROO", 50.0, System.currentTimeMillis());
        WorkingMemoryEntryPoint entry = session.getWorkingMemoryEntryPoint("StockStream");
        InternalFactHandle handle5 = (InternalFactHandle)entry.insert((Object)tick5);
        InternalFactHandle handle6 = (InternalFactHandle)entry.insert((Object)tick6);
        InternalFactHandle handle7 = (InternalFactHandle)entry.insert((Object)tick7);
        InternalFactHandle handle8 = (InternalFactHandle)entry.insert((Object)tick8);
        StreamsTest.assertNotNull((Object)handle5);
        StreamsTest.assertNotNull((Object)handle6);
        StreamsTest.assertNotNull((Object)handle7);
        StreamsTest.assertNotNull((Object)handle8);
        StreamsTest.assertTrue((boolean)handle5.isEvent());
        StreamsTest.assertTrue((boolean)handle6.isEvent());
        StreamsTest.assertTrue((boolean)handle7.isEvent());
        StreamsTest.assertTrue((boolean)handle8.isEvent());
        session.fireAllRules();
        StreamsTest.assertEquals((int)1, (int)results.size());
        StreamsTest.assertSame((Object)tick7, results.get(0));
    }

    public void testEntryPointReference() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_EntryPointReference.drl");
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        ArrayList results = new ArrayList();
        session.setGlobal("results", results);
        StockTick tick5 = new StockTick(5L, "DROO", 50.0, System.currentTimeMillis());
        StockTick tick6 = new StockTick(6L, "ACME", 10.0, System.currentTimeMillis());
        StockTick tick7 = new StockTick(7L, "ACME", 30.0, System.currentTimeMillis());
        StockTick tick8 = new StockTick(8L, "DROO", 50.0, System.currentTimeMillis());
        WorkingMemoryEntryPoint entry = session.getWorkingMemoryEntryPoint("stream1");
        InternalFactHandle handle5 = (InternalFactHandle)entry.insert((Object)tick5);
        InternalFactHandle handle6 = (InternalFactHandle)entry.insert((Object)tick6);
        InternalFactHandle handle7 = (InternalFactHandle)entry.insert((Object)tick7);
        InternalFactHandle handle8 = (InternalFactHandle)entry.insert((Object)tick8);
        StreamsTest.assertNotNull((Object)handle5);
        StreamsTest.assertNotNull((Object)handle6);
        StreamsTest.assertNotNull((Object)handle7);
        StreamsTest.assertNotNull((Object)handle8);
        StreamsTest.assertTrue((boolean)handle5.isEvent());
        StreamsTest.assertTrue((boolean)handle6.isEvent());
        StreamsTest.assertTrue((boolean)handle7.isEvent());
        StreamsTest.assertTrue((boolean)handle8.isEvent());
        session.fireAllRules();
        StreamsTest.assertEquals((int)1, (int)results.size());
        StreamsTest.assertSame((Object)tick7, results.get(0));
    }

    public void testModifyRetracOnEntryPointFacts() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_modifyRetractEntryPoint.drl");
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        ArrayList results = new ArrayList();
        session.setGlobal("results", results);
        StockTick tick5 = new StockTick(5L, "DROO", 50.0, System.currentTimeMillis());
        StockTick tick6 = new StockTick(6L, "ACME", 10.0, System.currentTimeMillis());
        StockTick tick7 = new StockTick(7L, "ACME", 30.0, System.currentTimeMillis());
        StockTick tick8 = new StockTick(8L, "DROO", 50.0, System.currentTimeMillis());
        WorkingMemoryEntryPoint entry = session.getWorkingMemoryEntryPoint("stream1");
        InternalFactHandle handle5 = (InternalFactHandle)entry.insert((Object)tick5);
        InternalFactHandle handle6 = (InternalFactHandle)entry.insert((Object)tick6);
        InternalFactHandle handle7 = (InternalFactHandle)entry.insert((Object)tick7);
        InternalFactHandle handle8 = (InternalFactHandle)entry.insert((Object)tick8);
        StreamsTest.assertNotNull((Object)handle5);
        StreamsTest.assertNotNull((Object)handle6);
        StreamsTest.assertNotNull((Object)handle7);
        StreamsTest.assertNotNull((Object)handle8);
        StreamsTest.assertTrue((boolean)handle5.isEvent());
        StreamsTest.assertTrue((boolean)handle6.isEvent());
        StreamsTest.assertTrue((boolean)handle7.isEvent());
        StreamsTest.assertTrue((boolean)handle8.isEvent());
        session.fireAllRules();
        System.out.println(results);
        StreamsTest.assertEquals((int)2, (int)results.size());
        StreamsTest.assertEquals((int)30, (int)((Number)results.get(0)).intValue());
        StreamsTest.assertEquals((int)110, (int)((Number)results.get(1)).intValue());
        StreamsTest.assertEquals((int)3, (int)entry.getObjects().size());
        StreamsTest.assertEquals((int)0, (int)session.getObjects().size());
    }

    public void testGetEntryPointList() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_EntryPointReference.drl");
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        WorkingMemoryEntryPoint def = session.getWorkingMemoryEntryPoint(EntryPoint.DEFAULT.getEntryPointId());
        WorkingMemoryEntryPoint s1 = session.getWorkingMemoryEntryPoint("stream1");
        WorkingMemoryEntryPoint s2 = session.getWorkingMemoryEntryPoint("stream2");
        WorkingMemoryEntryPoint s3 = session.getWorkingMemoryEntryPoint("stream3");
        Collection eps = session.getWorkingMemoryEntryPoints();
        StreamsTest.assertEquals((int)4, (int)eps.size());
        StreamsTest.assertTrue((boolean)eps.contains(def));
        StreamsTest.assertTrue((boolean)eps.contains(s1));
        StreamsTest.assertTrue((boolean)eps.contains(s2));
        StreamsTest.assertTrue((boolean)eps.contains(s3));
    }
}

