/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import org.drools.lang.dsl.DSLMappingEntry;
import org.drools.lang.dsl.DSLTokenizedMappingFile;

public class DSLMappingEntryTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DSLMappingEntry createEntry(String inputKey, String inputValue) throws IOException {
        DSLMappingEntry entry;
        block4: {
            String mapping = "[condition][]" + inputKey + "=" + inputValue;
            StringReader dsl = new StringReader(mapping);
            entry = null;
            try {
                DSLTokenizedMappingFile parser = new DSLTokenizedMappingFile();
                if (parser.parseAndLoad((Reader)dsl)) {
                    entry = (DSLMappingEntry)parser.getMapping().getEntries().get(0);
                    break block4;
                }
                throw new RuntimeException("Error parsing entry: " + mapping + ": " + parser.getErrors().toString());
            }
            finally {
                dsl.close();
            }
        }
        return entry;
    }

    public void testPatternCalculation() throws IOException {
        String inputKey = "The Customer name is {name} and surname is {surname} and it has US$ 50,00 on his {pocket}";
        String inputValue = "Customer( name == \"{name}\", surname == \"{surname}\", money > $money )";
        String expectedKeyP = "(\\W|^)The\\s+Customer\\s+name\\s+is\\s+(.*?)\\s+and\\s+surname\\s+is\\s+(.*?)\\s+and\\s+it\\s+has\\s+US\\$\\s+50,00\\s+on\\s+his\\s+(.*?)$";
        String expectedValP = "$1Customer( name == \"$2\", surname == \"$3\", money > \\$money )";
        DSLMappingEntry entry = this.createEntry("The Customer name is {name} and surname is {surname} and it has US$ 50,00 on his {pocket}", "Customer( name == \"{name}\", surname == \"{surname}\", money > $money )");
        DSLMappingEntryTest.assertEquals((String)"The Customer name is {name} and surname is {surname} and it has US$ 50,00 on his {pocket}", (String)entry.getMappingKey());
        DSLMappingEntryTest.assertEquals((String)"(\\W|^)The\\s+Customer\\s+name\\s+is\\s+(.*?)\\s+and\\s+surname\\s+is\\s+(.*?)\\s+and\\s+it\\s+has\\s+US\\$\\s+50,00\\s+on\\s+his\\s+(.*?)$", (String)entry.getKeyPattern().pattern());
        DSLMappingEntryTest.assertEquals((String)"Customer( name == \"{name}\", surname == \"{surname}\", money > $money )", (String)entry.getMappingValue());
        DSLMappingEntryTest.assertEquals((String)"$1Customer( name == \"$2\", surname == \"$3\", money > \\$money )", (String)entry.getValuePattern());
    }

    public void testPatternCalculation2() throws IOException {
        String inputKey = "-name is {name}";
        String inputValue = "name == \"{name}\"";
        String expectedKeyP = "(\\W|^)-\\s*name\\s+is\\s+(.*?)$";
        String expectedValP = "$1name == \"$2\"";
        DSLMappingEntry entry = this.createEntry("-name is {name}", "name == \"{name}\"");
        DSLMappingEntryTest.assertEquals((String)"-name is {name}", (String)entry.getMappingKey());
        DSLMappingEntryTest.assertEquals((String)"(\\W|^)-\\s*name\\s+is\\s+(.*?)$", (String)entry.getKeyPattern().pattern());
        DSLMappingEntryTest.assertEquals((String)"name == \"{name}\"", (String)entry.getMappingValue());
        DSLMappingEntryTest.assertEquals((String)"$1name == \"$2\"", (String)entry.getValuePattern());
    }

    public void testPatternCalculation3() throws IOException {
        String inputKey = "- name is {name}";
        String inputValue = "name == \"{name}\"";
        String expectedKeyP = "(\\W|^)-\\s*name\\s+is\\s+(.*?)$";
        String expectedValP = "$1name == \"$2\"";
        DSLMappingEntry entry = this.createEntry("- name is {name}", "name == \"{name}\"");
        DSLMappingEntryTest.assertEquals((String)"- name is {name}", (String)entry.getMappingKey());
        DSLMappingEntryTest.assertEquals((String)entry.getKeyPattern().pattern(), (String)"(\\W|^)-\\s*name\\s+is\\s+(.*?)$", (String)entry.getKeyPattern().pattern());
        DSLMappingEntryTest.assertEquals((String)"name == \"{name}\"", (String)entry.getMappingValue());
        DSLMappingEntryTest.assertEquals((String)"$1name == \"$2\"", (String)entry.getValuePattern());
    }

    private DSLMappingEntry setupEntry() throws IOException {
        String inputKey = "String is \"{value}\"";
        String inputValue = "SomeFact(value==\"{value}\")";
        return this.createEntry("String is \"{value}\"", "SomeFact(value==\"{value}\")");
    }

    public void testExpandNoSpaces() throws IOException {
        DSLMappingEntry entry = this.setupEntry();
        String result = entry.getKeyPattern().matcher("String is \"blah\"").replaceAll(entry.getValuePattern());
        DSLMappingEntryTest.assertEquals((String)"SomeFact(value==\"blah\")", (String)result);
    }

    public void testExpandWithLeadingSpace() throws IOException {
        DSLMappingEntry entry = this.setupEntry();
        String result = entry.getKeyPattern().matcher("String is \" blah\"").replaceAll(entry.getValuePattern());
        DSLMappingEntryTest.assertEquals((String)"SomeFact(value==\" blah\")", (String)result);
    }

    public void testExpandWithMultipleLeadingSpaces() throws IOException {
        DSLMappingEntry entry = this.setupEntry();
        String result = entry.getKeyPattern().matcher("String is \"   blah\"").replaceAll(entry.getValuePattern());
        DSLMappingEntryTest.assertEquals((String)"SomeFact(value==\"   blah\")", (String)result);
    }

    public void testExpandWithTrailingSpace() throws IOException {
        DSLMappingEntry entry = this.setupEntry();
        String result = entry.getKeyPattern().matcher("String is \"blah \"").replaceAll(entry.getValuePattern());
        DSLMappingEntryTest.assertEquals((String)"SomeFact(value==\"blah \")", (String)result);
    }

    public void testExpandWithMultipleTrailingSpaces() throws IOException {
        DSLMappingEntry entry = this.setupEntry();
        String result = entry.getKeyPattern().matcher("String is \"blah  \"").replaceAll(entry.getValuePattern());
        DSLMappingEntryTest.assertEquals((String)"SomeFact(value==\"blah  \")", (String)result);
    }

    public void testExpandWithInternalSpace() throws IOException {
        DSLMappingEntry entry = this.setupEntry();
        String result = entry.getKeyPattern().matcher("String is \"bl ah\"").replaceAll(entry.getValuePattern());
        DSLMappingEntryTest.assertEquals((String)"SomeFact(value==\"bl ah\")", (String)result);
    }

    public void testExpandWithMultipleSpaces() throws IOException {
        DSLMappingEntry entry = this.setupEntry();
        String result = entry.getKeyPattern().matcher("String is \"  bl  ah  \"").replaceAll(entry.getValuePattern());
        DSLMappingEntryTest.assertEquals((String)"SomeFact(value==\"  bl  ah  \")", (String)result);
    }

    public void testExpandWithDots() throws IOException {
        String inputKey = "- {prop} is {val} ";
        String inputValue = "{prop} == {val}";
        DSLMappingEntry entry = this.createEntry("- {prop} is {val} ", "{prop} == {val}");
        String result = entry.getKeyPattern().matcher("- type is ClientServiceType.TypeGOLD").replaceAll(entry.getValuePattern());
        DSLMappingEntryTest.assertEquals((String)result, (String)"type == ClientServiceType.TypeGOLD", (String)result);
    }

    public void testExpandPartialWords() throws IOException {
        String inputKey = "- {prop} is {val} ";
        String inputValue = "{prop} == {val}";
        DSLMappingEntry entry = this.createEntry("- {prop} is {val} ", "{prop} == {val}");
        String result = entry.getKeyPattern().matcher("- type is_not ClientServiceType.TypeGOLD").replaceAll(entry.getValuePattern());
        DSLMappingEntryTest.assertEquals((String)result, (String)"- type is_not ClientServiceType.TypeGOLD", (String)result);
    }

    public void testExpandPartialWords2() throws IOException {
        String inputKey = "- {prop} is_not {val} ";
        String inputValue = "{prop} != {val}";
        DSLMappingEntry entry = this.createEntry("- {prop} is_not {val} ", "{prop} != {val}");
        String result = entry.getKeyPattern().matcher("- type is_not ClientServiceType.TypeGOLD").replaceAll(entry.getValuePattern());
        DSLMappingEntryTest.assertEquals((String)result, (String)"type != ClientServiceType.TypeGOLD", (String)result);
    }

    public void testExpandPartialWords3() throws IOException {
        String inputKey = "- {prop} is not {val} ";
        String inputValue = "{prop} != {val}";
        DSLMappingEntry entry = this.createEntry("- {prop} is not {val} ", "{prop} != {val}");
        String result = entry.getKeyPattern().matcher("- type is not ClientServiceType.TypeGOLD").replaceAll(entry.getValuePattern());
        DSLMappingEntryTest.assertEquals((String)result, (String)"type != ClientServiceType.TypeGOLD", (String)result);
    }

    public void testExpandWithBrackets() throws IOException {
        String inputKey = "attr {attr_name} is in \\[ {values} \\]";
        String inputValue = "{attr_name} in ( {values} )";
        DSLMappingEntry entry = this.createEntry("attr {attr_name} is in \\[ {values} \\]", "{attr_name} in ( {values} )");
        String result = entry.getKeyPattern().matcher("attr name is in [ 'Edson', 'Bob' ]").replaceAll(entry.getValuePattern());
        DSLMappingEntryTest.assertEquals((String)result, (String)"name in ( 'Edson', 'Bob' )", (String)result);
    }

    public void testExpandWithParethesis() throws IOException {
        String inputKey = "((H|h)e|(S|s)he) \\(is\\) (a|an) $xx {attribute} (man|woman)";
        String inputValue = "Person( attribute == \"{attribute}\" )";
        DSLMappingEntry entry = this.createEntry("((H|h)e|(S|s)he) \\(is\\) (a|an) $xx {attribute} (man|woman)", "Person( attribute == \"{attribute}\" )");
        String result = entry.getKeyPattern().matcher("he (is) a $xx handsome man").replaceAll(entry.getValuePattern());
        DSLMappingEntryTest.assertEquals((String)result, (String)"Person( attribute == \"handsome\" )", (String)result);
    }

    public void testSingleCharacterBetweenVars() throws IOException {
        String inputKey = "DSL sentence with {key1} {key2}";
        String inputValue = "Sentence( {key1} == {key2} )";
        DSLMappingEntry entry = this.createEntry("DSL sentence with {key1} {key2}", "Sentence( {key1} == {key2} )");
        String result = entry.getKeyPattern().matcher("DSL sentence with mykey myvalue").replaceAll(entry.getValuePattern());
        DSLMappingEntryTest.assertEquals((String)result, (String)"Sentence( mykey == myvalue )", (String)result);
    }

    public void testExpandWithQualifiedVars() throws IOException {
        String inputKey = "When the credit rating is {rating:ENUM:Applicant.creditRating}";
        String inputValue = "applicant:Applicant(credit=={rating})";
        DSLMappingEntry entry = this.createEntry("When the credit rating is {rating:ENUM:Applicant.creditRating}", "applicant:Applicant(credit=={rating})");
        String result = entry.getKeyPattern().matcher("When the credit rating is AA").replaceAll(entry.getValuePattern());
        DSLMappingEntryTest.assertEquals((String)result, (String)"applicant:Applicant(credit==AA)", (String)result);
    }

    public void testExpandWithRegexp() throws IOException {
        String inputKey = "When the credit rating is {rating:regexp:\\d{3}}";
        String inputValue = "applicant:Applicant(credit=={rating})";
        DSLMappingEntry entry = this.createEntry("When the credit rating is {rating:regexp:\\d{3}}", "applicant:Applicant(credit=={rating})");
        DSLMappingEntryTest.assertEquals((String)"(\\W|^)When\\s+the\\s+credit\\s+rating\\s+is\\s+(\\d{3})(\\W|$)", (String)entry.getKeyPattern().toString());
        DSLMappingEntryTest.assertEquals((String)"$1applicant:Applicant(credit==$2)$3", (String)entry.getValuePattern());
        String result = entry.getKeyPattern().matcher("When the credit rating is 555").replaceAll(entry.getValuePattern());
        DSLMappingEntryTest.assertEquals((String)result, (String)"applicant:Applicant(credit==555)", (String)result);
    }

    public void testExpandWithLineBreaks() throws IOException {
        String inputKey = "This is a sentence with line breaks";
        String inputValue = "Cheese\\n(price == 10)";
        DSLMappingEntry entry = this.createEntry("This is a sentence with line breaks", "Cheese\\n(price == 10)");
        DSLMappingEntryTest.assertEquals((String)"(\\W|^)This\\s+is\\s+a\\s+sentence\\s+with\\s+line\\s+breaks(\\W|$)", (String)entry.getKeyPattern().toString());
        DSLMappingEntryTest.assertEquals((String)"$1Cheese\n(price == 10)$2", (String)entry.getValuePattern());
        String result = entry.getKeyPattern().matcher("This is a sentence with line breaks").replaceAll(entry.getValuePattern());
        DSLMappingEntryTest.assertEquals((String)result, (String)"Cheese\n(price == 10)", (String)result);
    }

    public void testExpandWithPound() throws IOException {
        String inputKey = "Bedingung-\\#19-MKM4";
        String inputValue = "eval ( $p.getTempVal(\"\\#UML-ATZ-1\") < $p.getZvUmlStfr() )";
        DSLMappingEntry entry = this.createEntry("Bedingung-\\#19-MKM4", "eval ( $p.getTempVal(\"\\#UML-ATZ-1\") < $p.getZvUmlStfr() )");
        DSLMappingEntryTest.assertEquals((String)"(\\W|^)Bedingung-#19-MKM4(\\W|$)", (String)entry.getKeyPattern().toString());
        DSLMappingEntryTest.assertEquals((String)"$1eval ( \\$p.getTempVal(\"#UML-ATZ-1\") < \\$p.getZvUmlStfr() )$2", (String)entry.getValuePattern());
        String result = entry.getKeyPattern().matcher("Bedingung-#19-MKM4").replaceAll(entry.getValuePattern());
        DSLMappingEntryTest.assertEquals((String)result, (String)"eval ( $p.getTempVal(\"#UML-ATZ-1\") < $p.getZvUmlStfr() )", (String)result);
    }
}

