/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.HashSet;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.drools.base.ClassTypeResolver;
import org.drools.base.EnabledBoolean;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.DrlParser;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.FieldConstraintDescr;
import org.drools.lang.descr.LiteralRestrictionDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.RestrictionDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.GroupElement;
import org.drools.rule.LiteralConstraint;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.Rule;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleBuilder;
import org.drools.time.TimeUtils;
import org.drools.util.DateUtils;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;

public class RuleBuilderTest
extends TestCase {
    private Mockery mockery = new Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testBuild() throws Exception {
        DrlParser parser = new DrlParser();
        PackageBuilder pkgBuilder = new PackageBuilder();
        pkgBuilder.addPackage(new PackageDescr("org.drools"));
        Package pkg = pkgBuilder.getPackage();
        PackageDescr pkgDescr = parser.parse((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("nestedConditionalElements.drl")));
        Assert.assertFalse((String)parser.getErrors().toString(), (boolean)parser.hasErrors());
        RuleDescr ruleDescr = (RuleDescr)pkgDescr.getRules().get(0);
        String ruleClassName = "RuleClassName.java";
        ruleDescr.setClassName("RuleClassName.java");
        ruleDescr.addAttribute(new AttributeDescr("dialect", "java"));
        ClassTypeResolver typeResolver = new ClassTypeResolver(new HashSet(), ((Object)((Object)this)).getClass().getClassLoader());
        typeResolver.addImport(pkgDescr.getName() + ".*");
        typeResolver.addImport("java.lang.*");
        RuleBuilder builder = new RuleBuilder();
        PackageBuilderConfiguration conf = pkgBuilder.getPackageBuilderConfiguration();
        DialectCompiletimeRegistry dialectRegistry = pkgBuilder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
        Dialect dialect = dialectRegistry.getDialect("java");
        RuleBuildContext context = new RuleBuildContext(pkgBuilder, ruleDescr, dialectRegistry, pkg, dialect);
        builder.build(context);
        Assert.assertTrue((String)context.getErrors().toString(), (boolean)context.getErrors().isEmpty());
        Rule rule = context.getRule();
        RuleBuilderTest.assertEquals((String)"There should be 2 rule level declarations", (int)2, (int)rule.getDeclarations().length);
        GroupElement not = (GroupElement)rule.getLhs().getChildren().get(1);
        RuleBuilderTest.assertTrue((boolean)not.isNot());
        RuleBuilderTest.assertTrue((boolean)not.getOuterDeclarations().isEmpty());
        RuleBuilderTest.assertEquals((int)1, (int)not.getInnerDeclarations().size());
        RuleBuilderTest.assertTrue((boolean)not.getInnerDeclarations().keySet().contains("$state"));
        GroupElement not2 = (GroupElement)((GroupElement)not.getChildren().get(0)).getChildren().get(1);
        RuleBuilderTest.assertTrue((boolean)not2.isNot());
        RuleBuilderTest.assertTrue((boolean)not2.getOuterDeclarations().isEmpty());
        RuleBuilderTest.assertEquals((int)1, (int)not2.getInnerDeclarations().size());
        RuleBuilderTest.assertTrue((boolean)not2.getInnerDeclarations().keySet().contains("$likes"));
    }

    public void testBuildAttributes() throws Exception {
        final RuleBuildContext context = (RuleBuildContext)this.mockery.mock(RuleBuildContext.class);
        final Rule rule = (Rule)this.mockery.mock(Rule.class);
        final RuleDescr ruleDescr = new RuleDescr("my rule");
        ruleDescr.addAttribute(new AttributeDescr("no-loop", "true"));
        ruleDescr.addAttribute(new AttributeDescr("auto-focus", "false"));
        ruleDescr.addAttribute(new AttributeDescr("agenda-group", "my agenda"));
        ruleDescr.addAttribute(new AttributeDescr("activation-group", "my activation"));
        ruleDescr.addAttribute(new AttributeDescr("ruleflow-group", "mygroup"));
        ruleDescr.addAttribute(new AttributeDescr("lock-on-active", ""));
        ruleDescr.addAttribute(new AttributeDescr("enabled", "false"));
        ruleDescr.addAttribute(new AttributeDescr("duration", "60"));
        ruleDescr.addAttribute(new AttributeDescr("date-effective", "10-Jul-1974"));
        ruleDescr.addAttribute(new AttributeDescr("date-expires", "10-Jul-2040"));
        final Calendar effective = Calendar.getInstance();
        effective.setTime(DateUtils.parseDate((String)"10-Jul-1974"));
        final Calendar expires = Calendar.getInstance();
        expires.setTime(DateUtils.parseDate((String)"10-Jul-2040"));
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((RuleBuildContext)this.allowing(context)).getRule();
                this.will(2.returnValue((Object)rule));
                ((RuleBuildContext)this.allowing(context)).getRuleDescr();
                this.will(2.returnValue((Object)ruleDescr));
                ((Rule)this.oneOf(rule)).setNoLoop(true);
                ((Rule)this.oneOf(rule)).setAutoFocus(false);
                ((Rule)this.oneOf(rule)).setAgendaGroup("my agenda");
                ((Rule)this.oneOf(rule)).setActivationGroup("my activation");
                ((Rule)this.oneOf(rule)).setRuleFlowGroup("mygroup");
                ((Rule)this.oneOf(rule)).setLockOnActive(true);
                ((Rule)this.oneOf(rule)).setEnabled(EnabledBoolean.ENABLED_FALSE);
                ((Rule)this.oneOf(rule)).setDuration(60L);
                ((Rule)this.oneOf(rule)).setDateEffective(effective);
                ((Rule)this.oneOf(rule)).setDateExpires(expires);
            }
        });
        RuleBuilder builder = new RuleBuilder();
        builder.buildAttributes(context);
        this.mockery.assertIsSatisfied();
    }

    public void testBuildDurationExpression() throws Exception {
        final RuleBuildContext context = (RuleBuildContext)this.mockery.mock(RuleBuildContext.class);
        final Rule rule = (Rule)this.mockery.mock(Rule.class);
        final RuleDescr ruleDescr = new RuleDescr("my rule");
        ruleDescr.addAttribute(new AttributeDescr("duration", "( 1h30m )"));
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((RuleBuildContext)this.allowing(context)).getRule();
                this.will(3.returnValue((Object)rule));
                ((RuleBuildContext)this.allowing(context)).getRuleDescr();
                this.will(3.returnValue((Object)ruleDescr));
                ((Rule)this.oneOf(rule)).setDuration(TimeUtils.parseTimeString((String)"1h30m"));
            }
        });
        RuleBuilder builder = new RuleBuilder();
        builder.buildAttributes(context);
        this.mockery.assertIsSatisfied();
    }

    public void testBuildBigDecimalLiteralConstraint() throws Exception {
        PackageDescr pkgDescr = new PackageDescr("org.drools");
        RuleDescr ruleDescr = new RuleDescr("Test Rule");
        AndDescr andDescr = new AndDescr();
        PatternDescr patDescr = new PatternDescr("java.math.BigDecimal", "$bd");
        FieldConstraintDescr fcd = new FieldConstraintDescr("this");
        LiteralRestrictionDescr restr = new LiteralRestrictionDescr("==", "10");
        fcd.addRestriction((RestrictionDescr)restr);
        patDescr.addConstraint((BaseDescr)fcd);
        andDescr.addDescr((BaseDescr)patDescr);
        ruleDescr.setLhs(andDescr);
        ruleDescr.setConsequence((Object)"");
        pkgDescr.addRule(ruleDescr);
        PackageBuilder pkgBuilder = new PackageBuilder();
        pkgBuilder.addPackage(pkgDescr);
        Assert.assertTrue((String)pkgBuilder.getErrors().toString(), (boolean)pkgBuilder.getErrors().isEmpty());
        Rule rule = pkgBuilder.getPackages()[0].getRule("Test Rule");
        GroupElement and = rule.getLhs();
        Pattern pat = (Pattern)and.getChildren().get(0);
        LiteralConstraint fc = (LiteralConstraint)pat.getConstraints().get(0);
        RuleBuilderTest.assertTrue((String)("Wrong class. Expected java.math.BigDecimal. Found: " + fc.getField().getValue().getClass()), (boolean)(fc.getField().getValue() instanceof BigDecimal));
    }

    public void testBuildBigIntegerLiteralConstraint() throws Exception {
        PackageDescr pkgDescr = new PackageDescr("org.drools");
        RuleDescr ruleDescr = new RuleDescr("Test Rule");
        AndDescr andDescr = new AndDescr();
        PatternDescr patDescr = new PatternDescr("java.math.BigInteger", "$bd");
        FieldConstraintDescr fcd = new FieldConstraintDescr("this");
        LiteralRestrictionDescr restr = new LiteralRestrictionDescr("==", "10");
        fcd.addRestriction((RestrictionDescr)restr);
        patDescr.addConstraint((BaseDescr)fcd);
        andDescr.addDescr((BaseDescr)patDescr);
        ruleDescr.setLhs(andDescr);
        ruleDescr.setConsequence((Object)"");
        pkgDescr.addRule(ruleDescr);
        PackageBuilder pkgBuilder = new PackageBuilder();
        pkgBuilder.addPackage(pkgDescr);
        Assert.assertTrue((String)pkgBuilder.getErrors().toString(), (boolean)pkgBuilder.getErrors().isEmpty());
        Rule rule = pkgBuilder.getPackages()[0].getRule("Test Rule");
        GroupElement and = rule.getLhs();
        Pattern pat = (Pattern)and.getChildren().get(0);
        LiteralConstraint fc = (LiteralConstraint)pat.getConstraints().get(0);
        RuleBuilderTest.assertTrue((String)("Wrong class. Expected java.math.BigInteger. Found: " + fc.getField().getValue().getClass()), (boolean)(fc.getField().getValue() instanceof BigInteger));
    }
}

