/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import org.drools.commons.jci.problems.CompilationProblem;
import org.drools.compiler.DroolsError;
import org.drools.lang.descr.BaseDescr;

public class DescrBuildError
extends DroolsError {
    private BaseDescr parentDescr;
    private BaseDescr descr;
    private Object object;
    private String message;
    private int[] errorLines = new int[0];

    public DescrBuildError(BaseDescr parentDescr, BaseDescr descr, Object object, String message) {
        this.parentDescr = parentDescr;
        this.descr = descr;
        this.object = object;
        this.message = message;
    }

    public BaseDescr getParentDescr() {
        return this.parentDescr;
    }

    public BaseDescr getDescr() {
        return this.descr;
    }

    public Object getObject() {
        return this.object;
    }

    public int[] getErrorLines() {
        return this.errorLines;
    }

    public int getLine() {
        return this.descr != null ? this.descr.getLine() : -1;
    }

    public String getMessage() {
        String summary = this.message;
        if (this.object instanceof CompilationProblem[]) {
            CompilationProblem[] problem = (CompilationProblem[])this.object;
            int i = 0;
            while (i < problem.length) {
                summary = i != 0 ? String.valueOf(summary) + "\n" + problem[i].getMessage() : String.valueOf(summary) + " " + problem[i].getMessage();
                ++i;
            }
        }
        return summary;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.message);
        buf.append(" : ");
        buf.append(this.parentDescr);
        buf.append("\n");
        if (this.object instanceof CompilationProblem[]) {
            CompilationProblem[] problem = (CompilationProblem[])this.object;
            int i = 0;
            while (i < problem.length) {
                buf.append("\t");
                buf.append(problem[i]);
                buf.append("\n");
                ++i;
            }
        } else if (this.object != null) {
            buf.append(this.object);
        }
        return buf.toString();
    }
}

