/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.xml.processes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.compiler.xml.XmlRuleFlowProcessDumper;
import org.drools.compiler.xml.XmlWorkflowProcessDumper;
import org.drools.compiler.xml.processes.AbstractNodeHandler;
import org.drools.definition.process.Connection;
import org.drools.process.core.Context;
import org.drools.process.core.context.exception.ExceptionScope;
import org.drools.process.core.context.variable.VariableScope;
import org.drools.workflow.core.Node;
import org.drools.workflow.core.node.CompositeContextNode;
import org.drools.workflow.core.node.CompositeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeNodeHandler
extends AbstractNodeHandler {
    @Override
    protected Node createNode() {
        CompositeContextNode result = new CompositeContextNode();
        VariableScope variableScope = new VariableScope();
        result.addContext((Context)variableScope);
        result.setDefaultContext((Context)variableScope);
        return result;
    }

    public Class<?> generateNodeFor() {
        return CompositeNode.class;
    }

    public boolean allowNesting() {
        return true;
    }

    protected String getNodeName() {
        return "composite";
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, boolean includeMeta) {
        super.writeNode(this.getNodeName(), node, xmlDump, includeMeta);
        CompositeNode compositeNode = (CompositeNode)node;
        this.writeAttributes(compositeNode, xmlDump, includeMeta);
        xmlDump.append(">" + EOL);
        String[] stringArray = compositeNode.getActionTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String eventType = stringArray[n2];
            this.writeActions(eventType, compositeNode.getActions(eventType), xmlDump);
            ++n2;
        }
        this.writeTimers(compositeNode.getTimers(), xmlDump);
        if (compositeNode instanceof CompositeContextNode) {
            ExceptionScope exceptionScope;
            VariableScope variableScope = (VariableScope)((CompositeContextNode)compositeNode).getDefaultContext("VariableScope");
            if (variableScope != null) {
                List variables = variableScope.getVariables();
                XmlWorkflowProcessDumper.visitVariables(variables, xmlDump);
            }
            if ((exceptionScope = (ExceptionScope)((CompositeContextNode)compositeNode).getDefaultContext("ExceptionScope")) != null) {
                XmlWorkflowProcessDumper.visitExceptionHandlers(exceptionScope.getExceptionHandlers(), xmlDump);
            }
        }
        List<Node> subNodes = this.getSubNodes(compositeNode);
        xmlDump.append("      <nodes>" + EOL);
        for (Node subNode : subNodes) {
            XmlRuleFlowProcessDumper.INSTANCE.visitNode((org.drools.definition.process.Node)subNode, xmlDump, includeMeta);
        }
        xmlDump.append("      </nodes>" + EOL);
        List<Connection> connections = this.getSubConnections(compositeNode);
        xmlDump.append("      <connections>" + EOL);
        for (Connection connection : connections) {
            XmlRuleFlowProcessDumper.INSTANCE.visitConnection(connection, xmlDump, includeMeta);
        }
        xmlDump.append("      </connections>" + EOL);
        Map<String, CompositeNode.NodeAndType> inPorts = this.getInPorts(compositeNode);
        xmlDump.append("      <in-ports>" + EOL);
        for (Map.Entry<String, CompositeNode.NodeAndType> entry : inPorts.entrySet()) {
            xmlDump.append("        <in-port type=\"" + entry.getKey() + "\" nodeId=\"" + entry.getValue().getNodeId() + "\" nodeInType=\"" + entry.getValue().getType() + "\" />" + EOL);
        }
        xmlDump.append("      </in-ports>" + EOL);
        Map<String, CompositeNode.NodeAndType> outPorts = this.getOutPorts(compositeNode);
        xmlDump.append("      <out-ports>" + EOL);
        for (Map.Entry<String, CompositeNode.NodeAndType> entry : outPorts.entrySet()) {
            xmlDump.append("        <out-port type=\"" + entry.getKey() + "\" nodeId=\"" + entry.getValue().getNodeId() + "\" nodeOutType=\"" + entry.getValue().getType() + "\" />" + EOL);
        }
        xmlDump.append("      </out-ports>" + EOL);
        this.endNode(this.getNodeName(), xmlDump);
    }

    protected void writeAttributes(CompositeNode compositeNode, StringBuilder xmlDump, boolean includeMeta) {
    }

    protected List<Node> getSubNodes(CompositeNode compositeNode) {
        ArrayList<Node> subNodes = new ArrayList<Node>();
        org.drools.definition.process.Node[] nodeArray = compositeNode.getNodes();
        int n = nodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            org.drools.definition.process.Node subNode = nodeArray[n2];
            if (!(subNode instanceof CompositeNode.CompositeNodeStart) && !(subNode instanceof CompositeNode.CompositeNodeEnd)) {
                subNodes.add((Node)subNode);
            }
            ++n2;
        }
        return subNodes;
    }

    protected List<Connection> getSubConnections(CompositeNode compositeNode) {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        org.drools.definition.process.Node[] nodeArray = compositeNode.getNodes();
        int n = nodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            org.drools.definition.process.Node subNode = nodeArray[n2];
            if (!(subNode instanceof CompositeNode.CompositeNodeEnd)) {
                for (Connection connection : subNode.getIncomingConnections("DROOLS_DEFAULT")) {
                    if (connection.getFrom() instanceof CompositeNode.CompositeNodeStart) continue;
                    connections.add(connection);
                }
            }
            ++n2;
        }
        return connections;
    }

    protected Map<String, CompositeNode.NodeAndType> getInPorts(CompositeNode compositeNode) {
        return compositeNode.getLinkedIncomingNodes();
    }

    protected Map<String, CompositeNode.NodeAndType> getOutPorts(CompositeNode compositeNode) {
        return compositeNode.getLinkedOutgoingNodes();
    }
}

